package multisab.processing.analysis;

import multisab.processing.scenarios.AnalysisType;
import multisab.processing.scenarios.DataTypes;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Disorders {
    public static String NORMAL="NORMAL";
    public static String PAC="PAC";
    public static String PVC="PVC";
    public static String COMPENSATED_COUPLET="COMPENSATED_COUPLET";
    public static String DECOMPENSATED_COUPLET="DECOMPENSATED_COUPLET";
    public static String PVC_AND_PAC="PVC_AND_PAC";
    public static String FUSION="FUSION";
    public static String VENTRICULAR_ECTOPY="VENTRICULAR_ECTOPY";
    public static String LBBB="LBBB";
    public static String RBBB="RBBB";
    public static String VENTRICULAR_FLUTTER="VENTRICULAR_FLUTTER";
    public static String VENTRICULAR_FIBRILLATION="VENTRICULAR_FIBRILLATION";
    public static String ATRIAL_FLUTTER="ATRIAL_FLUTTER";
    public static String VENTRICULAR_TACHYCARDIA="VENTRICULAR_TACHYCARDIA";
    public static String ATRIAL_FIBRILLATION="ATRIAL_FIBRILLATION";
    public static String WANDERING_ATRIAL_PACEMAKER="WANDERING_ATRIAL_PACEMAKER";
    public static String SUPRAVENTRICULAR_TACHYARRHYTHMIA="SUPRAVENTRICULAR_TACHYARRHYTHMIA";
    public static String SECOND_DEGREE_BLOCK="SECOND_DEGREE_BLOCK";
    public static String JUNCTION_RHYTHM="JUNCTION_RHYTHM";
    public static String VENTRICULAR_BIGEMINY="VENTRICULAR_BIGEMINY";
    public static String VENTRICULAR_TRIGEMINY="VENTRICULAR_TRIGEMINY";
    public static String ATRIAL_BIGEMINY="ATRIAL_BIGEMINY";
    public static String ATRIAL_TRIGEMINY="ATRIAL_TRIGEMINY";
    public static String PACED_RHYTHM="PACED_RHYTHM";
    public static String SINUS_BRADYCARDIA="SINUS_BRADYCARDIA";
    public static String PREEXCITATION_WPW="PREEXCITATION_WPW";
    public static String IDIOVENTRICULAR_RHYTHM="IDIOVENTRICULAR_RHYTHM";
    public static String ARRHYTHMIA="ARRHYTHMIA";
    public static String SUPRAVENTRICULAR_ARRHYTHMIA="SUPRAVENTRICULAR_ARRHYTHMIA";
    public static String CONGESTIVE_HEART_FAILURE="CONGESTIVE_HEART_FAILURE";
    public static String CORONARY_ARTERY_DISEASE="CORONARY_ARTERY_DISEASE";

    public static String EPILEPSY="EPILEPSY";
    public static String GRAND_MAL="GRAND_MAL";
    public static String PETIT_MAL="PETIT_MAL";
    public static String SLEEP="SLEEP";
    public static String STAGE1_SLEEP="STAGE1_SLEEP";
    public static String STAGE2_SLEEP="STAGE2_SLEEP";
    public static String STAGE3_SLEEP="STAGE3_SLEEP";
    public static String STAGE4_SLEEP="STAGE4_SLEEP";

    public static String UNSPECIFIED_DISORDER="UNSPECIFIED_DISORDER";

    public static String[] getAllDisorders(){
        Field[] declaredFields = Disorders.class.getDeclaredFields();
        String [] disorders = new String[declaredFields.length];
        int i = 0;
        try {
            for (Field field : declaredFields) {
                disorders[i] = field.get(null).toString();
                i++;
            }
        }
        catch (Exception e){};
        return disorders;
    }

    public static int getDisorderIntegerNumber(String disorder){
        int disorderInteger;
        switch (disorder){
            case "NORMAL":
                disorderInteger = 0;
                break;
            case "PAC":
                disorderInteger = 1;
                break;
            case "PVC":
                disorderInteger = 2;
                break;
            case "COMPENSATED_COUPLET":
                disorderInteger = 3;
                break;
            case "DECOMPENSATED_COUPLET":
                disorderInteger = 4;
                break;
            case "PVC_AND_PAC":
                disorderInteger = 5;
                break;
            case "FUSION":
                disorderInteger = 6;
                break;
            case "VENTRICULAR_ECTOPY":
                disorderInteger = 7;
                break;
            case "LBBB":
                disorderInteger = 8;
                break;
            case "RBBB":
                disorderInteger = 9;
                break;
            case "VENTRICULAR_FLUTTER":
                disorderInteger = 10;
                break;
            case "VENTRICULAR_FIBRILLATION":
                disorderInteger = 11;
                break;
            case "ATRIAL_FLUTTER":
                disorderInteger = 12;
                break;
            case "VENTRICULAR_TACHYCARDIA":
                disorderInteger = 13;
                break;
            case "ATRIAL_FIBRILLATION":
                disorderInteger = 14;
                break;
            case "WANDERING_ATRIAL_PACEMAKER":
                disorderInteger = 15;
                break;
            case "SUPRAVENTRICULAR_TACHYARRHYTHMIA":
                disorderInteger = 16;
                break;
            case "SECOND_DEGREE_BLOCK":
                disorderInteger = 17;
                break;
            case "JUNCTION_RHYTHM":
                disorderInteger = 18;
                break;
            case "VENTRICULAR_BIGEMINY":
                disorderInteger = 19;
                break;
            case "VENTRICULAR_TRIGEMINY":
                disorderInteger = 20;
                break;
            case "ATRIAL_BIGEMINY":
                disorderInteger = 21;
                break;
            case "ATRIAL_TRIGEMINY":
                disorderInteger = 22;
                break;
            case "PACED_RHYTHM":
                disorderInteger = 23;
                break;
            case "SINUS_BRADYCARDIA":
                disorderInteger = 24;
                break;
            case "PREEXCITATION_WPW":
                disorderInteger = 25;
                break;
            case "IDIOVENTRICULAR_RHYTHM":
                disorderInteger = 26;
                break;
            case "ARRHYTHMIA":
                disorderInteger = 27;
                break;
            case "SUPRAVENTRICULAR_ARRHYTHMIA":
                disorderInteger = 28;
                break;
            case "CONGESTIVE_HEART_FAILURE":
                disorderInteger = 29;
                break;
            case "EPILEPSY":
                disorderInteger = 30;
                break;
            case "GRAND_MAL":
                disorderInteger = 31;
                break;
            case "PETIT_MAL":
                disorderInteger = 32;
                break;
            case "SLEEP":
                disorderInteger = 33;
                break;
            case "STAGE1_SLEEP":
                disorderInteger = 34;
                break;
            case "STAGE2_SLEEP":
                disorderInteger = 35;
                break;
            case "STAGE3_SLEEP":
                disorderInteger = 36;
                break;
            case "STAGE4_SLEEP":
                disorderInteger = 37;
                break;
            case "UNSPECIFIED_DISORDER":
                disorderInteger = 38;
                break;
            default:
                disorderInteger = -1;
                break;
        }
        return disorderInteger;
    }


    public static List<String> getDisordersForAnalysisAndDataType(String analysisType, String dataType){
        List<String> list = new ArrayList<>();
        boolean normalAdded = false;
        boolean ecg_or_hrv_added = false;
        boolean eeg_added = false;
        if (analysisType.equals(AnalysisType.INSPECTION)) {
            return list;
        } else if (analysisType.equals(AnalysisType.PREDICTION)) {
            //not implemented yet!
            return list;
        } else { //if classification or detection
            if (dataType.contains("ECG") || dataType.contains("HRV")) {
                list.add(Disorders.NORMAL);
                list.add(Disorders.ARRHYTHMIA);
                list.add(Disorders.ATRIAL_BIGEMINY);
                list.add(Disorders.ATRIAL_FIBRILLATION);
                list.add(Disorders.ATRIAL_FLUTTER);
                list.add(Disorders.ATRIAL_TRIGEMINY);
                list.add(Disorders.COMPENSATED_COUPLET);
                list.add(Disorders.CONGESTIVE_HEART_FAILURE);
                list.add(Disorders.CORONARY_ARTERY_DISEASE);
                list.add(Disorders.DECOMPENSATED_COUPLET);
                list.add(Disorders.FUSION);
                list.add(Disorders.IDIOVENTRICULAR_RHYTHM);
                list.add(Disorders.JUNCTION_RHYTHM);
                list.add(Disorders.LBBB);
                list.add(Disorders.PAC);
                list.add(Disorders.PACED_RHYTHM);
                list.add(Disorders.PREEXCITATION_WPW);
                list.add(Disorders.PVC);
                list.add(Disorders.PVC_AND_PAC);
                list.add(Disorders.RBBB);
                list.add(Disorders.SECOND_DEGREE_BLOCK);
                list.add(Disorders.SINUS_BRADYCARDIA);
                list.add(Disorders.SUPRAVENTRICULAR_ARRHYTHMIA);
                list.add(Disorders.SUPRAVENTRICULAR_TACHYARRHYTHMIA);
                list.add(Disorders.VENTRICULAR_BIGEMINY);
                list.add(Disorders.VENTRICULAR_ECTOPY);
                list.add(Disorders.VENTRICULAR_FIBRILLATION);
                list.add(Disorders.VENTRICULAR_FLUTTER);
                list.add(Disorders.VENTRICULAR_TACHYCARDIA);
                list.add(Disorders.VENTRICULAR_TRIGEMINY);
                list.add(Disorders.WANDERING_ATRIAL_PACEMAKER);
                list.add(Disorders.UNSPECIFIED_DISORDER);
                normalAdded = true;
                ecg_or_hrv_added = true;
            }
            if (dataType.contains("EEG")) {
                if (!normalAdded) {
                    list.add(Disorders.NORMAL);
                }
                list.add(Disorders.EPILEPSY);
                list.add(Disorders.GRAND_MAL);
                list.add(Disorders.PETIT_MAL);
                list.add(Disorders.SLEEP);
                list.add(Disorders.STAGE1_SLEEP);
                list.add(Disorders.STAGE2_SLEEP);
                list.add(Disorders.STAGE3_SLEEP);
                list.add(Disorders.STAGE4_SLEEP);
                if (!normalAdded) {
                    list.add(Disorders.UNSPECIFIED_DISORDER);
                }

                eeg_added = true;
            }
            if (dataType.contains("EMG") || dataType.contains("OTHER")) {
               if (!ecg_or_hrv_added && !eeg_added){
                   list.add(Disorders.NORMAL);
                   list.add(Disorders.UNSPECIFIED_DISORDER);
               }
            }
        }
        return list;
    }

}
