package multisab.processing.analysis;

import multisab.processing.scenarios.AnalysisType;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Features {
    ArrayList<String> selectedFeatures;

    public Features(){
        selectedFeatures = new ArrayList<String>();
    }

    public void addFeature(String feature){
        this.selectedFeatures.add(feature);
    }

    public ArrayList<String> getSelectedFeaturesList(){
        return this.selectedFeatures;
    }
    public String [] getSelectedFeaturesArray(){
        String [] selectedFeatures = new String[this.selectedFeatures.size()];
        Iterator<String> it;
        it = this.selectedFeatures.iterator();
        int i = 0;
        while (it.hasNext()){
            selectedFeatures[i] = it.next();
            i++;
        }
        return selectedFeatures;
    }

    public int getSelectedFeaturesSize(){
        return this.selectedFeatures.size();
    }

    public static List<String> getAllFeaturesForAnalysisAndDataType(String analysisType, String dataType){
        List<String> list = new ArrayList<>();
        if (analysisType.equals(AnalysisType.INSPECTION)){
            return list;
        }
        else if (analysisType.equals(AnalysisType.PREDICTION)){
            //not implemented yet!
            return list;
        }
        else { //if classification or detection
            if (dataType.contains("ECG")){
                Field[] fields = Features.class.getDeclaredFields();
                for (int i = 0; i< fields.length; i++){
                    if (fields[i].getName().startsWith("ECG_")){
                        list.add(fields[i].getName());
                    }
                }
            }
            if (dataType.contains("HRV")){
                Field[] fields = Features.class.getDeclaredFields();
                for (int i = 0; i< fields.length; i++){
                    if (fields[i].getName().startsWith("HRV_")){
                        list.add(fields[i].getName());
                    }
                }
            }
            if (dataType.contains("EEG")){
                Field[] fields = Features.class.getDeclaredFields();
                for (int i = 0; i< fields.length; i++){
                    if (fields[i].getName().startsWith("EEG_")){
                        list.add(fields[i].getName());
                    }
                }
            }
            if (dataType.contains("HRV") || dataType.contains("EEG") || dataType.contains("EMG") || dataType.contains("OTHER")){
                list.add(Features.ALPHABET_ENTROPY);
                list.add(Features.AP_EN);
                list.add(Features.CARNAP_ENTROPY_1D);
                list.add(Features.CORRECTED_CONDITIONAL_SHANNON_ENTROPY);
                list.add(Features.CORRELATION_ENTROPY);
                list.add(Features.FUZZY_AP_EN);
                list.add(Features.RENYI_ENTROPY);
                list.add(Features.SAMP_EN);
                list.add(Features.SHANNON_ENTROPY);
                list.add(Features.DFA_ALPHA1);
                list.add(Features.DFA_ALPHA2);
                list.add(Features.HIGUCHI_DIMENSION);
                list.add(Features.HURST_EXPONENT);
                list.add(Features.POWER_LAW_EXPONENT_ALPHA);
                list.add(Features.CORRELATION_DIMENSION);
                list.add(Features.CTM);
                list.add(Features.LARGEST_LYAPUNOV_EXPONENT);
                list.add(Features.RECURRENCE_PLOT);
                list.add(Features.SPATIAL_FILLING_INDEX);
                list.add(Features.ALLAN_FACTOR);
                list.add(Features.LEMPEL_ZIV_COMPLEXITY);
                list.add(Features.AUTOCORRELATION_COEFFICIENT);
                list.add(Features.FANO_FACTOR);
                list.add(Features.HAAR_WAVELET_STANDARD_DEVIATION);
            }
            if (dataType.contains("EEG")){ //MULTIVARIATE FEATURES
                list.add(Features.CROSS_RECURRENCE);
                list.add(Features.MUTUAL_DIMENSION);
            }
        }
        return list;
    }

    public static final String ALPHABET_ENTROPY = "ALPHABET_ENTROPY";
    public static final String AP_EN = "APPROXIMATE_ENTROPY";
    public static final String CARNAP_ENTROPY_1D = "CARNAP_ENTROPY_1D";
    public static final String CORRECTED_CONDITIONAL_SHANNON_ENTROPY = "CORRECTED_CONDITIONAL_SHANNON_ENTROPY";
    public static final String CORRELATION_ENTROPY = "CORRELATION_ENTROPY";
    public static final String FUZZY_AP_EN = "FUZZY_AP_EN";
    public static final String RENYI_ENTROPY = "RENYI_ENTROPY";
    public static final String SAMP_EN = "SAMP_EN";
    public static final String SHANNON_ENTROPY = "SHANNON_ENTROPY";
    public static final String DFA = "DFA";
    public static final String HIGUCHI_DIMENSION = "HIGUCHI_DIMENSION";
    public static final String HURST_EXPONENT = "HURST_EXPONENT";
    public static final String POWER_LAW_EXPONENT_ALPHA = "POWER_LAW_EXPONENT_ALPHA";
    public static final String CROSS_RECURRENCE = "CROSS_RECURRENCE";
    public static final String MUTUAL_DIMENSION = "MUTUAL_DIMENSION";
    public static final String PHASE_SYNCHRONIZATION = "PHASE_SYNCHRONIZATION";
    public static final String SYNCHRONIZATION_LIKELIHOOD = "SYNCHRONIZATION_LIKELIHOOD";
    public static final String CORRELATION_DIMENSION = "CORRELATION_DIMENSION";
    public static final String CTM = "CTM";
    public static final String LARGEST_LYAPUNOV_EXPONENT = "LARGEST_LYAPUNOV_EXPONENT";
    public static final String NONLINEAR_FORECASTING = "NONLINEAR_FORECASTING";
    public static final String RECURRENCE_PLOT = "RECURRENCE_PLOT";
    public static final String SPATIAL_FILLING_INDEX = "SPATIAL_FILLING_INDEX";
    public static final String ALLAN_FACTOR = "ALLAN_FACTOR";
    public static final String LEMPEL_ZIV_COMPLEXITY = "LEMPEL_ZIV_COMPLEXITY";
    public static final String AUTOCORRELATION_COEFFICIENT = "AUTOCORRELATION_COEFFICIENT";
    public static final String FANO_FACTOR = "FANO_FACTOR";
    public static final String HAAR_WAVELET_STANDARD_DEVIATION = "HAAR_WAVELET_STANDARD_DEVIATION";

    public static final String SPECTRAL_ANALYSIS_HRV = "SPECTRAL_ANALYSIS_HRV";
    public static final String HRV_AVNN = "HRV_AVNN";
    public static final String HRV_SDNN = "HRV_SDNN";
    public static final String HRV_RMSSD = "HRV_RMSSD";
    public static final String HRV_PNNX = "HRV_PNNX";
    public static final String HRV_NNX = "HRV_NNX";
    public static final String HRV_SDSD = "HRV_SDSD";
    public static final String HRV_SDANN = "HRV_SDANN";
    public static final String HRV_HRV_TRIANGULAR_INDEX = "HRV_HRV_TRIANGULAR_INDEX";
    public static final String HRV_TINN = "HRV_TINN";
    public static final String HRV_TOTAL_PWR = "HRV_TOTAL_PWR";
    public static final String HRV_ULF = "HRV_ULF";
    public static final String HRV_VLF = "HRV_VLF";
    public static final String HRV_LF = "HRV_LF";
    public static final String HRV_HF = "HRV_HF";
    public static final String HRV_LF_HF_RATIO = "HRV_LF_HF_RATIO";
    public static final String HRV_SPECT_EN = "HRV_SPECT_EN";
    public static final String HRV_STANDARD_DEVIATION_RATIO = "HRV_STANDARD_DEVIATION_RATIO";
    public static final String SPECTRAL_ANALYSIS_EEG = "SPECTRAL_ANALYSIS_EEG";
    public static final String EEG_MEAN = "EEG_MEAN";
    public static final String EEG_STANDARD_DEVIATION = "EEG_STANDARD_DEVIATION";
    public static final String EEG_MEAN_OF_FIRST_DIFF = "EEG_MEAN_OF_FIRST_DIFF";
    public static final String EEG_MEAN_OF_SECOND_DIFF = "EEG_MEAN_OF_SECOND_DIFF";
    public static final String EEG_MEAN_OF_FIRST_DIFF_NORM = "EEG_MEAN_OF_FIRST_DIFF_NORM";
    public static final String EEG_MEAN_OF_SECOND_DIFF_NORM = "EEG_MEAN_OF_SECOND_DIFF_NORM";
    public static final String EEG_TOTAL_PWR = "EEG_TOTAL_PWR";
    public static final String EEG_DELTA_BAND = "EEG_DELTA_BAND";
    public static final String EEG_THETA_BAND = "EEG_THETA_BAND";
    public static final String EEG_ALPHA_BAND = "EEG_ALPHA_BAND";
    public static final String EEG_BETA_BAND = "EEG_BETA_BAND";
    public static final String EEG_GAMMA_BAND = "EEG_GAMMA_BAND";
    public static final String EEG_SPECT_EN = "EEG_SPECT_EN";
    public static final String ECG_R_WAVE_AMPLITUDE = "ECG_R_WAVE_AMPLITUDE";
    public static final String ECG_QRS_COMPLEX_DURATION = "ECG_QRS_COMPLEX_DURATION";
    public static final String ECG_P_WAVE_AMPLITUDE = "ECG_P_WAVE_AMPLITUDE";
    public static final String ECG_P_WAVE_ABSENCE = "ECG_P_WAVE_ABSENCE";
    public static final String ECG_P_WAVE_DURATION = "ECG_P_WAVE_DURATION";
    public static final String ECG_T_WAVE_AMPLITUDE = "ECG_T_WAVE_AMPLITUDE";
    public static final String ECG_T_WAVE_DURATION = "ECG_T_WAVE_DURATION";
    public static final String ECG_ST_SEGMENT_DURATION = "ECG_ST_SEGMENT_DURATION";
    public static final String ECG_ST_SEGMENT_SLOPE = "ECG_ST_SEGMENT_SLOPE";
    public static final String ECG_QT_INTERVAL_DURATION = "ECG_QT_INTERVAL_DURATION";
    public static final String ECG_PR_INTERVAL_DURATION = "PR_INTERVAL_DURATION";
    public static final String ECG_J_POINT_AMPLITUDE = "ECG_J_POINT_AMPLITUDE";
    public static final String ECG_R_S_RATIO = "ECG_R_S_RATIO";
    public static final String ECG_Q_WAVE_AMPLITUDE = "ECG_Q_WAVE_AMPLITUDE";
    public static final String ECG_R_WAVE_DURATION = "ECG_R_WAVE_DURATION";
    public static final String ECG_S_WAVE_DURATION = "ECG_S_WAVE_DURATION";
    public static final String ECG_FIBRILATORY_RATE = "ECG_FIBRILATORY_RATE";
    public static final String ECG_QT_QTc_RATIO = "ECG_QT_QTc_RATIO";
    public static final String ECG_QTV_NORM = "ECG_QTV_NORM";
    public static final String ECG_QTVI = "ECG_QTVI";
    public static final String ECG_TQ_INTERVAL_WE = "ECG_TQ_INTERVAL_WE";
    public static final String ECG_TQ_INTERVAL_RWE = "ECG_TQ_INTERVAL_RWE";
    public static final String HRV_PNN50 = "HRV_PNN50";
    public static final String HRV_NN50 = "HRV_NN50";
    public static final String HRV_PNN20 = "HRV_PNN20";
    public static final String HRV_NN20 = "HRV_NN20";
    public static final String HRV_1_AVNN = "HRV_1_AVNN";
    public static final String HEART_RATE_TURBULENCE_ONSET = "HEART_RATE_TURBULENCE_ONSET";
    public static final String HEART_RATE_TURBULENCE_SLOPE = "HEART_RATE_TURBULENCE_SLOPE";
    public static final String DFA_ALPHA1 = "DFA_ALPHA1";
    public static final String DFA_ALPHA2 = "DFA_ALPHA2";
    public static final String ECG_J_POINT_AMPLITUDE_STDEV = "ECG_J_POINT_AMPLITUDE_STDEV";

}
