package multisab.processing.analysis;

import multisab.processing.scenarios.AnalysisType;
import org.bouncycastle.math.raw.Mod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelingMethod {
    public static final String SVM = "SVM";
    public static final String MLP = "MLP";
    public static final String RBF_NETWORK = "RBF_NETWORK";
    public static final String PNN = "PNN";
    public static final String NEAT = "NEAT";
    public static final String RF = "RF";
    public static final String EXT = "EXT"; //extra trees

    public static final List<String> getParametersForModelingMethod(String modelinMethod){
        List<String> parameters = new ArrayList<>();
        switch (modelinMethod){
            case "RF":
                parameters.add("No. of trees");
                break;
            case "EXT":
                parameters.add("No. of trees");
                break;
        }
        return parameters;
    }

    public static List<String> getAllModelingMethodsForAnalysisAndDataType(String analysisType, String dataType) {
        List<String> list = new ArrayList<>();
        if (analysisType.equals(AnalysisType.INSPECTION)) {
            return list;
        }
        else if (analysisType.equals(AnalysisType.PREDICTION)) {
            //not implemented yet!
            // It is expected that a regression type classifier is referenced here!
            return list;
        }
        else {
            list.add(ModelingMethod.SVM);
            list.add(ModelingMethod.MLP);
            list.add(ModelingMethod.RBF_NETWORK);
            list.add(ModelingMethod.PNN);
            list.add(ModelingMethod.NEAT);
            list.add(ModelingMethod.RF);
            list.add(ModelingMethod.EXT);
        }
        return list;
    }
}
