package multisab.processing.analysis;

import com.aparapi.Kernel;

/**
 * Created by ajovic on 23.3.2017..
 */
public class ParalellizationTest {
    public static void main(String[] args) {

        float[] intA = new float[1000000];
        float[] intB = new float[1000000];
        float[] result = new float[1000000];

        for (int i = 0; i < intA.length; i++) {
            intA[i] = (float) Math.random() * 1000;
            intB[i] = (float) Math.random() * 1000;
        }


        Kernel kernel = new Kernel() {
            @Override
            public void run() {
                int i = getGlobalId();
                result[i] = sqrt(intA[i]) + sqrt(intB[i]);
            }
        };

//      kernel.setExecutionMode(Kernel.EXECUTION_MODE.JTP);
        kernel.setExecutionMode(Kernel.EXECUTION_MODE.GPU);
//      kernel.setExecutionMode(Kernel.EXECUTION_MODE.CPU);
        long time1 = System.currentTimeMillis();
        kernel.execute(1000000, 10000);
        long time2 = System.currentTimeMillis();

        System.err.println(time2 - time1);
    }



}
