%import processing_1_8_0_74.*

file = java.io.File('C:\Users\dkukolja\Desktop\processing\Data\100.csv');

data = multisab.processing.dataHandling.CsvFile(file);

signals = data.getSignals();

ecg = signals(1,:);

frequency = data.calculateFrequency(0);

RPeaks = multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection.Elgendi.DetectRWave(ecg,frequency);

ecgFiducialPointsSignal = multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ptDetection.MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);

ecgFiltred = multisab.processing.ecgAnalysis.ecgPreprocessing.BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);

RPeaks = ecgFiducialPointsSignal.getQrsPeak();
RPeaks = RPeaks + 1;

ecgFiducialPointsSignal = multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.FiducialPointsDetection.detectFiducialPoints(ecg,frequency);

QwavePeak = ecgFiducialPointsSignal.getQwavePeak();
ind = find(QwavePeak>0);
QwavePeak = QwavePeak(ind) + 1;
SwavePeak = ecgFiducialPointsSignal.getSwavePeak();
ind = find(SwavePeak>0);
SwavePeak = SwavePeak(ind) + 1;

QwaveAbsence = ecgFiducialPointsSignal.getQwaveAbsence();
SwaveAbsence = ecgFiducialPointsSignal.getSwaveAbsence();


% LP filtering n=8 Chebyshev 70Hz
ecgFiltred = multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ptDetection.MartinezPT.Chebyshev_LF_70(ecgFiltred,frequency);

% Powerline filtering

% Upsample to 1024 - cubic spline
time = (length(ecgFiltred)-1)/frequency;
numberOfSample = ceil(time*1024)

ecgUpSampled = spline((0:length(ecgFiltred)-1)/(length(ecgFiltred)-1),ecgFiltred,(0:numberOfSample-1)/(numberOfSample-1));

% Reanotiranje R zubaca

RPeaksReannot = RPeaks * 1024 / frequency;
RPeaksReannot = round(RPeaksReannot);

RPeaksAmplitudes = ecgUpSampled(RPeaksReannot);

if mean(RPeaksAmplitudes) > 0
    orientation = 1;
else
    orientation = 0;
end

if (orientation == 1)
    for i = 1:length(RPeaksReannot)
        while ecgUpSampled(RPeaksReannot(i)) < ecgUpSampled(RPeaksReannot(i)+1)
            RPeaksReannot(i) = RPeaksReannot(i)+1;
        end
        while ecgUpSampled(RPeaksReannot(i)) < ecgUpSampled(RPeaksReannot(i)-1)
            RPeaksReannot(i) = RPeaksReannot(i)-1;
        end
    end
else
    for i = 1:length(RPeaksReannot)
        while ecgUpSampled(RPeaksReannot(i)) > ecgUpSampled(RPeaksReannot(i)+1)
            RPeaksReannot(i) = RPeaksReannot(i)+1;
        end
        while ecgUpSampled(RPeaksReannot(i)) > ecgUpSampled(RPeaksReannot(i)-1)
            RPeaksReannot(i) = RPeaksReannot(i)-1;
        end
    end
end

% Reanotiranje Q vala

QwaveReannot = QwavePeak * 1024 / frequency;
QwaveReannot = round(QwaveReannot);

if (orientation == 0)
    for i = 1:length(QwaveReannot)
        if QwaveAbsence==false
            while ecgUpSampled(QwaveReannot(i)) < ecgUpSampled(QwaveReannot(i)+1)
                QwaveReannot(i) = QwaveReannot(i)+1;
            end
            while ecgUpSampled(QwaveReannot(i)) < ecgUpSampled(QwaveReannot(i)-1)
                QwaveReannot(i) = QwaveReannot(i)-1;
            end
        end
    end
else
    for i = 1:length(RPeaksReannot)
        if QwaveAbsence==false
            while ecgUpSampled(QwaveReannot(i)) > ecgUpSampled(QwaveReannot(i)+1)
                QwaveReannot(i) = QwaveReannot(i)+1;
            end
            while ecgUpSampled(QwaveReannot(i)) > ecgUpSampled(QwaveReannot(i)-1)
                QwaveReannot(i) = QwaveReannot(i)-1;
            end
        end
    end
end

% Reanotiranje S vala

SwaveReannot = SwavePeak * 1024 / frequency;
SwaveReannot = round(SwaveReannot);

if (orientation == 0)
    for i = 1:length(SwaveReannot)
        if SwaveAbsence==false
            while ecgUpSampled(SwaveReannot(i)) < ecgUpSampled(SwaveReannot(i)+1)
                SwaveReannot(i) = SwaveReannot(i)+1;
            end
            while ecgUpSampled(SwaveReannot(i)) < ecgUpSampled(SwaveReannot(i)-1)
                SwaveReannot(i) = SwaveReannot(i)-1;
            end
        end
    end
else
    for i = 1:length(SwaveReannot)
        if SwaveAbsence==false
            while ecgUpSampled(SwaveReannot(i)) > ecgUpSampled(SwaveReannot(i)+1)
                SwaveReannot(i) = SwaveReannot(i)+1;
            end
            while ecgUpSampled(SwaveReannot(i)) > ecgUpSampled(SwaveReannot(i)-1)
                SwaveReannot(i) = SwaveReannot(i)-1;
            end
        end
    end
end

% New frequncy
newFrequency = 1024;


startTime = 0;
segmentLength = 10;
k = 0;

sampleStart = 1;
sampleEnd = round(segmentLength*newFrequency);


ecgSegment = ecgUpSampled(sampleStart:sampleEnd);

ind = find(RPeaksReannot < sampleEnd);

RPeaksSegment = RPeaksReannot(ind);
QwavePeakSegment = QwaveReannot(ind);
SwavePeakSegment = SwaveReannot(ind);

QwaveAbsenceSegment = QwaveAbsence(ind);;
SwaveAbsenceSegment = SwaveAbsence(ind);;

figure(1);
plot(ecgSegment)
hold on
plot(RPeaksSegment,ecgSegment(RPeaksSegment),'ro')

plot(QwavePeakSegment,ecgSegment(QwavePeakSegment),'r*')
plot(SwavePeakSegment,ecgSegment(SwavePeakSegment),'r*')


% RRmin - the minimum RR interval found in the ECG under analysis

RRmin = RPeaksSegment(2) - RPeaksSegment(1);

for i=2:length(RPeaksSegment)-1
    RRtemp = RPeaksSegment(i+1) - RPeaksSegment(i);
    if RRtemp < RRmin
        RRmin = RRtemp;
    end
end

% Stvaranje CC matrice

% TODO Podijela R zubaca na temelju 2 parametara - RR prije i RR poslije -
% moda nije potrebno - vjerojatno bitno ne utjee na CC
% TODO modificirati algoritam odabira broja R zubaca koji ulaze (na temelju CC matrice)
% TOD0 modificirati algoritam tako da se rauna RRleft i RRright (na temelju izabranih R peakova)

M = length(RPeaksSegment);

s = ceil(0.3 * RRmin);
e = ceil(0.7 * RRmin);

L = s + e + 1;

N = M;
if (RPeaksSegment(1) - s) < 1
    start = 2;
    N = N - 1;
else
    start = 1;
end

if (RPeaksSegment(M) + e) > length(ecgSegment)
    stop = M - 1;
    N = N - 1;
else
    stop = M;
end

X = zeros(L, N);

for i = 1:N
    j = i + start - 1; %ili neka druga transformacija koja odreuje R zubac, npr. ovisna o CC
    for k = 1:L
        l = RPeaksSegment(j) - s + k - 1;
        X(k,i) = ecgSegment(l);
    end
end

figure(2)
plot(X);

[U,S,V] = svd(X);

P=U*S;
template = P(:,1);

figure(3);
plot(template);
hold on;

templateRPeak = 1+s;
templateAmplitudeR = template(1+s);

templateFiducialPoints = multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection.MartinezQS.DetectFiducialPoints(template,newFrequency,templateRPeak);

templateQwavePeak = templateFiducialPoints.getQwavePeak() + 1;
templateSwavePeak = templateFiducialPoints.getSwavePeak() + 1;

templateAmplitudeQ = template(templateQwavePeak);

templateQR = templateAmplitudeR - templateAmplitudeQ;

plot(templateQwavePeak,template(templateQwavePeak),'r*')
plot(templateSwavePeak,template(templateSwavePeak),'r*')

atrialActivity = ecgSegment;

P = 40;
M = 20;

for i = 1:length(RPeaksSegment)
    RPeak = RPeaksSegment(i);
    
    %TODO: Prvi R zubac ne treba imati Q val - tamo treba normalizirati prema S valu
    intervalQR = ecgSegment(RPeak) - ecgSegment(RPeak + templateQwavePeak - templateRPeak);
    templateForQRSTinterval = template/templateQR * intervalQR;
    templateForQRSTinterval = templateForQRSTinterval - templateForQRSTinterval(templateRPeak) + ecgSegment(RPeak);
    
    %TODO: Za prvi R zubac treba provjeriti da li je RPeak < 0.3 RRmin
    
    for j = -s:e
        k = j + RPeak;
        l = j + templateRPeak;
        if (k>0) && (k<=length(atrialActivity))
            atrialActivity(k) = atrialActivity(k) - templateForQRSTinterval(l);
        end
    end
end

figure(1);
plot(atrialActivity,'r')
