/*
 * Encog(tm) Java Examples v3.3
 * http://www.heatonresearch.com/encog/
 * https://github.com/encog/encog-java-examples
 *
 * Copyright 2008-2014 Heaton Research, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *   
 * For more information on Heaton Research copyrights, licenses 
 * and trademarks visit:
 * http://www.heatonresearch.com/copyright
 */
package multisab.processing.machineLearning;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.encog.ConsoleStatusReportable;
import org.encog.Encog;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.wizard.AnalystWizard;
import org.encog.bot.BotUtil;
import org.encog.mathutil.Equilateral;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.versatile.NormalizationHelper;
import org.encog.ml.data.versatile.VersatileMLDataSet;
import org.encog.ml.data.versatile.columns.ColumnDefinition;
import org.encog.ml.data.versatile.columns.ColumnType;
import org.encog.ml.data.versatile.sources.CSVDataSource;
import org.encog.ml.data.versatile.sources.VersatileDataSource;
import org.encog.ml.factory.MLMethodFactory;
import org.encog.ml.factory.MLTrainFactory;
import org.encog.ml.model.EncogModel;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.HybridStrategy;
import org.encog.ml.train.strategy.RequiredImprovementStrategy;
import org.encog.ml.train.strategy.StopTrainingStrategy;
import org.encog.neural.networks.training.propagation.manhattan.ManhattanPropagation;
import org.encog.neural.networks.training.strategy.RegularizationStrategy;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.normalize.DataNormalization;
import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.input.InputFieldCSV;
import org.encog.util.normalize.input.InputFieldCSVText;
import org.encog.util.normalize.output.OutputFieldRangeMapped;
import org.encog.util.normalize.output.nominal.OutputOneOf;
import org.encog.util.normalize.target.NormalizationStorageCSV;
import org.encog.util.simple.EncogUtility;

import static org.encog.util.csv.CSVFormat.DECIMAL_POINT;

public class IrisClassification {


	public void run(String[] args) {

		try {

			double in[][] = new double[150][4];
			String out[] = new String[150];

			File sourceFile = new File("E:/iris.csv");
			ReadCSV csv = new ReadCSV(sourceFile, false, DECIMAL_POINT);

			String[] line = new String[4];
			int i = 0;

			while(csv.next()) {
				in[i][0] = Double.parseDouble(csv.get(0));
				in[i][1] = Double.parseDouble(csv.get(1));
				in[i][2] = Double.parseDouble(csv.get(2));
				in[i][3] = Double.parseDouble(csv.get(3));
				out[i] = csv.get(4);
				i++;
			}

			// Analyze the data, determine the min/max/mean/sd of every column.
			double min[] = new double[4];
			double max[] = new double[4];
			double mean[] = new double[4];
			double sd[] = new double[4];

			for(i = 0; i < 4; i++) {
				min[i] = in[0][i];
				max[i] = in[0][i];
				for(int j = 1; j < 150; j++) {
					if (in[j][i] < min[i]) {
						min[i] = in[j][i];
					}
					if (in[j][i] > max[i]) {
						max[i] = in[j][i];
					}
				}
			}

			Map<Integer, String> mapClasses = new HashMap<Integer, String>();
			Map<String, Integer> inverseMapClasses = new HashMap<String, Integer>();

			int numberOfClasses = 0;
			mapClasses.put(numberOfClasses, out[0]);
			inverseMapClasses.put(out[0], numberOfClasses);
			numberOfClasses++;

			for(int j = 1; j < 150; j++) {
				if (!mapClasses.containsValue(out[j])) {
					mapClasses.put(numberOfClasses, out[j]);
					inverseMapClasses.put(out[j], numberOfClasses);
					numberOfClasses++;
				}
			}
			
			// Map the prediction column to the output of the model, and all
			// other columns to the input.
			// data.defineSingleOutputOthersInput(outputColumn);

			// Now normalize the data.  Encog will automatically determine the correct normalization
			// type based on the model you chose in the last step.
			// data.normalize();

			double features[][] = new double[150][4];
			double rangeMin = -1;
			double rangeMax = 1;

			for(i = 0; i < 4; i++) {
				for(int j = 0; j < 150; j++) {
					features[j][i] = (in[j][i]-min[i]) * (rangeMax - rangeMin) / (max[i] - min[i]) + rangeMin;
				}
			}

			double ideal[][] = new double[150][2];
			double encode[]; // = new double[2];
			Equilateral eq = new Equilateral(3, -1, 1);

			for(int j = 0; j < 150; j++)  {
				int intClass = inverseMapClasses.get(out[j]);
				encode = eq.encode(intClass);
				for(i = 0; i < 2; i++) {
					ideal[j][i] = encode[i];
				}
			}

			// Create the data set
			MLDataSet dataSet = new BasicMLDataSet(features, ideal);

			// Create feedforward neural network as the model type. MLMethodFactory.TYPE_FEEDFORWARD.
			// You could also other model types, such as:
			// MLMethodFactory.TYPE_SVM:  Support Vector Machine (SVM)
			// MLMethodFactory.TYPE_RBFNETWORK: RBF Neural Network
			// MLMethodFactor.TYPE_NEAT: NEAT Neural Network
			// MLMethodFactor.TYPE_PNN: Probabilistic Neural Network

			MLMethodFactory methodFactory = new MLMethodFactory();
			int inputFeatures = 4;
			int outputNeurons = 2;
			MLMethod method = methodFactory.create(MLMethodFactory.TYPE_FEEDFORWARD, "?:B->TANH->4:B->TANH->?", inputFeatures, outputNeurons);

			MLTrainFactory trainFactory = new MLTrainFactory();
			String trainerName = MLTrainFactory.TYPE_RPROP;
			String trainerArgs = "";
			MLTrain train = trainFactory.create(method,dataSet,trainerName,trainerArgs);
			/*
			// reset if improve is less than 1% over 5 cycles
			if( method instanceof MLResettable && !(train instanceof ManhattanPropagation) ) {
				train.addStrategy(new RequiredImprovementStrategy(500));
			}

			EncogUtility.trainToError(train, 0.01);
			method = train.getMethod();
			*/

			if( method instanceof MLEncodable) {
				train.addStrategy(new RegularizationStrategy(0.01));
				train.addStrategy(new StopTrainingStrategy(0.01, 100));
			}

			EncogUtility.trainToError(train, 0.01);
			method = train.getMethod();


			EncogUtility.evaluate((MLRegression) method, dataSet);

			// Display our normalization parameters.
			// NormalizationHelper helper = data.getNormHelper();
			// System.out.println(helper.toString());
			
			// Display the final model.
			System.out.println("Final model: " + method);
			
			// Loop over the entire, original, dataset and feed it through the model.
			// This also shows how you would process new data, that was not part of your
			// training set.  You do not need to retrain, simply use the NormalizationHelper
			// class.  After you train, you can save the NormalizationHelper to later
			// normalize and denormalize your data.

			csv.close();
			csv = new ReadCSV(sourceFile, false, DECIMAL_POINT);

			double input[] = new double[4];

			while(csv.next()) {
				StringBuilder result = new StringBuilder();
				line[0] = csv.get(0);
				line[1] = csv.get(1);
				line[2] = csv.get(2);
				line[3] = csv.get(3);
				String correct = csv.get(4);

				input[0] = Double.parseDouble(line[0]);
				input[1] = Double.parseDouble(line[1]);
				input[2] = Double.parseDouble(line[2]);
				input[3] = Double.parseDouble(line[3]);

				//helper.normalizeInputVector(line,input.getData(),false);
				for(i = 0; i < 4; i++) {
					input[i] = (input[i]-min[i]) * (rangeMax - rangeMin) / (max[i] - min[i]) + rangeMin;
				}

				MLData data = new BasicMLData(input);
				MLData output = ((MLRegression) method).compute(data);

				String irisChosen = mapClasses.get(eq.decode(output.getData()));
				//String irisChosen = helper.denormalizeOutputVectorToString(output)[0];
				
				result.append(Arrays.toString(line));
				result.append(" -> predicted: ");
				result.append(irisChosen);
				result.append("(correct: ");
				result.append(correct);
				result.append(")");
				
				System.out.println(result.toString());
			}
			

			Encog.getInstance().shutdown();

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public static void main(String[] args) {
		IrisClassification prg = new IrisClassification();
		prg.run(args);
	}
}
