package multisab.processing.machineLearning.RFcore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Entry {

	protected ArrayList<Field> fields;
	
	public Entry(){
		this.fields = new ArrayList<>();
	}
	
	public Entry(ArrayList<String> data, Map<Integer, Map<Integer, String>> dictionaries){
		this.fields = new ArrayList<>();
		for (int i=0; i<data.size(); i++){
			if(isNumeric(data.get(i)) ){
				RealValField rvf = new RealValField(i);
				rvf.setValue(Double.parseDouble(data.get(i)));		
				fields.add(rvf);
			}
			else {
				CategoryField cf = new CategoryField(i);
				//check if dictionary list is empty
				if(dictionaries.get(i)==null){
					dictionaries.put(i, new HashMap<Integer, String>());
				}
				Map dict = dictionaries.get(i);
				if(	dict.containsValue(data.get(i))){
					int key = getKey(dict, data.get(i));
					cf.setValue(getKey(dict, data.get(i)));
				}
				else{
					dict.put(dict.keySet().size(), data.get(i));
					cf.setValue(getKey(dict, data.get(i)));
				}
				fields.add(cf);
				
			}
			
		}
		
	}
	
	
	
	public ArrayList<Field> getFields(){
		return fields;
	}
	
	public void setFields(ArrayList<Field> data){
		this.fields = data;
	}
	
	
	private static boolean isNumeric(String str)  
	{  
	  try  
	  {  
	    double d = Double.parseDouble(str);  
	  }  
	  catch(NumberFormatException nfe)  
	  {  
	    return false;  
	  }  
	  return true;  
	}
	
	public static int getKey(Map<Integer, String> dict, String value)
	{  
		int key = 0 ;
		for(Map.Entry<Integer, String> entry: dict.entrySet()){
			if(entry.getValue().equals(value))
				key= entry.getKey();
		}
		
		return key;
	    
	}

	
}
