package multisab.processing.machineLearning.normalization;

import org.encog.mathutil.Equilateral;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Davor on 10.10.2016..
 */
public class EquilateralStringCoder extends Coder {

    private Equilateral eq;
    Map<Integer, String> mapClasses = new HashMap<Integer, String>();
    Map<String, Integer> inverseMapClasses = new HashMap<String, Integer>();

    public EquilateralStringCoder(double outputNormalizationMin, double outputNormalizationMax, int numberOfClasses) {
        super(outputNormalizationMin, outputNormalizationMax, numberOfClasses);
    }

    @Override
    public double[][] encode(String[] classes){

        int numberOfSamples = classes.length;

        numberOfClasses = 0;
        mapClasses.put(numberOfClasses, classes[0]);
        inverseMapClasses.put(classes[0], numberOfClasses);
        numberOfClasses++;

        for(int j = 1; j < numberOfSamples; j++) {
            if (!mapClasses.containsValue(classes[j])) {
                mapClasses.put(numberOfClasses, classes[j]);
                inverseMapClasses.put(classes[j], numberOfClasses);
                numberOfClasses++;
            }
        }

        double[][] ideal = new double[numberOfSamples][numberOfClasses-1];

        double encode[];
        eq = new Equilateral(numberOfClasses, outputNormalizationMin, outputNormalizationMax);

        for(int j = 0; j < numberOfSamples; j++)  {
            int intClass = inverseMapClasses.get(classes[j]);
            encode = eq.encode(intClass);
            for(int i = 0; i < (numberOfClasses - 1); i++) {
                ideal[j][i] = encode[i];
            }
        }

        return ideal;
    }

    @Override
    public String decodeToString(double[] clasifierOutput){

        return mapClasses.get(eq.decode(clasifierOutput));
    }
}
