package multisab.processing.machineLearning.normalization;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Davor on 10.10.2016..
 */
public class IntStringCoder extends Coder {

    Map<Double, String> mapClasses = new HashMap<Double, String>();
    Map<String, Double> inverseMapClasses = new HashMap<String, Double>();

    public IntStringCoder(double outputNormalizationMin, double outputNormalizationMax, int numberOfClasses) {
        super(outputNormalizationMin, outputNormalizationMax, numberOfClasses);
    }

    @Override
    public double[][] encode(String[] classes){

        int numberOfSamples = classes.length;

        numberOfClasses = 0;
        mapClasses.put((double)numberOfClasses, classes[0]);
        inverseMapClasses.put(classes[0], (double)numberOfClasses);
        numberOfClasses++;

        for(int j = 1; j < numberOfSamples; j++) {
            if (!mapClasses.containsValue(classes[j])) {
                mapClasses.put((double)numberOfClasses, classes[j]);
                inverseMapClasses.put(classes[j], (double)numberOfClasses);
                numberOfClasses++;
            }
        }

        double ideal[][] = new double[numberOfSamples][1];

        for(int j = 0; j < numberOfSamples; j++)  {
            double doubleClass = inverseMapClasses.get(classes[j]);
            ideal[j][0] = doubleClass;
        }

        return ideal;
    }

    @Override
    public String decodeToString(double[] clasifierOutput){

        return mapClasses.get(clasifierOutput[0]);
    }
}
