package multisab.processing.scenarios;

import multisab.processing.multisabException.ScenarioException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * created by Alan Jovic 11.03.2018.
 */
public class PredefinedScenarios {
    /**
     * The method returns an array of predefined scenarios names, based on analysis type and data type selected
     * @param analysisType
     * @param dataType
     * @return
     * @throws Exception
     */
    public static List<String> getPredefinedScenariosNames(String analysisType, String dataType, String language) throws Exception{
        String [] dataTypes;
        List<String> predefinedScenariosList = new ArrayList<>();
        int i;
        boolean ecgAdded = false;

        if (language != null) {
            if (language.toLowerCase().equals("hr")) {
                switch (analysisType) {
                    case (AnalysisType.CLASSIFICATION):
                        dataTypes = DataTypes.getAllDataTypesContainingDataType(dataType);
                        if (dataTypes == null) {
                            throw new Exception("Error: Unknown data type selected");
                        }
                        if (dataType.contains("ECG")) {
                            predefinedScenariosList.add(Scenarios.AMI_CLASSIFICATION_HR);
                            predefinedScenariosList.add(Scenarios.CHF_CLASSIFICATION_HR);
                            predefinedScenariosList.add(Scenarios.AF_CLASSIFICATION_HR);
                            predefinedScenariosList.add(Scenarios.ARRHYTHMIA_CLASSIFICATION_HR);
                            ecgAdded = true;
                        }
                        if (dataType.contains("HRV")) {
                            if (!ecgAdded) {
                                predefinedScenariosList.add(Scenarios.CHF_CLASSIFICATION_HR);
                                predefinedScenariosList.add(Scenarios.AF_CLASSIFICATION_HR);
                                predefinedScenariosList.add(Scenarios.ARRHYTHMIA_CLASSIFICATION_HR);
                            }
                        }
                        if (dataType.contains("EEG")) {
                            predefinedScenariosList.add(Scenarios.EPILEPSY_CLASSIFICATION_HR);
                        }
                        //TODO: add other scenarios
                        break;
                    case (AnalysisType.DETECTION):
                        dataTypes = DataTypes.getAllDataTypesContainingDataType(dataType);
                        if (dataTypes == null) {
                            throw new Exception("Error: Unknown data type selected");
                        }
                        if (dataType.contains("ECG")) {
                            predefinedScenariosList.add(Scenarios.AMI_DETECTION_HR);
                            predefinedScenariosList.add(Scenarios.CHF_DETECTION_HR);
                            predefinedScenariosList.add(Scenarios.AF_DETECTION_HR);
                            predefinedScenariosList.add(Scenarios.ARRHYTHMIA_DETECTION_HR);
                            ecgAdded = true;
                        }
                        if (dataType.contains("HRV")) {
                            if (!ecgAdded) {
                                predefinedScenariosList.add(Scenarios.CHF_DETECTION_HR);
                                predefinedScenariosList.add(Scenarios.AF_DETECTION_HR);
                                predefinedScenariosList.add(Scenarios.ARRHYTHMIA_DETECTION_HR);
                            }
                        }
                        if (dataType.contains("EEG")) {
                            predefinedScenariosList.add(Scenarios.EPILEPSY_DETECTION_HR);
                        }
                        //TODO: add other scenarios
                        break;
                    case (AnalysisType.INSPECTION):
                        predefinedScenariosList.add("Inspekcija i vizualizacija");
                        break;
                    default:
                        throw new ScenarioException("No scenarios defined for the analysis and data type");
                }
            }
            else if (language.toLowerCase().equals("en")){
                switch (analysisType) {
                    case (AnalysisType.CLASSIFICATION):
                        dataTypes = DataTypes.getAllDataTypesContainingDataType(dataType);
                        if (dataTypes == null) {
                            throw new Exception("Error: Unknown data type selected");
                        }
                        if (dataType.contains("ECG")) {
                            predefinedScenariosList.add(Scenarios.AMI_CLASSIFICATION_EN);
                            predefinedScenariosList.add(Scenarios.CHF_CLASSIFICATION_EN);
                            predefinedScenariosList.add(Scenarios.AF_CLASSIFICATION_EN);
                            predefinedScenariosList.add(Scenarios.ARRHYTHMIA_CLASSIFICATION_EN);
                            ecgAdded = true;
                        }
                        if (dataType.contains("HRV")) {
                            if (!ecgAdded) {
                                predefinedScenariosList.add(Scenarios.CHF_CLASSIFICATION_EN);
                                predefinedScenariosList.add(Scenarios.AF_CLASSIFICATION_EN);
                                predefinedScenariosList.add(Scenarios.ARRHYTHMIA_CLASSIFICATION_EN);
                            }
                        }
                        if (dataType.contains("EEG")) {
                            predefinedScenariosList.add(Scenarios.EPILEPSY_CLASSIFICATION_EN);
                        }
                        //TODO: add other scenarios
                        break;
                    case (AnalysisType.DETECTION):
                        dataTypes = DataTypes.getAllDataTypesContainingDataType(dataType);
                        if (dataTypes == null) {
                            throw new Exception("Error: Unknown data type selected");
                        }
                        if (dataType.contains("ECG")) {
                            predefinedScenariosList.add(Scenarios.AMI_DETECTION_EN);
                            predefinedScenariosList.add(Scenarios.CHF_DETECTION_EN);
                            predefinedScenariosList.add(Scenarios.AF_DETECTION_EN);
                            predefinedScenariosList.add(Scenarios.ARRHYTHMIA_DETECTION_EN);
                            ecgAdded = true;
                        }
                        if (dataType.contains("HRV")) {
                            if (!ecgAdded) {
                                predefinedScenariosList.add(Scenarios.CHF_DETECTION_EN);
                                predefinedScenariosList.add(Scenarios.AF_DETECTION_EN);
                                predefinedScenariosList.add(Scenarios.ARRHYTHMIA_DETECTION_EN);
                            }
                        }
                        if (dataType.contains("EEG")) {
                            predefinedScenariosList.add(Scenarios.EPILEPSY_DETECTION_EN);
                        }
                        //TODO: add other scenarios
                        break;
                    case (AnalysisType.INSPECTION):
                        predefinedScenariosList.add("Inspection and visualization");
                        break;
                    default:
                        throw new ScenarioException("No scenarios defined for the analysis and data type");
                }
            }
        }
        if (predefinedScenariosList.size()==0) {
            throw new ScenarioException("No scenarios defined for the analysis and data type");
        }

        return predefinedScenariosList;

    }
}

