package multisab.processing.signalVisualization;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.imageio.ImageIO;

import java.util.Arrays;

import multisab.processing.dataHandling.*;

public class ImageCreating_noGridLabel {

	private int maxGridLines = 100;
	private double gridIntervals[] = {0.2, 0.5, 1, 2, 5, 10, 15, 30, 60, 120, 300, 600, 1800, 3600, 86400};
	private String gridIntervalsNames[] = {"0.2 s", "0.5 s", "1 s", "2 s", "5 s", "10 s", "15 s", "30 s", "1 min", "2 min", "5 min", "10 min", "30 min", "1 sat", "1 dan"};
	private double gridTicks[] = {1, 5, 10, 50, 100, 500}; //{0.5, 1, 5, 10, 50, 100, 500};
	//private String gridTicksUnits[] = {"p", "u", "m", "", "k", "M"};

	private InputData data;

	private Metadata metadata;
	private double[][] signals;
	//Ukupan broj signala (u datoteci)
	private int signalsNum;
	private String[] signalLabels;
	//Broj signala za iscrtavanje
	private int plotSignalsNum;
	private String[] plotSignalLabels;
	private int[] signalsIndicesPlot;
	private double duration;

	private int width;
	private int height;

	private double plotStart;
	private double plotStop;
	private double gridInterval;

	private int gridTick;
	private double[] gridTickValue;
	private String gridLabel;
	private String label;
	private int[] gridValue1;
	private int[] gridValue2;
	private int[] gridValue3;
	private int[] gridValue4;
	private boolean plotShort;
	private double[] scale;
	private double[] origin;
	private String[] physicalDimension;
	private double[][] sortedSignals;

	public ImageCreating_noGridLabel(String recordFilePath) {

		//Učitavanje podataka

		File file = new File(recordFilePath);

		String ext = "";
		int i = recordFilePath.lastIndexOf('.');
		if (i > 0) {
			ext = recordFilePath.substring(i+1);
		}
		String recordType = ext.toUpperCase();
		try {
			if (recordType.equals("EDF")) {
				data = new EdfFile(file,false);
			}
			if (recordType.equals("ANN")) {
				data = new AnnFile(file,false);
			}
			if (recordType.equals("TXT")) {
				data = new TxtFile(file,false);
			}
			if (recordType.equals("CSV")) {
				data = new CsvFile(file,false);
			}

			metadata = data.getMetadata();

			signals = data.getSignals();
			signalsNum = data.getNumberOfSignals();
			duration = data.calculateDuration();

			signalLabels = new String[signalsNum];

			for (i = 0; i < signalsNum; i++) {
				signalLabels[i] = metadata.getSignalParameters()[i].getLabel();
			}

			sortedSignals = new double[signalsNum][];

			for (i = 0; i < signalsNum; i++) {
				double[] signal = Arrays.copyOf(signals[i], signals[i].length);
				Arrays.sort(signal);
				sortedSignals[i] = signal;
			}

		}
		catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			System.out.println("File not found. Sorry for the inconvenience.");
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.out.println("An error occurred while loading file. The file had to be closed.");
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void setImageParameters_height(int width, int minHeight, String[] signalType, boolean plotAllSignals, int[] signalsIndices) {

		this.width = width;
		plotShort = false;

		if (plotAllSignals) {
			plotSignalsNum = signalsNum;
			signalsIndicesPlot = new int[plotSignalsNum];
			for (int i = 0; i < plotSignalsNum; i++) {
				signalsIndicesPlot[i] = i;
			}
		}
		else {
			plotSignalsNum = signalsIndices.length;
			if (plotSignalsNum == 0) {
				plotSignalsNum = 1;
				signalsIndicesPlot = new int[plotSignalsNum];
				signalsIndicesPlot[0] = 0;
			}
			else {
				signalsIndicesPlot = new int[plotSignalsNum];
				for (int i = 0; i < plotSignalsNum; i++) {
					signalsIndicesPlot[i] = signalsIndices[i];
				}
			}
		}

		plotSignalLabels = new String[plotSignalsNum];

		for (int i = 0; i < plotSignalsNum; i++) {
			plotSignalLabels[i] = metadata.getSignalParameters()[signalsIndicesPlot[i]].getLabel();
		}

		//Izračun visine slike

		gridTick = 15;
		height = 1 + 18 + (7 * plotSignalsNum + 1) * gridTick;

		if (height < minHeight) {
			gridTick = (int)(minHeight - 1 - 18) / (7 * plotSignalsNum + 1);
			height = 1 + 18 + (7 * plotSignalsNum + 1) * gridTick;
		}

		yAxisProperties(signalType);
	}

	public void setImageParameters_width(int width, int height, String[] signalType, boolean plotAllSignals, int[] signalsIndices) {

		this.width = width;
		plotShort = false;

		if (plotAllSignals) {
			plotSignalsNum = signalsNum;
			signalsIndicesPlot = new int[plotSignalsNum];
			for (int i = 0; i < plotSignalsNum; i++) {
				signalsIndicesPlot[i] = i;
			}
		}
		else {
			plotSignalsNum = signalsIndices.length;
			if (plotSignalsNum == 0) {
				plotSignalsNum = 1;
				signalsIndicesPlot = new int[plotSignalsNum];
				signalsIndicesPlot[0] = 0;
			}
			else {
				signalsIndicesPlot = new int[plotSignalsNum];
				for (int i = 0; i < plotSignalsNum; i++) {
					signalsIndicesPlot[i] = signalsIndices[i];
				}
			}
		}


		//Izračun visine slike

		gridTick = (int)(height - 1 - 18) / (7 * plotSignalsNum + 1);
		this.height = 1 + 18 + (7 * plotSignalsNum + 1) * gridTick;


		if (gridTick < 12) {
			plotShort = true;
			gridTick = (int)(height - 1 - 18) / (2 * plotSignalsNum + 4); //gridTick = (int)(height - 20 - 18) / (2 * plotSignalsNum + 6);
			this.height = 1 + 18 + (2 * plotSignalsNum + 4) * gridTick; //this.height = 20 + 18 + (2 * plotSignalsNum + 4) * gridTick;
			if (gridTick < 9) {
				return;
			}
		}

		yAxisProperties(signalType);
	}

	private void yAxisProperties(String[] signalType) {

		// Izračun intervala koordinatne rešetke na y osi

		int signalIndex = 0;
		label = "";
		gridValue1 = new int [signalsNum];
		gridValue2 = new int [signalsNum];
		gridValue3 = new int [signalsNum];
		gridValue4 = new int [signalsNum];

		if (signalType.length == 1) { // TODO: Pretpostavka: Ako postoji više "istih" signala riječ je o EKG-u ili EEG-u

			//if (signalType[0].equalsIgnoreCase("ECG") || signalType[0].equalsIgnoreCase("EEG")) {

			int maxSignalValueIndex = 0;

			double maxDiff = sortedSignals[signalIndex][(int)(0.875 * data.getSignalSamplesNum(signalIndex))]
					- sortedSignals[signalIndex][(int)(0.125 * data.getSignalSamplesNum(signalIndex))];

			for (signalIndex = 1; signalIndex < signalsNum; signalIndex++) {
				double diff = sortedSignals[signalIndex][(int)(0.875 * data.getSignalSamplesNum(signalIndex))]
						- sortedSignals[signalIndex][(int)(0.125 * data.getSignalSamplesNum(signalIndex))];
				if (diff > maxDiff) {
					maxSignalValueIndex = signalIndex;
					maxDiff = diff;
				}
			}

			double maxValue = sortedSignals[maxSignalValueIndex][(int)(0.875 * data.getSignalSamplesNum(maxSignalValueIndex))];
			double minValue = sortedSignals[maxSignalValueIndex][(int)(0.125 * data.getSignalSamplesNum(maxSignalValueIndex))];
			double originValue = 0;
			//double originValue = sortedSignals[maxSignalValueIndex][(int)(0.5 * data.getSignalSamplesNum(maxSignalValueIndex))];
			if (Math.max(Math.abs(sortedSignals[maxSignalValueIndex][(int)(0.95 * data.getSignalSamplesNum(maxSignalValueIndex))]), Math.abs(sortedSignals[maxSignalValueIndex][(int)(0.05 * data.getSignalSamplesNum(maxSignalValueIndex))]))
					> 2 * Math.max(Math.abs(maxValue), Math.abs(minValue))) {
				maxValue = sortedSignals[maxSignalValueIndex][(int)(0.95 * data.getSignalSamplesNum(maxSignalValueIndex))];
				minValue = sortedSignals[maxSignalValueIndex][(int)(0.05 * data.getSignalSamplesNum(maxSignalValueIndex))];
			}

			scale = new double[signalsNum];
			origin = new double[signalsNum];
			physicalDimension = new String[signalsNum];

			for (int i = 0; i < signalsNum; i++) {
				scale[i] = 1;
				origin[i] = originValue;
				physicalDimension[i] = metadata.getSignalParameters()[i].getPhysicalDimension();
			}

			while (Math.max(Math.abs(maxValue), Math.abs(minValue)) < 1) {

				for (int i = 0; i < signalsNum; i++) {
					scale[i] = scale[i] * 1000;
				}
				maxValue = maxValue * 1000;
				minValue = minValue * 1000;

				for (int i = 0; i < signalsNum; i++) {

					switch (physicalDimension[i].charAt(0)) {
						case 'M': physicalDimension[i] = "k" + physicalDimension[i].substring(1);
							break;
						case 'k': physicalDimension[i] = "" + physicalDimension[i].substring(1);
							break;
						case 'm': physicalDimension[i] = "u" + physicalDimension[i].substring(1);
							break;
						case 'u': physicalDimension[i] = "p" + physicalDimension[i].substring(1);
							break;
						default:  physicalDimension[i] = physicalDimension[i] + "*10e-3";
							break;
					}

				}

			}

			while (Math.max(Math.abs(maxValue), Math.abs(minValue)) > 1000) {

				for (int i = 0; i < signalsNum; i++) {
					scale[i] = scale[i] * 0.001;
				}
				maxValue = maxValue * 0.001;
				minValue = minValue * 0.001;

				for (int i = 0; i < signalsNum; i++) {

					switch (physicalDimension[i].charAt(0)) {
						case 'k': physicalDimension[i] = "M" + physicalDimension[i].substring(1);
							break;
						case 'm': physicalDimension[i] = "" + physicalDimension[i].substring(1);
							break;
						case 'u': physicalDimension[i] = "m" + physicalDimension[i].substring(1);
							break;
						case 'p': physicalDimension[i] = "u" + physicalDimension[i].substring(1);
							break;
						default:  physicalDimension[i] = physicalDimension[i] + "*10e+3";
							break;
					}

				}

			}

			gridTickValue = new double[signalsNum];
			double gridTickValues;

			int gridTickIndex = 0;
			gridTickValues = gridTicks[gridTickIndex];

			while (Math.max(Math.abs(maxValue), Math.abs(minValue)) > (gridTickValues * 3)) {

				gridTickIndex = gridTickIndex + 1;
				gridTickValues = gridTicks[gridTickIndex];
			}

			label = ", " + Integer.toString((int)gridTickValues) + " " + physicalDimension[0] + " (" + signalType[0] + ")";

			for (int i = 0; i < signalsNum; i++) {
				gridTickValue[i] = gridTickValues;
				gridValue1[i] = (int)(0 + 3 * gridTickValue[i]);
				gridValue2[i] = (int)(0 + 2 * gridTickValue[i]);
				gridValue3[i] = (int)(0 - 2 * gridTickValue[i]);
				gridValue4[i] = (int)(0 - 3 * gridTickValue[i]);
			}
		}
		else {
			scale = new double[signalsNum];
			origin = new double[signalsNum];
			physicalDimension = new String[signalsNum];
			gridTickValue = new double[signalsNum];

			for (int s = 0; s < signalsNum; s++) {
				scale[s] = 1;
				physicalDimension[s] = metadata.getSignalParameters()[s].getPhysicalDimension();
			}

			for(int s = 0; s < signalsNum; s++) {

				double maxValue;
				double minValue;

				if (signalType[s].equalsIgnoreCase("ECG") || signalType[s].equalsIgnoreCase("EEG") || signalType[s].equalsIgnoreCase("EMG")) {

					maxValue = sortedSignals[s][(int)(0.875 * data.getSignalSamplesNum(s))];
					minValue = sortedSignals[s][(int)(0.125 * data.getSignalSamplesNum(s))];
					origin[s] = 0;
					if (Math.max(Math.abs(sortedSignals[s][(int)(0.95 * data.getSignalSamplesNum(s))]), Math.abs(sortedSignals[s][(int)(0.05 * data.getSignalSamplesNum(s))]))
							> 2 * Math.max(Math.abs(maxValue), Math.abs(minValue))) {
						maxValue = sortedSignals[s][(int)(0.95 * data.getSignalSamplesNum(s))];
						minValue = sortedSignals[s][(int)(0.05 * data.getSignalSamplesNum(s))];
					}
				}
				else {

					maxValue = sortedSignals[s][(int)(0.875 * data.getSignalSamplesNum(s))];
					minValue = sortedSignals[s][(int)(0.125 * data.getSignalSamplesNum(s))];
					origin[s] = sortedSignals[s][(int)(0.5 * data.getSignalSamplesNum(s))];
					if (Math.max(Math.abs(sortedSignals[s][(int)(0.95 * data.getSignalSamplesNum(s))]), Math.abs(sortedSignals[s][(int)(0.05 * data.getSignalSamplesNum(s))]))
							> 2 * Math.max(Math.abs(maxValue), Math.abs(minValue))) {
						maxValue = sortedSignals[s][(int)(0.95 * data.getSignalSamplesNum(s))];
						minValue = sortedSignals[s][(int)(0.05 * data.getSignalSamplesNum(s))];
					}
				}

				while (Math.max(Math.abs(maxValue), Math.abs(minValue)) < 1) {

					scale[s] = scale[s] * 1000;

					maxValue = maxValue * 1000;
					minValue = minValue * 1000;

					switch (physicalDimension[s].charAt(0)) {
						case 'M': physicalDimension[s] = "k" + physicalDimension[s].substring(1);
							break;
						case 'k': physicalDimension[s] = "" + physicalDimension[s].substring(1);
							break;
						case 'm': physicalDimension[s] = "u" + physicalDimension[s].substring(1);
							break;
						case 'u': physicalDimension[s] = "p" + physicalDimension[s].substring(1);
							break;
						default:  physicalDimension[s] = physicalDimension[s] + "*10e-3";
							break;
					}

				}

				while (Math.max(Math.abs(maxValue), Math.abs(minValue)) > 1000) {

					scale[s] = scale[s] * 0.001;

					maxValue = maxValue * 0.001;
					minValue = minValue * 0.001;

					switch (physicalDimension[s].charAt(0)) {
						case 'k': physicalDimension[s] = "M" + physicalDimension[s].substring(1);
							break;
						case 'm': physicalDimension[s] = "" + physicalDimension[s].substring(1);
							break;
						case 'u': physicalDimension[s] = "m" + physicalDimension[s].substring(1);
							break;
						case 'p': physicalDimension[s] = "u" + physicalDimension[s].substring(1);
							break;
						default:  physicalDimension[s] = physicalDimension[s] + "*10e+3";
							break;
					}

				}

				int gridTickIndex = 0;
				gridTickValue[s] = gridTicks[gridTickIndex];

				if (signalType[s].equalsIgnoreCase("ECG") || signalType[s].equalsIgnoreCase("EEG") || signalType[s].equalsIgnoreCase("EMG")) {

					while (Math.max(Math.abs(maxValue), Math.abs(minValue)) > (gridTickValue[s] * 3)) {

						gridTickIndex = gridTickIndex + 1;
						gridTickValue[s] = gridTicks[gridTickIndex];
					}

					gridTickValue[s] = gridTickValue[s];
					gridValue1[s] = (int)(0 + 3 * gridTickValue[s]);
					gridValue2[s] = (int)(0 + 2 * gridTickValue[s]);
					gridValue3[s] = (int)(0 - 2 * gridTickValue[s]);
					gridValue4[s] = (int)(0 - 3 * gridTickValue[s]);
				}
				else {

					while ((maxValue - minValue) > (gridTickValue[s] * 6)) {

						gridTickIndex = gridTickIndex + 1;
						gridTickValue[s] = gridTicks[gridTickIndex];
					}

					gridTickValue[s] = gridTickValue[s];
					origin[s] = ((int)(origin[s]/gridTickValue[s])) * gridTickValue[s];
					gridValue1[s] = (int)(origin[s] + 3 * gridTickValue[s]);
					gridValue2[s] = (int)(origin[s] + 2 * gridTickValue[s]);
					gridValue3[s] = (int)(origin[s] - 2 * gridTickValue[s]);
					gridValue4[s] = (int)(origin[s] - 3 * gridTickValue[s]);
				}
			}

			for (int i = 0; i < plotSignalsNum; i++) {
				signalIndex = signalsIndicesPlot[i];
				label = label + ", " + Integer.toString((int)gridTickValue[signalIndex]) + " " + physicalDimension[signalIndex] + " (" + signalType[signalIndex] + ")";
			}
		}
	}


	public void getImage(double start, double stop, String session) {

		if (start < 0)
			start = 0;
		if (start > duration)
			start = 0;
		if (stop > duration)
			stop = duration;

		//Ako bi se iscrtavale i anotacije
		//Annotation[] annots = data.getAnnotsFromInterval(0, start, stop);

		try {

			// TYPE_INT_ARGB specifies the image format: 8-bit RGBA packed into integer pixels

			BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);

			Graphics2D ig2 = bi.createGraphics();



			//Računanje parametara potrebnih za crtanje

			//Ispravljanje starta i stopa da budu dijeljivi s grid intervalom

			gridInterval = 0.2;
			String gridIntervalName = "0.2 s";

			plotStop = 0;

			int gridLines = (int)((stop-start)/gridInterval);

			if (gridLines > maxGridLines) {
				int k = 1;
				while (gridLines > maxGridLines) {
					gridInterval = gridIntervals[k];
					gridIntervalName = gridIntervalsNames[k];

					gridLines = (int)((stop-start)/gridInterval);

					k = k + 1;
				}
			}

			if ( ( ((int)(start/gridInterval)) * gridInterval) !=  start) {
				start = ((int)(start/gridInterval)) * gridInterval;
				start = Math.max(0, start);
			}
			if ( ( ((int)(stop/gridInterval)) * gridInterval) !=  stop) {
				plotStop = ((int)(stop/gridInterval)+1) * gridInterval;
				stop = Math.min(data.calculateDuration(), plotStop);
			}
			else {
				plotStop = stop;
			}

			gridLines = (int)((plotStop-start)/gridInterval);

			plotStart = start;

			if (plotShort == false) {

				// Traženje najduljeg naziva signala ili vrijednosti na y osi

				int maxLabelWidth = 0;

				Font labelsFont = new Font("TimesRoman", Font.ITALIC, 15);
				ig2.setFont(labelsFont);
				FontMetrics fontMetrics = ig2.getFontMetrics();
				int stringWidth = 0;
				int stringHeight = 0;

				int signalIndex = 0;

				for (signalIndex = 0; signalIndex < signalsNum; signalIndex++) {
					String signalLabel = metadata.getSignalParameters()[signalIndex].getLabel();
					stringWidth = fontMetrics.stringWidth(signalLabel);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
				}

				Font unitFont = new Font("TimesRoman", Font.PLAIN, 10);
				ig2.setFont(labelsFont);
				fontMetrics = ig2.getFontMetrics();
				ig2.setFont(unitFont);
				fontMetrics = ig2.getFontMetrics();
				for (signalIndex = 0; signalIndex < plotSignalsNum; signalIndex++) {
					String v1 = Integer.toString(gridValue1[signalIndex]) + physicalDimension[signalIndex];
					stringWidth = fontMetrics.stringWidth(v1);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
					String v2 = Integer.toString(gridValue2[signalIndex]) + physicalDimension[signalIndex];
					stringWidth = fontMetrics.stringWidth(v2);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
					String v3 = Integer.toString(gridValue3[signalIndex]) + physicalDimension[signalIndex];
					stringWidth = fontMetrics.stringWidth(v3);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
					String v4 = Integer.toString(gridValue4[signalIndex]) + physicalDimension[signalIndex];
					stringWidth = fontMetrics.stringWidth(v4);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
				}


				//Generiranje teksta o duljini intervala koordinatne rešetke i podacima o signalima

				gridLabel = "Interval koordinatne rešetke: " + gridIntervalName + label;

				//Ispis naziva signala

				ig2.setFont(labelsFont);
				ig2.setPaint(Color.black);
				fontMetrics = ig2.getFontMetrics();
				for (int i = 0; i < plotSignalsNum; i++) {
					signalIndex = signalsIndicesPlot[i];
					String signalLabel = metadata.getSignalParameters()[signalIndex].getLabel();
					stringWidth = fontMetrics.stringWidth(signalLabel);
					stringHeight = fontMetrics.getAscent();
					ig2.drawString(signalLabel, width - maxLabelWidth, 1 + stringHeight/2 + gridTick * (4 + 7 * i) - 1);
					ig2.drawString(signalLabel, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (4 + 7 * i) - 1);
				}

				//Ispis vrijednost na y os

				ig2.setFont(unitFont);
				fontMetrics = ig2.getFontMetrics();
				for (int i = 0; i < plotSignalsNum; i++) {
					signalIndex = signalsIndicesPlot[i];
					String v1 = Integer.toString(gridValue1[signalIndex]) + physicalDimension[signalIndex];
					String v2 = Integer.toString(gridValue2[signalIndex]) + physicalDimension[signalIndex];
					String v3 = Integer.toString(gridValue3[signalIndex]) + physicalDimension[signalIndex];
					String v4 = Integer.toString(gridValue4[signalIndex]) + physicalDimension[signalIndex];
					stringWidth = fontMetrics.stringWidth(v1);
					stringHeight = fontMetrics.getAscent();
					stringWidth = fontMetrics.stringWidth(v1);
					ig2.drawString(v1, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (1 + 7 * i) - 1);
					stringWidth = fontMetrics.stringWidth(v2);
					ig2.drawString(v2, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (2 + 7 * i) - 1);
					stringWidth = fontMetrics.stringWidth(v3);
					ig2.drawString(v3, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (6 + 7 * i) - 1);
					stringWidth = fontMetrics.stringWidth(v4);
					ig2.drawString(v4, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (7 + 7 * i) - 1);
				}

				//Ispis vremena

				Font xLabelFont = new Font("TimesRoman", Font.PLAIN, 15);
				ig2.setFont(xLabelFont);
				String t1 = timeInSecondsToString(start);
				fontMetrics = ig2.getFontMetrics();
				stringWidth = fontMetrics.stringWidth(t1);
				stringHeight = fontMetrics.getAscent();
				ig2.setPaint(Color.black);
				ig2.drawString(t1, maxLabelWidth - stringWidth/2, height - 1 - 2);

				String t2 = timeInSecondsToString(plotStop);
				stringWidth = fontMetrics.stringWidth(t2);
				ig2.drawString(t2, width - stringWidth/2 - maxLabelWidth, height - 1 - 2);


				//Crtanje grida

				ig2.setPaint(Color.red.brighter());
				int i;
				for(i = 0; i<=gridLines; i++) { //for(i = 1; i<gridLines; i++) {
					double x1 = maxLabelWidth + 5 + ((double)(width - 2 * maxLabelWidth - 10 - 1)) / (gridLines) * i;
					double y1 = height - 1 - 18;
					double x2 = maxLabelWidth + 5 + ((double)(width - 2 * maxLabelWidth - 10 - 1)) / (gridLines) * i;
					double y2 = 1;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 1; i<(7 * plotSignalsNum + 1); i++) {
					double x1 = maxLabelWidth + 5;
					double y1 = 1 + gridTick * i;
					double x2 = width - maxLabelWidth - 5 - 1;
					double y2 = 1 + gridTick * i;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				ig2.setPaint(Color.red.darker());
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5;
					double y1 = 1 + (4 + 7 * i) * gridTick;
					double x2 = width - maxLabelWidth - 5 - 1;
					double y2 = 1 + (4 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}


				i = 0; {
					double x1 = maxLabelWidth + 5 + 1;
					double y1 = 1 + (0 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 1;
					double y2 = 1 + (7 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5 - 1;
					y1 = 1 + (0 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 - 1;
					y2 = 1 + (7 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5;
					y1 = 1 + (0 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 - 4;
					y2 = 1 + (0 + 7 * i) * gridTick + 7;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5;
					y1 = 1 + (0 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 + 4;
					y2 = 1 + (0 + 7 * i) * gridTick + 7;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 1; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5 + 1;
					double y1 = 1 + (1 - 0.7 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 1;
					double y2 = 1 + (7 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5 - 1;
					y1 = 1 + (1 - 0.7 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 - 1;
					y2 = 1 + (7 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5;
					y1 = 1 + (1 - 0.7 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 - 4;
					y2 = 1 + (1 - 0.7 + 7 * i) * gridTick + 7;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5;
					y1 = 1 + (1 - 0.7 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 + 4;
					y2 = 1 + (1 - 0.7 + 7 * i) * gridTick + 7;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				i = plotSignalsNum - 1; {
					double x1 = maxLabelWidth + 5 + 1;
					double y1 = 1 + (1 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 1;
					double y2 = (8 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					x1 = maxLabelWidth + 5 - 1;
					y1 = 1 + (1 + 7 * i) * gridTick;
					x2 = maxLabelWidth + 5 - 1;
					y2 = (8 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}


				ig2.setPaint(Color.black.darker());
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5 - 3;
					double y1 = 1 + (1 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 4;
					double y2 = 1 + (1 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5 - 3;
					double y1 = 1 + (2 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 4;
					double y2 = 1 + (2 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5 - 3;
					double y1 = 1 + (6 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 4;
					double y2 = 1 + (6 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5 - 3;
					double y1 = 1 + (7 + 7 * i) * gridTick;
					double x2 = maxLabelWidth + 5 + 4;
					double y2 = 1 + (7 + 7 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				ig2.setPaint(Color.red.brighter());
				ig2.draw(new Line2D.Double(maxLabelWidth + 5, 1, width - maxLabelWidth - 5 - 1, 1));
				ig2.draw(new Line2D.Double(maxLabelWidth + 5, height - 1 - 18, width - maxLabelWidth - 5 - 1, height - 1 - 18));


				//Iscrtavanje grafova

				for (int j = 0; j < plotSignalsNum; j++) {

					signalIndex = signalsIndicesPlot[j];

					int startIndex = (int) data.calculateSampleFromTime(start, signalIndex);
					int stopIndex = (int) data.calculateSampleFromTime(stop, signalIndex) - 1;

					//double max = data.getMetadata().getSignalParameters()[signalIndex].getPhysicalMax();
					//double min = data.getMetadata().getSignalParameters()[signalIndex].getPhysicalMin();

					ig2.setPaint(Color.black.darker());
					for(i = startIndex; i < stopIndex; i++) {
						double x1 = maxLabelWidth + 5 + (double)(width - 2 * maxLabelWidth - 10) / (data.calculateSampleFromTime(plotStop, signalIndex) - startIndex + 1) * (i - startIndex);
						double y1 = 1 + gridTick * (4 + 7 * j) - (int)(((signals[signalIndex][i]-origin[signalIndex])/gridTickValue[signalIndex]*gridTick) * scale[signalIndex]);
						double x2 = maxLabelWidth + 5 + (double)(width - 2 * maxLabelWidth - 10) / (data.calculateSampleFromTime(plotStop, signalIndex) - startIndex + 1) * (i - startIndex + 1);
						double y2 = 1 + gridTick * (4 + 7 * j) - (int)(((signals[signalIndex][i+1]-origin[signalIndex])/gridTickValue[signalIndex]*gridTick) * scale[signalIndex]);
						ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					}
				}
			}

			else {
				// Traženje najduljeg naziva signala

				int maxLabelWidth = 0;

				Font labelsFont = new Font("TimesRoman", Font.ITALIC, 15);
				ig2.setFont(labelsFont);
				FontMetrics fontMetrics = ig2.getFontMetrics();
				int stringWidth = 0;
				int stringHeight = 0;

				int signalIndex = 0;

				for (signalIndex = 0; signalIndex < signalsNum; signalIndex++) {
					String signalLabel = metadata.getSignalParameters()[signalIndex].getLabel();
					stringWidth = fontMetrics.stringWidth(signalLabel);
					if (maxLabelWidth < stringWidth) {
						maxLabelWidth = stringWidth;
					}
				}

				//Generiranje teksta o duljini intervala koordinatne rešetke i podacima o signalima

				gridLabel = "Interval koordinatne rešetke: " + gridIntervalName + label;


				//Ispis naziva signala

				ig2.setFont(labelsFont);
				ig2.setPaint(Color.black);
				fontMetrics = ig2.getFontMetrics();
				for (int i = 0; i < plotSignalsNum; i++) {
					signalIndex = signalsIndicesPlot[i];
					String signalLabel = metadata.getSignalParameters()[signalIndex].getLabel();
					stringWidth = fontMetrics.stringWidth(signalLabel);
					stringHeight = fontMetrics.getAscent();
					ig2.drawString(signalLabel, width - maxLabelWidth, 1 + stringHeight/2 + gridTick * (3 + 2 * i) - 1);
					ig2.drawString(signalLabel, maxLabelWidth - stringWidth, 1 + stringHeight/2 + gridTick * (3 + 2 * i) - 1);
				}

				//Ispis vremena

				Font xLabelFont = new Font("TimesRoman", Font.PLAIN, 15);
				ig2.setFont(xLabelFont);
				String t1 = timeInSecondsToString(start);
				fontMetrics = ig2.getFontMetrics();
				stringWidth = fontMetrics.stringWidth(t1);
				stringHeight = fontMetrics.getAscent();
				ig2.setPaint(Color.black);
				ig2.drawString(t1, maxLabelWidth - stringWidth/2, height - 1 - 2);

				String t2 = timeInSecondsToString(plotStop);
				stringWidth = fontMetrics.stringWidth(t2);
				ig2.drawString(t2, width - stringWidth/2 - maxLabelWidth, height - 1 - 2);


				//Crtanje grida

				ig2.setPaint(Color.red.brighter());
				int i;
				for(i = 0; i<=gridLines; i++) {
					double x1 = maxLabelWidth + 5 + ((double)(width - 2 * maxLabelWidth - 10 - 1)) / (gridLines) * i;
					double y1 = height - 1 - 18;
					double x2 = maxLabelWidth + 5 + ((double)(width - 2 * maxLabelWidth - 10 - 1)) / (gridLines) * i;
					double y2 = 1;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				for(i = 1; i<(2 * plotSignalsNum + 4); i++) {
					double x1 = maxLabelWidth + 5;
					double y1 = 1 + gridTick * i;
					double x2 = width - maxLabelWidth - 5 - 1;
					double y2 = 1 + gridTick * i;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}
				ig2.setPaint(Color.red.darker());
				for(i = 0; i<plotSignalsNum; i++) {
					double x1 = maxLabelWidth + 5;
					double y1 = 1 + (3 + 2 * i) * gridTick;
					double x2 = width - maxLabelWidth - 5 - 1;
					double y2 = 1 + (3 + 2 * i) * gridTick;
					ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				}


				double x1 = maxLabelWidth + 5 + 1;
				double y1 = 1;
				double x2 = maxLabelWidth + 5 + 1;
				double y2 = 1 + (4 + 2 * plotSignalsNum) * gridTick - 1;
				ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				x1 = maxLabelWidth + 5 - 1;
				y1 = 1;
				x2 = maxLabelWidth + 5 - 1;
				y2 = 1 + (4 + 2 * plotSignalsNum) * gridTick - 1;
				ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				x1 = maxLabelWidth + 5;
				y1 = 1;
				x2 = maxLabelWidth + 5 - 4;
				y2 = 1 + 7;
				ig2.draw(new Line2D.Double(x1, y1, x2, y2));
				x1 = maxLabelWidth + 5;
				y1 = 1;
				x2 = maxLabelWidth + 5 + 4;
				y2 = 1 + 7;
				ig2.draw(new Line2D.Double(x1, y1, x2, y2));


				ig2.setPaint(Color.red.brighter());
				ig2.draw(new Line2D.Double(maxLabelWidth + 5, 1, width - maxLabelWidth - 5 - 1, 1));
				ig2.draw(new Line2D.Double(maxLabelWidth + 5, height - 1 - 18, width - maxLabelWidth - 5 - 1, height - 1 - 18));


				//Iscrtavanje grafova

				for (int j = 0; j < plotSignalsNum; j++) {

					signalIndex = signalsIndicesPlot[j];

					int startIndex = (int) data.calculateSampleFromTime(start, signalIndex);
					int stopIndex = (int) data.calculateSampleFromTime(stop, signalIndex) - 1;

					ig2.setPaint(Color.black.darker());
					for(i = startIndex; i < stopIndex; i++) {
						x1 = maxLabelWidth + 5 + (double)(width - 2 * maxLabelWidth - 10) / (data.calculateSampleFromTime(plotStop, signalIndex) - startIndex + 1) * (i - startIndex);
						y1 = 1 + gridTick * (3 + 2 * j) - (int)(((signals[signalIndex][i]-origin[signalIndex])/gridTickValue[signalIndex]*gridTick) * scale[signalIndex]);
						x2 = maxLabelWidth + 5 + (double)(width - 2 * maxLabelWidth - 10) / (data.calculateSampleFromTime(plotStop, signalIndex) - startIndex + 1) * (i - startIndex + 1);
						y2 = 1 + gridTick * (3 + 2 * j) - (int)(((signals[signalIndex][i+1]-origin[signalIndex])/gridTickValue[signalIndex]*gridTick) * scale[signalIndex]);
						ig2.draw(new Line2D.Double(x1, y1, x2, y2));
					}
				}
			}


			// Snimanje u datoteku

			ImageIO.write(bi, "PNG", new File(session + ".png"));
			//ImageIO.write(bi, "JPEG", new File(session + ".jpg"));
			//ImageIO.write(bi, "gif", new File(session + ".gif"));
			//ImageIO.write(bi, "BMP", new File(session + ".bmp"));

		}
		catch (IOException ie) {
			ie.printStackTrace();
		}
	}

	/**
	 * Pretvara vrijeme u sekundama u ljepši ispis u formatu sati:minute:sekunde.tisućinke.
	 *
	 * @param timeInSeconds Vrijeme zadano u sekundama, npr. 123.332
	 * @return Formatizirani String u navedenom formatu.
	 */
	public static String timeInSecondsToString(double timeInSeconds) {
		StringBuilder time = new StringBuilder();
		int hours = (int) timeInSeconds / 3600;
		int minutes = ((int)timeInSeconds  - hours * 3600) / 60;
		int seconds = ((int)timeInSeconds) - hours * 3600 - minutes * 60;
		int miliseconds = (int)((timeInSeconds - ((int)timeInSeconds)) * 1000);
		boolean hoursExist = false;
		boolean minutesExist = false;

		if (hours == 0) {
			time.append("");
		}
		else {
			hoursExist = true;
			if (hours < 10) {
				time.append("0");
			}
			time.append(hours);
			time.append(":");
		}

		if (minutes == 0) {
			if (hoursExist) {
				time.append("00:");
				minutesExist = true;
			}
			else {
				time.append("");
			}
		}
		else {
			minutesExist = true;
			if (minutes < 10) {
				if (hoursExist) {
					time.append("0");
				}
			}
			time.append(minutes);
			time.append(":");
		}

		if (seconds == 0) {
			if (minutesExist) {
				time.append("00");
			}
			else {
				time.append("0");
			}
		}
		else {
			if (seconds < 10) {
				if (minutesExist) {
					time.append("0");
				}
			}
			time.append(seconds);
		}
		if (miliseconds == 0) {
			time.append(".000");
		}
		else {
			time.append("." + Integer.toString(miliseconds));
		}

		return time.toString();
	}

	public int getSignalsNum() {
		return signalsNum;
	}

	public String[] getSignalLabels() {
		return signalLabels;
	}

	public int getPlotSignalsNum() {
		return plotSignalsNum;
	}

	public String[] getPlotSignalLabels() {
		return plotSignalLabels;
	}

	public double getDuration() {
		return duration;
	}

	public String getGridLabel() {
		return gridLabel;
	}

	public double getPlotStart() {
		return plotStart;
	}

	public double getPlotStop() {
		return plotStop;
	}

	public double getPlotSegment() {
		return plotStop - plotStart;
	}

	public double getGridInterval() {
		return gridInterval;
	}
}