package multisab.processing.analysis;

import multisab.processing.multisabException.ModelingException;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FeatureSelectionResults {

    public static void saveFeatureSelectionResultsToFile(String filename, List<String> fsMethodNames, List<String> [] fsMethodResults, boolean append) throws ModelingException {
        try {
            BufferedWriter bw;

            if (filename != null){
                bw = new BufferedWriter(new FileWriter(filename, append));
            }
            else {
                bw = new BufferedWriter(new FileWriter("FeatureSelectionResults.mod", append));
            }
            for (int i = 0; i<fsMethodNames.size(); i++) {
                bw.write(fsMethodNames.get(i));
                bw.newLine();
                Iterator<String> it = fsMethodResults[i].iterator();
                while(it.hasNext()){
                    bw.write(it.next());
                    bw.newLine();
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        } catch (IOException exc) {
            throw new ModelingException("We cannot save feature selection results to file.");
        }
    }
    public static String[][] loadFeatureSelectionResultsFromFile(String filename) throws ModelingException{
        String [][] featureSelectionResults = null;
        String temp;

        try{
            BufferedReader br;

            if (filename != null){
                br = new BufferedReader(new FileReader(filename));
            }
            else {
                br = new BufferedReader(new FileReader("FeatureSelectionResults.mod"));
            }
            int i = 0;
            int j = 0;
            int featureNumber = 0;
            temp = br.readLine();
            while (temp != null){
                if (temp.equals("")){
                    j++;
                    featureNumber = i;
                    i = 0;
                }
                else if (!temp.contains(" ")){
                    temp = br.readLine();
                    continue;
                }
                else {
                    i++;
                }
                temp = br.readLine();
            }
            br.close();
            featureSelectionResults = new String[j][featureNumber];

            if (filename != null){
                br = new BufferedReader(new FileReader(filename));
            }
            else {
                br = new BufferedReader(new FileReader("FeatureSelectionResults.mod"));
            }
            i=0;
            j=0;
            temp = br.readLine();
            while (temp != null){
                if (temp.equals("")){
                    j++;
                    temp = br.readLine();
                }
                else if (!temp.contains(" ")){
                    temp = br.readLine();
                    continue;
                }
                else {
                    featureSelectionResults[j][i] = temp.trim();
                    temp = br.readLine();
                    i++;
                }
            }
            br.close();
        }
         catch (IOException exc) {
            throw new ModelingException("We cannot save feature selection results to file.");
        }
        return featureSelectionResults;
    }

    public static void saveSelectedFeatureIndicesToFile(String filename, int[] featureIndices, boolean all) throws ModelingException{
        try {
            BufferedWriter bw;

            if (filename != null){
                bw = new BufferedWriter(new FileWriter(filename));
            }
            else {
                bw = new BufferedWriter(new FileWriter("FeatureSelectionFeatureIndices.mod"));
            }
            if (all){
                bw.write("ALL");
                bw.newLine();
            }
            else {
                for (int i = 0; i<featureIndices.length; i++) {
                    bw.write(Integer.toString(featureIndices[i]));
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
        } catch (IOException exc) {
            throw new ModelingException("We cannot save feature selection indices to file.");
        }
    }
    public static int [] loadSelectedFeatureIndicesFromFile(String filename) throws ModelingException{
        try {
            BufferedReader br;
            String s;
            if (filename != null){
                br = new BufferedReader(new FileReader(filename));
            }
            else {
                br = new BufferedReader(new FileReader("FeatureSelectionFeatureIndices.mod"));
            }
            s = br.readLine();
            if (s.equals("ALL")){
                int [] featureIndices = new int[1];
                featureIndices[0] = -1;
                return featureIndices;
            }
            else {
                List<Integer> featureIndicesList = new ArrayList<>();
                while (s != null) {
                    featureIndicesList.add(Integer.parseInt(s));
                    s = br.readLine();
                }
                br.close();
                int[] featureIndices = new int[featureIndicesList.size()];
                Iterator<Integer> it = featureIndicesList.iterator();
                int i = 0;
                while (it.hasNext()) {
                    featureIndices[i] = it.next();
                    i++;
                }
                return featureIndices;
            }
        }
        catch (IOException exc) {
            throw new ModelingException("We cannot load feature selection indices from file.");
        }
        catch (Exception exc) {
            throw new ModelingException("We cannot load feature selection indices from file.");
        }
    }
}
