package multisab.processing.dataHandling;

//import java.util.ArrayList;

/**
 * @author Davor
 */
public class Annotation {
    /**
     * Time of the annotation, in seconds from the start of the record
     */
    protected double timeAnnots;
    /**
     * Sample of the annotation, in seconds from the start of the record
     */
    protected int sample;
    /**
     * Duration of the annotation
     */
    protected double duration;
    /**
     * Type
     */
    protected char type;
    /**
     * Whether annotation represents something that is not a heart beat type
     */
    protected boolean nonBeat;
    /**
     * Auxiliary information
     */
    protected String aux;


    /**
     * @return the timeAnnots
     */
    public double getTimeAnnots() {
        return timeAnnots;
    }

    /**
     * @return the sample
     */
    public double getSample() {
        return sample;
    }

    /**
     * @return the duration
     */
    public double getDuration() {
        return duration;
    }

    /**
     * @return the type
     */
    public char getType() {
        return type;
    }

    /**
     *
     * @return nonBeat
     */
    public boolean isNonBeat(){
        return nonBeat;
    }
    /**
     * @return the aux
     */
    public String getAux() {
        return aux;
    }


}