package multisab.processing.ecgAnalysis.ecgFiducialPointsDetection;

/**
 * @author Davor Kukolja
 */

public class ecgFiducialPoints {
    private int[] PwaveOnset;
    private int[] PwavePeak;
    private int[] PwaveOffset;
    private int[] qrsOnset;
    private int[] qrsPeak;
    private int[] qrsOffset;
    private int[] TwaveOnset;
    private int[] TwavePeak;
    private int[] TwaveOffset;
    private int[] QwavePeak;
    private int[] SwavePeak;

    private boolean[] QwaveAbsence;
    private boolean[] SwaveAbsence;

    public ecgFiducialPoints getFiducialPointFromInterval(long startSample, long endSample) {
        ecgFiducialPoints FiducialPoints = new ecgFiducialPoints();
        int numberOfPointsFromInterval = 0;
        int i;

        for (i = 0; i < this.qrsPeak.length; i++) {
            if ((this.qrsPeak[i] >= startSample) && (this.qrsPeak[i] <= endSample)) {
                numberOfPointsFromInterval = numberOfPointsFromInterval + 1;
            }
        }

        FiducialPoints.PwaveOnset = new int[numberOfPointsFromInterval];
        FiducialPoints.PwavePeak = new int[numberOfPointsFromInterval];
        FiducialPoints.PwaveOffset = new int[numberOfPointsFromInterval];
        FiducialPoints.qrsOnset = new int[numberOfPointsFromInterval];
        FiducialPoints.qrsPeak = new int[numberOfPointsFromInterval];
        FiducialPoints.qrsOffset = new int[numberOfPointsFromInterval];
        FiducialPoints.TwaveOnset = new int[numberOfPointsFromInterval];
        FiducialPoints.TwavePeak = new int[numberOfPointsFromInterval];
        FiducialPoints.TwaveOffset = new int[numberOfPointsFromInterval];
        FiducialPoints.QwavePeak = new int[numberOfPointsFromInterval];
        FiducialPoints.SwavePeak = new int[numberOfPointsFromInterval];

        FiducialPoints.QwaveAbsence = new boolean[numberOfPointsFromInterval];
        FiducialPoints.SwaveAbsence = new boolean[numberOfPointsFromInterval];

        int j = 0;

        for (i = 0; i < this.qrsPeak.length; i++) {
            if ((this.qrsPeak[i] >= startSample) && (this.qrsPeak[i] <= endSample)) {
                if (this.PwavePeak[i] == Integer.MIN_VALUE) {
                    FiducialPoints.PwaveOnset[j] = Integer.MIN_VALUE;
                    FiducialPoints.PwavePeak[j] = Integer.MIN_VALUE;
                    FiducialPoints.PwaveOffset[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.PwaveOnset[j] = this.PwaveOnset[i] - (int) startSample;
                    FiducialPoints.PwavePeak[j] = this.PwavePeak[i] - (int) startSample;
                    FiducialPoints.PwaveOffset[j] = this.PwaveOffset[i] - (int) startSample;
                }

                if (this.qrsOnset[i] == Integer.MIN_VALUE) {
                    FiducialPoints.qrsOnset[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.qrsOnset[j] = this.qrsOnset[i] - (int)startSample;
                }
                FiducialPoints.qrsPeak[j] = this.qrsPeak[i] - (int)startSample;
                if (this.qrsOffset[i] == Integer.MIN_VALUE) {
                    FiducialPoints.qrsOffset[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.qrsOffset[j] = this.qrsOffset[i] - (int)startSample;
                }

                if (this.TwavePeak[i] == Integer.MIN_VALUE) {
                    FiducialPoints.TwaveOnset[j] = Integer.MIN_VALUE;
                    FiducialPoints.TwavePeak[j] = Integer.MIN_VALUE;
                    FiducialPoints.TwaveOffset[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.TwaveOnset[j] = this.TwaveOnset[i] - (int) startSample;
                    FiducialPoints.TwavePeak[j] = this.TwavePeak[i] - (int) startSample;
                    FiducialPoints.TwaveOffset[j] = this.TwaveOffset[i] - (int) startSample;
                }

                if (this.QwavePeak[i] == Integer.MIN_VALUE) {
                    FiducialPoints.QwavePeak[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.QwavePeak[j] = this.QwavePeak[i] - (int)startSample;
                }
                if (this.SwavePeak[i] == Integer.MIN_VALUE) {
                    FiducialPoints.SwavePeak[j] = Integer.MIN_VALUE;
                }
                else {
                    FiducialPoints.SwavePeak[j] = this.SwavePeak[i] - (int)startSample;
                }

                FiducialPoints.QwaveAbsence[j] = this.QwaveAbsence[i];
                FiducialPoints.SwaveAbsence[j] = this.SwaveAbsence[i];

                j = j + 1;
            }
        }


        return FiducialPoints;
    }

    public int[] getPwaveOnset() {
        return PwaveOnset;
    }

    public void setPwaveOnset(int[] pwaveOnset) {
        PwaveOnset = pwaveOnset;
    }

    public int[] getPwavePeak() {
        return PwavePeak;
    }

    public void setPwavePeak(int[] pwavePeak) {
        PwavePeak = pwavePeak;
    }

    public int[] getPwaveOffset() {
        return PwaveOffset;
    }

    public void setPwaveOffset(int[] pwaveOffset) {
        PwaveOffset = pwaveOffset;
    }

    public int[] getQrsOnset() {
        return qrsOnset;
    }

    public void setQrsOnset(int[] qrsOnset) {
        this.qrsOnset = qrsOnset;
    }

    public int[] getQrsPeak() {
        return qrsPeak;
    }

    public void setQrsPeak(int[] qrsPeak) {
        this.qrsPeak = qrsPeak;
    }

    public int[] getQrsOffset() {
        return qrsOffset;
    }

    public void setQrsOffset(int[] qrsOffset) {
        this.qrsOffset = qrsOffset;
    }

    public int[] getTwaveOnset() {
        return TwaveOnset;
    }

    public void setTwaveOnset(int[] twaveOnset) {
        TwaveOnset = twaveOnset;
    }

    public int[] getTwavePeak() {
        return TwavePeak;
    }

    public void setTwavePeak(int[] twavePeak) {
        TwavePeak = twavePeak;
    }

    public int[] getTwaveOffset() {
        return TwaveOffset;
    }

    public void setTwaveOffset(int[] twaveOffset) {
        TwaveOffset = twaveOffset;
    }

    public int[] getQwavePeak() {
        return QwavePeak;
    }

    public void setQwavePeak(int[] qwavePeak) {
        QwavePeak = qwavePeak;
    }

    public int[] getSwavePeak() {
        return SwavePeak;
    }

    public void setSwavePeak(int[] swavePeak) {
        SwavePeak = swavePeak;
    }

    public boolean[] getQwaveAbsence() {
        return QwaveAbsence;
    }

    public void setQwaveAbsence(boolean[] qwaveAbsence) {
        QwaveAbsence = qwaveAbsence;
    }

    public boolean[] getSwaveAbsence() {
        return SwaveAbsence;
    }

    public void setSwaveAbsence(boolean[] swaveAbsence) {
        SwaveAbsence = swaveAbsence;
    }
}
