package multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection;

import multisab.processing.preprocessing.iirj.Butterworth;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Davor Kukolja
 */

public class Elgendi {

    public static int[] DetectRWave(double[] ecg, double fs) {
        double[] ecgFiltred;
        double[] MAqrs;
        double[] MAbeat;
        int[] qrs;

        ecgFiltred = Butter8_20(ecg,fs);

        /*
        PrintWriter writer = null;

        try {
            writer = new PrintWriter("D:\\_Friganovic_Algoritmi_MATLAB\\Databases\\MITBIH_Elgendi\\test_v4.csv", "UTF-8");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        for(int i=0; i<ecgFiltred.length; i++) {
            writer.println(new StringBuilder().append(ecgFiltred[i]).append(";").toString());
            //System.out.println(ecgFiltred[i]);
        }

        writer.close();
        */

        MovingAverages MA = ElgendiMA_qrs(ecgFiltred,fs);
        MAqrs = MA.MAqrs;
        MAbeat = MA.MAbeat;

        qrs = ElgendiFiducialMarksQRS(ecgFiltred,MAbeat,MAqrs,fs);

        return qrs;
    }

    public static double[] Butter8_20(double[] ecg, double fs) {
        int n = ecg.length;
        double[] ecgFiltred = new double[n];
        int nfact = 3 * 100;
        double[] ecgFiltredReflection = new double[n + 2 * nfact];

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[nfact - i] = 2 * ecg[0] - ecg[0 + i];
        }

        for (int i = 0; i < n; i++) {
            ecgFiltredReflection[i + nfact] = ecg[i];
        }

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[n + nfact - 1 + i] = 2 * ecg[n - 1] - ecg[n - 1 - i];
        }

        Butterworth butterworth = new Butterworth();
        //butterworth.lowPass(3,fs,20);
        //butterworth.highPass(3,fs,8);
        butterworth.bandPass(3,fs,14,12);

        for (int i = 0; i < n + 2 * nfact; i++) {
            ecgFiltredReflection[i] = butterworth.filter(ecgFiltredReflection[i]);
        }

        Butterworth butterworth2 = new Butterworth();
        //butterworth2.lowPass(3,fs,20);
        //butterworth2.highPass(3,fs,8);
        butterworth2.bandPass(3,fs,14,12);

        for (int i = 0; i < n + 2 * nfact; i++) {
            ecgFiltredReflection[n + 2 * nfact - i - 1] = butterworth2.filter(ecgFiltredReflection[n + 2 * nfact - i - 1]);
        }

        for (int i = 0; i < n; i++) {
            ecgFiltred[i] = ecgFiltredReflection[i + nfact];
        }

        return ecgFiltred;
    }

    public static MovingAverages ElgendiMA_qrs(double[] ecgFiltred, double fs) {
        MovingAverages MA = new MovingAverages();

        int n = ecgFiltred.length;

        int W1 = (int) Math.ceil(0.097*fs);
        int W2 = (int) Math.ceil(0.611*fs);

        //1. Squaring
        double[] ecgSquared = new double[n];
        for(int i=0; i<n; i++){
            ecgSquared[i] = ecgFiltred[i]*ecgFiltred[i];
        }

        //2. Moving Averages
        MA.MAqrs = MovingAverage(ecgSquared,W1);
        MA.MAbeat = MovingAverage(ecgSquared,W2);

        return MA;
    }

    public static int[] ElgendiFiducialMarksQRS(double[] ecgFiltred, double[] MAbeat, double[] MAqrs, double fs) {
        List<Integer> positions;
        List<Integer> Blocks;
        int numberOfQRS = 0;

        positions = new ArrayList<Integer>();
        Blocks = new ArrayList<Integer>();

        int n = ecgFiltred.length;

        int W1 = (int) Math.ceil(0.097 * fs);
        int W2 = (int) Math.ceil(0.611 * fs);
        double beta = 0.08;
        double sum = 0;
        double[] ecgSquared = new double[n];
        for (int i = 0; i < n; i++) {
            ecgSquared[i] = ecgFiltred[i] * ecgFiltred[i];
            sum = sum + ecgSquared[i];
        }
        double z = sum / n;
        double alpha = beta * z;

        double[] BlocksOfInterest = new double[n];

        for (int i = 0; i < n; i++) {
            double THR1 = MAbeat[i] + alpha;
            if (MAqrs[i] >= THR1) {
                BlocksOfInterest[i] = 0.1;
            } else {
                BlocksOfInterest[i] = 0;
            }
        }

        BlocksOfInterest[0] = 0;
        BlocksOfInterest[n - 1] = 0;
        int k = 0;
        for (int b = 1; b < n; b++) {
            if (BlocksOfInterest[b] - BlocksOfInterest[b - 1] != 0) {
                Blocks.add(b);
                k = k + 1;
            }
        }

        double THR2 = W1;

        for (int j = 1; j < k + 1; j = j + 2) {
            if (Blocks.get(j) - Blocks.get(j-1) >= THR2) {
                int I = Blocks.get(j - 1);
                double m = ecgFiltred[I];
                for (int l = I + 1; l < Blocks.get(j) + 1; l++) {
                    if (ecgFiltred[l] > m) {
                        I = l;
                        m = ecgFiltred[l];
                    }
                }
                positions.add(I);
                numberOfQRS++;
            }
        }

        int[] qrs = new int[numberOfQRS];
        for (int i = 0; i < numberOfQRS; i++) {
            qrs[i] = (positions.get(i));
        }

        return qrs;
    }

    public static double[] MovingAverage(double[] x, int N) {
        int n = x.length;
        double[] MA = new double[n];
        double sum = 0;

        for(int i = (int) Math.round((N-1)/2); i < n - Math.round((N-1)/2); i++) {
            sum = 0;
            for (int j = i - (int) Math.round((N-1)/2); j < i + Math.round((N-1)/2) + 1; j++) {
                sum = sum + x[j];
            }
            MA[i] = sum / N;
        }

        for (int i = 0; i < Math.round((N-1)/2); i++) {
            sum = 0;
            for (int j = i; j < i + N + 1; j++) {
                sum = sum + x[j];
            }
            MA[i] = sum / N;
        }

        for (int i = n - Math.round((N-1)/2) - 1; i < n; i++) {
            sum = 0;
            for (int j = i - N; j < i + 1; j++) {
                sum = sum + x[j];
            }
            MA[i] = sum / N;
        }

        return MA;
    }
}
