package multisab.processing.ecgAnalysis.ecgPreprocessing;

import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;
import multisab.processing.preprocessing.iirj.Butterworth;

public class BaselineWanderRemoval {

    public static double[] RemoveBaselineWander(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints) {
        double[] ecgFiltred;

        ecgFiltred = Butter_HF_05(ecg, frequency);

        return ecgFiltred;
    }

    public static double[] Butter_HF_05(double[] ecg, double frequency) {

        int l = ecg.length;

        double[] ecgFiltred = new double[l];
        int nfact = 3 * 100;
        double[] ecgFiltredReflection = new double[l + 2 * nfact];

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[nfact - i] = 2 * ecg[0] - ecg[0 + i];
        }

        for (int i = 0; i < l; i++) {
            ecgFiltredReflection[i + nfact] = ecg[i];
        }

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[l + nfact - 1 + i] = 2 * ecg[l - 1] - ecg[l - 1 - i];
        }

        Butterworth butterworth = new Butterworth();
        butterworth.highPass(3, frequency, 0.5);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[i] = butterworth.filter(ecgFiltredReflection[i]);
        }

        Butterworth butterworth2 = new Butterworth();
        butterworth2.highPass(3, frequency, 0.5);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[l + 2 * nfact - i - 1] = butterworth2.filter(ecgFiltredReflection[l + 2 * nfact - i - 1]);
        }

        for (int i = 0; i < l; i++) {
            ecgFiltred[i] = ecgFiltredReflection[i + nfact];
        }

        return ecgFiltred;
    }
}
