// Primjer kreiranja slika uz fiksnu duljinu ili širinu
// U ovom testnom primjeru svaki korisnik mora sam podesiti putanju do datoteka gdje su spremljeni signali

package multisab.processing.imageTestMain;

import multisab.processing.signalVisualization.ImageCreating;

public class SignalVisualization {


    private static int width; // Širina slike
    private static int minHeight; // Minimalna visina slike. Koristi se samo kada je širina slike fiksirana. Visina ne može biti niža, ali može biti viša (npr. ako ima puno signala)
    private static int height; // Visina slike. Koristi se kada je visina slike fiksirana.
    private static double start; // Vrijeme početka za iscrtavanje signala u sekundama. Može doći do korekcije vremena ako nije djeljivo s intervalom rešetke(grida), ako je uzetno negativno početno vrijeme ili ako je signal prekratak.
    private static double stop; // Vrijeme kraja za iscrtavanje signala u sekundama. Može doći do korekcije vremena.
    private static boolean plotAllSignals; // Da li se iscrtavaju svi signali
    private static String session; // Putanja do kreirane slike
    // String[] signalType; // Vrste signala koje se iscrtavaju (i te oznake se ispisuju na slici). Ako se polje sastoji od jednog stringa, pretpostavlja se da postoji samo jedan signal ili da su svi signali iste vrste te da ih želimo skalirati na isti način
    // int signalsIndices[]; // Ako se ne iscrtavatavaju svi signali (plotAllSignals == false) polje signalsIndices određuje indekse signala koji se iscrtavaju počevši od nule
    private static String session1;
    private static String session2;
    private static String session3;
    private static String session4;
    private static String session5;

    // Konstruktor
    public void SignalVisualization() {
    }

    // Metoda za kreiranje slike
    public void create() {

        /*
    	String recordFilePath = "C:\\Users\\Davor\\Documents\\Data\\r01.edf"; // U ovom testnom primjeru svaki korisnik mora sam podesiti putanju do datoteka gdje su spremljeni signali
        String[] signalType = new String[1];
        plotAllSignals = true; // Iscrtavaju se svi signali
        int signalsIndices[] = {}; // U ovom slučaju nije važno što se nalazi u polju signalsIndices jer se iscrtavaju svi signali
        signalType[0] = "ECG"; // Svi signali su EKG te se jednako skaliraju. Kada bi signalType bilo polje od 5 "ECG" stringova svaki signal bi imao svoju skalu.
        //*/
        /*
        // Duljina signala u datoteci aami3a.txt je 59.833 sekundi tako da će u nekim primjerima dolaziti do korekcije početnog i završnog vremena
        String recordFilePath = "C:\\Users\\Davor\\Documents\\Data\\aami3a.txt"; // U ovom testnom primjeru svaki korisnik mora sam podesiti putanju do datoteka gdje su spremljeni signali
        String[] signalType = new String[1]; // Svi signali su EKG te se jednako skaliraju. U ovom slučaju je to nevažno jer postoji samo jedan signal.
        plotAllSignals = true; // Iscrtavaju se svi signali
        int signalsIndices[] = {}; // U ovom slučaju nije važno što se nalazi u polju signalsIndices jer se iscrtavaju svi signali
        signalType[0] = "ECG"; // Svi signali su EKG te se jednako skaliraju
        //*/
        /*
        //Duljina signala u datoteci rc01.edf je 46 sekundi tako da će u nekim primjerima dolaziti do korekcije početnog i završnog vremena
        String recordFilePath = "C:\\Users\\Davor\\Documents\\Data\\rc01.edf"; // U ovom testnom primjeru svaki korisnik mora sam podesiti putanju do datoteka gdje su spremljeni signali
        String[] signalType = new String[1]; // Svi signali su EEG te se jednako skaliraju.
        plotAllSignals = false; // Ne iscrtavaju se svi signali
        int signalsIndices[] = {0, 1, 2, 3, 4}; // Iscrtavaju se signali s indeksima 0, 1, 2, 3 i 4 (vizualizira se prvih 5 signala)
        signalType[0] = "EEG"; // Za sada se svi signali jednako skaliraju s pojačanjem dobivenim od svih EEG signala koji se nalaze u datoteci (to je bug koju ću popraviti).
        //*/
        ///*
        String recordFilePath = "C:\\Users\\Davor\\Documents\\Data\\drive01.edf"; // U ovom testnom primjeru svaki korisnik mora sam podesiti putanju do datoteka gdje su spremljeni signali
        String[] signalType = new String[6]; // Svaki signali se skalira prema svojim vrijednostima (jer je polje signalType veće od 1)
        plotAllSignals = false; // Ne iscrtavaju se svi signali
        int signalsIndices[] = {0, 2, 3}; // Iscrtavaju se signali s indeksima 0, 2 i 3
        signalType[0] = "ECG"; // Vrsta signala s indeksom 0 je ECG
        signalType[1] = "EMG"; // Vrsta signala s indeksom 1 je EMG
        signalType[2] = "footGSR"; // Vrsta signala s indeksom 2 je footGSR
        signalType[3] = "handGSR"; // Vrsta signala s indeksom 3 je handGSR
        signalType[4] = "HR"; // Vrsta signala s indeksom 4 je HR
        signalType[5] = "RESP"; // Vrsta signala s indeksom 5 je RESP
        //*/

        width = 1280; // Širina slike je 1280 piksela
        minHeight = 720; // Minimalna visina slike je 720 piksela
        start = 60; // Početno vrijeme je 60 sekundi
        stop = 120; // Završno vrijeme je 120 sekundi

        session1 = "session1_signal_visualization";
        session2 = "session2_signal_visualization";
        session3 = "session3_signal_visualization";
        session4 = "session4_signal_visualization";
        session5 = "session5_signal_visualization";

        session1 = System.getProperty("user.home") + "/IdeaProjects/backend/files/" + session1; // Putanja gdje će se spremiti prva slika
        session2 = System.getProperty("user.home") + "/IdeaProjects/backend/files/" + session2; // Putanja gdje će se spremiti druga slika
        session3 = System.getProperty("user.home") + "/IdeaProjects/backend/files/" + session3; // Putanja gdje će se spremiti treća slika
        session4 = System.getProperty("user.home") + "/IdeaProjects/backend/files/" + session4; // Putanja gdje će se spremiti četvrta slika
        session5 = System.getProperty("user.home") + "/IdeaProjects/backend/files/" + session5; // Putanja gdje će se spremiti peta slika

        // Glavna klasa za kreiranje slika
        // Klasa je iz paketa signalVisualization. Ovdje je dan samo primjer korištenja.
        ImageCreating image = new ImageCreating(recordFilePath);
        // Dohvat broja signala te njihovih labela
        int signalsNum = image.getSignalsNum();
        System.out.println("Ukupan broj signala je: " + signalsNum);
        String[] signalLabels = new String[signalsNum];
        signalLabels = image.getSignalLabels();
        for(int i = 0; i < signalsNum; i++) {
            System.out.println(signalLabels[i]);
        }
        // Dohvat duljine signala u sekundama
        double duration = image.getDuration();
        System.out.println("Duljina signala je: " + duration + " sekundi");
        System.out.println();

        // Podešavanje parametara za sliku koja ima fiksnu širinu. Nakon podešavanja parametara, kada god se pozove metoda za kreiranje slike, kreira se slika s postavljenim parametrima
        image.setImageParameters_height(width, minHeight, signalType, plotAllSignals, signalsIndices);
        // Dohvaćanje parametara slike. Ove metode treba zvati samo nakon poziva metode setImageParameters_height
        // Dohvat broja signala koji se vizualiziraju te njihovih labela
        int plotSignalsNum = image.getPlotSignalsNum();
        System.out.println("Broj signala koji se vizualiziraju je: " + plotSignalsNum);
        String[] plotSignalLabels = new String[plotSignalsNum];
        plotSignalLabels = image.getPlotSignalLabels();
        for(int i = 0; i < plotSignalsNum; i++) {
            System.out.println(plotSignalLabels[i]);
        }
        System.out.println();

        // Poziv metode za kreiranje slike
        image.getImage(start, stop, session1); // Vizualizacija odabranih signala od 60 do 120 sekunde
        image.getImage(start+60, stop+60, session2); // Vizualizacija odabranih signala od 120 do 180 sekunde
        // Dohvaćanje parametara slike. Ove metode treba zvati samo nakon poziva metode getImage
        System.out.println("Labela koordinatne rešetke: " + image.getGridLabel());
        System.out.println("Početak vizualizacije signala: " + image.getPlotStart() + " sekundi");
        System.out.println("Kraj vizualizacije signala: " + image.getPlotStop() + " sekundi");
        System.out.println("Duljina segmenta za vizualizaciju signala: " + image.getPlotSegment() + " sekundi");
        System.out.println("Interval koordinatne rešetke: " + image.getGridInterval() + " sekundi");

        // Podešavanje novih parametara za vizualizaciju signala (slika šira 200 piksela (1480), minimalna visina snižena za 400 piksela(na 320 piksela))
        image.setImageParameters_height(width+200, minHeight-400, signalType, plotAllSignals, signalsIndices);

        image.getImage(start, stop, session3); // Vizualizacija odabranih signala od 60 do 120 sekunde

        image.getImage(start+60, stop+60, session4); // Vizualizacija odabranih signala od 120 do 180 sekunde
        image.getImage(-1, 1000000, session4); // Vizualizacija odabranih signala od početka do kraja (Niti jedan testni signal nije dugačak 1000000 sekundi)





        width = 1480;
        height = 220;

        // Podešavanje parametara za vizualizaciju signala gdje je visina slike fiksirana. Nakon podešavanja parametara, kada god se pozove metoda za kreiranje slike, kreira se slika s postavljenim parametrima
        image.setImageParameters_width(width, height, signalType, plotAllSignals, signalsIndices);

        image.getImage(start, stop, session5); // Vizualizacija odabranih signala od 60 do 120 sekunde
    }
}