package multisab.processing.outputHandling.featureVectors;

import multisab.processing.analysis.ExtractedFeatures;
import multisab.processing.outputHandling.OutputFile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * @author lsuc
 */
public class CSVFile extends OutputFile {


    public CSVFile(String filePath) {
        this.filePath = filePath;
    }

    /* (non-Javadoc)
     * @see extractedFeatures.output.OutputFile#writeToFile(extractedFeatures.output.ExtractedFeatures)
     */
    @Override
    public void writeToFile(ExtractedFeatures extractedFeatures, boolean append) throws IOException {
        String[] featureNames;
        BufferedWriter out = null;
        try {
            File extractionFile = new File(getFilePath());
            if (!extractionFile.exists()) {
                extractionFile.createNewFile();
            }
            out = new BufferedWriter(new FileWriter(extractionFile, append));
            if (!append) {
                StringBuilder printToFileBuilder = new StringBuilder();
                featureNames = extractedFeatures.getAllFeatureNames();
                for (int i = 0; i < featureNames.length - 1; i++) {
                    printToFileBuilder.append(featureNames[i]);
                    printToFileBuilder.append(", ");
                }
                printToFileBuilder.append(featureNames[featureNames.length - 1]);
                out.write(printToFileBuilder.toString());
                out.newLine();
            }
            StringBuilder printToFileBuilder;
            for (int i = 0; i < extractedFeatures.getExtractedFeatureVectorsCount(); i++) {
                printToFileBuilder = new StringBuilder();
                printToFileBuilder.append(extractedFeatures.getFilename(i));
                printToFileBuilder.append(extractedFeatures.getSignalLabel(i));
                printToFileBuilder.append(extractedFeatures.getStartTime(i));
                printToFileBuilder.append(extractedFeatures.getSegmentLength(i));
                for (int j = 0; j < extractedFeatures.getExtractedFeatures(i).length - 1; j++) {
                    printToFileBuilder.append(extractedFeatures.getExtractedFeatures(i)[j]);
                    printToFileBuilder.append(", ");
                }
                printToFileBuilder.append(extractedFeatures.getExtractedFeatures(i)[extractedFeatures.getExtractedFeatures(i).length - 1]);
                out.write(printToFileBuilder.toString());
                out.newLine();
                out.flush();
            }
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }
}
