package multisab.processing.preprocessing.qrsDetection;

import multisab.processing.dataHandling.*;
import multisab.processing.outputHandling.featureVectors.CSVFile;
import multisab.processing.preprocessing.morphologicalOperations.MMOperators;
import multisab.processing.preprocessing.qrsDetection.Elgendi;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection.PanTompkins;
import multisab.processing.*;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.Object;
import java.util.*;


/**
 * Created by Krešimir on 16.1.2017..
 */
public class DatabaseTesting {
    private static InputData data;
    private static double[][] signals;
    private static List<Double> qrsIndex = new ArrayList<Double>();
    private static InputData ann;
    private static List<Double> annIndex = new ArrayList<Double>();

    public static void main(String arg[]) {
        int [] beatAnnotations = {33,78,76,82,66,65,97,74,83,86,114,70,101,106,110,69,47,102,81,63};


        double TP = 0;
        double FP = 0;
        double FN = 0;

        double TP1 = 0;
        double FP1 = 0;
        double FN1 = 0;
        //Input path to database main folder
        String databaseRecordPath = "E:\\MULTISAB\\TestDatabases\\mit-bih_arrhythmia\\csv";
        String databaseAnnotationPath = "E:\\MULTISAB\\TestDatabases\\mit-bih_arrhythmia\\ann";

        //Go through files in Records
        File RecordDir = new File(databaseRecordPath);
        File[] recordListing = RecordDir.listFiles();
        if (recordListing != null) {
            for (File child : recordListing) {

                String recordFilePath = child.getName();

                //Open record file
                String ext = "";
                int i = recordFilePath.lastIndexOf('.');
                if (i >= 0) {
                    ext = recordFilePath.substring(i + 1);
                }
                String recordType = ext.toUpperCase();
                try {
                    if (recordType.equals("EDF")) {
                        data = new EdfFile(child,false);
                    }
                    if (recordType.equals("TXT")) {
                        data = new TxtFile(child,false);
                    }
                    if (recordType.equals("CSV")) {
                        data = new CsvFile(child,false);
                    }

                    signals = data.getSignals();

                //find associated Ann file
                    File AnnDir = new File(databaseAnnotationPath);
                    File[] annListing = AnnDir.listFiles();
                    if (annListing != null) {
                        for (File child2 : annListing) {
                            String annFilePath = child2.getName();

                            //Open ann file
                            String ext2 = "";
                            int j = annFilePath.lastIndexOf('.');
                            if (j >= 0) {
                                ext2 = annFilePath.substring(i + 1);
                            }
                            String annType = ext2.toUpperCase();
                            if (annType.equals("ANN")) {
                                if (annFilePath.substring(0, j).equals(recordFilePath.substring(0, i))) {
                                    annIndex.clear();
                                    ann = new AnnFile(child2,false);
                                    Annotation[][] annotation = ann.getAnnotations();
                                    for (int a = 0; a < annotation[0].length; a++){

                                        for (int ann:beatAnnotations){
                                            if (ann == annotation[0][a].getType()){
                                                annIndex.add(annotation[0][a].getSample());
                                            }
                                        }

                                    }

                                }
                            }

                        }
                    }



                 /***************TESTING ******************/
                 /****************************************/
                    TP1 = 0;
                    FP1 = 0;
                    FN1 = 0;

                    double fs = data.calculateFrequency(1);
                    qrsIndex.clear();
                    if (recordFilePath.compareTo("114.csv") == 0){
                        signals[0] = signals[1];
                    }
                    double [] mmf = MMOperators.MMF(signals[0],fs);
                    qrsIndex = Elgendi.DetectRSpike(MMOperators.MMF(signals[0],fs),fs);
                    //qrsIndex = Elgendi.DetectRSpike(signals[0],fs);


                    int sampleDeviation = (int)(0.06 * fs);
                    boolean qrsDetectionFlag;

                    for (double qrsDetected:qrsIndex){
                        qrsDetectionFlag = false;
                        for (double qrsReal:annIndex){
                            if (qrsDetected >= (qrsReal - sampleDeviation) && qrsDetected <= (qrsReal + sampleDeviation)){
                                TP++;
                                TP1++;
                                qrsDetectionFlag = true;
                                break;
                            }
                        }
                        if (qrsDetectionFlag == false){
                            FP++;
                            FP1++;
                            System.out.printf("FP: %f\n",qrsDetected);
                        }

                    }

                    for (double qrsReal:annIndex){
                        qrsDetectionFlag = false;
                        for (double qrsDetected:qrsIndex){
                            if (qrsReal >= (qrsDetected - sampleDeviation) && qrsReal <= (qrsDetected + sampleDeviation)){
                                qrsDetectionFlag = true;
                                break;
                            }
                        }
                        if (qrsDetectionFlag == false){
                            FN++;
                            FN1++;
                            System.out.printf("FN :%f\n",qrsReal);
                        }

                    }

                    double sensitivity = (double)(TP1/(TP1 + FN1)) * 100;
                    double precision = (double)(TP1/(TP1 + FP1)) * 100;
                    System.out.printf("Subject %s \n",recordFilePath.substring(0, i));
                    System.out.printf("TP = %.0f, FN = %.0f, FP = %.0f \n",TP1,FN1,FP1);
                    System.out.printf("Sensitivity of QRS detection algoritam: %.2f%% \n",sensitivity);
                    System.out.printf("Precision of QRS detection algoritam: %.2f%% \n",precision);
                } catch (FileNotFoundException e) {
                    // TODO Auto-generated catch block
                    System.out.println("File not found. Sorry for the inconvenience.");
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    System.out.println("An error occurred while loading file. The file had to be closed.");
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

            double sensitivity = (double)(TP/(TP + FN)) * 100;
            double precision = (double)(TP/(TP + FP)) * 100;

            System.out.printf("All subjects");
            System.out.printf("\nTP = %.0f, FN = %.0f, FP = %.0f \n",TP,FN,FP);
            System.out.printf("Sensitivity of QRS detection algoritam: %.2f%% \n",sensitivity);
            System.out.printf("Precision of QRS detection algoritam: %.2f%% \n",precision);
    }
}
