package multisab.processing.analysis;

import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * Created by Korisnik on 10/11/2017.
 */
public class ParallelExtractionThread extends Thread{
    private double[] signal;
    private double frequency;
    private ecgFiducialPoints FiducialPoints; // Modificirao Davor /////////////////////////////////////////////
    private FeatureExtraction featureExtraction;
    private String filename;
    private String signalLabel;
    private String startTime;
    private String segmentLength;
    private ArrayList<String> results;
    private boolean morphologicalECGFeaturesPresent;
    private String disorder;

    public ParallelExtractionThread(/*ThreadGroup g, */FeatureExtraction featureExtraction, double [] signal, double frequency, String filename, String signalLabel, String startTime, String segmentLength, String disorder){
        //super(g, (Runnable) null);
        this.signal = signal;
        this.featureExtraction = featureExtraction;
        this.filename = filename;
        this.signalLabel = signalLabel;
        this.startTime = startTime;
        this.segmentLength = segmentLength;
        this.frequency = frequency;

        this.morphologicalECGFeaturesPresent = false;
        this.disorder = disorder;
    }

    // Modificirao Davor //
    public ParallelExtractionThread(/*ThreadGroup g, */FeatureExtraction featureExtraction, double [] signal, double frequency, ecgFiducialPoints FiducialPoints, String filename, String signalLabel, String startTime, String segmentLength, String disorder){
        //super(g, (Runnable) null);
        this.signal = signal;
        this.frequency = frequency;
        this.FiducialPoints = FiducialPoints;
        this.featureExtraction = featureExtraction;
        this.filename = filename;
        this.signalLabel = signalLabel;
        this.startTime = startTime;
        this.segmentLength = segmentLength;

        this.morphologicalECGFeaturesPresent = true;
        this.disorder = disorder;
    }
    public void run(){
        try {
            // Modificirao Davor //
            if (!morphologicalECGFeaturesPresent) {
                results = this.featureExtraction.performFeatureExtraction(signal,frequency);
            }
            else{
                // TODO: Ako je riječ o EKG signalu može se računati samo HRV i EKG morfološke značajke
                results = this.featureExtraction.performFeatureExtraction(signal,frequency); //Ovo bi se moglo izbaciti ako bi se realiziralo:
                //results = this.featureExtraction.performHRVFeatureExtraction(signal, frequency, FiducialPoints);
                results.addAll(this.featureExtraction.performMorphologicalECGFeatureExtraction(signal, frequency, FiducialPoints));
            }
        }
        catch (Exception exc){
            System.err.println(exc.getMessage());
        }

    }
    public ArrayList<String> getResults(){
        return this.results;
    }
    public String getFilename(){
        return this.filename;
    }
    public String getSignalLabel(){
        return this.signalLabel;
    }
    public String getStartTime(){
        return this.startTime;
    }

    public String getSegmentLength() {
        return segmentLength;
    }
    public String getDisorder() {
        return disorder;
    }
}
