package multisab.processing.analysis;


import multisab.processing.dataHandling.*;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ptDetection.MartinezPT;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection.Elgendi;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection.PanTompkins;
import multisab.processing.ecgAnalysis.ecgPreprocessing.BaselineWanderRemoval;
import multisab.processing.preprocessing.morphologicalOperations.MMOperators;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;

import static multisab.processing.dataHandling.InputData.getSamplesFromInterval;

/**
 * Created by ajovic on 23.3.2017..
 */
public class Parallelization {
    private InputData [] data;
    public static final int DECIMAL_PLACES = 6;
    private Metadata [] metadata;
    private double[][][] signals;
    //Ukupan broj signala (u datoteci)
    private int [] signalsNum;
    private String[][] signalLabels;
    //Trajanje signala
    private double[] duration;
    private boolean parallelize = false;
    //private double[][] sortedSignals;
    private Features selectedFeatures;
    private FeatureParameters selectedFeatureParameters;
    private double startTime;
    private double endTime;
    private double segmentLength;
    private boolean untilEndOfTheRecord;
    private FeatureExtraction featureExtraction;
    private ExtractedFeatures extractedFeatures;
    private String [] disorders;
    private PreprocessingMethod preprocessingMethod = null;
    private String filenameOutput;

    public Parallelization(String [] recordFilePaths, PreprocessingMethod preprocessingMethod, String filenameOutput){
            if (recordFilePaths != null) {
                this.preprocessingMethod = preprocessingMethod;
                this.filenameOutput = filenameOutput;
                data = new InputData[recordFilePaths.length];
                metadata = new Metadata[recordFilePaths.length];
                signals = new double[recordFilePaths.length][][];
                signalsNum = new int[recordFilePaths.length];
                duration = new double[recordFilePaths.length];
                signalLabels = new String[recordFilePaths.length][];
                File file;
                int j;
                String ext = "";
                String recordType;
                for (int i = 0; i<recordFilePaths.length; i++) {
                    file = new File(recordFilePaths[i]);

                    ext = "";
                    j = recordFilePaths[i].lastIndexOf('.');
                    if (j > 0) {
                        ext = recordFilePaths[i].substring(j + 1);
                    }
                    recordType = ext.toUpperCase();
                    //Ucitavanje zapisa odgovarajuce ekstenzije
                    try {
                        if (recordType.equals("EDF")) {
                            data[i] = new EdfFile(file,false);
                        }
                        if (recordType.equals("ANN")) {
                            data[i] = new AnnFile(file,false);
                        }
                        if (recordType.equals("TXT")) {
                            data[i] = new TxtFile(file,false);
                        }
                        if (recordType.equals("CSV")) {
                            data[i] = new CsvFile(file,false);
                        }
                        metadata[i] = data[i].getMetadata();

                        signals[i] = data[i].getSignals();
                        signalsNum[i] = data[i].getNumberOfSignals();
                        duration[i] = data[i].calculateDuration();

                        signalLabels[i] = new String[signalsNum[i]];

                        for (j = 0; j < signalsNum[i]; j++) {
                            signalLabels[i][j] = metadata[i].getSignalParameters()[j].getLabel();
                        }

                    } catch (FileNotFoundException e) {
                        System.out.println("File not found. Sorry for the inconvenience.");
                        e.printStackTrace();
                    } catch (IOException e) {
                        System.out.println("An error occurred while loading file. The file had to be closed.");
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
    }

    public Parallelization(String [] recordFilePaths, boolean allSignals, String[][] selectedSignals, PreprocessingMethod preprocessingMethod, String filenameOutput){
        if (recordFilePaths != null) {
            this.preprocessingMethod = preprocessingMethod;
            this.filenameOutput = filenameOutput;
            data = new InputData[recordFilePaths.length];
            metadata = new Metadata[recordFilePaths.length];
            signals = new double[recordFilePaths.length][][];
            signalsNum = new int[recordFilePaths.length];
            duration = new double[recordFilePaths.length];
            signalLabels = new String[recordFilePaths.length][];
            File file;
            int j;
            String ext = "";
            String recordType;
            for (int i = 0; i<recordFilePaths.length; i++) {
                file = new File(recordFilePaths[i]);

                ext = "";
                j = recordFilePaths[i].lastIndexOf('.');
                if (j > 0) {
                    ext = recordFilePaths[i].substring(j + 1);
                }
                recordType = ext.toUpperCase();
                //Ucitavanje zapisa odgovarajuce ekstenzije
                try {
                    if (recordType.equals("EDF")) {
                        data[i] = new EdfFile(file,false);
                    }
                    if (recordType.equals("ANN")) {
                        data[i] = new AnnFile(file,false);
                    }
                    if (recordType.equals("TXT")) {
                        data[i] = new TxtFile(file,false);
                    }
                    if (recordType.equals("CSV")) {
                        data[i] = new CsvFile(file,false);
                    }
                    metadata[i] = data[i].getMetadata();

                    if (allSignals) {
                        signals[i] = data[i].getSignals();

                        signalsNum[i] = data[i].getNumberOfSignals();
                        duration[i] = data[i].calculateDuration();

                        signalLabels[i] = new String[signalsNum[i]];

                        for (j = 0; j < signalsNum[i]; j++) {
                            signalLabels[i][j] = metadata[i].getSignalParameters()[j].getLabel();
                        }
                    }
                    else {  // specific signals in each record where selected
                        // now, first find the names of all signals and then use only those signals that match the selected names
                        signalsNum[i] = data[i].getNumberOfSignals();
                        signalLabels[i] = new String[signalsNum[i]];

                        for (j = 0; j < signalsNum[i]; j++) {
                            signalLabels[i][j] = metadata[i].getSignalParameters()[j].getLabel();
                        }
                        int [] indices = new int[selectedSignals[i].length];
                        for (j = 0; j < selectedSignals[i].length; j++){
                            for (int k = 0; k < signalLabels[i].length; k++){
                                if (selectedSignals[i][j].equals(signalLabels[i][k])){
                                    indices[j] = k;
                                    break;
                                }
                            }
                        }
                        // finish up with determining the appropriate signals
                        signalsNum[i] = selectedSignals[i].length;
                        signalLabels[i] = selectedSignals[i];
                        duration[i] = data[i].calculateDuration();

                        for (j = 0; j < selectedSignals[i].length; j++){
                            signals[i][j] = data[i].getSignal(indices[j]);
                        }
                    }
                } catch (FileNotFoundException e) {
                    System.out.println("File not found. Sorry for the inconvenience.");
                    e.printStackTrace();
                } catch (IOException e) {
                    System.out.println("An error occurred while loading file. The file had to be closed.");
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


    private int analyzeParallelizationOptions(){
        // get the runtime object associated with the current Java application
        Runtime runtime = Runtime.getRuntime();
        // get the number of processors available to the Java virtual machine
        return runtime.availableProcessors();
    }

    public void setParallelize(boolean parallelize){
        this.parallelize = parallelize;
    }
    public void setFeatures(Features selectedFeatures){
        this.selectedFeatures = selectedFeatures;
    }
    public void setSelectedFeatureParameters(FeatureParameters selectedFeatureParameters){
        this.selectedFeatureParameters = selectedFeatureParameters;
    }
    public void setStartTime(double startTime){
        this.startTime = startTime;
    }
    public void setEndTime(double endTime){
        this.endTime = endTime;
    }
    public void setUntilEndOfTheRecord(boolean untilEndOfTheRecord){ this.untilEndOfTheRecord = untilEndOfTheRecord;  }
    public void setSegmentLength(double segmentLength){
        this.segmentLength = segmentLength;
    }
    public void setDisorders(String [] disorders){
        this.disorders = disorders;
    }


    private boolean containsMultivariateFeatures(){
        String [] features = this.selectedFeatures.getSelectedFeaturesArray();
        for (int i=0; i<features.length; i++){
            if (features[i].equals(Features.MUTUAL_DIMENSION) || features[i].equals(Features.PHASE_SYNCHRONIZATION) || features[i].equals(Features.SYNCHRONIZATION_LIKELIHOOD) || features[i].equals(Features.CROSS_RECURRENCE)){
                return true;
            }
        }
        return false;
    }

    // Modificirao Davor //
    private boolean containsMorphologicalECGFeatures(){
        String [] features = this.selectedFeatures.getSelectedFeaturesArray();
        for (int i=0; i<features.length; i++){
            if (features[i].equals(Features.ECG_R_WAVE_AMPLITUDE) || features[i].equals(Features.ECG_QRS_COMPLEX_DURATION)
                    || features[i].equals(Features.ECG_P_WAVE_AMPLITUDE) || features[i].equals(Features.ECG_P_WAVE_ABSENCE)
                    || features[i].equals(Features.ECG_P_WAVE_DURATION) || features[i].equals(Features.ECG_T_WAVE_AMPLITUDE)
                    || features[i].equals(Features.ECG_T_WAVE_DURATION) || features[i].equals(Features.ECG_ST_SEGMENT_DURATION)
                    || features[i].equals(Features.ECG_ST_SEGMENT_SLOPE) || features[i].equals(Features.ECG_QT_INTERVAL_DURATION)
                    || features[i].equals(Features.ECG_PR_INTERVAL_DURATION) || features[i].equals(Features.ECG_J_POINT_AMPLITUDE)
                    || features[i].equals(Features.ECG_R_S_RATIO) || features[i].equals(Features.ECG_Q_WAVE_AMPLITUDE)
                    || features[i].equals(Features.ECG_R_WAVE_DURATION) || features[i].equals(Features.ECG_S_WAVE_DURATION)
                    || features[i].equals(Features.ECG_FIBRILATORY_RATE) || features[i].equals(Features.ECG_QT_QTc_RATIO)
                    || features[i].equals(Features.ECG_QTV_NORM) || features[i].equals(Features.ECG_QTVI)
                    || features[i].equals(Features.ECG_TQ_INTERVAL_WE) || features[i].equals(Features.ECG_TQ_INTERVAL_RWE)
                    || features[i].equals(Features.ECG_J_POINT_AMPLITUDE_STDEV)){
                return true;
            }
        }
        return false;
    }

    public boolean runParallelization() throws Exception{
        featureExtraction = new FeatureExtraction(this.selectedFeatures, this.selectedFeatureParameters, this.preprocessingMethod);
        if (this.disorders == null) {
            extractedFeatures = new ExtractedFeatures(this.selectedFeatures.getSelectedFeaturesArray(), this.selectedFeatureParameters.getAllSelectedFeatures(),false);
        }
        else {
            extractedFeatures = new ExtractedFeatures(this.selectedFeatures.getSelectedFeaturesArray(), this.selectedFeatureParameters.getAllSelectedFeatures(),true);
        }
        boolean allok;
        long c = System.currentTimeMillis();
        System.out.println("Starting analysis: "+c);
        if (!this.parallelize){
            allok = this.runSingleThreadedFeatureExtraction();
        }
        else {
            allok = this.runMultiThreadedFeatureExtraction();
        }
        long d = System.currentTimeMillis();
        System.out.println("Ending analysis: "+d);
        System.out.println("Difference: "+(d-c));
        if (allok) {
            extractedFeatures.writeFeatureExtractionResultsToOutputFile(this.filenameOutput);
        }
        else {
            throw new Exception("Something went wrong with feature extraction");
        }
        return true;
    }
    private boolean runSingleThreadedFeatureExtraction(){
        /* In the case of single threaded feature extraction,
           the extraction proceeds one patient file at a time,
           one signal at a time and one segment at a time.
           */
        double [] signal;
        ArrayList<String> results;
        long sampleStart, sampleEnd;
        AnnFile ann = null;
        // Modificirao Davor //
        boolean morphologicalECGFeaturesPresent = this.containsMorphologicalECGFeatures();
        double [] ecg = null;
        double [] ecgFiltred = null;
        double frequency = 0;
        ecgFiducialPoints ecgFiducialPointsSignal = new ecgFiducialPoints();
        ecgFiducialPoints ecgFiducialPointsSegment = null;
        int[] RPeaks = null;
        boolean annotationSpecificDisordersBySegment = false;
        // SignalParameterData signalParameter;

        int segmentsNumber = 0;
        if (!this.untilEndOfTheRecord) {
            //Dodala Nikolina: ako je duljina segmenta veca od razlike vremena završetka i pocetka, segment se krati
            if (this.segmentLength > (this.endTime - this.startTime)) {
                this.segmentLength = this.endTime - this.startTime;
                System.out.println("Segment lenght longer than total length, reduced to: this.segmentLength");
            }
            segmentsNumber =(int) ((this.endTime - this.startTime) / this.segmentLength);
        }
        /*
        if (disorders!=null){
            if (disorders[0].equals("ANN")){
                annotationSpecificDisordersBySegment = true;
            }
        }*/

        for (int i = 0; i < this.data.length; i++){
            if (untilEndOfTheRecord){
                if (segmentLength == 0.0){  // the case where the entire record is one segment
                    segmentsNumber = 1;
                    this.segmentLength = duration[i]-1e-3;   // note that this may not be precise, test to see if it's ok
                }
                else {
                    this.endTime = duration[i]-1e-3;
                    segmentsNumber = (int) ((this.endTime - this.startTime) / this.segmentLength);
                }
            }

            if (data[i].getClass().getSimpleName().equals("AnnFile")) {
                ann = (AnnFile) data[i];
            }

            String[] morphologyMethods;
            String[] noiseFilteringMethods;
            for (int j = 0; j < this.signalsNum[i]; j++){
                if (ann!=null){
                    frequency = 1.0;
                }
                else {
                    frequency = data[i].calculateFrequency(j);
                }
                // Modificirao Davor //
                if (morphologicalECGFeaturesPresent) {  // morphological ECG features are present, ECG fiducial point detection is required
                    ecg = data[i].getSamples(j);

                    // TODO Dodati izbor metoda za detekciju
                    morphologyMethods = this.preprocessingMethod.getMorphologyMethods();
                    for (int k = 0; k < morphologyMethods.length; k++){
                        if (morphologyMethods[i].equals("PAN_TOMPKINS_R_PEAK_DETECTION")){
                            //RPeaks = PanTompkins.DetectRSpike(ecg,frequency); // needs to be adapted for calculation
                        }
                        if (morphologyMethods[i].equals("ELGENDI_R_PEAK_DETECTION")){
                            RPeaks = Elgendi.DetectRWave(ecg,frequency);
                        }
                        if (morphologyMethods[i].equals("MARTINEZ_PT_FOR_P_AND_T_PEAKS")){
                            ecgFiducialPointsSignal = MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);
                        }
                    }

                    // TODO Ako se moguće - ako postoje i EKG signal i ANN anotacije (npr. kao kod MIT arrhythmia baze podataka):
                    // TODO Dodati mogućnost računanja karakterističnih točaka na temelju referentnih anotacija R zubaca

                    // TODO Dodati izbor metoda za uklanjanje šuma i lutanja bazne linije
                    noiseFilteringMethods = this.preprocessingMethod.getNoiseFilteringMethods();
                    for (int k = 0; k < noiseFilteringMethods.length; k++){
                        if (noiseFilteringMethods[i].equals(PreprocessingMethod.BASELINE_WANDER_REMOVAL_ECG)){
                            ecgFiltred = BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);
                        }
                        if (noiseFilteringMethods[i].equals(PreprocessingMethod.MMF)){
                            if (ecgFiltred == null) {
                                ecgFiltred = MMOperators.MMF(ecg,frequency);
                            }
                            else {
                                ecgFiltred = MMOperators.MMF(ecgFiltred,frequency);
                            }
                        }
                    }
                }
                for (int k = 0; k < segmentsNumber; k++) {
                    if (!morphologicalECGFeaturesPresent) {
                        if (ann != null){
                            signal = ann.getAnnotationTimesAsIntervalValues(this.startTime + k * this.segmentLength, this.segmentLength);
                        }
                        else {
                            sampleStart = data[i].calculateSampleFromTime(this.startTime + k * this.segmentLength, j);
                            sampleEnd = data[i].calculateSampleFromTime(this.startTime + (k + 1) * this.segmentLength, j);
                            signal = data[i].getSamplesFromInterval(j, sampleStart, sampleEnd);
                        }
                    }
                    else{
                        sampleStart = data[i].calculateSampleFromTime(this.startTime + k* this.segmentLength, j);
                        sampleEnd = data[i].calculateSampleFromTime(this.startTime + (k+1) * this.segmentLength, j);
                        if (ecgFiltred != null) {
                            signal = getSamplesFromInterval(ecgFiltred, sampleStart, sampleEnd);
                        }
                        else {
                            signal = getSamplesFromInterval(ecg, sampleStart, sampleEnd);
                        }
                        ecgFiducialPointsSegment = ecgFiducialPointsSignal.getFiducialPointFromInterval(sampleStart, sampleEnd);
                    }
                    try {
                        if (!morphologicalECGFeaturesPresent) {
                            results = featureExtraction.performFeatureExtraction(signal,frequency);
                        }
                        else {
                            results = featureExtraction.performMorphologicalECGFeatureExtraction(signal, frequency, ecgFiducialPointsSegment);
                        }
                        if (disorders!=null){
                            this.saveSignalInformation(results, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + k * this.segmentLength), Double.toString(this.segmentLength), this.disorders[i]);
                        }
                        else {
                            this.saveSignalInformation(results, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + k * this.segmentLength), Double.toString(this.segmentLength), null);
                        }
                    }
                    catch (Exception exc){
                        System.err.println(exc.getMessage());
                    }
                }
            }
        }
        return true;
    }
    private boolean runMultiThreadedFeatureExtraction(){
        /* In the case of multithreaded feature extraction,
           the case at hand is first analyzed:
           - if multiple segments are present in a signal, then these are resolved in parallel
           - if there are no multiple segments, but there are signals of the same type, then these are resolved in parallel
           - if there are no multiple segments nor signals of the same type, but there are multiple patient files, then these are resolved in parallel
           - lastly, if there is only a single file with a single signal of a type and a single segment, then it is treated as sequential and single threaded
           If multivariate features are extracted, signal based parallelization is disregarded.
           In all cases, if there is no additional physical resource available at the time, the calculation proceeds sequentially as single thread
           */
        double [] signal;
        double [] signalA, signalB;
        // Modificirao Davor //
        double [] ecg = null;
        double [] ecgFiltred = null;
        double frequency = 0;
        ecgFiducialPoints ecgFiducialPointsSignal = new ecgFiducialPoints();
        ecgFiducialPoints ecgFiducialPointsSegment;
        int[] RPeaks = null;
        // SignalParameterData signalParameter;

        int processorsAvailable;
        ParallelExtractionThread parallelExtractionThread;

        boolean multivariateFeaturesPresent = this.containsMultivariateFeatures();
        boolean morphologicalECGFeaturesPresent = this.containsMorphologicalECGFeatures(); // Modificirao Davor //
        int l;
        AnnFile ann = null;
        ArrayList<ParallelExtractionThread> th;
        Iterator<ParallelExtractionThread> it;

        int segmentsNumber;
        if (!untilEndOfTheRecord) {
            //Dodala Nikolina: ako je duljina segmenta veca od razlike vremena završetka i pocetka, segment se krati
            if (this.segmentLength > (this.endTime - this.startTime)) {
                this.segmentLength = this.endTime - this.startTime;
                System.out.println("Segment lenght longer than total length, reduced to: this.segmentLength");
            }
            segmentsNumber = (int) ((this.endTime - this.startTime) / this.segmentLength);
        }
        else {
            if (segmentLength == 0.0){ // the case where the entire record is one segment
                segmentsNumber = 1;
            }
            else {
                segmentsNumber = 2; // this may not be accurate, namely if a record is longer than segmentLength, but shorter than twice the length, then this would not hold, however this is a cornercase that should not influence execution time
            }
        }

        if (segmentsNumber >= 2){  // npr. 5
            processorsAvailable = this.analyzeParallelizationOptions()-1; //npr. 2
            System.out.println("Logical cores available: "+processorsAvailable);
            long sampleStart, sampleEnd;

            for (int i = 0; i < this.data.length; i++) {
                if (untilEndOfTheRecord){
                   this.endTime = duration[i]-1e-3;
                   segmentsNumber = (int) ((this.endTime - this.startTime) / this.segmentLength);
                }

                if (data[i].getClass().getSimpleName().equals("AnnFile")) {
                    ann = (AnnFile) data[i];
                }
                String[] morphologyMethods;
                String[] noiseFilteringMethods;
                for (int j = 0; j < this.signalsNum[i]; j++) {
                    if (ann != null) {
                        frequency = 1.0;
                    }
                    else {
                        frequency = data[i].calculateFrequency(j);
                    }
                    // Modificirao Davor //
                    if (morphologicalECGFeaturesPresent) {  // morphological ECG features are present, ECG fiducial point detection is required
                        ecg = data[i].getSamples(j); //Nikolina: metoda getSamples baca exception

                        morphologyMethods = this.preprocessingMethod.getMorphologyMethods();
                        for (int k = 0; k < morphologyMethods.length; k++){
                            if (morphologyMethods[k].equals("PAN_TOMPKINS_R_PEAK_DETECTION")){
                                //RPeaks = PanTompkins.DetectRSpike(ecg,frequency); // needs to be adapted for calculation
                            }
                            if (morphologyMethods[k].equals("ELGENDI_R_PEAK_DETECTION")){
                                RPeaks = Elgendi.DetectRWave(ecg,frequency);
                            }
                            if (morphologyMethods[k].equals("MARTINEZ_PT_FOR_P_AND_T_PEAKS")){
                                ecgFiducialPointsSignal = MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);
                            }
                        }

                        noiseFilteringMethods = this.preprocessingMethod.getNoiseFilteringMethods();
                        for (int k = 0; k < noiseFilteringMethods.length; k++){
                            if (noiseFilteringMethods[k].equals(PreprocessingMethod.BASELINE_WANDER_REMOVAL_ECG)){
                                ecgFiltred = BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);
                            }
                            if (noiseFilteringMethods[k].equals(PreprocessingMethod.MMF)){
                                if (ecgFiltred == null) {
                                    ecgFiltred = MMOperators.MMF(ecg,frequency);
                                }
                                else {
                                    ecgFiltred = MMOperators.MMF(ecgFiltred,frequency);
                                }
                            }
                        }
                    }

                    for (int k = 0; k < segmentsNumber; k = k + l) {
                        //g = new ThreadGroup("Group");
                        th = new ArrayList<ParallelExtractionThread>();
                        for (l = 0; l < processorsAvailable; l++) {
                            if (k + l >= segmentsNumber) {//reached the end of parallelization
                                break;
                            }
                            // Modificirao Davor //
                            if (!morphologicalECGFeaturesPresent) {
                                if (ann != null){
                                    signal = ann.getAnnotationTimesAsIntervalValues(this.startTime + (k + l) * this.segmentLength, this.segmentLength);
                                    if (signal.length == 0){
                                        System.err.println("Rec. "+ann.getName()+ ": No samples in segment: ["+(this.startTime + (k + l) * this.segmentLength) + ", " + (this.startTime + (k + l + 1) * this.segmentLength) + "] s");
                                        continue;
                                    }
                                }
                                else{
                                    sampleStart = data[i].calculateSampleFromTime(this.startTime + (k + l)* this.segmentLength, j);
                                    sampleEnd = data[i].calculateSampleFromTime(this.startTime + (k + l + 1) * this.segmentLength, j);
                                    signal = data[i].getSamplesFromInterval(j, sampleStart, sampleEnd);
                                }

                                if (this.disorders != null) {
                                    parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + (k + l) * this.segmentLength), Double.toString(this.segmentLength), this.disorders[i]);
                                }
                                else {
                                    parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + (k + l) * this.segmentLength), Double.toString(this.segmentLength), null);
                                }
                            }
                            else {
                                sampleStart = data[i].calculateSampleFromTime(this.startTime + (k + l)* this.segmentLength, j);
                                sampleEnd = data[i].calculateSampleFromTime(this.startTime + (k + l + 1) * this.segmentLength, j);
                                if (ecgFiltred != null) {
                                    signal = getSamplesFromInterval(ecgFiltred, sampleStart, sampleEnd);
                                }
                                else {
                                    signal = getSamplesFromInterval(ecg, sampleStart, sampleEnd);
                                }
                                ecgFiducialPointsSegment = ecgFiducialPointsSignal.getFiducialPointFromInterval(sampleStart, sampleEnd);
                                if (this.disorders != null) {
                                    parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + (k + l) * this.segmentLength), Double.toString(this.segmentLength), this.disorders[i]);
                                }
                                else {
                                    parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime + (k + l) * this.segmentLength), Double.toString(this.segmentLength), null);
                                }
                            }
                            th.add(parallelExtractionThread);
                            parallelExtractionThread.start();
                        }
                        try {
                            it = th.iterator();
                            while (it.hasNext()){
                                it.next().join();
                            }
                        }
                        catch (java.lang.InterruptedException iexc){}
                        this.saveSignalInformation(th);
                    }
                }
            }
        }

        else if (signalsNum[0] >= 2 && segmentsNumber == 1) { // several signals, but one segment per signal; ann file always has only one signal, so it doesn't come to this branch
            ArrayList<String> results;
            long sampleStart, sampleEnd;
            processorsAvailable = this.analyzeParallelizationOptions()-1;
            System.out.println("Logical cores available: "+processorsAvailable);
            int k = 0;


            for (int i = 0; i < this.data.length; i++) {
                if (untilEndOfTheRecord){
                    this.endTime = duration[i]-1e-3;
                    this.segmentLength = endTime - startTime;
                }
                sampleStart = data[i].calculateSampleFromTime(this.startTime, 0);
                sampleEnd = data[i].calculateSampleFromTime(this.endTime, 0);

                String[] morphologyMethods;
                String[] noiseFilteringMethods;

                for (int j = 0; j < this.signalsNum[i]; j = j + k) {
                    //g = new ThreadGroup("Group");
                    th = new ArrayList<ParallelExtractionThread>();

                    for (k = 0; k < processorsAvailable; k++) {
                        if (j + k >= this.signalsNum[i]) {//reached the end of parallelization
                            break;
                        }
                        if (ann != null){
                            frequency = 1.0;
                        }
                        else {
                            frequency = data[i].calculateFrequency(j + k);
                        }
                        // Modificirao Davor //
                        if (!morphologicalECGFeaturesPresent) {
                            signal = data[i].getSamplesFromInterval(j + k, sampleStart, sampleEnd);
                            if (this.disorders!= null) {
                                parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[i]);
                            }
                            else {
                                parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                            }
                        }
                        else {
                            ecg = data[i].getSamples(j + k);

                            morphologyMethods = this.preprocessingMethod.getMorphologyMethods();
                            for (l = 0; l < morphologyMethods.length; l++){
                                if (morphologyMethods[l].equals("PAN_TOMPKINS_R_PEAK_DETECTION")){
                                    //RPeaks = PanTompkins.DetectRSpike(ecg,frequency); // needs to be adapted for calculation
                                }
                                if (morphologyMethods[l].equals("ELGENDI_R_PEAK_DETECTION")){
                                    RPeaks = Elgendi.DetectRWave(ecg,frequency);
                                }
                                if (morphologyMethods[l].equals("MARTINEZ_PT_FOR_P_AND_T_PEAKS")){
                                    ecgFiducialPointsSignal = MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);
                                }
                            }

                            noiseFilteringMethods = this.preprocessingMethod.getNoiseFilteringMethods();
                            for (l = 0; l < noiseFilteringMethods.length; l++){
                                if (noiseFilteringMethods[l].equals(PreprocessingMethod.BASELINE_WANDER_REMOVAL_ECG)){
                                    ecgFiltred = BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);
                                }
                                if (noiseFilteringMethods[l].equals(PreprocessingMethod.MMF)){
                                    if (ecgFiltred == null) {
                                        ecgFiltred = MMOperators.MMF(ecg,frequency);
                                    }
                                    else {
                                        ecgFiltred = MMOperators.MMF(ecgFiltred,frequency);
                                    }
                                }
                            }
                            if (ecgFiltred != null) {
                                signal = getSamplesFromInterval(ecgFiltred, sampleStart, sampleEnd);
                            }
                            else {
                                signal = getSamplesFromInterval(ecgFiltred, sampleStart, sampleEnd);
                            }
                            ecgFiducialPointsSegment = ecgFiducialPointsSignal.getFiducialPointFromInterval(sampleStart, sampleEnd);
                            if (this.disorders != null) {
                                parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[i]);
                            }
                            else {
                                parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i].getName(), signalLabels[i][j], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                            }
                        }
                        th.add(parallelExtractionThread);
                        parallelExtractionThread.start();
                    }
                    try {
                        it = th.iterator();
                        while (it.hasNext()){
                            it.next().join();
                        }
                    }
                    catch (java.lang.InterruptedException iexc) { }
                    this.saveSignalInformation(th);
                }

               if (multivariateFeaturesPresent) {  // multivariate features are present, do only calculations for them, no parallelization
                   for (int j = 0; j < this.signalsNum[i]; j ++) {
                       for (k = j+1; k < this.signalsNum[i]; k ++) {
                           signalA = data[i].getSamplesFromInterval(j, sampleStart, sampleEnd);
                           signalB = data[i].getSamplesFromInterval(k, sampleStart, sampleEnd);
                           try {
                               results = featureExtraction.performMultivariateFeatureExtraction(signalA,signalB);
                               if (this.disorders != null) {
                                   this.saveSignalInformation(results, data[i].getName(), signalLabels[i][j] + "+" + signalLabels[i][k], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[i]);
                               }
                               else {
                                   this.saveSignalInformation(results, data[i].getName(), signalLabels[i][j] + "+" + signalLabels[i][k], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                               }
                           }
                           catch (Exception exc){
                               System.err.println(exc.getMessage());
                           }
                       }
                   }
                }
            }
        }
        else if (this.data.length >= 2 && signalsNum[0] == 1 && segmentsNumber == 1){    // several records, one signal and one segment per record, parallelize by records
            long sampleStart = 0l, sampleEnd = 0l;
            processorsAvailable = this.analyzeParallelizationOptions()-1;
            System.out.println("Logical cores available: "+ processorsAvailable);
            int j = 0;

            for (int i = 0; i < this.data.length; i = i+j) {
                if (untilEndOfTheRecord){
                    this.endTime = duration[i]-1e-3;
                    this.segmentLength = endTime - startTime;
                }
                if (data[i].getClass().getSimpleName().equals("AnnFile")) {
                    ann = (AnnFile) data[i];
                }
                th = new ArrayList<ParallelExtractionThread>();
                for (j = 0; j < processorsAvailable; j++) {
                    if (i + j >= data.length) {//reached the end of parallelization
                        break;
                    }
                    if (ann != null){
                        frequency = 1.0;
                    }
                    else {
                        frequency = data[i + j].calculateFrequency(0);
                    }
                    // Modificirao Davor //
                    if (!morphologicalECGFeaturesPresent) {
                        if (ann == null) {
                            sampleStart = data[i].calculateSampleFromTime(this.startTime, 0);
                            sampleEnd = data[i].calculateSampleFromTime(this.endTime, 0);
                            signal = data[i + j].getSamplesFromInterval(0, sampleStart, sampleEnd);
                        } else {
                            ann = (AnnFile) data[i + j];
                            signal = ann.getAnnotationTimesAsIntervalValues(this.startTime, this.segmentLength);
                        }
                        if (this.disorders != null) {
                            parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i + j].getName(), signalLabels[i + j][0], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[i]);
                        }
                        else {
                            parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, data[i + j].getName(), signalLabels[i + j][0], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                        }
                    }
                    else {
                        String[] morphologyMethods;
                        String[] noiseFilteringMethods;

                        ecg = data[i + j].getSamples(0);

                        morphologyMethods = this.preprocessingMethod.getMorphologyMethods();
                        for (l = 0; l < morphologyMethods.length; l++){
                            if (morphologyMethods[l].equals("PAN_TOMPKINS_R_PEAK_DETECTION")){
                                //RPeaks = PanTompkins.DetectRSpike(ecg,frequency); // needs to be adapted for calculation
                            }
                            if (morphologyMethods[l].equals("ELGENDI_R_PEAK_DETECTION")){
                                RPeaks = Elgendi.DetectRWave(ecg,frequency);
                            }
                            if (morphologyMethods[l].equals("MARTINEZ_PT_FOR_P_AND_T_PEAKS")){
                                ecgFiducialPointsSignal = MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);
                            }
                        }

                        noiseFilteringMethods = this.preprocessingMethod.getNoiseFilteringMethods();
                        for (l = 0; l < noiseFilteringMethods.length; l++){
                            if (noiseFilteringMethods[l].equals(PreprocessingMethod.BASELINE_WANDER_REMOVAL_ECG)){
                                ecgFiltred = BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);
                            }
                            if (noiseFilteringMethods[l].equals(PreprocessingMethod.MMF)){
                                if (ecgFiltred == null) {
                                    ecgFiltred = MMOperators.MMF(ecg,frequency);
                                }
                                else {
                                    ecgFiltred = MMOperators.MMF(ecgFiltred,frequency);
                                }
                            }
                        }
                        if (ecgFiltred != null) {
                            signal = getSamplesFromInterval(ecgFiltred, sampleStart, sampleEnd);
                        }
                        else {
                            signal = getSamplesFromInterval(ecg, sampleStart, sampleEnd);
                        }
                        ecgFiducialPointsSegment = ecgFiducialPointsSignal.getFiducialPointFromInterval(sampleStart, sampleEnd);
                        if (this.disorders != null) {
                            parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i + j].getName(), signalLabels[i + j][0], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[i]);
                        }
                        else {
                            parallelExtractionThread = new ParallelExtractionThread(this.featureExtraction, signal, frequency, ecgFiducialPointsSegment, data[i + j].getName(), signalLabels[i + j][0], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                        }
                    }
                    th.add(parallelExtractionThread);
                    parallelExtractionThread.start();
                }
                try {
                    it = th.iterator();
                    while (it.hasNext()){
                        it.next().join();
                    }
                } catch (java.lang.InterruptedException iexc) { }
                this.saveSignalInformation(th);
            }
        }
        else if (this.data != null && segmentsNumber == 1 && signalsNum[0] == 1){   // single record, single signal, single segment, no parallelization
            if (this.data != null) {
                ArrayList<String> results;
                long sampleStart;
                long sampleEnd;
                if (untilEndOfTheRecord){
                    this.endTime = duration[0]-1e-3;
                    this.segmentLength = endTime - startTime;
                }
                if (data[0].getClass().getSimpleName().equals("AnnFile")){
                    ann = (AnnFile) data[0];
                    frequency = 1.0;
                }
                else {
                    frequency = data[0].calculateFrequency(0);
                }
                // Modificirao Davor //
                if (!morphologicalECGFeaturesPresent) {
                    if (ann != null) {
                        signal = ann.getAnnotationTimesAsIntervalValues(this.startTime, this.segmentLength);
                    } else {
                        sampleStart = data[0].calculateSampleFromTime(this.startTime, 0);
                        sampleEnd = data[0].calculateSampleFromTime(this.endTime, 0);
                        signal = data[0].getSamplesFromInterval(0, sampleStart, sampleEnd);
                    }
                    try {
                        results = featureExtraction.performFeatureExtraction(signal,frequency);
                        if (this.disorders != null) {
                            this.saveSignalInformation(results, data[0].getName(), signalLabels[0][0], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[0]);
                        }
                        else {
                            this.saveSignalInformation(results, data[0].getName(), signalLabels[0][0], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                        }
                    } catch (Exception exc) {
                        System.err.println(exc.getMessage());
                    }
                }
                else {
                    sampleStart = data[0].calculateSampleFromTime(this.startTime, 0);
                    sampleEnd = data[0].calculateSampleFromTime(this.endTime, 0);
                    ecg = data[0].getSamplesFromInterval(0, sampleStart, sampleEnd);

                    String[] morphologyMethods;
                    String[] noiseFilteringMethods;

                    morphologyMethods = this.preprocessingMethod.getMorphologyMethods();
                    for (l = 0; l < morphologyMethods.length; l++){
                        if (morphologyMethods[l].equals("PAN_TOMPKINS_R_PEAK_DETECTION")){
                            //RPeaks = PanTompkins.DetectRSpike(ecg,frequency); // needs to be adapted for calculation
                        }
                        if (morphologyMethods[l].equals("ELGENDI_R_PEAK_DETECTION")){
                            RPeaks = Elgendi.DetectRWave(ecg,frequency);
                        }
                        if (morphologyMethods[l].equals("MARTINEZ_PT_FOR_P_AND_T_PEAKS")){
                            ecgFiducialPointsSignal = MartinezPT.DetectFiducialPoints(ecg,frequency,RPeaks);
                        }
                    }

                    noiseFilteringMethods = this.preprocessingMethod.getNoiseFilteringMethods();
                    for (l = 0; l < noiseFilteringMethods.length; l++){
                        if (noiseFilteringMethods[l].equals(PreprocessingMethod.BASELINE_WANDER_REMOVAL_ECG)){
                            ecgFiltred = BaselineWanderRemoval.RemoveBaselineWander(ecg,frequency,ecgFiducialPointsSignal);
                        }
                        if (noiseFilteringMethods[l].equals(PreprocessingMethod.MMF)){
                            if (ecgFiltred == null) {
                                ecgFiltred = MMOperators.MMF(ecg,frequency);
                            }
                            else {
                                ecgFiltred = MMOperators.MMF(ecgFiltred,frequency);
                            }
                        }
                    }
                    try {
                        if (ecgFiltred!=null) {
                            results = featureExtraction.performMorphologicalECGFeatureExtraction(ecgFiltred, frequency, ecgFiducialPointsSignal);
                        }
                        else {
                            results = featureExtraction.performMorphologicalECGFeatureExtraction(ecg, frequency, ecgFiducialPointsSignal);
                        }
                        if (this.disorders != null) {
                            this.saveSignalInformation(results, data[0].getName(), signalLabels[0][0], Double.toString(this.startTime), Double.toString(this.segmentLength), this.disorders[0]);
                        }
                        else {
                            this.saveSignalInformation(results, data[0].getName(), signalLabels[0][0], Double.toString(this.startTime), Double.toString(this.segmentLength), null);
                        }
                    } catch (Exception exc) {
                        System.err.println(exc.getMessage());
                    }
                }
            }
        }
        else {
            return false;
        }
        return true;
    }
    private void saveSignalInformation(ArrayList<ParallelExtractionThread> group){
        Iterator<ParallelExtractionThread> it = group.iterator();
        ParallelExtractionThread t;
        String [] results;
        int i = 0, j = 0;
        while (it.hasNext()){
            t = it.next();
            results = new String[t.getResults().size()];
            for (j = 0; j<t.getResults().size(); j++){
                results[j] = t.getResults().get(j);
            }
            this.extractedFeatures.addExtractedFeatureVector(t.getFilename(), t.getSignalLabel(), t.getStartTime(), t.getSegmentLength(), results, t.getDisorder());
            i++;
        }
    }
    private void saveSignalInformation (ArrayList<String> results, String filename, String signalLabel, String startTime, String segmentLength, String disorder){
         Iterator<String> it = results.iterator();
         String [] res = new String[results.size()];
         int i=0;
         while (it.hasNext()){
            res[i] = it.next();
            i++;
         }
        this.extractedFeatures.addExtractedFeatureVector(filename, signalLabel, startTime, segmentLength, res, disorder);
    }

    public static void main(String[] args) { //if needed for testing

    }
}