package multisab.processing.analysis.expertSystem;

import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;

public class TestDroolsMain {

    public static final void main(String[] args) {
        TestDroolsMain tdm = new TestDroolsMain();
        tdm.executeDrools();
    }

    void executeDrools() {
        DetectionExpertSystem t1 = new DetectionExpertSystem();
        DetectionExpertSystem t2 = new DetectionExpertSystem();
        DetectionExpertSystem t3 = new DetectionExpertSystem();

        t1.setAge(35);
        t1.setGender("M");
        t1.setJpointAmplitude(0.23);
        t1.setLead1Name("V2");
        t1.setLead2Name("V3");

        t2.setAge(35);
        t2.setGender("M");
        t2.setJpointAmplitude(0.27);
        t2.setLead1Name("V2");
        t2.setLead2Name("V3");

        t3.setJpointAmplitude(0.12);
        t3.setLead1Name("V5");
        t3.setLead2Name("V6");

        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kr = ks.getRepository();
            KieFileSystem kfs = ks.newKieFileSystem();

            kfs.write(ResourceFactory.newClassPathResource("rules/AMIRules.drl", this.getClass()));
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();

            if (kb.getResults().hasMessages(Message.Level.ERROR)) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }

            KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
            KieSession kSession = kContainer.newKieSession();

            kSession.insert(t1);
            kSession.insert(t2);
            kSession.insert(t3);

            kSession.fireAllRules();
            kSession.dispose();

            System.out.println("Rules end");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
