package multisab.processing.commonSignalFeatures.nonlinear.entropy;

import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;

public class ShannonEntropy {
    public static final int MINIMAL_LENGTH_FOR_EXTRACTION = 20;

    public static double calculateShannonEntropy(double[] HRVseries, int dim, int division) {
        double max = Statistics.maximum(HRVseries);
        double min = Statistics.minimum(HRVseries);
        double boxSize = (max - min) / division;

        int sum;
        // find distribution of points within dim dimensional boxes of size boxSize
        int[] boxes = new int[(int) Math.pow((double) division, (double) dim)];
        int[] locator = new int[dim];
        for (int i = 0; i < HRVseries.length - dim; i++) {
            for (int j = 0; j < dim; j++) {
                locator[j] = (int) /*Math.ceil(*/((HRVseries[i + j] - min) / boxSize/*)*/ - 1);
                if (locator[j] < 0) {
                    locator[j] = 0;
                }
            }
            sum = 0;
            for (int j = 0, a = dim - 1; j < dim; j++, a--) {
                sum += (int) locator[j] * Math.pow(division, a);
            }
            boxes[sum]++;
        }
        double sumEntropy = 0.0;
        //double entropy = 0.0;
        // divide and logarithmize in order to obtain Shannon entropy, disregard empty boxes
        //double percent = 0.0;
        double log2 = Math.log10(2.0);
        for (int i = 0; i < boxes.length; i++) {
            if (boxes[i] > 1) {
                sumEntropy += (double) (boxes[i]) / (HRVseries.length - dim + 1) * Math.log10((double) (boxes[i]) / (HRVseries.length - dim + 1)) / log2;
            }
            /*else if (boxes[i] == 1){
				percent ++;
			}*/
        }
        return -sumEntropy;
    }
}
