package multisab.processing.commonSignalFeatures.nonlinear.multivariate;

import multisab.processing.commonSignalFeatures.nonlinear.phaseSpace.CorrelationDimension;

public class MutualDimension {

    public static final int FINESSE = 20;
    //U STAMOVOM RADU
    public static final int MAXIMUM_EMBEDDING_DIMENSION = 16;
    //Use of non-linear EEG measures to characterize EEG changes during mental activity.
    //Stam CJ, van Woerkom TC, Pritchard WS.
    public static double D2A = 0, D2B = 0, D2C = 0;

    public static double calculateMutualDimension(double[] series1, double[] series2, int dimension1, int dimension2, int lag1, int lag2, int finesse) {
        //double D2A = 0, D2B = 0, D2C = 0;

        try {
            D2A = CorrelationDimension.calculateCorrelationDimension(series1, dimension1, lag1, finesse);
            D2B = CorrelationDimension.calculateCorrelationDimension(series2, dimension2, lag2, finesse);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();

        }

        int lag = Math.max(lag1, lag2);
        int dimension = Math.max(dimension1, dimension2) * 2;
        int N = Math.min(series1.length - (dimension - 1) * lag, series2.length - (dimension - 1) * lag);


        double cMatrix[][] = new double[N][dimension];

        for (int g = 0; g < N; g++) {
            for (int n = 1; n <= dimension / 2; n++) {
                cMatrix[g][n - 1] = series1[g + (n - 1) * lag];
            }

        }
        for (int g = 0; g < N; g++) {
            for (int n = dimension / 2 + 1; n <= dimension; n++) {
                cMatrix[g][n - 1] = series2[g + (n - 1) * lag];
            }
        }
        try {
            D2C = CorrelationDimension.calculateCorrelationDimension(cMatrix, finesse);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();

        }

        return D2A + D2B - D2C;
    }
}
