package multisab.processing.dataHandling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Davor
 */

public class AnnFile extends InputData {

    private int frequency;

    /**
     * Number of annotations in the signal - it is set to 0 if the signal is the whole signal
     */
    int annotationsCount;
    /**
     * Times of annotations, in seconds from the start of the record
     */
    List<Double> timeAnnots;
    /**
     * Times of annotations
     */
    //List<String> timeAnnotsExact;
    /**
     * List of annotations
     */
    List<Character> type;
    /**
     * Numbers of samples corresponding to the annotations
     */
    List<Integer> samplesNumbers;
    /**
     * List of auxiliary annotations
     */


    public AnnFile(File selectedFile, boolean loadHeaderOnly) throws Exception { //Exception {

        super(selectedFile);

        BufferedReader in = null;

        if (recordType.equals("ANN")) {
            if (!loadHeaderOnly) {
                try {
                    in = new BufferedReader(new FileReader(selectedFile));

                    addAnnHeaderData();
                    loadAnnData(in);
                } finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            else {
                try {
                    in = new BufferedReader(new FileReader(selectedFile));

                    addAnnHeaderData();
                } finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }

    private void addAnnHeaderData() {

        metadata = new Metadata();

        metadata.setVersionOfDataFormat("ANN");
        metadata.setLocalPatientIdentification("X");
        metadata.setLocalRecordingIdentification("X");
        metadata.setRecordingStartDate("Startdata X X X X");
        metadata.setRecordingStartTime("X");
        metadata.setHeaderLengthInBytes(1);
        metadata.setReserved("");
        metadata.setDataRecordsNum(1);
        metadata.setDataRecordDurationInSec(1);
        metadata.setSignalsNum(1);

        numberOfSignals = 1;
        numberOfSamples = new int[numberOfSignals];
        signals = new double[numberOfSignals][];

        numberOfAnnotations = 1;

        SignalParameterData[] signalsParameterData = new SignalParameterData[1];

        SignalParameterData signal = new SignalParameterData();

        signal.setLabel("ANN_Annotations");
        signal.setTransducerType("");
        signal.setPhysicalDimension("");
        signal.setPhysicalMin(0);
        signal.setPhysicalMax(1);
        signal.setDigitalMin(-32768);
        signal.setDigitalMax(32767);
        signal.setPrefiltering("");
        signal.setSamplesInDataRecordNum(1);
        signal.setReserved("");
        signal.setPhysicalSampleMax(1);
        signal.setPhysicalSampleMin(0);
        signal.setType(1);

        signalsParameterData[0] = signal;

        metadata.setSignalParameters(signalsParameterData);
    }

    private void loadAnnData(BufferedReader in) throws Exception {


        List<String> aux;

        boolean fantasia = false;

        timeAnnots = new ArrayList<Double>();
        //timeAnnotsExact = new ArrayList<String>();
        type = new ArrayList<Character>();
        samplesNumbers = new ArrayList<Integer>();
        aux = new ArrayList<String>();
        ArrayList <Integer> nonBeatsArray = new ArrayList<Integer>();
        boolean [] nonBeats = null;
        try {
            String line;
            String firstPart;
            String secondPart;
            String thirdPart;
            String fourthPart;
            int loc = 0;

            while ((line = in.readLine()) != null) {
                line = line.trim();
                if (line.equals("")) continue;
                else if (line.contains("Type") || line.contains("Time")) continue;
                else if (line.contains("t0")) {
                    fantasia = true;
                    continue;
                }
                if (fantasia) {
                    firstPart = line.substring(0, line.indexOf("\t"));
                    secondPart = line.substring(line.indexOf("\t"));
                    secondPart = secondPart.trim();
                    thirdPart = secondPart.substring(secondPart.indexOf("\t"));
                    secondPart = secondPart.substring(0, secondPart.indexOf("\t"));
                    thirdPart = thirdPart.trim();

                    if (thirdPart instanceof Object) {
                        aux.add(thirdPart);
                    } else {
                        aux.add("");
                    }
                    type.add(Character.valueOf(secondPart.charAt(0)));
                    timeAnnots.add(Double.valueOf(InputData.timeStringToSeconds(firstPart))); // dodaj vrijeme anotacije u listu vremena anotacija
                    //timeAnnotsExact.add(firstPart);
                } else {
                    if (line.contains("]")) {
                        firstPart = line.substring(0, line.indexOf("]") + 1);
                        secondPart = line.substring(line.indexOf("]") + 1);
                        secondPart = secondPart.trim();
                    } else {
                        firstPart = line.substring(0, line.indexOf(" "));
                        secondPart = line.substring(line.indexOf(" ") + 1);
                        secondPart = secondPart.trim();
                    }
                    thirdPart = secondPart.substring(secondPart.indexOf(" "));
                    secondPart = secondPart.substring(0, secondPart.indexOf(" "));
                    thirdPart = thirdPart.trim();

                    if (thirdPart.contains("\t")) {
                        fourthPart = thirdPart.substring(thirdPart.indexOf("\t") + 1);
                        aux.add(fourthPart);
                    } else {
                        aux.add("");
                    }
                    thirdPart = thirdPart.substring(0, thirdPart.indexOf(" "));

                    type.add(Character.valueOf(thirdPart.charAt(0))); // dodaj anotaciju u listu anotacija
                    samplesNumbers.add(Integer.valueOf(Integer.parseInt(secondPart))); // dodaj broj uzorka u listu brojeva uzorka
                    if (thirdPart.charAt(0)=='~' || thirdPart.charAt(0)=='+' || thirdPart.charAt(0)=='[' || thirdPart.charAt(0)=='x' || thirdPart.charAt(0)==']' || thirdPart.charAt(0)==']' || thirdPart.charAt(0)=='(' || thirdPart.charAt(0)==')' || thirdPart.charAt(0)=='p' || thirdPart.charAt(0)=='u' || thirdPart.charAt(0)=='t' || thirdPart.charAt(0)=='`' || thirdPart.charAt(0)=='\'' || thirdPart.charAt(0)=='^' || thirdPart.charAt(0)=='s' || thirdPart.charAt(0)=='T' || thirdPart.charAt(0)=='*' || thirdPart.charAt(0)=='D' || thirdPart.charAt(0)=='=' || thirdPart.charAt(0)=='"' || thirdPart.charAt(0)=='@') {
                        nonBeatsArray.add(loc); // ako anotacija nije otkucaj, dodaj njezin broj u listu neotkucaja
                        loc++;
                    }
                    else {
                        loc++;
                    }
                    timeAnnots.add(Double.valueOf(InputData.timeStringToSeconds(firstPart))); // dodaj vrijeme anotacije u listu vremena anotacija
                    //timeAnnotsExact.add(firstPart);
                }
            }
            nonBeats = new boolean[loc];
            for (int i=0; i<loc; i++){
                nonBeats[i] = false;
            }
            Iterator<Integer> iter = nonBeatsArray.iterator();

            while (iter.hasNext()){
                nonBeats[iter.next()] = true;
            }

        } catch (NumberFormatException e) {
            //System.out.println("File contains some illegal data (like more than 59 minutes of recording).");
            //e.printStackTrace();
            throw new Exception("File contains some illegal data (like more than 59 minutes of recording).");
        } catch (IOException exe) {
            if (timeAnnots.size() == 0) {
                throw new Exception("File is empty.");
            }
        }

        annotationsCount = timeAnnots.size();


        metadata.setDataRecordDurationInSec(duration);

        frequency = (int) Math.round(samplesNumbers.get(annotationsCount - 1) / duration);

        // TODO: pitati Alana
        double start = timeAnnots.get(0).doubleValue();
        for (int i = 0; i < timeAnnots.size(); i++) {
            timeAnnots.set(i, timeAnnots.get(i).doubleValue() - start);
        }
        duration = timeAnnots.get(annotationsCount - 1).doubleValue();

        annots = new Annotation[1][];

        Annotation[] signalAnnots = new Annotation[annotationsCount];

        for (int k = 0; k < annotationsCount; k++) {
            Annotation ann = new Annotation();
            ann.timeAnnots = timeAnnots.get(k);
            ann.sample = samplesNumbers.get(k);
            ann.duration = 0;
            ann.type = type.get(k);
            ann.nonBeat = nonBeats[k];
            ann.aux = aux.get(k);
            signalAnnots[k] = ann;
        }

        annots[0] = signalAnnots;
        numberOfAnnotsSamples = new int[1];
        numberOfAnnotsSamples[0] = annotationsCount;

        return;
    }

    /**
     * @return Početno vrijeme anotacija u zapisu - ne mora biti jednako 0.
     */
    public double getStartTimeAnnots() {
        return this.annots[0][0].getTimeAnnots();
    }

    /**
     * @return Završno vrijeme anotacija u zapisu.
     */
    public double getFinalTimeAnnots() {
        return this.annots[0][numberOfAnnotsSamples[0]].getTimeAnnots();
    }

    public double [] getAnnotationTimesAsIntervalValues(double startTime, double segmentLength){
        ArrayList<Double> dataAnnots1 = new ArrayList<Double>();

        int i;
        for (i = 0; i<this.numberOfAnnotsSamples[0]; i++){
            if (this.annots[0][i].timeAnnots>=startTime){
                break;
            }
        }
        int start = i;
        for (; i<this.numberOfAnnotsSamples[0]; i++){
            if (this.annots[0][i].timeAnnots>startTime+segmentLength){
                break;
            }
        }
        int end = i-1;


        /*if (this.testing && !this.disregardNonBeats || this.rrOnly){
            for (i=start; i<end; i++){
                dataAnnots.add(timeAnnots.get(i+1)-timeAnnots.get(i));
            }
        }
        else {*/
            boolean temp;
            int j;
            double rez;
            int low, high;
            for (i=start; i<end; i=high){
                j=0;
                temp = annots[0][i].nonBeat;
                while (temp){ // dok je nonbeat
                    j++;
                    if (i+j>end)break;
                    temp = annots[0][i+j].nonBeat;
                }
                if (i+j>end)break;
                low = i+j;
                temp = annots[0][low+1].nonBeat;
                j=0;
                while (temp){ // dok je drugi nonbeat
                    j++;
                    if (low+1+j>end)break;
                    temp = annots[0][low+1+j].nonBeat;
                }
                if (low+1+j>end)break;
                high = low+1+j;
                rez = annots[0][high].timeAnnots-annots[0][low].timeAnnots;
                if (rez >= 1.3 && annots[0][high-1].type=='|'){ // slucaj cudnog QRS artefakta
                    rez = annots[0][high-1].timeAnnots-annots[0][low].timeAnnots;
                    dataAnnots1.add(rez);
                    dataAnnots1.add(annots[0][high].timeAnnots-annots[0][high-1].timeAnnots);
                }
                else {
                    dataAnnots1.add(rez);
                }
            }
            double [] dataAnnots = new double[dataAnnots1.size()];
            i = 0;
        Iterator<Double> it = dataAnnots1.iterator();
            while (it.hasNext()){
                dataAnnots[i]=it.next().doubleValue();
                i++;
            }
        return dataAnnots;
    }

    /** This function would require major changes in the implementation of the class and is specific for HRV PhysioNet annotation file, thus it is still unimplemented
     *
     * @return rhythm or segment beat type,
     * currently supports:
     * - Normal
     * - Decompensated couplet (PAC-PAC, PVC-PAC)
     * - Compensated couplet (PAC-PVC, PVC-PVC)
     * - PVC
     * - PVC and PAC
     * - Fusion
     * - Ventricular_ectopy
     * - PAC
     * - LBBB
     * - RBBB
     *
     * default rhythm priorities:
     * - Ventricular_flutter
     * - Ventricular_tachycardia
     * - Ventricular_bigeminy
     * - Ventricular_trigeminy
     * - 2nd_degree_block
     * - Idioventricular_rhythm
     * - Atrial_flutter
     * - Atrial_fibrillation
     * - Wandering atrial pacemaker
     * - Supraventricular_tachyarrhythmia
     * - Junction_rhythm
     * - Preexcitation_WPW
     * - Atrial_bigeminy
     * - Atrial_trigeminy
     * - Paced_rhythm
     * - Sinus_pause
     * - Sinus_bradycardia
     */
    /**
    public String getRhythmTypeForSegment(double starting, double segmentLength, boolean time){
        int i,j;
        int start = 0;
        int end = 0;
        if (time){
            for (i = 0; i<this.timeAnnots.size(); i++){
                if (this.timeAnnots.get(i).doubleValue()>=starting){
                    break;
                }
            }
            start = i;
            for (; i<this.timeAnnots.size(); i++){
                if (this.timeAnnots.get(i).doubleValue()>starting+segmentLength){
                    break;
                }
            }
            end = i-1;
        }
        else {
            start = (int) starting;
            end = (int)(starting+segmentLength);
        }
        char [] segmAnnots = new char[end-start+1];
        int countRhythms = 0;
        String temp;
        boolean couplet = false;
        boolean [] rhythmsSegment;
        this.faultySegmentBeginning = false;
        this.faultySegmentEnd = false;
        boolean onlyNormalAndStart = false;

        for (i=start; i<=end; i++){
            segmAnnots[i-start] = annots.get(i).charValue();
        }
        if (start!=0){
            for (i=start; i<=end-4; i++){  // priznaju se za ovaj segment samo ritmovi koji pocinju najkasnije 4 anotacije prije kraja zapisa ili ako postoje, onda oni iz prethodnog segmenta
                if (!this.rhythms.get(i).equals("")){ // ako anotacija nije otkucaj nego ritam
                    countRhythms++;
                }
            }
        }
        else {
            if (!this.rhythms.get(0).equals("(N")){
                countRhythms++;
            }
            else {
                onlyNormalAndStart = true;
            }
            for (i=1; i<=end-4; i++){  // priznaju se za ovaj segment samo ritmovi koji pocinju najkasnije 4 anotacije prije kraja zapisa ili ako postoje, onda oni iz prethodnog segmenta
                if (!this.rhythms.get(i).equals("")){ // ako anotacija nije otkucaj nego ritam
                    countRhythms++;
                    if (onlyNormalAndStart){
                        onlyNormalAndStart = false;
                    }
                }
            }
        }
        if (!lastSegmentRhythm.equals("(N") && countRhythms==0){ // ako je prosli segment zavrsio s nenormalnim ritmom i nema novih ritmova u ovom segmentu (stari ritam se nastavlja)
            temp = lastSegmentRhythm;
            for (i=end; i>=end-3; i--){	// provjeri je li do kraja segmenta ima nekih novih ritmova (zapamti zadnji)
                if (!this.rhythms.get(i).equals("")){
                    lastSegmentRhythm = this.rhythms.get(i);
                    break;
                }
            }
            return rhythm.get(temp);
        }
        else if (!lastSegmentRhythm.equals("(N") && countRhythms!=0){ // ako ima novih ritmova u ovom segmentu, a stari ritam je nenormalan
            // ritam iz prethodnog segmenta ce nadjacati sve ritmove u ovom segmentu ako je jaci od njih i traje najmanje do ukljucivo 4. anotacije u ovom segmentu
            temp = lastSegmentRhythm;
            //int indexNewRhythm = 0; // bitno samo za skraćivanje intervala
            boolean disregardOldRhythm = false;
            String temp2;
            for (i=start; i<=start+3; i++){
                temp2 = this.rhythms.get(i);
                if (!temp2.equals("")){
                    disregardOldRhythm = true;
                    break;
                }
            }
            rhythmsSegment = new boolean[rhythmPriorities.size()];
            for (i=0; i<rhythmPriorities.size(); i++){
                rhythmsSegment[i] = false;
            }
            String rhyt;
            int priority;
            if (!disregardOldRhythm){
                if (!temp.equals("(N")){
                    rhyt = InputDataSignals.getAnnotationsRhythms().get(temp);
                    priority = this.rhythmPriorities.get(rhyt);
                    rhythmsSegment[priority] = true;
                }
                // svi ostali ritmovi ne uzimaju se zasad u obzir, ovdje promijeniti i povecati polje ako se trebaju uzeti u obzir
                for (i=start+3; i<=end-4; i++){
                    temp = this.rhythms.get(i);
                    if (!temp.equals("")){
                        if (!temp.equals("(N")){
                            rhyt = InputDataSignals.getAnnotationsRhythms().get(temp);
                            priority = this.rhythmPriorities.get(rhyt);
                            rhythmsSegment[priority] = true;
                        }
                    }
                }
                for (i=0; i<rhythmsSegment.length; i++){
                    if (rhythmsSegment[i]){
                        break;
                    }
                }
                j=i;
                for (i=end; i>=start; i--){ // dohvati zadnji tip ritma u ovom segmentu za sljedeći segment
                    if (!this.rhythms.get(i).equals("")){
                        lastSegmentRhythm = this.rhythms.get(i);
                        break;
                    }
                }
                if (j<rhythmsSegment.length){
                    return prioritiesRhythm[j];
                }
                else return rhythm.get("(N");
            }
            else { // last rhythm segment nebitan zbog prekratkog vremena u ovom segmentu
                //boolean otherNotNormal = false;
                for (i=start; i<=end-4; i++){
                    temp = this.rhythms.get(i);
                    if (!temp.equals("")){
                        rhyt = InputDataSignals.getAnnotationsRhythms().get(temp);
                        if (rhyt.equals("Normal")){
                            this.normalRhythmChangeIndex = i-start;
                        }
                        else {
                            priority = this.rhythmPriorities.get(rhyt);
                            rhythmsSegment[priority] = true;
                        }
                    }
                }
                for (i=0; i<rhythmsSegment.length; i++){
                    if (rhythmsSegment[i]){
                        break;
                    }
                }
                j=i;
                if (j==rhythmsSegment.length){ // situacija kad na pocetku imamo u prvih mozda par beatova poremecaj, pa je to dovoljno da napravi distorziju u normalnom ritmu
                    this.faultySegmentBeginning = true;
                }
                for (i=end; i>=start; i--){ // dohvati zadnji tip ritma u ovom segmentu za sljedeći segment
                    if (!this.rhythms.get(i).equals("")){
                        lastSegmentRhythm = this.rhythms.get(i);
                        break;
                    }
                }
                if (j<rhythmsSegment.length){
                    return prioritiesRhythm[j];
                }
                else {
                    temp = "Normal";
                    int countnonbeats = 0;
                    i = normalRhythmChangeIndex+1;
                    for (; i<segmAnnots.length; i++){
                        if (i<segmAnnots.length-1){
                            if (segmAnnots[i]=='V' && segmAnnots[i+1]=='V'){
                                return "Decompensated_couplet";
                            }
                            else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                                return "Compensated_couplet";
                            }
                            else if (segmAnnots[i]=='V' && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                                return "Compensated_couplet";
                            }
                            else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && segmAnnots[i]=='V'){
                                return "Decompensated_couplet";
                            }
                        }
                        if (segmAnnots[i]=='V'){
                            //return "PVC";
                            temp = "PVC";
                        }
                        else if (segmAnnots[i]=='F'){
                            if (!temp.equals("PVC")){
                                temp = "Fusion";
                            }
                        }
                        else if (segmAnnots[i]=='E'){
                            if (!temp.equals("Fusion")){
                                temp = "Ventricular_ectopy";
                            }
                        }
                        else if (segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a'){
                            if (temp.equals("PVC")){
                                return "PVC_and_PAC";
                            }
                            if (!temp.equals("Fusion")&&!temp.equals("Ventricular_ectopy")) {
                                temp = "PAC";
                            }
                        }
                        else if (segmAnnots[i]=='L'){
                            if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy")) {
                                temp = "LBBB";
                            }
                        }
                        else if (segmAnnots[i]=='R'){
                            if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy")&&!temp.equals("LBBB")) {
                                temp = "RBBB";
                            }
                        }
                        else if (segmAnnots[i]=='+'){ // u zadnja 4 beata ako ima promjene ritma
                            lastSegmentRhythm = this.rhythms.get(start+i);
                            if (temp.equals("Normal")){ // slucaj kad na kraju (u zadnja 4 perioda) dodje poremećaj koji poremeti RRintervale u ovom segmentu
                                this.faultySegmentEnd = true;
                                this.normalRhythmChangeIndex = i-countnonbeats;
                                break;
                            }
                        }
                        else if (this.disregardNonBeats){
                            if (nonBeats[start+i]){
                                countnonbeats++;
                            }
                        }
                    }
                    return temp;
                }
            }
        }
        else if (lastSegmentRhythm.equals("(N") && countRhythms!=0){ // ako ima novih ritmova u ovom segmentu, drugi uvjet vrijedi samo da se eliminira prvi segment s normalnim ritmom
            rhythmsSegment = new boolean[rhythmPriorities.size()];
            String rhyt;
            int priority;

            for (i=0; i<rhythmsSegment.length; i++){
                rhythmsSegment[i] = false;
            }
            for (i=start; i<=end-4; i++){
                temp = this.rhythms.get(i);
                if (!temp.equals("")){
                    if (!temp.equals("(N")){
                        rhyt = InputDataSignals.getAnnotationsRhythms().get(temp);
                        priority = this.rhythmPriorities.get(rhyt);
                        rhythmsSegment[priority] = true;
                    }
                }
            }
            for (i=0; i<rhythmsSegment.length; i++){
                if (rhythmsSegment[i]){
                    break;
                }
            }
            j=i;
            for (i=end; i>=start; i--){ // dohvati zadnji tip ritma u ovom segmentu za sljedeći segment
                if (!this.rhythms.get(i).equals("")){
                    lastSegmentRhythm = this.rhythms.get(i);
                    break;
                }
            }
            if (j<rhythmsSegment.length){
                return prioritiesRhythm[j];
            }
            else {
                temp = "Normal";
                int countnonbeats = 0;
                i = 0;
                for (; i<segmAnnots.length; i++){
                    if (i<segmAnnots.length-1){
                        if (segmAnnots[i]=='V' && segmAnnots[i+1]=='V'){
                            return "Decompensated_couplet";
                        }
                        else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                            return "Compensated_couplet";
                        }
                        else if (segmAnnots[i]=='V' && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                            return "Compensated_couplet";
                        }
                        else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && segmAnnots[i]=='V'){
                            return "Decompensated_couplet";
                        }
                    }
                    if (segmAnnots[i]=='V'){
                        //return "PVC";
                        temp = "PVC";
                    }
                    else if (segmAnnots[i]=='F'){
                        if (!temp.equals("PVC")){
                            temp = "Fusion";
                        }
                    }
                    else if (segmAnnots[i]=='E'){
                        if (!temp.equals("Fusion")){
                            temp = "Ventricular_ectopy";
                        }
                    }
                    else if (segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a'){
                        if (temp.equals("PVC")){
                            return "PVC_and_PAC";
                        }
                        if (!temp.equals("Fusion")&&!temp.equals("Ventricular_ectopy")) {
                            temp = "PAC";
                        }
                    }
                    else if (segmAnnots[i]=='L'){
                        if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy")) {
                            temp = "LBBB";
                        }
                    }
                    else if (segmAnnots[i]=='R'){
                        if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy")&&!temp.equals("LBBB")) {
                            temp = "RBBB";
                        }
                    }
                    else if (this.disregardNonBeats){
                        if (nonBeats[start+i]){
                            countnonbeats++;
                        }
                    }
                }
                return temp;
            }
        }
        else { // nema globalnog ritma u ovom segmentu, normalan ritam u proslom segmentu, potrebno je rucno parsiranje znak po znak u potrazi za kupletom, PAC_PVC kupletom, PVC, Fusion, PAC, LBBB, RBBB, Normal ritmovima (tim redoslijedom)
            temp = "Normal";
            couplet = false;
            int countnonbeats = 0;
            if (onlyNormalAndStart) {
                i=1;
            }
            else {
                i=0;
            }
            for (; i<segmAnnots.length; i++){
                if (i<segmAnnots.length-1){
                    if (segmAnnots[i]=='V' && segmAnnots[i+1]=='V'){
                        temp = "Decompensated_couplet";
                        couplet = true;
                    }
                    else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                        if (!temp.equals("Decompensated_couplet")){
                            temp = "Compensated_couplet";
                            couplet = true;
                        }
                    }
                    else if (segmAnnots[i]=='V' && (segmAnnots[i+1]=='A' || segmAnnots[i+1]=='S' || segmAnnots[i+1]=='a')){
                        temp = "Compensated_couplet";
                        couplet = true;
                    }
                    else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && segmAnnots[i]=='V'){
                        if (!temp.equals("Decompensated_couplet")){
                            temp = "Decompensated_couplet";
                            couplet = true;
                        }
                    }
                }
                if (segmAnnots[i]=='V' && !couplet){
                    //return "PVC";
                    if (!temp.equals("PVC_and_PAC")){
                        temp = "PVC";
                    }
                }
                else if (segmAnnots[i]=='F' && !couplet){
                    if (!temp.equals("PVC") && !temp.equals("PVC_and_PAC")){
                        temp = "Fusion";
                    }
                }
                else if (segmAnnots[i]=='E' && !couplet){
                    if (!temp.equals("Fusion") && !temp.equals("PVC_and_PAC")){
                        temp = "Ventricular_ectopy";
                    }
                }
                else if ((segmAnnots[i]=='A' || segmAnnots[i]=='S' || segmAnnots[i]=='a') && !couplet){
                    if (temp.equals("PVC")){
                        temp = "PVC_and_PAC";
                    }
                    if (!temp.equals("Fusion")&& !temp.equals("Ventricular_ectopy") && !temp.equals("PVC_and_PAC")) {
                        temp = "PAC";
                    }
                }
                else if (segmAnnots[i]=='L' && !couplet){
                    if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy") && !temp.equals("PVC_and_PAC")) {
                        temp = "LBBB";
                    }
                }
                else if (segmAnnots[i]=='R' && !couplet){
                    if (!temp.equals("Fusion")&&!temp.equals("PAC")&&!temp.equals("Ventricular_ectopy")&&!temp.equals("LBBB") && !temp.equals("PVC_and_PAC")) {
                        temp = "RBBB";
                    }
                }
                else if (segmAnnots[i]=='+'){ // u zadnja 4 beata ako ima promjene ritma
                    lastSegmentRhythm = this.rhythms.get(start+i);
                    if (temp.equals("Normal")){ // slucaj kad na kraju (u zadnja 4 perioda) dodje poremećaj koji poremeti RRintervale u ovom segmentu
                        this.faultySegmentEnd = true;
                        this.normalRhythmChangeIndex = i-countnonbeats;
                        break;
                    }
                }
                else if (this.disregardNonBeats){
                    if (nonBeats[start+i]){
                        countnonbeats++;
                    }
                }
                // svi ostali otkucaji i nonbeatovi koji nisu ovdje navedeni smatraju se normalnima ili nebitnima
            }
            return temp;
        }
    }
     */

    @Override
    public double calculateFrequency(int signalIndex) {
        return frequency;
    }

}