/**
 *
 */
package multisab.processing.dataHandling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Davor
 */

public class CsvFile extends InputData {

    private int frequency;
    private double times[];
    private int csvType = 0;

    public CsvFile(File selectedFile, boolean loadHeaderOnly) throws Exception { //Exception {

        super(selectedFile);

        BufferedReader in = null;

        if (recordType.equals("CSV")) {
            if (!loadHeaderOnly) {
                try {
                    in = new BufferedReader(new FileReader(selectedFile));

                    loadCsvHeaderData(in);
                    if (csvType == 0) {
                        loadCsvData(in);
                    }
                    if (csvType == 1) {
                        loadCsvData2(in);
                    }
                } finally {
                    if (in != null) {
                        in.close();
                    }
                }
                findMinAndMaxSampleAllSignals();
            }
            else {
                try {
                    in = new BufferedReader(new FileReader(selectedFile));

                    loadCsvHeaderData(in);

                } finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }


    private void loadCsvHeaderData(BufferedReader in) throws Exception {

        metadata = new Metadata();

        metadata.setVersionOfDataFormat("TXT");
        metadata.setLocalPatientIdentification("X");
        metadata.setLocalRecordingIdentification("X");
        metadata.setRecordingStartDate("Startdata X X X X");
        metadata.setRecordingStartTime("X");
        metadata.setHeaderLengthInBytes(1);
        metadata.setReserved("");
        metadata.setDataRecordsNum(1);
        metadata.setDataRecordDurationInSec(1);

        numberOfAnnotations = 0;
        numberOfAnnotsSamples = new int[numberOfAnnotations];
        annots = new Annotation[numberOfAnnotations][];


        try {
            /**
             * List of signal' labels
             */
            List<String> labels;
            /**
             * List of signals' physical dimensions
             */
            List<String> physicalDimensions;

            labels = new ArrayList<String>();
            physicalDimensions = new ArrayList<String>();

            String line;
            String firstPart;
            String secondPart;

            line = in.readLine();
            line = line.trim();

            //if (line.equals("")) ;
            //else if (line.contains("time")) ;

            if (line.substring(0, 0).equals("'")) {

                csvType = 0;

                firstPart = line.substring(0, line.indexOf(","));
                secondPart = line.substring(line.indexOf(",") + 1);

                while (secondPart.contains(",")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf(","));
                    secondPart = secondPart.substring(secondPart.indexOf(",") + 1);

                    numberOfSignals++;
                    firstPart = firstPart.trim();
                    firstPart = firstPart.substring(1);
                    firstPart = firstPart.substring(0, firstPart.indexOf("'"));
                    labels.add(firstPart);
                }

                secondPart = secondPart.trim();
                secondPart = secondPart.substring(1);
                secondPart = secondPart.substring(0, secondPart.indexOf("'"));
                if (!(secondPart.equals(""))) {
                    numberOfSignals++;
                    labels.add(secondPart);
                }

                line = in.readLine();
                line = line.trim();

                firstPart = line.substring(0, line.indexOf(","));
                secondPart = line.substring(line.indexOf(",") + 1);

                while (secondPart.contains(",")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf(","));
                    secondPart = secondPart.substring(secondPart.indexOf(",") + 1);

                    firstPart = firstPart.trim();
                    firstPart = firstPart.substring(1);
                    firstPart = firstPart.substring(0, firstPart.indexOf("'"));
                    physicalDimensions.add(firstPart);
                }

                secondPart = secondPart.trim();
                secondPart = secondPart.substring(1);
                secondPart = secondPart.substring(0, secondPart.indexOf("'"));
                if (!(secondPart.equals(""))) {
                    physicalDimensions.add(secondPart);
                }

            }

            else {

                csvType = 1;

                firstPart = line.substring(0, line.indexOf("\t"));
                secondPart = line.substring(line.indexOf("\t") + 1);

                while (secondPart.contains("\t")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf("\t"));
                    secondPart = secondPart.substring(secondPart.indexOf("\t") + 1);

                    numberOfSignals++;
                    firstPart = firstPart.trim();
                    labels.add(firstPart);
                }

                secondPart = secondPart.trim();
                if (!(secondPart.equals(""))) {
                    numberOfSignals++;
                    labels.add(secondPart);
                }

                line = in.readLine();
                line = line.trim();

                firstPart = line.substring(0, line.indexOf("\t"));
                secondPart = line.substring(line.indexOf("\t") + 1);

                while (secondPart.contains("\t")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf("\t"));
                    secondPart = secondPart.substring(secondPart.indexOf("\t") + 1);

                    firstPart = firstPart.trim();
                    firstPart = firstPart.substring(1, firstPart.indexOf(")"));
                    physicalDimensions.add(firstPart);
                }

                secondPart = secondPart.trim();
                secondPart = secondPart.substring(1, secondPart.indexOf(")"));
                if (!(secondPart.equals(""))) {
                    physicalDimensions.add(secondPart);
                }

            }

            SignalParameterData[] signalsParameterData = new SignalParameterData[numberOfSignals];

            for (int i = 0; i < numberOfSignals; i++) {

                SignalParameterData signal = new SignalParameterData();

                signal.setLabel(labels.get(i));
                signal.setTransducerType("");
                signal.setPhysicalDimension(physicalDimensions.get(i));
                signal.setPhysicalMin(0);
                signal.setPhysicalMax(1);
                signal.setDigitalMin(-32768);
                signal.setDigitalMax(32767);
                signal.setPrefiltering("");
                signal.setSamplesInDataRecordNum(1);
                signal.setReserved("");
                signal.setPhysicalSampleMax(1);
                signal.setPhysicalSampleMin(0);
                signal.setType(0);

                signalsParameterData[i] = signal;
            }

            metadata.setSignalParameters(signalsParameterData);

        } catch (IOException exe) {
            if (numberOfSignals == 0) {
                throw new Exception("File is empty.");
            }
        }

        metadata.setSignalsNum(numberOfSignals);

    }

    private void loadCsvData(BufferedReader in) throws Exception {

        /**
         * Times of annotations, in seconds from the start of the record
         */
        List<Double> timeSamples;
        /**
         * Times of annotations
         */
        //List<String> timeSamplesExact;
        /**
         * List of annotations
         */
        List<Double> values;

        timeSamples = new ArrayList<Double>();
        //timeSamplesExact = new ArrayList<String>();
        values = new ArrayList<Double>();

        try {
            String line;
            String firstPart;
            String secondPart;

            while ((line = in.readLine()) != null) {
                line = line.trim();
                if (line.equals("")) continue;

                firstPart = line.substring(0, line.indexOf(","));
                secondPart = line.substring(line.indexOf(",") + 1);

                firstPart = firstPart.substring(1);
                firstPart = firstPart.substring(0, firstPart.indexOf("'"));
                timeSamples.add(Double.valueOf(InputData.timeStringToSeconds(firstPart))); // dodaj vrijeme anotacije u listu vremena anotacija
                //timeSamplesExact.add(firstPart);

                while (secondPart.contains(",")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf(","));
                    secondPart = secondPart.substring(secondPart.indexOf(",") + 1);

                    values.add(Double.valueOf(firstPart));
                }

                if (!(secondPart.equals(""))) {
                    values.add(Double.valueOf(secondPart));
                }
            }
        } catch (NumberFormatException e) {
            //System.out.println("File contains some illegal data (like more than 59 minutes of recording).");
            //e.printStackTrace();
            throw new Exception("File contains some illegal data (like more than 59 minutes of recording).");
        }

        // TODO: pitati Alana
        double start = timeSamples.get(0).doubleValue();
        for (int i = 0; i < timeSamples.size(); i++) {
            timeSamples.set(i, timeSamples.get(i).doubleValue() - start);
        }

        numberOfSamples = new int[numberOfSignals];
        signals = new double[numberOfSignals][];

        for (int i = 0; i < numberOfSignals; i++) {

            double[] signal = new double[timeSamples.size()];

            for (int k = 0; k < timeSamples.size(); k++) {
                signal[k] = values.get(i + numberOfSignals * k);
            }

            signals[i] = signal;
            numberOfSamples[i] = timeSamples.size();
            metadata.getSignalParameters()[i].setSamplesInDataRecordNum(timeSamples.size());
        }

        duration = timeSamples.get(timeSamples.size() - 1).doubleValue();
        metadata.setDataRecordDurationInSec(duration);

        times = new double[timeSamples.size()];

        for (int k = 0; k < timeSamples.size(); k++) {
            times[k] = timeSamples.get(k);
        }

        frequency = (int) Math.round((timeSamples.size() - 1) / (timeSamples.get(timeSamples.size() - 1)));

        return;
    }

    private void loadCsvData2(BufferedReader in) throws Exception {

        /**
         * Times of annotations, in seconds from the start of the record
         */
        List<Double> timeSamples;
        /**
         * Times of annotations
         */
        //List<String> timeSamplesExact;
        /**
         * List of annotations
         */
        List<Double> values;

        timeSamples = new ArrayList<Double>();
        //timeSamplesExact = new ArrayList<String>();
        values = new ArrayList<Double>();

        try {
            String line;
            String firstPart;
            String secondPart;

            while ((line = in.readLine()) != null) {
                line = line.trim();
                if (line.equals("")) continue;

                firstPart = line.substring(0, line.indexOf("\t"));
                secondPart = line.substring(line.indexOf("\t") + 1);
                secondPart = secondPart.trim();

                timeSamples.add(Double.valueOf(InputData.timeStringToSeconds(firstPart))); // dodaj vrijeme anotacije u listu vremena anotacija
                //timeSamplesExact.add(firstPart);

                while (secondPart.contains("\t")) {
                    firstPart = secondPart.substring(0, secondPart.indexOf("\t"));
                    secondPart = secondPart.substring(secondPart.indexOf("\t") + 1);
                    secondPart = secondPart.trim();

                    values.add(Double.valueOf(firstPart));
                }

                if (!(secondPart.equals(""))) {
                    values.add(Double.valueOf(secondPart));
                }
            }
        } catch (NumberFormatException e) {
            //System.out.println("File contains some illegal data (like more than 59 minutes of recording).");
            //e.printStackTrace();
            throw new Exception("File contains some illegal data (like more than 59 minutes of recording).");
        }

        // TODO: pitati Alana
        double start = timeSamples.get(0).doubleValue();
        for (int i = 0; i < timeSamples.size(); i++) {
            timeSamples.set(i, timeSamples.get(i).doubleValue() - start);
        }

        numberOfSamples = new int[numberOfSignals];
        signals = new double[numberOfSignals][];

        for (int i = 0; i < numberOfSignals; i++) {

            double[] signal = new double[timeSamples.size()];

            for (int k = 0; k < timeSamples.size(); k++) {
                signal[k] = values.get(i + numberOfSignals * k);
            }

            signals[i] = signal;
            numberOfSamples[i] = timeSamples.size();
            metadata.getSignalParameters()[i].setSamplesInDataRecordNum(timeSamples.size());
        }

        duration = timeSamples.get(timeSamples.size() - 1).doubleValue();
        metadata.setDataRecordDurationInSec(duration);

        times = new double[timeSamples.size()];

        for (int k = 0; k < timeSamples.size(); k++) {
            times[k] = timeSamples.get(k);
        }

        frequency = (int) Math.round((timeSamples.size() - 1) / (timeSamples.get(timeSamples.size() - 1)));

        return;
    }

    @Override
    public double calculateFrequency(int signalIndex) {
        return frequency;
    }
}
