package multisab.processing.machineLearning;

import multisab.processing.multisabException.ModelingException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfusionMatrix {

    private int [][] classifications;
    private String [] classNames;

    public ConfusionMatrix(String [] actualClasses, String [] predictedClasses, String [] allClasses) throws ModelingException {
        if (actualClasses.length != predictedClasses.length){
            throw new ModelingException("The number of predictions does not match the number of actual classes");
        }

        classNames = new String[allClasses.length];
        classifications = new int[allClasses.length][allClasses.length];

        for (int i = 0; i < allClasses.length; i++){
            classNames[i] = allClasses[i];
        }

        for (int i = 0; i<classNames.length; i++){  // rows, actual classes
            for (int j = 0; j<classNames.length; j++) {  // columns, predicted classes
                classifications[i][j] = 0;
                for (int k = 0; k < actualClasses.length; k++) {
                    if (actualClasses[k].equals(classNames[i]) && predictedClasses[k].equals(classNames[j])) {
                        classifications[i][j]++;
                    }
                }
            }
        }
    }
    public int[][] getClassifications(){
        return this.classifications;
    }
    public String[] getClassNames(){
        return this.classNames;
    }
}
