package multisab.processing.machineLearning.normalization;

import org.encog.mathutil.Equilateral;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Davor on 10.10.2016..
 */
public class EquilateralCoder extends Coder {

    private Equilateral eq;
    private Map<Integer, Integer> mapClasses = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> inverseMapClasses = new HashMap<Integer, Integer>();

    public EquilateralCoder(double outputNormalizationMin, double outputNormalizationMax, int numberOfClasses) {
        super(outputNormalizationMin, outputNormalizationMax, numberOfClasses);
    }

    @Override
    public double[][] encode(int[] classes){

        int numberOfSamples = classes.length;

        numberOfClasses = 0;
        mapClasses.put(numberOfClasses, classes[0]);
        inverseMapClasses.put(classes[0], numberOfClasses);
        numberOfClasses++;

        for(int j = 1; j < numberOfSamples; j++) {
            if (!mapClasses.containsValue(classes[j])) {
                mapClasses.put(numberOfClasses, classes[j]);
                inverseMapClasses.put(classes[j], numberOfClasses);
                numberOfClasses++;
            }
        }

        double[][] ideal = new double[numberOfSamples][numberOfClasses-1];

        double encode[];
        eq = new Equilateral(numberOfClasses, outputNormalizationMin, outputNormalizationMax);

        for(int j = 0; j < numberOfSamples; j++)  {
            int intClass = inverseMapClasses.get(classes[j]);
            encode = eq.encode(intClass);
            for(int i = 0; i < (numberOfClasses - 1); i++) {
                ideal[j][i] = encode[i];
            }
        }

        return ideal;
    }

    @Override
    public int decode(double[] clasifierOutput){

        return mapClasses.get(eq.decode(clasifierOutput));
    }
}
