package multisab.processing.machineLearning.normalization;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Davor on 10.10.2016..
 */
public class IntOneOfNCoder extends Coder {

    Map<Double, Integer> mapClasses = new HashMap<Double, Integer>();
    Map<Integer, Double> inverseMapClasses = new HashMap<Integer, Double>();

    public IntOneOfNCoder(double outputNormalizationMin, double outputNormalizationMax, int numberOfClasses) {
        super(outputNormalizationMin, outputNormalizationMax, numberOfClasses);
    }

    @Override
    public double[][] encode(int[] classes){

        int numberOfSamples = classes.length;

        numberOfClasses = 0;
        mapClasses.put((double)numberOfClasses, classes[0]);
        inverseMapClasses.put(classes[0], (double)numberOfClasses);
        numberOfClasses++;

        for(int j = 1; j < numberOfSamples; j++) {
            if (!mapClasses.containsValue(classes[j])) {
                mapClasses.put((double)numberOfClasses, classes[j]);
                inverseMapClasses.put(classes[j], (double)numberOfClasses);
                numberOfClasses++;
            }
        }

        double ideal[][] = new double[numberOfSamples][1];

        for(int j = 0; j < numberOfSamples; j++)  {
            double doubleClass = inverseMapClasses.get(classes[j]);
            ideal[j][0] = doubleClass;
        }

        return ideal;
    }

    @Override
    public int decode(double[] clasifierOutput){

        int numberOfClasses = clasifierOutput.length;

        int index = 0;
        double max = clasifierOutput[0];

        for(int i = 1; i < numberOfClasses; i++) {
            if(clasifierOutput[i] > max) {
                index = i;
                max = clasifierOutput[i];
            }
        }

        return mapClasses.get((double)index);
    }
}