package multisab.processing.preprocessing.otherFunctions;

/**
 * Class FindLocalExtremes contains method to find local extremes(minimus and maximums) in array of doubles.
 * Methods returns double array with zeros on points where extreme is not found and extreme amplitude on points where
 * extreme is found.
 * Point is consider local maximum if previous and next point have smaller amplitude. Analog is for minimum.
 *
 * Methods findMaximum/MinimumWithMinPeakDistance finds greatest extremes so that they are minimaly separated by
 * minPeakDistance points.
 *
 *
 * @author: Krešimir Friganović
 * @date 17.11.2016.
 */
public class FindLocalExtremes {
    public static double[] findMaximum (double[] x,int beginning,int ending){
        /*Finds maximum in array from beginning to ending
         @output: xy[0] - amplitude of maximum
         @output: xy[1] - location of maximum
         */
        double [] xy = new double[2];
        xy[0] = x[beginning];
        xy[1] = beginning;
            for (int i = beginning; i < ending; i++) {
                if (Math.abs(x[i]) > xy[0]) {
                    xy[0] = x[i];
                    xy[1] = i;
                }
            }

            return xy;
        }
    public static double[] findMinimum (double[] x,int beginning,int ending){
        /*Finds minimum in array from beginning to ending
         @output: xy[0] - amplitude of maximum
         @output: xy[1] - location of maximum
         */
        double [] xy = new double[2];
        xy[0] = x[beginning];
        xy[1] = beginning;
        for (int i = beginning; i < ending; i++) {
            if (Math.abs(x[i]) < xy[0]) {
                xy[0] = x[i];
                xy[1] = i;
            }
        }

        return xy;
    }

    public static double[] findLocalMaximums(double[] x) {

        int n = x.length;
        double[] maximum = new double[n];


        for (int i = 1; i < n - 1; i++) {
            if ((x[i - 1] < x[i]) && (x[i + 1] < x[i])) {
                maximum[i] = x[i];
            } else {
                maximum[i] = 0.0;
            }
        }
        return maximum;
    }
    public static double[] findLocalMinimums(double[] x) {

        int n = x.length;
        double[] minimum = new double[n];


        for (int i = 1; i < n - 1; i++) {
            if ((x[i - 1] > x[i]) && (x[i + 1] > x[i])) {
                minimum[i] = x[i];
            } else {
                minimum[i] = 0.0;
            }
        }
        return minimum;
    }

    public static double[] findMaximumWithMinPeakDistance(double[] x, int minPeakDistance) {

        int n = x.length;
        double[] maximumMinPeakDistance = new double[n];
        int tempLoc = 0;
        double max = 0;

        for (int i = 1; i < n - minPeakDistance; i++) {
            if ((Math.abs(x[i - 1]) <= Math.abs(x[i])) && (Math.abs(x[i + 1]) <= Math.abs(x[i]))) {

                for (int j = i + 1; j < i + minPeakDistance; j++) {
                    if ((Math.abs(x[j - 1]) <= Math.abs(x[j])) && (Math.abs(x[j + 1]) <= Math.abs(x[j])))
                        if (Math.abs(x[j]) > Math.abs(x[i])) {
                            tempLoc = j;
                            i = j;

                        }
                    tempLoc = i;
                }
                maximumMinPeakDistance[tempLoc] = x[tempLoc];
                i = tempLoc + minPeakDistance;
            }
        }
        return maximumMinPeakDistance;
    }
    public static double[] findMinimumWithMinPeakDistance(double[] x, int minPeakDistance) {

        int n = x.length;
        double[] minimumMinPeakDistance = new double[n];
        int tempLoc = 0;
        double max = 0;

        for (int i = 1; i < n - minPeakDistance; i++) {
            if ((Math.abs(x[i - 1]) <= Math.abs(x[i])) && (Math.abs(x[i + 1]) <= Math.abs(x[i]))) {

                for (int j = i + 1; j < i + minPeakDistance; j++) {
                    if ((Math.abs(x[j - 1]) >= Math.abs(x[j])) && (Math.abs(x[j + 1]) >= Math.abs(x[j])))
                        if (Math.abs(x[j]) < Math.abs(x[i])) {
                            tempLoc = j;
                            i = j;

                        }
                    tempLoc = i;
                }
                minimumMinPeakDistance[tempLoc] = x[tempLoc];
                i = tempLoc + minPeakDistance;
            }
        }
        return minimumMinPeakDistance;
    }

}


