package multisab.processing.reporting;

import multisab.processing.machineLearning.Classifier;
import multisab.processing.machineLearning.featureSelection.FeatureSelectionMethods;
import multisab.processing.multisabException.ReportException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.swing.JRViewer;
import org.encog.Encog;
import org.encog.util.csv.ReadCSV;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import java.awt.*;
import java.io.*;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import static org.encog.util.csv.CSVFormat.DECIMAL_POINT;


public class ReportingMain {
    boolean featureSelectionComparison;
    boolean machineLearningComparison;

    DefaultTableModel tableModel;

    public static void main(String[] args) {
        ReportingMain prg = new ReportingMain();
//        prg.printToConsole();
        prg.printToJasper();
    }
    public static String getReportAsStringFromFile(String filepath) throws ReportException{
        StringBuilder sb = new StringBuilder();
        String temp = "";
        if (filepath != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filepath));
                temp = br.readLine();
                while (temp != null){
                    sb.append(temp);
                    temp = br.readLine();
                }
                br.close();
                return sb.toString();
            } catch (IOException exc) {
                throw new ReportException("Report results can not be read");
            }
        }
        else return null;
    }

    public void printToJasper() {
        //String jrxmlFileName = "C:/Users/Davor/IdeaProjects/processing/C1_report.jrxml";
        //String jasperFileName = "C:/Users/Davor/IdeaProjects/processing/C1_report.jasper";
        //String pdfFileName = "C:/Users/Davor/IdeaProjects/processing/C1_report.pdf";

        //JasperCompileManager.compileReportToFile(jrxmlFileName, jasperFileName);


        // Compile jrxml file.
        //JasperReport jasperReport = JasperCompileManager.compileReport("C:/Users/Davor/IdeaProjects/processing/report1.jrxml");

        // Parameters for report
        //Map<String, Object> parameters = new HashMap<String, Object>();

        //JRDataSource dataSource = new JRTableModelDataSource(tableModel);

        //jasperPrint = JasperFillManager.fillReport("C:/Users/Davor/IdeaProjects/processing/report1.jasper", parameters, dataSource);

        // Make sure the output directory exists.
        //File outDir = new File("C:/Users/Davor/IdeaProjects/processing/jasperoutput");
        //outDir.mkdirs();

        // Export to PDF.
        //JasperExportManager.exportReportToPdfFile(jasperPrint,"C:/Users/Davor/IdeaProjects/processing/jasperoutput/StyledTextReport.pdf");

        Map<String, Object> parameters = new HashMap<>();
        parameters.put("NASLOV", "Testni izvještaj");


        LinkedList<TestRecord> testRecords = new LinkedList<>();
        testRecords.add(new TestRecord("111", "G Conger", "Orthopaedic", "jim@wheremail.com"));
        testRecords.add(new TestRecord("222", "A Date", "ENT", "adate@somemail.com"));
        testRecords.add(new TestRecord("333", "R Linz", "Paedriatics", "rlinz@heremail.com"));
        testRecords.add(new TestRecord("444", "V Sethi", "Nephrology", "vsethi@whomail.com"));
        testRecords.add(new TestRecord("555", "K Rao", "Orthopaedics", "krao@whatmail.com"));
        testRecords.add(new TestRecord("666", "V Santana", "Nephrology", "vsan@whenmail.com"));
        testRecords.add(new TestRecord("777", "J Pollock", "Nephrology", "jpol@domail.com"));
        testRecords.add(new TestRecord("888", "H David", "Nephrology", "hdavid@donemail.com"));
        testRecords.add(new TestRecord("999", "P Patel", "Nephrology", "ppatel@gomail.com"));
        testRecords.add(new TestRecord("101", "C Comer", "Nephrology", "ccomer@whymail.com"));

        String jasperFileName = "reporting_test/report1.jasper";

        try {
            JasperPrint jasperPrint = JasperFillManager.fillReport(jasperFileName, parameters, new TestDataSource(testRecords));

            JRViewer jrviewer = new JRViewer(jasperPrint);
            JFrame aFrame = new JFrame("Izvještaj");
            aFrame.getContentPane().add(jrviewer);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            aFrame.setSize(screenSize.width, screenSize.height);
            aFrame.setLocation(0, 0);
            aFrame.setVisible(true);

            // Export to PDF.
            JasperExportManager.exportReportToPdfFile(jasperPrint,"reporting_test/report1.pdf");

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void printToConsole() {
        try {
            // Parametri za datoteku "outputHRV_MIT_large_30s_A.csv"

            int numberOfInstances = 48;
            int numberOfFeatures = 29;

            String featuresNames[] = {
                    "Attractor_dimension",
                    "Factor_m_approximate_entropy",
                    "Factor_m_sample_entropy",
                    "Spatial_filling_index_lag_2",
                    "Standard_deviation_ratio",
                    "Approximate_entropy_0_1",
                    "Approximate_entropy_0_15",
                    "Approximate_entropy_0_2",
                    "Approximate_entropy_0_25",
                    "Sample_entropy_0_1",
                    "Sample_entropy_0_15",
                    "Sample_entropy_0_2",
                    "Sample_entropy_0_25",
                    "Corrected_conditional_Shannon_entropy",
                    "Low_frequency_PSD",
                    "High_frequency_PSD",
                    "Low_high_frequency_PSD_ratio",
                    "Largest_Lyapunov_exponent",
                    "Mean",
                    "SDNN",
                    "SDSD",
                    "RMSSD",
                    "pNN50",
                    "HRV_triangular_index",
                    "TINN",
                    "Fano_factor",
                    "Allan_factor",
                    "Recurrence_REC_lag_2",
                    "Recurrence_LMean_lag_2",
                    "Recurrence_DET_lag_2",
                    "Recurrence_ShEn_lag_2",
                    "Recurrence_Lam_lag_2"
            };


            double in[][] = new double[numberOfInstances][numberOfFeatures];
            String out[] = new String[numberOfInstances];
            int outInt[] = new int[numberOfInstances];
            int predictedInt[] = new int[numberOfInstances];


            // Učitavanje podataka

            String pathname = "reporting_test/outputHRV_MIT_large_30s_A.csv";
            File sourceFile = new File(pathname);
            ReadCSV csv = new ReadCSV(sourceFile, false, DECIMAL_POINT);

            String[] line = new String[numberOfFeatures];

            int i = 0;

            while (csv.next()) {
                for (int j = 0; j < numberOfFeatures; j++) {
                    in[i][j] = Double.parseDouble(csv.get(j));
                }
                out[i] = csv.get(numberOfFeatures);
                i++;
            }

            csv.close();


            HashMap<String, Integer> map = new HashMap<>();

            String key;
            Integer value;

            key = out[0];
            value = 0;

            map.put(key, value);

            for (int j = 0; j < numberOfInstances; j++) {
                key = out[j];
                if (map.containsKey(key)) {
                    outInt[j] = map.get(key);
                } else {
                    value = value + 1;
                    map.put(key, value);
                    outInt[j] = map.get(key);
                }
            }

            int numberOfClasses = map.size();


            // Ručni odabir značajki

            //int features[] = {0,1,4,6,8,13,17,18,20,23,24,25,26,27,28};
            int features[] = {0, 1, 4, 6, 13, 18, 20, 23, 25, 27, 28};
            int numberOfSelectedFeatures = features.length;
            String selectedFeaturesNames[] = new String[numberOfSelectedFeatures];

            double inSelected[][] = new double[numberOfInstances][numberOfSelectedFeatures];

            for (int fea = 0; fea < numberOfSelectedFeatures; fea++) {
                selectedFeaturesNames[fea] = featuresNames[features[fea]];
                for (int inst = 0; inst < numberOfInstances; inst++) {
                    inSelected[inst][fea] = in[inst][features[fea]];
                }
            }

            numberOfFeatures = numberOfSelectedFeatures;
            in = inSelected;

            // Postupci selekcije značajki

            double[] RF = new double[numberOfFeatures];
            RF = FeatureSelectionMethods.ReliefF(in, outInt);

            double[] SU = new double[numberOfFeatures];
            SU = FeatureSelectionMethods.symmetricalUncertainty(in, outInt);

            double[] chi2 = new double[numberOfFeatures];
            chi2 = FeatureSelectionMethods.chiSquareScore(in, outInt);

            String featureSelection;
            featureSelection = String.format("%40s %8s %8s %8s", "Feature selection", "RF", "SU", "chi2");
            System.out.println(featureSelection);
            for (int k = 0; k < numberOfSelectedFeatures; k++) {
                featureSelection = String.format("%40s %8.4f %8.4f %8.2f", selectedFeaturesNames[k], RF[k], SU[k], chi2[k]);
                System.out.println(featureSelection);
            }

            System.out.println();


            // Postavljanje parametara kros-validacije

            int[] CV = new int[numberOfInstances];
            int k = 2;

            for (int j = 0; j < numberOfInstances; j++) {
                CV[j] = j % 2;
            }

            int[][] confusionMatrix = new int[numberOfClasses][numberOfClasses];
            for (int c = 0; c < numberOfClasses; c++) {
                for (int l = 0; l < numberOfClasses; l++) {
                    confusionMatrix[c][l] = 0;
                }
            }


            for (int fold = 0; fold < k; fold++) {

                int numberOfTrainingInstances = 0;
                for (int instance = 0; instance < numberOfInstances; instance++) {
                    if (CV[instance] != fold) {
                        numberOfTrainingInstances++;
                    }
                }

                double in_train[][] = new double[numberOfTrainingInstances][numberOfFeatures];
                //String out_train[] = new String[numberOfTrainingInstances]; // Za CV klase moraju biti int jer se inače preslikavanje u svakom preklopu nije isto
                int out_train[] = new int[numberOfTrainingInstances];

                numberOfTrainingInstances = 0;
                for (int instance = 0; instance < numberOfInstances; instance++) {
                    if (CV[instance] != fold) {
                        in_train[numberOfTrainingInstances] = in[instance];
                        out_train[numberOfTrainingInstances] = outInt[instance];
                        numberOfTrainingInstances++;
                    }
                }

                // Odabir metode strojnog učenja

                Classifier classifier = new Classifier("SVM", numberOfClasses);
                //Classifier classifier = new Classifier("PNN", numberOfClasses);
                //Classifier classifier = new Classifier("NEAT", numberOfClasses);
                //Classifier classifier = new Classifier("FEEDFORWARD", numberOfClasses);
                //classifier.setCodeType("OneOfN");

                classifier.train(in_train, out_train);

                double input[][] = new double[1][numberOfFeatures];

                for (int instance = 0; instance < numberOfInstances; instance++) {
                    if (CV[instance] == fold) {

                        String correct = out[instance];

                        for (int j = 0; j < numberOfFeatures; j++) {
                            input[0][j] = in[instance][j];
                        }

                        //String[] labelChosen = classifier.classifyToString(input);
                        int[] labelChosen = classifier.classify(input);

                        confusionMatrix[labelChosen[0]][map.get(correct)]++;
                    }
                }
            }

            Encog.getInstance().shutdown();

            System.out.println();

            for (int c = 0; c < numberOfClasses; c++) {
                StringBuilder result = new StringBuilder();
                for (int l = 0; l < numberOfClasses; l++) {
                    result.append(confusionMatrix[c][l]).append(" ");
                }
                System.out.println(result);
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}
