package multisab.processing.reporting;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

import java.util.List;

public class TestDataSource implements JRDataSource {
    private final List<TestRecord> testRecords;
    private int curr_pos;

    public TestDataSource(List<TestRecord> testRecords) {
        this.testRecords = testRecords;
        curr_pos = -1;
    }

    @Override
    public boolean next() throws JRException {
        if (curr_pos + 1 >= testRecords.size()) {
            return false;
        }

        curr_pos++;

        return true;
    }

    @Override
    public Object getFieldValue(JRField jRField) throws JRException {
        String fieldName = jRField.getName();

        switch (fieldName) {
            case "ID":
                return testRecords.get(curr_pos).getId();
            case "NAME":
                return testRecords.get(curr_pos).getName();
            case "DEPARTMENT":
                return testRecords.get(curr_pos).getDepartment();
            case "EMAIL":
                return testRecords.get(curr_pos).getEmail();
            default:
                return null;
        }
    }
}
