package multisab.processing.analysis;

import multisab.processing.commonSignalFeatures.nonlinear.AllanFactor;
import multisab.processing.commonSignalFeatures.nonlinear.LempelZivComplexity;
import multisab.processing.commonSignalFeatures.nonlinear.entropy.*;
import multisab.processing.commonSignalFeatures.nonlinear.fractal.DFA;
import multisab.processing.commonSignalFeatures.nonlinear.fractal.HiguchiDimension;
import multisab.processing.commonSignalFeatures.nonlinear.fractal.HurstExponent;
import multisab.processing.commonSignalFeatures.nonlinear.fractal.PowerLawExponentAlpha;
import multisab.processing.commonSignalFeatures.nonlinear.multivariate.MutualDimension;
import multisab.processing.commonSignalFeatures.nonlinear.phaseSpace.*;
import multisab.processing.commonSignalFeatures.nonlinear.multivariate.CrossRecurrence;
import multisab.processing.commonSignalFeatures.timeDomain.AutocorrelationCoefficient;
import multisab.processing.commonSignalFeatures.timeDomain.FanoFactor;
import multisab.processing.commonSignalFeatures.timeFrequencyDomain.HaarWaveletStandardDeviation;
import multisab.processing.ecgAnalysis.MorphologicalAnalysisECG;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;
import multisab.processing.eegAnalysis.TimeDomainAnalysisEEG;
import multisab.processing.hrvAnalysis.SpectralAnalysisHRV;
import multisab.processing.hrvAnalysis.StandardDeviationRatio;
import multisab.processing.hrvAnalysis.TimeDomainAnalysisHRV;
import multisab.processing.eegAnalysis.SpectralAnalysisEEG;

import java.util.ArrayList;
import java.util.Iterator;

public class FeatureExtraction {
    private Features features;
    private FeatureParameters parameters;
    private PreprocessingMethod preprocessingMethod;

    public FeatureExtraction(Features features, FeatureParameters parameters, PreprocessingMethod preprocessingMethod){
        this.features = features;
        this.parameters = parameters;
        this.preprocessingMethod = preprocessingMethod;
    }
    public ArrayList<String> performFeatureExtraction(double [] signal, double frequency) throws Exception{
        ArrayList<String> results = new ArrayList<String>();
        //TODO: nastaviti dodavati pokretanje ekstrakcije za sve implementirane znacajke

        ArrayList<String> features = this.features.getSelectedFeaturesList();
        Iterator<String> it = features.iterator();
        String feature;
        String parameter;
        int i = 0;
        ArrayList<Integer> m; // add additional integer parameters
        ArrayList<Double> r; // add additional double parameters
        double radius;
        double threshold;
        double scaleAllanFactor;
        double scaleFanoFactor;
        double lowerFrequencyRange;
        double upperFrequencyRange;
        double lowerFrequencyRangeLF;
        double upperFrequencyRangeLF;
        double lowerFrequencyRangeHF;
        double upperFrequencyRangeHF;
        int dimension;
        int division;
        int order;
        int scaleHaarWavelet;

        boolean dfa_long;
        int minimalAnalyzedSegmentLength = 0;
        int boundForAlphaLongCalculation = 0;
        int kMax = 0;
        int lag = 0;
        int trajectoryLength = 0;
        int pnnX = 0;
        int nnX = 0;
        int noSegm = 0;

        boolean dimensionSet;
        boolean radiusSet;
        boolean divisionSet;
        boolean orderSet;
        boolean trajectoryLengthSet;
        boolean minimalAnalyzedSegmentLengthSet;
        boolean boundForAlphaLongCalculationSet;
        boolean kMaxSet;
        boolean lagSet;
        boolean scaleAllanFactorSet;
        boolean scaleFanoFactorSet;
        boolean scaleHaarWaveletSet;
        boolean lowerFrequencyRangeSet;
        boolean upperFrequencyRangeSet;
        boolean lowerFrequencyRangeLFSet;
        boolean upperFrequencyRangeLFSet;
        boolean lowerFrequencyRangeHFSet;
        boolean upperFrequencyRangeHFSet;
        boolean pnnXset;
        boolean nnXset;
        boolean noSegmSet;
        double dfaResults;

        boolean spectrumCalculated = false;
        SpectralAnalysisHRV spectHRV = null;
        SpectralAnalysisEEG spectEEG = null;
        int spectMethod;
        int spectWindow;
        int spectFreq;


        while(it.hasNext()){
            feature = it.next();
            switch (feature){
                ///////////////// COMMON SIGNAL FEATURES ///////////
                // Approximate entropy
                case Features.AP_EN:
                    parameter = parameters.getSelectedParametersForFeature(Features.AP_EN);
                    m = new ArrayList<Integer>();
                    // this is a general implementation for ApEn parameters:
                    while(parameter.contains("m=")){
                        m.add(Integer.parseInt(parameter.substring(parameter.indexOf("m=")+2,parameter.indexOf(";", parameter.indexOf("m=")))));
                        parameter = parameter.substring(0,parameter.indexOf("m="))+parameter.substring(parameter.indexOf(";", parameter.indexOf("m=")));
                    }
                    r = new ArrayList<Double>();
                    while(parameter.contains("r=")) {
                        r.add(Double.parseDouble(parameter.substring(parameter.indexOf("r=")+2, parameter.indexOf(";", parameter.indexOf("r=")))));
                        parameter = parameter.substring(0, parameter.indexOf("r=")) + parameter.substring(parameter.indexOf(";", parameter.indexOf("r=")));
                    }
                    for (int j = 0; j < m.size(); j++) {
                        for (int k = 0; k < r.size(); k++) {
                            results.add(Double.toString(ApEn.calculateApEn(signal, m.get(j), r.get(k))));
                        }
                    }
                    break;
                // Sample entropy
                case Features.SAMP_EN:
                    parameter = parameters.getSelectedParametersForFeature(Features.SAMP_EN);
                    m = new ArrayList<Integer>();
                    // this is a general implementation for ApEn parameters:
                    while(parameter.contains("m=")){
                        m.add(Integer.parseInt(parameter.substring(parameter.indexOf("m=")+2,parameter.indexOf(";", parameter.indexOf("m=")))));
                        parameter = parameter.substring(0,parameter.indexOf("m="))+parameter.substring(parameter.indexOf(";", parameter.indexOf("m=")));
                    }
                    r = new ArrayList<Double>();
                    while(parameter.contains("r=")) {
                        r.add(Double.parseDouble(parameter.substring(parameter.indexOf("r=") + 2, parameter.indexOf(";", parameter.indexOf("r=")))));
                        parameter = parameter.substring(0, parameter.indexOf("r=")) + parameter.substring(parameter.indexOf(";", parameter.indexOf("r=")));
                    }
                    for (int j = 0; j < m.size(); j++) {
                        for (int k = 0; k < r.size(); k++) {
                            results.add(Double.toString(SampEn.calculateSampEn(signal, m.get(j), r.get(k))));
                        }
                    }
                    break;
                //  Carnap's 1D entropy
                case Features.CARNAP_ENTROPY_1D:
                    results.add(Double.toString(CarnapEntropy1D.calculateCarnapEntropy1D(signal)));
                    break;
                // Alphabet entropy (by Alan Jovic)
                case Features.ALPHABET_ENTROPY:
                    parameter = parameters.getSelectedParametersForFeature(Features.ALPHABET_ENTROPY);

                    threshold = Double.parseDouble(parameter.substring(parameter.indexOf("t=")+2,parameter.indexOf(";",parameter.indexOf("t="))));

                    AlphabetEntropy alphEn = new AlphabetEntropy(signal,threshold,false);
                    // assumes that the following alphabet entropy features are interesting, if not, or parametric, change implementation:
                    // letter exists, letter rate, average alphabet entropy, alphabet entropy variance, maximum alphabet entropy,
                    // average alphabet entropy per letter, variance of alphabet entropy per letter, maximum alphabet entropy per letter
                    boolean [] existsLetterAlphEn = alphEn.getExistsLetter();
                    for (int j = 0; j < existsLetterAlphEn.length; j++){
                        if (existsLetterAlphEn[j]){results.add("1");}
                        else results.add("0");
                    }
                    double [] letterRateAlphEn = alphEn.getRateAlphabet();
                    for (int j = 0; j < letterRateAlphEn.length; j++){
                        results.add(Double.toString(letterRateAlphEn[j]));
                    }
                    results.add(Double.toString(alphEn.getAverageAlphabetEntropy()));
                    results.add(Double.toString(alphEn.getVarianceAlphabetEntropy()));
                    results.add(Double.toString(alphEn.getMaximumAlphabetEntropy()));
                    double [] averageEntropyPerLetter = alphEn.getAverageAlphabetEntropyPerLetter();
                    for (int j = 0; j < averageEntropyPerLetter.length; j++){
                        results.add(Double.toString(averageEntropyPerLetter[j]));
                    }
                    double [] alphabetEntropyVariancePerLetter = alphEn.getVarianceAlphabetEntropyPerLetter();
                    for (int j = 0; j < alphabetEntropyVariancePerLetter.length; j++){
                        results.add(Double.toString(alphabetEntropyVariancePerLetter[j]));
                    }
                    double [] maximumAlphabetEntropyPerLetter = alphEn.getMaximumAlphabetEntropyPerLetter();
                    for (int j = 0; j < maximumAlphabetEntropyPerLetter.length; j++){
                        results.add(Double.toString(maximumAlphabetEntropyPerLetter[j]));
                    }
                    break;
                // corrected conditional Shannon entropy
                case Features.CORRECTED_CONDITIONAL_SHANNON_ENTROPY:
                    parameter = parameters.getSelectedParametersForFeature(Features.CORRECTED_CONDITIONAL_SHANNON_ENTROPY);
                    dimension = 0;
                    division = 0;
                    dimensionSet = false;
                    divisionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div="))));
                        divisionSet = true;
                    }
                    if (dimensionSet && divisionSet) {
                        results.add(Double.toString(CorrectedConditionalShannonEntropy.calculateCorrectedConditionalShannonEntropy(signal,dimension,division)));
                    }
                    else throw new Exception("Corrected conditional Shannon entropy parameters: dimension, division, not set.");
                    break;
                // correlation entropy
                case Features.CORRELATION_ENTROPY:
                    parameter = parameters.getSelectedParametersForFeature(Features.CORRELATION_ENTROPY);
                    dimension = 0;
                    division = 0;
                    dimensionSet = false;
                    divisionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div=")))); //bila je greska: pisamo je dim umjesto div
                        divisionSet = true;
                    }
                    if (dimensionSet && divisionSet) {
                        results.add(Double.toString(CorrelationEntropy.calculateCorrelationEntropy(signal,dimension,division)));
                    }
                    else throw new Exception("Correlation entropy parameters: dimension, division not set.");
                    break;
                // fuzzy approximate entropy
                case Features.FUZZY_AP_EN:
                    parameter = parameters.getSelectedParametersForFeature(Features.FUZZY_AP_EN);
                    m = new ArrayList<Integer>();
                    // this is a general implementation for ApEn parameters:
                    while(parameter.contains("m=")){
                        m.add(Integer.parseInt(parameter.substring(parameter.indexOf("m=")+2,parameter.indexOf(";", parameter.indexOf("m=")))));
                        parameter = parameter.substring(0,parameter.indexOf("m="))+parameter.substring(parameter.indexOf(";", parameter.indexOf("m=")));
                    }
                    r = new ArrayList<Double>();
                    while(parameter.contains("r=")) {
                        r.add(Double.parseDouble(parameter.substring(parameter.indexOf("r=") + 2, parameter.indexOf(";", parameter.indexOf("r=")))));
                        parameter = parameter.substring(0, parameter.indexOf("r=")) + parameter.substring(parameter.indexOf(";", parameter.indexOf("r=")));
                    }
                    for (int j = 0; j < m.size(); j++) {
                        for (int k = 0; k < r.size(); k++) {
                            results.add(Double.toString(FuzzyApEn.calculateFuzzyApEn(signal, m.get(j), r.get(k))));
                        }
                    }
                    break;
                // Renyi entropy
                case Features.RENYI_ENTROPY:
                    parameter = parameters.getSelectedParametersForFeature(Features.RENYI_ENTROPY);
                    order = 0;
                    orderSet = true;
                    if (parameter.contains("ord=")) {
                        order = Integer.parseInt(parameter.substring(parameter.indexOf("ord=")+4,parameter.indexOf(";",parameter.indexOf("ord="))));
                        orderSet = true;
                    }
                    if (orderSet) {
                        results.add(Double.toString(RenyiEntropy.calculateRenyiEntropy(signal, order)));
                    }
                    else throw new Exception("Renyi entropy parameters not set.");
                    break;
                // Shannon entropy
                case Features.SHANNON_ENTROPY:
                    parameter = parameters.getSelectedParametersForFeature(Features.SHANNON_ENTROPY); //Nikolina: RENYI ispravljeno u SHANNON
                    dimension = 0;
                    division = 0;
                    dimensionSet = false;
                    divisionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div="))));
                        divisionSet = true;
                    }
                    if (dimensionSet && divisionSet) {
                        results.add(Double.toString(ShannonEntropy.calculateShannonEntropy(signal,dimension,division)));
                    }
                    else throw new Exception("Shannon entropy parameters: dimension, division not set.");
                    break;
                ///////////////////////////////////////////////////

                ///////////////// FRACTAL FEATURES ///////////
                // Detrended fluctuation analysis
                case Features.DFA_ALPHA1:
                    parameter = parameters.getSelectedParametersForFeature(Features.DFA_ALPHA1);
                    //dfa_long = false;
                    minimalAnalyzedSegmentLengthSet = false;
                    boundForAlphaLongCalculationSet = false;
                    /*
                    if (parameter.contains("dfa_long=true")) {
                        dfa_long = true;
                    }*/
                    if (parameter.contains("minAnaSegLen=")) {
                        minimalAnalyzedSegmentLength = Integer.parseInt(parameter.substring(parameter.indexOf("minAnaSegLen=")+13,parameter.indexOf(";",parameter.indexOf("minAnaSegLen="))));
                        minimalAnalyzedSegmentLengthSet = true;
                    }
                    if (parameter.contains("boundAlphLong=")) {
                        boundForAlphaLongCalculation = Integer.parseInt(parameter.substring(parameter.indexOf("boundAlphLong=")+14,parameter.indexOf(";",parameter.indexOf("boundAlphLong="))));//Nikolina == -> =
                        boundForAlphaLongCalculationSet = true;
                    }
                    try {
                        if (minimalAnalyzedSegmentLengthSet && boundForAlphaLongCalculationSet) {
                            dfaResults = DFA.calculateDFA(signal, false, minimalAnalyzedSegmentLength, boundForAlphaLongCalculation)[0];
                        } else if (minimalAnalyzedSegmentLengthSet) {
                            dfaResults = DFA.calculateDFA(signal, false, minimalAnalyzedSegmentLength, DFA.DEFAULT_BOUND_FOR_ALPHA_LONG_CALCULATION)[0];
                        } else if (boundForAlphaLongCalculationSet) {
                            dfaResults = DFA.calculateDFA(signal, false, DFA.DEFAULT_MINIMAL_ANALYZED_SEGMENT_LENGTH, boundForAlphaLongCalculation)[0];
                        } else {
                        /*Nikolina:
                            Potencijalni problem, ako dfa_long nije true i ako nije zadan nijedan parametar do ovog dijela koda se ne dolazi već se baca exception
                         */
                            dfaResults = DFA.calculateDFA(signal, false, DFA.DEFAULT_MINIMAL_ANALYZED_SEGMENT_LENGTH, DFA.DEFAULT_BOUND_FOR_ALPHA_LONG_CALCULATION)[0];
                        }
                    }
                    catch (Exception ex){
                        dfaResults = 0.0; // come up with a better plan in the case of faulty segments
                    }
                    /*if (dfa_long) {
                        results.add(Double.toString(dfaResults[0]));
                        results.add(Double.toString(dfaResults[1]));
                    }
                    else {*/
                    results.add(Double.toString(dfaResults));
                    //}
                    break;
                // Detrended fluctuation analysis
                case Features.DFA_ALPHA2:
                    parameter = parameters.getSelectedParametersForFeature(Features.DFA_ALPHA2);

                    minimalAnalyzedSegmentLengthSet = false;
                    boundForAlphaLongCalculationSet = false;

                    if (parameter.contains("minAnaSegLen=")) {
                        minimalAnalyzedSegmentLength = Integer.parseInt(parameter.substring(parameter.indexOf("minAnaSegLen=")+13,parameter.indexOf(";",parameter.indexOf("minAnaSegLen="))));
                        minimalAnalyzedSegmentLengthSet = true;
                    }
                    if (parameter.contains("boundAlphLong=")) {
                        boundForAlphaLongCalculation = Integer.parseInt(parameter.substring(parameter.indexOf("boundAlphLong=")+14,parameter.indexOf(";",parameter.indexOf("boundAlphLong="))));//Nikolina == -> =
                        boundForAlphaLongCalculationSet = true;
                    }
                    try {
                        if (minimalAnalyzedSegmentLengthSet && boundForAlphaLongCalculationSet) {
                            dfaResults = DFA.calculateDFA(signal, true, minimalAnalyzedSegmentLength, boundForAlphaLongCalculation)[1];
                        } else if (minimalAnalyzedSegmentLengthSet) {
                            dfaResults = DFA.calculateDFA(signal, true, minimalAnalyzedSegmentLength, DFA.DEFAULT_BOUND_FOR_ALPHA_LONG_CALCULATION)[1];
                        } else if (boundForAlphaLongCalculationSet) {
                            dfaResults = DFA.calculateDFA(signal, true, DFA.DEFAULT_MINIMAL_ANALYZED_SEGMENT_LENGTH, boundForAlphaLongCalculation)[1];
                        } else {
                        /*Nikolina:
                            Potencijalni problem, ako dfa_long nije true i ako nije zadan nijedan parametar do ovog dijela koda se ne dolazi već se baca exception
                         */
                            dfaResults = DFA.calculateDFA(signal, true, DFA.DEFAULT_MINIMAL_ANALYZED_SEGMENT_LENGTH, DFA.DEFAULT_BOUND_FOR_ALPHA_LONG_CALCULATION)[1];
                        }
                    }
                    catch (Exception ex){
                        dfaResults = 0.0; // come up with a better plan in the case of faulty segments
                    }
                    /*if (dfa_long) {
                        results.add(Double.toString(dfaResults[0]));
                        results.add(Double.toString(dfaResults[1]));
                    }
                    else {*/
                    results.add(Double.toString(dfaResults));
                    //}
                    break;
                // Higuchi fractal dimension
                case Features.HIGUCHI_DIMENSION:
                    parameter = parameters.getSelectedParametersForFeature(Features.HIGUCHI_DIMENSION);
                    kMax = 0;
                    kMaxSet = false;
                    /*Nikolina:
                        trebalo bi provjeriti je li parameters null, inače se krši i niti ne ide u else...
                     */
                    if (parameter.contains("kmax=")) {
                        kMax = Integer.parseInt(parameter.substring(parameter.indexOf("kmax=")+5,parameter.indexOf(";",parameter.indexOf("kmax="))));
                        kMaxSet = true;
                    }
                    if (kMaxSet){
                        results.add(Double.toString(HiguchiDimension.calculateHiguchiDimension(signal,kMax)));
                    }
                    else {
                        results.add(Double.toString(HiguchiDimension.calculateHiguchiDimension(signal,HiguchiDimension.DEFAULT_KMAX)));
                    }
                    break;
                // Hurst exponent
                case Features.HURST_EXPONENT:
                    results.add(Double.toString(HurstExponent.calculateHurstExponent(signal)));
                    break;
                // Power Law Exponent Alpha
                case Features.POWER_LAW_EXPONENT_ALPHA:
                    results.add(Double.toString(PowerLawExponentAlpha.calculatePowerLawExponentAlpha(signal)));
                    break;
                ////////////////////////////////////////////////////////

                ///////////////// MULTIVARIATE FEATURES //////////////  -> implemented in multivariate feature extraction method
                case Features.CROSS_RECURRENCE:
                    break;
                case Features.MUTUAL_DIMENSION:
                    break;
                case Features.PHASE_SYNCHRONIZATION:  // not yet implemented
                    break;
                case Features.SYNCHRONIZATION_LIKELIHOOD:
                    break;

                ///////////////////////////////////////////////////////////
                ///////////////// MORPHOLOGICAL ECG FEATURES //////////////  -> implemented in morphological ECG feature extraction method
                case Features.ECG_R_WAVE_AMPLITUDE:
                    break;
                case Features.ECG_QRS_COMPLEX_DURATION:
                    break;
                case Features.ECG_P_WAVE_AMPLITUDE:
                    break;
                case Features.ECG_P_WAVE_ABSENCE:
                    break;
                case Features.ECG_P_WAVE_DURATION:
                    break;
                case Features.ECG_T_WAVE_AMPLITUDE:
                    break;
                case Features.ECG_T_WAVE_DURATION:
                    break;
                case Features.ECG_ST_SEGMENT_DURATION:
                    break;
                case Features.ECG_ST_SEGMENT_SLOPE:
                    break;
                case Features.ECG_QT_INTERVAL_DURATION:
                    break;
                case Features.ECG_PR_INTERVAL_DURATION:
                    break;
                case Features.ECG_J_POINT_AMPLITUDE:
                    break;
                case Features.ECG_R_S_RATIO:
                    break;
                case Features.ECG_Q_WAVE_AMPLITUDE:
                    break;
                case Features.ECG_R_WAVE_DURATION:
                    break;
                case Features.ECG_S_WAVE_DURATION:
                    break;
                case Features.ECG_FIBRILATORY_RATE:
                    break;
                case Features.ECG_QT_QTc_RATIO:
                    break;
                case Features.ECG_QTV_NORM:
                    break;
                case Features.ECG_QTVI:
                    break;
                case Features.ECG_TQ_INTERVAL_WE:
                    break;
                case Features.ECG_TQ_INTERVAL_RWE:
                    break;
                case Features.ECG_J_POINT_AMPLITUDE_STDEV:
                    break;

                ////////////////////////////////////////////////////////
                ///////////////// PHASE SPACE FEATURES //////////////
                case Features.CORRELATION_DIMENSION:
                    parameter = parameters.getSelectedParametersForFeature(Features.CORRELATION_DIMENSION);
                    lag = 1;
                    lagSet = false;
                    if (parameter.contains("lag=")) {
                        lag = Integer.parseInt(parameter.substring(parameter.indexOf("lag=")+4,parameter.indexOf(";",parameter.indexOf("lag="))));
                        lagSet = true;
                    }
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    division = 1;
                    divisionSet = false;
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div="))));
                        divisionSet = true;
                    }

                    if (dimensionSet && lagSet && divisionSet) {
                        results.add(Double.toString(CorrelationDimension.calculateCorrelationDimension(signal, dimension, lag, division)));
                    }
                    else throw new Exception("Correlation dimension parameters: dimension, lag, and division not set.");
                    break;
                case Features.CTM:
                    parameter = parameters.getSelectedParametersForFeature(Features.CTM);
                    lag = 1;
                    lagSet = false;
                    if (parameter.contains("lag=")) {
                        lag = Integer.parseInt(parameter.substring(parameter.indexOf("lag=")+4,parameter.indexOf(";",parameter.indexOf("lag="))));
                        lagSet = true;
                    }
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    radius = -1.0;
                    radiusSet = false;
                    if (parameter.contains("r=")) {
                        radius = Double.parseDouble(parameter.substring(parameter.indexOf("r=")+2,parameter.indexOf(";",parameter.indexOf("r="))));
                        radiusSet = true;
                    }
                    if (dimensionSet && lagSet && radiusSet) {
                        results.add(Double.toString(CTM.calculateCTM(signal, radius, dimension, lag)));
                    }
                    else if (dimensionSet && lagSet){
                        results.add(Double.toString(CTM.calculateCTM(signal, dimension, lag)));
                    }
                    else throw new Exception("Central tendency measure (CTM) parameters: dimension, lag not set.");
                    break;
                case Features.LARGEST_LYAPUNOV_EXPONENT:
                    parameter = parameters.getSelectedParametersForFeature(Features.LARGEST_LYAPUNOV_EXPONENT);
                    trajectoryLength = 1;
                    trajectoryLengthSet = false;
                    if (parameter.contains("tra=")) {
                        trajectoryLength = Integer.parseInt(parameter.substring(parameter.indexOf("tra=")+4,parameter.indexOf(";",parameter.indexOf("tra="))));
                        trajectoryLengthSet = true;
                    }
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    try {
                        if (trajectoryLengthSet && dimensionSet) {
                            results.add(Double.toString(LargestLyapunovExponent.calculateLargestLyapunovExponentRosenstien(signal, dimension, trajectoryLength)));
                        } else if (dimensionSet) {
                            results.add(Double.toString(LargestLyapunovExponent.calculateLargestLyapunovExponentRosenstien(signal, dimension, LargestLyapunovExponent.SMALL_TRAJECTORY_LENGTH)));
                        } else if (trajectoryLengthSet) {
                            results.add(Double.toString(LargestLyapunovExponent.calculateLargestLyapunovExponentRosenstien(signal, LargestLyapunovExponent.DEFAULT_PHASE_SPACE_DIMENSION, trajectoryLength)));
                        } else {
                            results.add(Double.toString(LargestLyapunovExponent.calculateLargestLyapunovExponentRosenstien(signal, LargestLyapunovExponent.DEFAULT_PHASE_SPACE_DIMENSION, LargestLyapunovExponent.SMALL_TRAJECTORY_LENGTH)));
                        }
                    }
                    catch (Exception ex){
                        results.add(Double.toString(0.0)); // try to figure something else out if possible
                    }
                    break;
                case Features.RECURRENCE_PLOT:
                    parameter = parameters.getSelectedParametersForFeature(Features.RECURRENCE_PLOT);
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    lag = 1;
                    lagSet = false;
                    if (parameter.contains("lag=")) {
                        lag = Integer.parseInt(parameter.substring(parameter.indexOf("lag=")+4,parameter.indexOf(";",parameter.indexOf("lag="))));
                        lagSet = true;
                    }
                    radius = -1.0;
                    radiusSet = false;
                    if (parameter.contains("r=")) {
                        radius = Double.parseDouble(parameter.substring(parameter.indexOf("r=")+2,parameter.indexOf(";",parameter.indexOf("r="))));
                        radiusSet = true;
                    }
                    RecurrencePlot rp = null;
                    if (dimensionSet && lagSet && !radiusSet){
                        rp = new RecurrencePlot(signal,dimension,lag);
                    }
                    else if (dimensionSet && lagSet && radiusSet){
                        rp = new RecurrencePlot(signal,dimension,lag,radius);
                    }
                    else throw new Exception("Recurrence plot parameters: dimension, lag not set.");
                    results.add(Double.toString(rp.calculateRecurrenceRate()));
                    results.add(Double.toString(rp.calculateLMean()));
                    results.add(Double.toString(rp.calculateDET()));
                    results.add(Double.toString(rp.calculateShannonEntropyRecurrence()));
                    results.add(Double.toString(rp.calculateLaminarity()));
                    break;
                case Features.SPATIAL_FILLING_INDEX:
                    parameter = parameters.getSelectedParametersForFeature(Features.SPATIAL_FILLING_INDEX);
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    lag = 1;
                    lagSet = false;
                    if (parameter.contains("lag=")) {
                        lag = Integer.parseInt(parameter.substring(parameter.indexOf("lag=")+4,parameter.indexOf(";",parameter.indexOf("lag="))));
                        lagSet = true;
                    }
                    division = 1;
                    divisionSet = false;
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div="))));
                        divisionSet = true;
                    }
                    if (dimensionSet && lagSet && divisionSet){
                        results.add(Double.toString(SpatialFillingIndex.calculateSpatialFillingIndex(signal, dimension, lag, division)));
                    }
                    else if (lagSet && divisionSet){
                        results.add(Double.toString(SpatialFillingIndex.calculateSpatialFillingIndex(signal, SpatialFillingIndex.DEFAULT_PHASE_SPACE_DIMENSION, lag, division)));
                    }
                    else throw new Exception("Spatial filling index: lag, division not set.");
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// NONLINEAR GENERAL FEATURES //////////////
                case Features.ALLAN_FACTOR:
                    parameter = parameters.getSelectedParametersForFeature(Features.ALLAN_FACTOR);
                    scaleAllanFactor = 0.0;
                    scaleAllanFactorSet = false;
                    if (parameter.contains("timeSc=")) {
                        scaleAllanFactor = Double.parseDouble(parameter.substring(parameter.indexOf("timeSc=")+7,parameter.indexOf(";",parameter.indexOf("timeSc="))));
                        scaleAllanFactorSet = true;
                    }
                    try {
                        if (scaleAllanFactorSet) {
                            results.add(Double.toString(AllanFactor.calculateAllanFactorFromIntervals(signal, scaleAllanFactor)));
                        }
                        else throw new Exception("Allan factor parameter time scale not set.");
                    }
                    catch (Exception ex){
                        results.add(Double.toString(0.0)); // try to figure something else out if possible
                    }
                    break;
                case Features.LEMPEL_ZIV_COMPLEXITY:
                    results.add(Double.toString(LempelZivComplexity.calculateLempelZivComplexity(signal)));
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// TIME DOMAIN FEATURES //////////////
                case Features.AUTOCORRELATION_COEFFICIENT:
                    results.add(Double.toString(AutocorrelationCoefficient.calculateAutocorrelationCoefficient(signal)));
                    break;
                case Features.FANO_FACTOR:
                    parameter = parameters.getSelectedParametersForFeature(Features.FANO_FACTOR);
                    scaleFanoFactor = 0.0;
                    scaleFanoFactorSet = false;
                    if (parameter.contains("timeSc=")) {
                        scaleFanoFactor = Double.parseDouble(parameter.substring(parameter.indexOf("timeSc=")+7,parameter.indexOf(";",parameter.indexOf("timeSc="))));
                        scaleFanoFactorSet = true;
                    }
                    try {
                        if (scaleFanoFactorSet) {
                            results.add(Double.toString(FanoFactor.calculateFanoFactorFromIntervals(signal, scaleFanoFactor)));
                        }
                        else throw new Exception("Fano factor parameter time scale not set.");
                    }
                    catch (Exception ex){
                        results.add(Double.toString(0.0)); // try to figure something else out if possible
                    }
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// TIME FREQUENCY FEATURES //////////////
                case Features.HAAR_WAVELET_STANDARD_DEVIATION:
                    parameter = parameters.getSelectedParametersForFeature(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                    scaleHaarWavelet = 0;
                    scaleHaarWaveletSet = false;
                    if (parameter.contains("haarSc=")) {
                        scaleHaarWavelet = Integer.parseInt(parameter.substring(parameter.indexOf("haarSc=")+7,parameter.indexOf(";",parameter.indexOf("haarSc="))));
                        scaleHaarWaveletSet = true;
                    }
                    if (scaleHaarWaveletSet){
                        results.add(Double.toString(HaarWaveletStandardDeviation.calculateHaarWaveletSTDEV(signal, scaleHaarWavelet)));
                    }
                    else {
                        /* Nikolina:
                            Do ovog dijela koda nece niti doci jer ako nije zadan parametar puknut ce na parameter.contains
                         */
                        results.add(Double.toString(HaarWaveletStandardDeviation.calculateHaarWaveletSTDEV(signal, HaarWaveletStandardDeviation.DEFAULT_HAAR_WAVELET_SCALE)));
                    }
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// HEART RATE VARIABILITY SPECTRAL FEATURES //////////////
                case Features.SPECTRAL_ANALYSIS_HRV:
                    results.add(Double.toString(1.0));
                    break;
                case Features.HRV_LF:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_LF);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_UPPER_BOUND)));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_UPPER_BOUND)));
                    }
                    break;
                case Features.HRV_HF:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_HF);
                    if (parameter != null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND)));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND)));
                    }
                    break;
                case Features.HRV_VLF:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_VLF);
                    if (parameter != null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_UPPER_BOUND)));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_UPPER_BOUND)));
                    }
                    break;
                case Features.HRV_ULF:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_ULF);
                    if (parameter != null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_UPPER_BOUND)));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_UPPER_BOUND)));
                    }
                    break;
                case Features.HRV_TOTAL_PWR:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_TOTAL_PWR);
                    if (parameter != null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            // this is an option to specify the total power of spectrum within specific frequency range
                            results.add(Double.toString(spectHRV.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getTotalPSD()));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getPSDForFrequencyBand(SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND, SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND)));
                    }
                    break;
                case Features.HRV_LF_HF_RATIO:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_LF_HF_RATIO);
                    if (parameter != null) {
                        lowerFrequencyRangeLF = 0;
                        upperFrequencyRangeLF = 0;
                        lowerFrequencyRangeHF = 0;
                        upperFrequencyRangeHF = 0;
                        lowerFrequencyRangeLFSet = false;
                        upperFrequencyRangeLFSet = false;
                        lowerFrequencyRangeHFSet = false;
                        upperFrequencyRangeHFSet = false;
                        if (parameter.contains("lowerFrLF=")) {
                            lowerFrequencyRangeLF = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFrLF=") + 10, parameter.indexOf(";", parameter.indexOf("lowerFrLF="))));
                            lowerFrequencyRangeLFSet = true;
                        }
                        if (parameter.contains("upperFrLF=")) {
                            upperFrequencyRangeLF = Double.parseDouble(parameter.substring(parameter.indexOf("upperFrLF=") + 10, parameter.indexOf(";", parameter.indexOf("upperFrLF="))));
                            upperFrequencyRangeLFSet = true;
                        }
                        if (parameter.contains("lowerFrHF=")) {
                            lowerFrequencyRangeHF = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFrHF=") + 10, parameter.indexOf(";", parameter.indexOf("lowerFrHF="))));
                            lowerFrequencyRangeHFSet = true;
                        }
                        if (parameter.contains("upperFrHF=")) {
                            upperFrequencyRangeHF = Double.parseDouble(parameter.substring(parameter.indexOf("upperFrHF=") + 10, parameter.indexOf(";", parameter.indexOf("upperFrHF="))));
                            upperFrequencyRangeHFSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeLFSet && upperFrequencyRangeLFSet && lowerFrequencyRangeHFSet && upperFrequencyRangeHFSet) {
                            results.add(Double.toString(spectHRV.getLFHFRatio(lowerFrequencyRangeLF, upperFrequencyRangeLF, lowerFrequencyRangeHF, upperFrequencyRangeHF)));
                        } else {
                            results.add(Double.toString(spectHRV.getLFHFRatio()));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getLFHFRatio()));
                    }
                    break;
                case Features.HRV_SPECT_EN:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_SPECT_EN);
                    if (parameter != null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectHRV.getSpectralEntropy(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectHRV.getSpectralEntropy()));
                        }
                    }
                    else {
                        if (spectHRV == null) {
                            spectHRV = this.calculateSpectrumHRV(signal,frequency);
                        }
                        results.add(Double.toString(spectHRV.getSpectralEntropy()));
                    }
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// HEART RATE VARIABILITY TIME DOMAIN FEATURES //////////////
                case Features.HRV_AVNN:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateAVNN(signal)));
                    break;
                case Features.HRV_1_AVNN:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculate1_AVNN(signal)));
                    break;
                case Features.HRV_SDNN:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateSDNN(signal)));
                    break;
                case Features.HRV_RMSSD:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateRMSSD(signal)));
                    break;
                case Features.HRV_PNN20:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculatePNNX(signal,20)));
                    break;
                case Features.HRV_PNN50:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculatePNNX(signal,50)));
                    break;
                case Features.HRV_PNNX:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_PNNX);
                    pnnXset = false;
                    if (parameter.contains("X=")){
                        pnnX = Integer.parseInt(parameter.substring(parameter.indexOf("X=")+2,parameter.indexOf(";",parameter.indexOf("X="))));
                        pnnXset = true;
                    }
                    if (pnnXset){
                        results.add(Double.toString(TimeDomainAnalysisHRV.calculatePNNX(signal, pnnX)));
                    }
                    break;
                case Features.HRV_NN20:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateNNXCount(signal,20)));
                    break;
                case Features.HRV_NN50:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateNNXCount(signal,50)));
                    break;
                case Features.HRV_NNX:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_NNX);
                    nnXset = false;
                    if (parameter.contains("X=")){
                        nnX = Integer.parseInt(parameter.substring(parameter.indexOf("X=")+2,parameter.indexOf(";",parameter.indexOf("X="))));
                        nnXset = true;
                    }
                    if (nnXset){
                        results.add(Double.toString(TimeDomainAnalysisHRV.calculateNNXCount(signal, nnX)));
                    }
                    break;
                case Features.HRV_SDSD:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateSDSD(signal)));
                    break;
                case Features.HRV_HRV_TRIANGULAR_INDEX:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateHRVTriangularIndex(signal)));
                    break;
                case Features.HRV_TINN:
                    results.add(Double.toString(TimeDomainAnalysisHRV.calculateTINN(signal)));
                    break;
                case Features.HRV_SDANN:
                    parameter = parameters.getSelectedParametersForFeature(Features.HRV_SDANN);
                    noSegmSet = false;
                    if (parameter.contains("noSegm=")){
                        noSegm = Integer.parseInt(parameter.substring(parameter.indexOf("noSegm=")+7,parameter.indexOf(";",parameter.indexOf("noSegm=")))); //+2 --> +7
                        noSegmSet = true;
                    }
                    if (noSegmSet){
                        results.add(Double.toString(TimeDomainAnalysisHRV.calculateSDANN(signal, noSegm)));
                    }
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// HRV STANDARD DEVIATION RATIO //////////////
                case Features.HRV_STANDARD_DEVIATION_RATIO:
                    results.add(Double.toString(StandardDeviationRatio.calculateStandardDeviationRatio(signal)));
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// EEG SPECTRAL FEATURES //////////////
                case Features.SPECTRAL_ANALYSIS_EEG:
                    results.add(Double.toString(1.0));
                    break;
                case Features.EEG_ALPHA_BAND:
                    parameter = parameters.getSelectedParametersForFeature(Features.EEG_ALPHA_BAND);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectEEG.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectEEG.getAlpha()));
                        }
                    }
                    else {
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        results.add(Double.toString(spectEEG.getAlpha()));
                    }
                    break;
                case Features.EEG_BETA_BAND:
                    parameter = parameters.getSelectedParametersForFeature(Features.EEG_BETA_BAND);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectEEG.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectEEG.getBeta()));
                        }
                    }
                    else {
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        results.add(Double.toString(spectEEG.getBeta()));
                    }
                    break;
                case Features.EEG_GAMMA_BAND:
                    parameter = parameters.getSelectedParametersForFeature(Features.EEG_GAMMA_BAND);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectEEG.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectEEG.getGamma()));
                        }
                    }
                    else {
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        results.add(Double.toString(spectEEG.getGamma()));
                    }
                    break;
                case Features.EEG_DELTA_BAND:
                    parameter = parameters.getSelectedParametersForFeature(Features.EEG_DELTA_BAND);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectEEG.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectEEG.getDelta()));
                        }
                    }
                    else {
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        results.add(Double.toString(spectEEG.getDelta()));
                    }
                    break;
                case Features.EEG_THETA_BAND:
                    parameter = parameters.getSelectedParametersForFeature(Features.EEG_THETA_BAND);
                    if (parameter!= null) {
                        lowerFrequencyRange = 0;
                        upperFrequencyRange = 0;
                        lowerFrequencyRangeSet = false;
                        upperFrequencyRangeSet = false;
                        if (parameter.contains("lowerFr=")) {
                            lowerFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("lowerFr=") + 8, parameter.indexOf(";", parameter.indexOf("lowerFr="))));
                            lowerFrequencyRangeSet = true;
                        }
                        if (parameter.contains("upperFr=")) {
                            upperFrequencyRange = Double.parseDouble(parameter.substring(parameter.indexOf("upperFr=") + 8, parameter.indexOf(";", parameter.indexOf("upperFr="))));
                            upperFrequencyRangeSet = true;
                        }
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        if (lowerFrequencyRangeSet && upperFrequencyRangeSet) {
                            results.add(Double.toString(spectEEG.getPSDForFrequencyBand(lowerFrequencyRange, upperFrequencyRange)));
                        } else {
                            results.add(Double.toString(spectEEG.getTheta()));
                        }
                    }
                    else {
                        if (spectEEG == null) {
                            spectEEG = this.calculateSpectrumEEG(signal,frequency);
                        }
                        results.add(Double.toString(spectEEG.getTheta()));
                    }
                    break;
                case Features.EEG_TOTAL_PWR:
                    if (spectEEG == null) {
                       spectEEG = this.calculateSpectrumEEG(signal,frequency);
                    }
                    results.add(Double.toString(spectEEG.getTotalPSD()));
                    break;
                case Features.EEG_SPECT_EN:
                    if (spectEEG == null) {
                        spectEEG = this.calculateSpectrumEEG(signal,frequency);
                    }
                    results.add(Double.toString(spectEEG.getSpectralEntropy()));
                    break;
                ////////////////////////////////////////////////////////
                ///////////////// EEG TIME DOMAIN FEATURES //////////////
                case Features.EEG_MEAN:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateMean(signal)));
                    break;
                case Features.EEG_MEAN_OF_FIRST_DIFF:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateMeanOfFirstDiff(signal)));
                    break;
                case Features.EEG_MEAN_OF_FIRST_DIFF_NORM:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateMeanOfFirstDiffNormalized(signal)));
                    break;
                case Features.EEG_MEAN_OF_SECOND_DIFF:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateMeanOfSecondDiff(signal)));
                    break;
                case Features.EEG_MEAN_OF_SECOND_DIFF_NORM:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateMeanOfSecondDiffNormalized(signal)));
                    break;
                case Features.EEG_STANDARD_DEVIATION:
                    results.add(Double.toString(TimeDomainAnalysisEEG.calculateStandardDeviation(signal)));
                    break;

                default:
                    throw new Exception("Unimplemented or unknown feature selected for extraction");

            }
        }
        return results;
    }
    private SpectralAnalysisEEG calculateSpectrumEEG(double [] signal, double frequency) throws Exception{
        int order = -1;
        String [] transformationMethods = preprocessingMethod.getTransformationMethods();

        String method;
        int methodInt = -1;
        String window ="";
        String [] parametersPreprocessingMethods = preprocessingMethod.getParametersForTransformationMethods();
        boolean windowSet = false;
        boolean orderSet = false;

        for (int i = 0; i < transformationMethods.length; i++){
            if (transformationMethods[i].equals(PreprocessingMethod.FFT)){
                methodInt = SpectralAnalysisEEG.FAST_FOURIER_TRANSFORM;
                for (int j = 0; j < parametersPreprocessingMethods.length; j++){
                    if (parametersPreprocessingMethods[i].contains("window=")){
                        window = parametersPreprocessingMethods[i].substring(parametersPreprocessingMethods[i].indexOf("window=")+7,parametersPreprocessingMethods[i].indexOf(";",parametersPreprocessingMethods[i].indexOf("window=")));
                        windowSet = true;
                    }
                }
                if (!windowSet){
                    window="NO_WINDOW";
                }
                break;
            }
            if (transformationMethods[i].equals(PreprocessingMethod.BURG)){
                methodInt = SpectralAnalysisEEG.BURG_METHOD;
                for (int j = 0; j < parametersPreprocessingMethods.length; j++){
                    if (parametersPreprocessingMethods[i].contains("ord=")){
                        order = Integer.parseInt(parametersPreprocessingMethods[i].substring(parametersPreprocessingMethods[i].indexOf("ord=")+4,parametersPreprocessingMethods[i].indexOf(";",parametersPreprocessingMethods[i].indexOf("ord="))));
                        orderSet = true;
                    }
                }
                if (!orderSet){
                    order = SpectralAnalysisEEG.DEFAULT_ORDER;
                }
                break;
            }
            if (transformationMethods[i].equals(PreprocessingMethod.LOMB_SCARGLE)){
                methodInt = SpectralAnalysisEEG.LOMB_SCARGLE_METHOD;
                break;
            }
        }

        if (methodInt == -1){
            // otherwise, method is unknown, report error
            throw new Exception("Specified spectral analysis method for EEG unknown.");
        }

        SpectralAnalysisEEG spectEEG = null;

        if (frequency != 0.0) {
            spectEEG = new SpectralAnalysisEEG(signal, frequency, methodInt, window, order);
        }
        else {
            throw new Exception("Sampling frequency for EEG not specified.");
        }

        return spectEEG;
    }
    private SpectralAnalysisHRV calculateSpectrumHRV(double [] signal, double frequency) throws Exception{
        int order = -1;
        String [] transformationMethods = preprocessingMethod.getTransformationMethods();

        //parameter = parameters.getSelectedParametersForFeature(Features.SPECTRAL_ANALYSIS_HRV);
        String method;
        int methodInt = -1;
        String window ="";
        String [] parametersPreprocessingMethods = preprocessingMethod.getParametersForTransformationMethods();
        boolean windowSet = false;
        boolean orderSet = false;

        for (int i = 0; i < transformationMethods.length; i++){
            if (transformationMethods[i].equals(PreprocessingMethod.FFT)){
                methodInt = SpectralAnalysisHRV.FAST_FOURIER_TRANSFORM;
                for (int j = 0; j < parametersPreprocessingMethods.length; j++){
                    if (parametersPreprocessingMethods[i].contains("window=")){
                        window = parametersPreprocessingMethods[i].substring(parametersPreprocessingMethods[i].indexOf("window=")+7,parametersPreprocessingMethods[i].indexOf(";",parametersPreprocessingMethods[i].indexOf("window=")));
                        windowSet = true;
                    }
                }
                if (!windowSet){
                    window="NO_WINDOW";
                }
                break;
            }
            if (transformationMethods[i].equals(PreprocessingMethod.BURG)){
                methodInt = SpectralAnalysisHRV.BURG_METHOD;
                for (int j = 0; j < parametersPreprocessingMethods.length; j++){
                    if (parametersPreprocessingMethods[i].contains("ord=")){
                        order = Integer.parseInt(parametersPreprocessingMethods[i].substring(parametersPreprocessingMethods[i].indexOf("ord=")+4,parametersPreprocessingMethods[i].indexOf(";",parametersPreprocessingMethods[i].indexOf("ord="))));
                        orderSet = true;
                    }
                }
                if (!orderSet){
                    order = SpectralAnalysisHRV.DEFAULT_ORDER;
                }
                break;
            }
            if (transformationMethods[i].equals(PreprocessingMethod.LOMB_SCARGLE)){
                methodInt = SpectralAnalysisHRV.LOMB_SCARGLE_METHOD;
                break;
            }
        }

        if (methodInt == -1){
            // otherwise, method is unknown, report error
            throw new Exception("Specified spectral analysis method for HRV unknown.");
        }

        // HRV uobicajeno svi koriste s 1.0 Hz sampling frequency, iako to zapravo i nije ispravno (rasprava s Davorom 18.1.2018.). Zasad ovako ostavljamo.
        SpectralAnalysisHRV spectHRV = new SpectralAnalysisHRV(signal,frequency,methodInt,window,order);
        return spectHRV;
    }

    /*Nikolina:
    Ova metoda se poziva samo ako ima vise signala u jednom zapisu, sto za ANN file nije moguce pa ne mogu testirati
    */
    public ArrayList<String> performMultivariateFeatureExtraction(double [] signalA, double[] signalB) throws Exception{
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> features = this.features.getSelectedFeaturesList();
        Iterator<String> it = features.iterator();
        String feature;
        String parameter;
        int i = 0;
        double radius;

        int dimension;
        int dimension1;
        int dimension2;
        int division;

        int lag;
        int lag1;
        int lag2;

        boolean dimensionSet;
        boolean dimension1Set;
        boolean dimension2Set;
        boolean lagSet;
        boolean lag1Set;
        boolean lag2Set;
        boolean radiusSet;
        boolean divisionSet;

        while(it.hasNext()) {
            feature = it.next();
            switch (feature) {
                ///////////////// MULTIVARIATE FEATURES //////////////
                case Features.CROSS_RECURRENCE:
                    parameter = parameters.getSelectedParametersForFeature(Features.CROSS_RECURRENCE);
                    dimension = 1;
                    dimensionSet = false;
                    if (parameter.contains("dim=")) {
                        dimension = Integer.parseInt(parameter.substring(parameter.indexOf("dim=")+4,parameter.indexOf(";",parameter.indexOf("dim="))));
                        dimensionSet = true;
                    }
                    lag = 1;
                    lagSet = false;
                    if (parameter.contains("lag=")) {
                        lag = Integer.parseInt(parameter.substring(parameter.indexOf("lag=")+4,parameter.indexOf(";",parameter.indexOf("lag="))));
                        lagSet = true;
                    }
                    radius = -1.0;
                    radiusSet = false;
                    if (parameter.contains("r=")) {
                        radius = Double.parseDouble(parameter.substring(parameter.indexOf("r=")+2,parameter.indexOf(";",parameter.indexOf("r="))));
                        radiusSet = true;
                    }
                    CrossRecurrence cr;
                    if (dimensionSet && lagSet && !radiusSet){
                        cr = new CrossRecurrence(signalA,signalB,dimension,lag);
                    }
                    else if (dimensionSet && lagSet && radiusSet){
                        cr = new CrossRecurrence(signalA,signalB,dimension,lag,radius);
                    }
                    else throw new Exception("Cross-recurrence plot parameters: dimension, lag not set.");
                    results.add(Double.toString(cr.calculateCC()));
                    results.add(Double.toString(cr.calculateLMean()));
                    results.add(Double.toString(cr.calculateDET()));
                    results.add(Double.toString(cr.calculateShannonEntropyRecurrence()));
                    results.add(Double.toString(cr.calculateLaminarity()));
                    break;
                case Features.MUTUAL_DIMENSION:
                    parameter = parameters.getSelectedParametersForFeature(Features.MUTUAL_DIMENSION);
                    dimension1 = 1;
                    dimension1Set = false;
                    if (parameter.contains("dim1=")) {
                        dimension1 = Integer.parseInt(parameter.substring(parameter.indexOf("dim1=")+5,parameter.indexOf(";",parameter.indexOf("dim1="))));
                        dimension1Set = true;
                    }
                    dimension2 = 1;
                    dimension2Set = false;
                    if (parameter.contains("dim2=")) {
                        dimension1 = Integer.parseInt(parameter.substring(parameter.indexOf("dim2=")+5,parameter.indexOf(";",parameter.indexOf("dim2="))));
                        dimension1Set = true;
                    }
                    lag1 = 1;
                    lag1Set = false;
                    if (parameter.contains("lag1=")) {
                        lag1 = Integer.parseInt(parameter.substring(parameter.indexOf("lag1=")+5,parameter.indexOf(";",parameter.indexOf("lag1="))));
                        lag1Set = true;
                    }
                    lag2 = 1;
                    lag2Set = false;
                    if (parameter.contains("lag2=")) {
                        lag2 = Integer.parseInt(parameter.substring(parameter.indexOf("lag2=")+5,parameter.indexOf(";",parameter.indexOf("lag2="))));
                        lag2Set = true;
                    }
                    division = 1;
                    divisionSet = false;
                    if (parameter.contains("div=")) {
                        division = Integer.parseInt(parameter.substring(parameter.indexOf("div=")+4,parameter.indexOf(";",parameter.indexOf("div="))));
                        divisionSet = true;
                    }
                    if (dimension1Set && lag1Set && dimension2Set && lag2Set && divisionSet){
                        results.add(Double.toString(MutualDimension.calculateMutualDimension(signalA, signalB, dimension1, dimension2, lag1, lag2, division)));
                    }
                    else if (dimension1Set && lag1Set && dimension2Set && lag2Set && !divisionSet){
                        results.add(Double.toString(MutualDimension.calculateMutualDimension(signalA, signalB, dimension1, dimension2, lag1, lag2, MutualDimension.FINESSE)));
                    }
                    else throw new Exception("Mutual dimension parameters not set.");
                    break;
                case Features.PHASE_SYNCHRONIZATION:  // not yet implemented
                    break;
                case Features.SYNCHRONIZATION_LIKELIHOOD: // not yet tested, unclear parameters
                    break;
                default:
                ////////////////////////////////////////////////////////
            }
        }
        return results;
    }
    // Modificirao Davor /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public ArrayList<String> performMorphologicalECGFeatureExtraction(double [] ecg, double frequency, ecgFiducialPoints FiducialPoints) throws Exception{
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> features = this.features.getSelectedFeaturesList();
        Iterator<String> it = features.iterator();
        String feature;
        String parameter;
        int i = 0;

        while(it.hasNext()) {
            feature = it.next();
            switch (feature) {
                ///////////////// MORPHOLOGICAL ECG FEATURES //////////////
                case Features.ECG_R_WAVE_AMPLITUDE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgRwaveAmplitude(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_QRS_COMPLEX_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgQRScomplexDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_P_WAVE_AMPLITUDE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgPwaveAmplitude(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_P_WAVE_ABSENCE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgPwaveAbsence(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_P_WAVE_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgPwaveDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_T_WAVE_AMPLITUDE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgTwaveAmplitude(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_T_WAVE_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgTwaveDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_ST_SEGMENT_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgSTsegmentDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_ST_SEGMENT_SLOPE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgSTsegmentSlope(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_QT_INTERVAL_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgQTintervalDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_PR_INTERVAL_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgPRintervalDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_J_POINT_AMPLITUDE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgJpointAmplitude(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_R_S_RATIO:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcg_R_S_Ratio(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_Q_WAVE_AMPLITUDE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgQwaveAmplitude(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_R_WAVE_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgRwaveDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_S_WAVE_DURATION:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgSwaveDuration(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_FIBRILATORY_RATE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgFibrilatoryRate(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_QT_QTc_RATIO:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcg_QT_QTc_Ratio(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_QTV_NORM:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgQTVnorm(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_QTVI:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgQTVI(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_TQ_INTERVAL_WE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgTQintervalWE(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_TQ_INTERVAL_RWE:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgTQintervalRWE(ecg, frequency, FiducialPoints)));
                    break;
                case Features.ECG_J_POINT_AMPLITUDE_STDEV:
                    results.add(Double.toString(MorphologicalAnalysisECG.calculateEcgJpointAmplitudeSD(ecg, frequency, FiducialPoints)));
                    break;
                default:
                    ////////////////////////////////////////////////////////
            }
        }
        return results;
    }
}
