package multisab.processing.analysis;

import multisab.processing.eegAnalysis.SpectralAnalysisEEG;
import multisab.processing.hrvAnalysis.SpectralAnalysisHRV;

import java.util.HashMap;

public class FeatureParameters {
    HashMap<String,String> selectedParameters;

    public FeatureParameters(){
        selectedParameters = new HashMap<String,String>();
    }

    public void addFeatureParameter(String feature, String parameterAndValue){
        if (this.selectedParameters.get(feature) == null){
            this.selectedParameters.put(feature, parameterAndValue+";");
        }
        else { // there is already a defined parameter for this feature, we should add the additional parameter
            this.selectedParameters.put(feature, this.selectedParameters.get(feature)+parameterAndValue+";");
        }
    }
    public String getSelectedParametersForFeature(String feature){
        return this.selectedParameters.get(feature);
    }
    public HashMap<String,String> getAllSelectedFeatures(){
        return this.selectedParameters;
    }

    public static String getParametersForFeature(String feature){
        String parameters = "";

        switch(feature){
            case Features.AP_EN:
                parameters = "m=2;r=0.1;r=0.15;r=0.2;r=0.25;";
                break;
            case Features.SAMP_EN:
                parameters = "m=2;r=0.1;r=0.15;r=0.2;r=0.25;";
                break;
            case Features.ALPHABET_ENTROPY:
                parameters = "t=20;";
                break;
            case Features.CORRECTED_CONDITIONAL_SHANNON_ENTROPY:
                parameters = "dim=2;div=6;";
                break;
            case Features.CORRELATION_ENTROPY:
                parameters = "dim=2;div=6;";
                break;
            // TODO: continue
            case Features.FUZZY_AP_EN:
                parameters = "m=2;r=0.1;r=0.15;r=0.2;r=0.25;";
                break;
            case Features.SHANNON_ENTROPY:
                parameters = "dim=2;div=6;";
                break;
            case Features.RENYI_ENTROPY:
                parameters = "ord=3;";
                break;
            case Features.DFA_ALPHA1:
                //parameters = "dfa_long=true;minAnaSegLen=5;boundAlphLong=13;";
                parameters = "minAnaSegLen=5;boundAlphLong=13;";
                break;
            case Features.DFA_ALPHA2:
                //parameters = "dfa_long=true;minAnaSegLen=5;boundAlphLong=13;";
                parameters = "minAnaSegLen=5;boundAlphLong=13;";
                break;
            case Features.HIGUCHI_DIMENSION:
                parameters = "kmax=8;";
                break;
            case Features.CORRELATION_DIMENSION:
                parameters = "dim=2;lag=1;div=20;";
                break;
            case Features.CTM:
                parameters = "dim=2;lag=1;";    // r= is currently not set
                break;
            case Features.LARGEST_LYAPUNOV_EXPONENT:
                parameters = "tra=10;dim=2;";
                break;
            case Features.RECURRENCE_PLOT:
                parameters = "dim=2;lag=1;";    // r= is currently not set
                break;
            case Features.SPATIAL_FILLING_INDEX:
                parameters = "dim=2;lag=1;div=10;";
                break;
            case Features.ALLAN_FACTOR:
                parameters = "timeSc=10;";
                break;
            case Features.FANO_FACTOR:
                parameters = "timeSc=10;";
                break;
            case Features.HAAR_WAVELET_STANDARD_DEVIATION:
                parameters = "haarSc=8;";
                break;
            case Features.HRV_LF:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_HF:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_VLF:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_VERY_LOW_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_ULF:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_TOTAL_PWR:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_LF_HF_RATIO:
                parameters = "lowerFrLF="+ SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFrLF="+ SpectralAnalysisHRV.DEFAULT_LOW_FREQUENCY_UPPER_BOUND+";";
                parameters += "lowerFrHF="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFrHF="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_SPECT_EN:
                parameters = "lowerFr="+ SpectralAnalysisHRV.DEFAULT_ULTRA_LOW_FREQUENCY_LOWER_BOUND+";";
                parameters += "upperFr="+ SpectralAnalysisHRV.DEFAULT_HIGH_FREQUENCY_UPPER_BOUND+";";
                break;
            case Features.HRV_PNNX:
                parameters = "X=50;";
                break;
            case Features.HRV_NNX:
                parameters = "X=50;";
                break;
            case Features.HRV_SDANN:
                parameters = "noSegm=50;";
                break;
            case Features.EEG_ALPHA_BAND:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_ALPHA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_ALPHA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.EEG_BETA_BAND:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_BETA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_BETA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.EEG_GAMMA_BAND:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_GAMMA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_GAMMA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.EEG_DELTA_BAND:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_DELTA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_DELTA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.EEG_THETA_BAND:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_THETA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_THETA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.EEG_TOTAL_PWR:
                parameters = "lowerFr="+ SpectralAnalysisEEG.DEFAULT_DELTA_BAND_LOWER_BOUND+ ";";
                parameters += "upperFr="+ SpectralAnalysisEEG.DEFAULT_GAMMA_BAND_UPPER_BOUND+ ";";
                break;
            case Features.CROSS_RECURRENCE:
                parameters = "dim=2;lag=1;";
                break;
            case Features.MUTUAL_DIMENSION:
                parameters = "dim1=2;dim2=2;lag1=1;lag2=1;div=20;";
                break;
            default:
                parameters = "";
                break;
        }
        return parameters;
    }
}
