package multisab.processing.commonSignalFeatures.nonlinear.entropy;

import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;

public class CorrelationEntropy {
    public static final int MINIMAL_LENGTH_FOR_EXTRACTION = 20;

    public static double calculateCorrelationEntropy(double[] HRVseries, int dim, int division) {
        double max = Statistics.maximum(HRVseries);
        double min = Statistics.minimum(HRVseries);
        double boxSize = (max - min) / division;
        int size;

        int sum;
        // find distribution of points within dim dimensional boxes of size boxSize
        int[] boxes = new int[(int) Math.pow((double) division, (double) dim)];
        int[] locator = new int[dim];
        for (int i = 0; i < HRVseries.length - dim; i++) {
            for (int j = 0; j < dim; j++) {
                locator[j] = (int) ((HRVseries[i + j] - min) / boxSize - 1);
                if (locator[j] < 0) {
                    locator[j] = 0;
                }
            }
            sum = 0;
            for (int j = 0, a = dim - 1; j < dim; j++, a--) {
                sum += (int) locator[j] * Math.pow(division, a);
            }
            boxes[sum]++;
        }
        double sumEntropy = 0.0;

        size = HRVseries.length - dim + 1;
        double log2 = Math.log10(2.0);
        for (int i = 0; i < boxes.length; i++) {
            if (boxes[i] > 1) {
                sumEntropy += ((double) (boxes[i]) / size) * ((double) (boxes[i]) / size) * Math.log10(((double) (boxes[i]) / size) * ((double) (boxes[i]) / size)) / log2;
            }
        }
        return -sumEntropy;
    }
}
