package multisab.processing.commonSignalFeatures.nonlinear.fractal;

import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;

//Higuchi, T., Approach to an irregular time series on the basis of the fractal theory, Physica D, 31, 277--283, 1988.
public class HiguchiDimension {
    public static final int MINIMAL_LENGTH_FOR_EXTRACTION = 100;
    public static final int DEFAULT_KMAX = 8;

    public static final double calculateHiguchiDimension(double[] segment, int kmax) {
        int N = segment.length;
        if (N <= kmax){
            System.err.print("Too short segment for calculating Higuchi's fractal dimension");
            return 0.0;
        }
        int z;
        double currLength;
        double[][] lengths = new double[kmax][kmax];

        for (int k = 1; k <= kmax; k++) {
            for (int m = 1; m <= k; m++) {
                currLength = 0.0;
                z = (N - m) / k;
                if (z == 0){
                    System.err.print("Too short segment for calculating Higuchi's fractal dimension");
                    return 0.0;
                }

                for (int i = 1; i <= z; i++) {
                    currLength += Math.abs(segment[(m - 1) + i * k] - segment[(m - 1) + (i - 1) * k]);
                }
                double ng = (N - 1) / (z * k);
                lengths[m - 1][k - 1] = (currLength * ng) / k;
            }
        }

        double[] lnInversek = new double[kmax];
        double[] lnAverageLength = new double[kmax];

        for (int k = 1; k <= kmax; k++) {
            double sum = 0.0;

            for (int m = 1; m <= k; m++) {
                sum += lengths[m - 1][k - 1];
            }


            lnInversek[k - 1] = Math.log(1.0 / k);
            lnAverageLength[k - 1] = Math.log(sum / k);
        }

        double[] alfaBeta = Statistics.fitLineThroughXYPointsCoefficients(lnInversek, lnAverageLength, 20);

        // the slope is the Higuchi dimension
        return alfaBeta[0];
    }
}