/*
 * Created on 2006.05.10
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package multisab.processing.commonSignalFeatures.nonlinear.phaseSpace;
import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;
/**
 * This class is used to calculate central tendency measure for the second order difference graph
 *
 * @author Alan Jovic
 */
//PROVJERITI JOŠ
public class CTM {
    public static final int MINIMAL_LENGTH_FOR_EXTRACTION = 20;

    /**
     * This method calculates CTM for the second order difference graph
     *
     * @param values array of values containing differences between points
     * @param r      data radius for the CTM calculation, by default it should be set 1/8 of the difference between longest and shortest point differences
     * @param dimen  second order difference plot dimension
     * @param lag interval T between consecutive points
     * @return Central tendency measure
     * <p>
     * M. E. Cohen, D. L. Hudson, and P. C. Deedwania, “Applying continuous chaotic modeling to cardiac signal multisab.processing.analysis,” IEEE Eng. Med. Biol. Mag., vol. 15, no. 5, pp. 97–102, Sep./Oct. 1996.
     */
    public static double calculateCTM(double[] values, double r, int dimen, int lag) {
        double ctm = 0.0;
        double sqr = 0.0;
        double temp = 0.0;
        for (int i = 0; i < values.length - ((dimen * lag + 1)); i++) { //-((dimen-1)*interv+2)
            sqr = 0.0;
            for (int j = 1; j <= dimen; j++) {
                temp = values[i + j * lag] - values[i + (j - 1) * lag];
                sqr += temp * temp;
            }
            if (Math.sqrt(sqr) < r) {
                ctm++;
            }
        }
        ctm /= (values.length - (dimen * lag));
        return ctm;
    }
    public static double calculateCTM(double[] values, int dimen, int lag) {
        double ctm = 0.0;
        double sqr = 0.0;
        double temp = 0.0;
        double mind = Statistics.getDifferenceMinimumNthOrder(values, lag, 0, values.length, false, Statistics.DESCENDING);
        double maxd = Statistics.getDifferenceMaximumNthOrder(values, lag, 0, values.length, false, Statistics.DESCENDING);
        double r = (maxd-mind)/8;
        for (int i = 0; i < values.length - ((dimen * lag + 1)); i++) { //-((dimen-1)*interv+2)
            sqr = 0.0;
            for (int j = 1; j <= dimen; j++) {
                temp = values[i + j * lag] - values[i + (j - 1) * lag];
                sqr += temp * temp;
            }
            if (Math.sqrt(sqr) < r) {
                ctm++;
            }
        }
        ctm /= (values.length - (dimen * lag));
        return ctm;
    }

}
