package multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ptDetection;

import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;
import multisab.processing.preprocessing.iirj.Butterworth;
import multisab.processing.preprocessing.iirj.ChebyshevII;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static java.lang.Math.PI;
import static java.lang.Math.floor;
import static multisab.processing.ecgAnalysis.ecgPreprocessing.BaselineWanderRemoval.Butter_HF_05;

/**
 * This class implements Martinez PT algorithm.
 *
 * @author Davor Kukolja
 */

public class MartinezPT {

    public static ecgFiducialPoints DetectFiducialPoints(double[] ecg, double frequency, int[] R_peaks) {
        ecgFiducialPoints FiducialPoints;

        double[] M;
        double[] phi;
        double Rv;

        int l = ecg.length;
        int n = R_peaks.length;

        FiducialPoints = new ecgFiducialPoints();

        int[] qrsPeak = new int[n];
        for (int i = 0; i < n; i++) {
            qrsPeak[i] = R_peaks[i];
        }

        FiducialPoints.setQrsPeak(qrsPeak);

        double[] ecg_filt;
        ecg_filt = Butter_HF_05(ecg, frequency);
        //ecg_filt = Chebyshev_LF_70(ecg_filt, frequency);
        ecg_filt = Butter_LF_70(ecg_filt, frequency);


        int orientation;

        if (calculateMeanRwaveAmplitude(ecg_filt, frequency, R_peaks) > 0) {
            orientation = 1; // R peak is positive
        }
        else {
            orientation = 0; // R peak is negative
        }

        double[] ecg_abs;
        ecg_abs = abs(ecg_filt);

        double[] ecg_filt_sort = Arrays.copyOf(ecg_abs, ecg_abs.length);
        Arrays.sort(ecg_filt_sort);

        int m = (int) floor(0.999 * l);
        double ecg_norm = ecg_filt_sort[m];

        for (int i = 0; i < l; i++) {
            ecg_filt[i] = ecg_filt[i] / ecg_norm;
        }

        ecg_abs = absolute(ecg_filt);

        Rv = 0.001;

        M = PT_M(ecg_abs, Rv);
        phi = PT_phi(ecg_abs, Rv);


        int[] R_peaks_reannot = new int[n];

        for (int i = 0; i < n; i++) {
            int temp = R_peaks[i];
            if (phi[temp - 1] < phi[temp] && phi[temp] < phi[temp + 1]) {
                int start = temp;
                int stop = temp + 1;
                while (true) {
                    if (phi[stop] < phi[temp]) {
                        break;
                    }
                    if (stop == l - 1) {
                        break;
                    }
                    stop = stop + 1;
                }
                int R_peak = maxIndex(M, start, stop);
                R_peaks_reannot[i] = R_peak;
            } else {
                if (phi[temp - 1] > phi[temp] && phi[temp] > phi[temp + 1]) {
                    int stop = temp;
                    int start = temp - 1;
                    while (true) {
                        if (phi[start] < phi[temp]) {
                            break;
                        }
                        if (start == 0) {
                            break;
                        }
                        start = start - 1;
                    }
                    int R_peak = maxIndex(M, start, stop);
                    R_peaks_reannot[i] = R_peak;
                } else {
                    R_peaks_reannot[i] = R_peaks[i];
                }
            }
        }


        int[] gamma_QRS_minus = new int[n];
        int[] gamma_QRS_plus = new int[n];

        double thr = 0.25 * PI / 2;
        double max_gamma_QRS_minus = 0.1 * frequency;
        double max_gamma_QRS_plus = 0.1 * frequency;

        int temp;
        int i;

        for (i = 0; i < n; i++) {
            temp = R_peaks_reannot[i] - 1;
            while (true) {
                if (phi[temp] < thr) {
                    break;
                }
                if (temp == 0) {
                    break;
                }
                temp = temp - 1;
            }
            gamma_QRS_minus[i] = temp;

            if ((R_peaks_reannot[i] - temp) > max_gamma_QRS_minus) {
                while ((R_peaks_reannot[i] - temp) > max_gamma_QRS_minus) {
                    thr = thr + 0.05 * PI / 2;
                    temp = R_peaks_reannot[i] - 1;
                    while (true) {
                        if (phi[temp] < thr) {
                            break;
                        }
                        if (temp == 0) {
                            break;
                        }
                        temp = temp - 1;
                    }
                    gamma_QRS_minus[i] = temp;
                }
                thr = 0.25 * PI / 2;
            }

            temp = R_peaks_reannot[i] + 1;
            while (true) {
                if (phi[temp] < thr) {
                    break;
                }
                if (temp == l - 1) {
                    break;
                }
                temp = temp + 1;
            }
            gamma_QRS_plus[i] = temp;

            if ((temp - R_peaks_reannot[i]) > max_gamma_QRS_plus) {
                while ((temp - R_peaks_reannot[i]) > max_gamma_QRS_plus) {
                    thr = thr + 0.05 * PI / 2;
                    temp = R_peaks_reannot[i] + 1;
                    while (true) {
                        if (phi[temp] < thr) {
                            break;
                        }
                        if (temp == l) {
                            break;
                        }
                        temp = temp + 1;
                    }
                    gamma_QRS_plus[i] = temp;
                }
                thr = 0.25 * PI / 2;
            }
        }


        int[] QRS_onset_v1 = new int[n];
        int[] QRS_offset_v1 = new int[n];

        int[] SwavePeak = new int[n];
        int[] QwavePeak = new int[n];

        boolean[] SwaveAbsence = new boolean[n];
        boolean[] QwaveAbsence = new boolean[n];

        Rv = 0.005;

        double[] window;
        double[] window_M;

        ecg_abs = abs(ecg_filt);

        double temp2;
        int maximum_ind = 0; //TODO
        int local_maximum;

        // Prvi R peak

        i = 0;
        int start = gamma_QRS_minus[i] - (int) floor(0.035 * frequency);
        if (start < 1) {
            QRS_onset_v1[i] = Integer.MIN_VALUE;
            QwaveAbsence[i] = true;
            QwavePeak[i] = Integer.MIN_VALUE;
        } else {
            window = getWindow(ecg_abs, start, gamma_QRS_minus[i]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                QwaveAbsence[i] = true;
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[i]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v1[i] = ind;
                QwavePeak[i] = ind;
            } else {
                QwaveAbsence[i] = false;
                QwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v1[i] = maximum_ind + start;
                } else {
                    QRS_onset_v1[i] = local_maximum + start;
                }
            }
        }

        for (i = 1; i < n; i++) {

            start = gamma_QRS_minus[i] - (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, gamma_QRS_minus[i]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                QwaveAbsence[i] = true;
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[i]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v1[i] = ind;
                QwavePeak[i] = ind;
            } else {
                QwaveAbsence[i] = false;
                QwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v1[i] = maximum_ind + start;
                } else {
                    QRS_onset_v1[i] = local_maximum + start;
                }
            }
        }

        FiducialPoints.setQrsOnset(QRS_onset_v1);
        FiducialPoints.setQwavePeak(QwavePeak);
        FiducialPoints.setQwaveAbsence(QwaveAbsence);

        // Zadnji R peak

        i = n - 1;
        start = gamma_QRS_plus[i];
        if ((start + floor(0.055 * frequency)) > ecg_abs.length - 1){
            QRS_offset_v1[i] = -1;
            SwaveAbsence[i] = true;
            SwavePeak[i] = Integer.MIN_VALUE;
        }
        else {
            int window_end = start + (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                SwaveAbsence[i] = true;
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v1[i] = ind;
                SwavePeak[i] = ind;
            }
            else {
                SwaveAbsence[i] = false;
                SwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v1[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v1[i] = local_maximum + start;
                }
            }
        }

        for (i = 0; i < n - 1; i++) {
            start = gamma_QRS_plus[i];
            int window_end = start + (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                SwaveAbsence[i] = true;
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v1[i] = ind;
                SwavePeak[i] = ind;
            }
            else {
                SwaveAbsence[i] = false;
                SwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window,local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v1[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v1[i] = local_maximum + start;
                }
            }
        }

        FiducialPoints.setQrsOffset(QRS_offset_v1);
        FiducialPoints.setSwavePeak(SwavePeak);
        FiducialPoints.setSwaveAbsence(SwaveAbsence);


        ecg_filt = Butter05_20(ecg, frequency);

        ecg_abs = abs(ecg_filt);

        ecg_filt_sort = Arrays.copyOf(ecg_abs, ecg_abs.length);
        Arrays.sort(ecg_filt_sort);

        m = (int) floor(0.999 * l);
        ecg_norm = ecg_filt_sort[m];

        for (i = 0; i < l; i++) {
            ecg_filt[i] = ecg_filt[i] / ecg_norm;
        }


        int[] QRS_onset_v2 = new int[n];
        int[] QRS_offset_v2 = new int[n];

        Rv = 0.005;

        ecg_abs = abs(ecg_filt);

        maximum_ind = 0; //TODO

        // Prvi R peak

        start = gamma_QRS_minus[0] - (int) floor(0.055 * frequency);
        if (start < 1) {
            QRS_onset_v2[0] = -1;
        } else {
            window = getWindow(ecg_abs, start, gamma_QRS_minus[0]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[0]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v2[0] = ind;
            } else {
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v2[0] = maximum_ind + start;
                } else {
                    QRS_onset_v2[0] = local_maximum + start;
                }
            }
        }

        for (i = 1; i < n; i++) {

            start = gamma_QRS_minus[i] - (int) floor(0.055 * frequency);
            window = getWindow(ecg_abs, start, gamma_QRS_minus[i]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[i]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v2[i] = ind;
            } else {
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v2[i] = maximum_ind + start;
                } else {
                    QRS_onset_v2[i] = local_maximum + start;
                }
            }
        }

        FiducialPoints.setQrsOnset(QRS_onset_v2);

        // Zadnji R peak

        i = n - 1;
        start = gamma_QRS_plus[i];
        if ((start + floor(0.055 * frequency)) > ecg_abs.length - 1){
            QRS_offset_v2[i] = -1;
        }
        else {
            int window_end = start + (int) floor(0.055 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v2[i] = ind;
            }
            else {
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v2[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v2[i] = local_maximum + start;
                }
            }
        }

        for (i = 0; i < n - 1; i++) {
            start = gamma_QRS_plus[i];
            int window_end = start + (int) floor(0.055 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v2[i] = ind;
            }
            else {
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window,local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v2[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v2[i] = local_maximum + start;
                }
            }
        }

        // FiducialPoints.setQrsOffset(QRS_offset_v2);


        // Amplitudes of R_peak

        double[] R_peak_amplitude = new double[n];

        if (QRS_onset_v2[0] == -1) {
            R_peak_amplitude[0] = -1;
        }
        else {
            R_peak_amplitude[0] = Math.abs(ecg_filt[R_peaks_reannot[0]] - ecg_filt[QRS_onset_v2[0]]);
        }
        for (i = 1; i < n; i++) {
            R_peak_amplitude[i] = Math.abs(ecg_filt[R_peaks_reannot[i]] - ecg_filt[QRS_onset_v2[i]]);
        }

        // Calculation of differences between adjacent ECG samples

        double[] ecg_filt_diff = new double[l];

        for (i = 1; i < l - 1; i++) {
            ecg_filt_diff[i] = ecg_filt[i + 1] - ecg_filt[i - 1];
        }

        // P/T wave detection

        Rv = 0.003; // Rv for P and T wave detection

        ////////////////// P wave detection //////////////////

        int[] P_peaks = new int[n];
        for (i = 0; i < n; i++) {
            P_peaks[i] = Integer.MIN_VALUE;
        }
        int[] PwaveOnset = new int[n];
        for (i = 0; i < n; i++) {
            PwaveOnset[i] = Integer.MIN_VALUE;
        }
        int[] PwaveOffset = new int[n];
        for (i = 0; i < n; i++) {
            PwaveOffset[i] = Integer.MIN_VALUE;
        }

        if (QRS_onset_v2[0] == Integer.MIN_VALUE) {
            P_peaks[0] = Integer.MIN_VALUE;
        }
        else {
            int window_length = (int) Math.ceil((R_peaks_reannot[1] - R_peaks_reannot[0])/4);

            start = QRS_onset_v2[0] - window_length;

            if (start < 0) {
                P_peaks[0] = Integer.MIN_VALUE;
            }
            else {
                int search = 0;

                while (window_length > 10) {
                    for (int j = 0; j < search + 1; j++) {
                        start = QRS_onset_v2[0] - window_length - j;
                        window = getWindow(ecg_filt, start, QRS_onset_v2[0] - j);
                        window = removeMedian(window);
                        window_M = PT_M(window, Rv);
                        window = PT_phi(window, Rv);

                        double maximum = max(window, 0, window.length - 1);
                        int P_peak = maxIndex(window, 0, window.length - 1);
                        double max_M = max(window_M, 0, window_M.length - 1);

                        if (window_M[P_peak] == max_M) {
                            if (P_peak == 0) {
                                continue;
                            }
                            else {
                                if(P_peak == window.length - 1) {
                                    continue;
                                }
                                else {
                                    P_peaks[0] = P_peak + start;
                                    WavePoints Pwave = waveDelineation(P_peaks[0], ecg_filt_diff, frequency, 0.0575);
                                    PwaveOnset[0] = Pwave.onset;
                                    PwaveOffset[0] = Pwave.offset;
                                    if ((Math.abs(ecg_filt[P_peaks[0]] - ecg_filt[Pwave.onset]) < 0.04 * R_peak_amplitude[0]) && (Math.abs(ecg_filt[P_peaks[0]] - ecg_filt[Pwave.offset]) < 0.04 * R_peak_amplitude[0])) {
                                        P_peaks[0] = Integer.MIN_VALUE;
                                    }
                                    window_length = 0;
                                    break;
                                }
                            }
                        }
                    }
                    window_length = window_length - 1;
                    search = search + 1;
                }
            }
        }

        for (i = 1; i < n; i++) {

            int window_length = (int) Math.ceil((R_peaks_reannot[i] - R_peaks_reannot[i - 1]) / 4);
            if (frequency / 2 < window_length) {
                window_length = (int) (frequency / 2); //Ograničenje radi testiranja QT baze
            }

            int search = 0;

            while (window_length > 10) {
                for (int j = 0; j < search + 1; j++) {
                    start = QRS_onset_v2[i] - window_length - j;
                    window = getWindow(ecg_filt, start, QRS_onset_v2[i] - j);
                    window = removeMedian(window);
                    window_M = PT_M(window, Rv);
                    window = PT_phi(window, Rv);

                    double maximum = max(window, 0, window.length - 1);
                    int P_peak = maxIndex(window, 0, window.length - 1);
                    double max_M = max(window_M, 0, window_M.length - 1);

                    if (window_M[P_peak] == max_M) {
                        if (P_peak == 0) {
                            continue;
                        } else {
                            if (P_peak == window.length - 1) {
                                continue;
                            } else {
                                P_peaks[i] = P_peak + start;
                                WavePoints Pwave = waveDelineation(P_peaks[i], ecg_filt_diff, frequency, 0.0575);
                                PwaveOnset[i] = Pwave.onset;
                                PwaveOffset[i] = Pwave.offset;
                                if ((Math.abs((ecg_filt[P_peaks[i]]) - ecg_filt[Pwave.onset]) < 0.04 * R_peak_amplitude[i]) && (Math.abs(ecg_filt[P_peaks[i]] - ecg_filt[Pwave.offset]) < 0.04 * R_peak_amplitude[i])) {
                                    P_peaks[i] = Integer.MIN_VALUE;
                                }
                                window_length = 0;
                                break;
                            }
                        }
                    }
                }
                window_length = window_length - 1;
                search = search + 1;
            }
        }
        FiducialPoints.setPwavePeak(P_peaks);
        FiducialPoints.setPwaveOnset(PwaveOnset);
        FiducialPoints.setPwaveOffset(PwaveOffset);


        ////////////////// T wave detection //////////////////

        int[] T_peaks = new int[n];
        for (i = 0; i < n; i++) {
            T_peaks[i] = Integer.MIN_VALUE;
        }
        int[] TwaveOnset = new int[n];
        for (i = 0; i < n; i++) {
            TwaveOnset[i] = Integer.MIN_VALUE;
        }
        int[] TwaveOffset = new int[n];
        for (i = 0; i < n; i++) {
            TwaveOffset[i] = Integer.MIN_VALUE;
        }

        //Zadnji R peak
        if (QRS_offset_v2[n - 1] == -1){
            T_peaks[n - 1] = Integer.MIN_VALUE;
        }
        else {
            int window_length = (int) Math.ceil((R_peaks_reannot[n - 1] - R_peaks_reannot[n - 2]) * 0.5);

            int stop = QRS_offset_v2[n - 1] + window_length;

            if (stop > l - 1) {
                window_length = l - 1 - QRS_offset_v2[n - 1];
            }
            else {
                int search = 0;

                while (window_length > 10) {
                    for (int j = 0; j < search + 1; j++){
                        start = QRS_offset_v2[n - 1] + j;
                        window = getWindow(ecg_filt, start, start + window_length);
                        window = removeMedian(window);
                        window_M = PT_M(window, Rv);
                        window = PT_phi(window, Rv);

                        double maximum = max(window, 0, window.length - 1);
                        int T_peak = maxIndex(window, 0, window.length - 1);
                        double minimum = min(window, 0, window.length - 1);
                        int T_peak2 = minIndex(window, 0, window.length - 1);
                        double max_M = max(window_M, 0, window_M.length - 1);

                        if (window_M[T_peak] == max_M) {
                            if (T_peak == 0) {
                                continue;
                            } else {
                                if (T_peak == window.length - 1) {
                                    continue;
                                } else {
                                    if (window_M[T_peak] / window_M[T_peak2] > 2.7) {
                                        T_peaks[n - 1] = T_peak + start;
                                        WavePoints Twave = waveDelineation(T_peaks[n - 1], ecg_filt_diff, frequency, 0.12);
                                        TwaveOnset[n - 1] = Twave.onset;
                                        TwaveOffset[n - 1] = Twave.offset;
                                        window_length = 0;
                                        break;
                                    } else {
                                        continue;
                                    }
                                }
                            }
                        }

                        if (window_M[T_peak2] == max_M) {
                            if (T_peak2 == 0) {
                                continue;
                            } else {
                                if (T_peak2 == window.length - 1) {
                                    continue;
                                } else {
                                    if (window_M[T_peak2] / window_M[T_peak] > 3) {
                                        T_peaks[n - 1] = T_peak2 + start;
                                        WavePoints Twave = waveDelineation(T_peaks[n - 1], ecg_filt_diff, frequency, 0.12);
                                        TwaveOnset[n - 1] = Twave.onset;
                                        TwaveOffset[n - 1] = Twave.offset;
                                        window_length = 0;
                                        break;
                                    } else {
                                        continue;
                                    }
                                }
                            }
                        }
                    }

                    window_length = window_length - 1;
                    search = search + 1;
                }
            }
        }

        for (i = 0; i < n - 1; i++) {

            int window_length = (int) Math.ceil((R_peaks_reannot[i + 1] - R_peaks_reannot[i]) * 0.5);
            if (frequency < window_length) {
                window_length = (int) frequency; //Ograničenje radi testiranja QT baze
            }

            int search = 0;

            while (window_length > 10) {
                for (int j = 0; j < search + 1; j++){
                    start = QRS_offset_v2[i] + j;
                    window = getWindow(ecg_filt, start, start + window_length);
                    window = removeMedian(window);
                    window_M = PT_M(window, Rv);
                    window = PT_phi(window, Rv);

                    double maximum = max(window, 0, window.length - 1);
                    int T_peak = maxIndex(window, 0, window.length - 1);
                    double minimum = min(window, 0, window.length - 1);
                    int T_peak2 = minIndex(window, 0, window.length - 1);
                    double max_M = max(window_M, 0, window_M.length - 1);

                    if (window_M[T_peak] == max_M) {
                        if (T_peak == 0) {
                            continue;
                        } else {
                            if (T_peak == window.length - 1) {
                                continue;
                            } else {
                                if (window_M[T_peak] / window_M[T_peak2] > 2.7) {
                                    T_peaks[i] = T_peak + start;
                                    WavePoints Twave = waveDelineation(T_peaks[i], ecg_filt_diff, frequency, 0.12);
                                    TwaveOnset[i] = Twave.onset;
                                    TwaveOffset[i] = Twave.offset;
                                    window_length = 0;
                                    break;
                                } else {
                                    continue;
                                }
                            }
                        }
                    }

                    if (window_M[T_peak2] == max_M) {
                        if (T_peak2 == 0) {
                            continue;
                        } else {
                            if (T_peak2 == window.length - 1) {
                                continue;
                            } else {
                                if (window_M[T_peak2] / window_M[T_peak] > 3) {
                                    T_peaks[i] = T_peak2 + start;
                                    WavePoints Twave = waveDelineation(T_peaks[i], ecg_filt_diff, frequency, 0.12);
                                    TwaveOnset[i] = Twave.onset;
                                    TwaveOffset[i] = Twave.offset;
                                    window_length = 0;
                                    break;
                                } else
                                    continue;
                            }
                        }
                    }
                }
                window_length = window_length - 1;
                search = search + 1;
            }
        }

        FiducialPoints.setTwavePeak(T_peaks);
        FiducialPoints.setTwaveOnset(TwaveOnset);
        FiducialPoints.setTwaveOffset(TwaveOffset);

        return FiducialPoints;
    }

    public static double calculateMeanRwaveAmplitude(double[] ecg, double frequency, int[] qrsPeak){
        int n = qrsPeak.length;

        double ecgRwaveAmplitude = 0;

        for (int i = 0; i < n; i++) {
            ecgRwaveAmplitude = ecgRwaveAmplitude + ecg[qrsPeak[i]];
        }

        ecgRwaveAmplitude = ecgRwaveAmplitude / n;

        return ecgRwaveAmplitude;
    };

    public static double[] Chebyshev_LF_70(double[] ecg, double frequency) {

        int l = ecg.length;

        double[] ecgFiltred = new double[l];
        int nfact = 3 * 100;
        double[] ecgFiltredReflection = new double[l + 2 * nfact];

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[nfact - i] = 2 * ecg[0] - ecg[0 + i];
        }

        for (int i = 0; i < l; i++) {
            ecgFiltredReflection[i + nfact] = ecg[i];
        }

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[l + nfact - 1 + i] = 2 * ecg[l - 1] - ecg[l - 1 - i];
        }

        ChebyshevII chebyshev = new ChebyshevII();
        chebyshev.lowPass(8, frequency, 70, 40);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[i] = chebyshev.filter(ecgFiltredReflection[i]);
        }

        ChebyshevII chebyshev2 = new ChebyshevII();
        chebyshev2.lowPass(8, frequency, 70, 40);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[l + 2 * nfact - i - 1] = chebyshev2.filter(ecgFiltredReflection[l + 2 * nfact - i - 1]);
        }

        for (int i = 0; i < l; i++) {
            ecgFiltred[i] = ecgFiltredReflection[i + nfact];
        }

        return ecgFiltred;
    }

    public static double[] Butter_LF_70(double[] ecg, double frequency) {

        int l = ecg.length;

        double[] ecgFiltred = new double[l];
        int nfact = 3 * 100;
        double[] ecgFiltredReflection = new double[l + 2 * nfact];

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[nfact - i] = 2 * ecg[0] - ecg[0 + i];
        }

        for (int i = 0; i < l; i++) {
            ecgFiltredReflection[i + nfact] = ecg[i];
        }

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[l + nfact - 1 + i] = 2 * ecg[l - 1] - ecg[l - 1 - i];
        }

        Butterworth butterworth = new Butterworth();
        butterworth.lowPass(8, frequency, 70);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[i] = butterworth.filter(ecgFiltredReflection[i]);
        }

        Butterworth butterworth2 = new Butterworth();
        butterworth2.lowPass(8, frequency, 70);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[l + 2 * nfact - i - 1] = butterworth2.filter(ecgFiltredReflection[l + 2 * nfact - i - 1]);
        }

        for (int i = 0; i < l; i++) {
            ecgFiltred[i] = ecgFiltredReflection[i + nfact];
        }

        return ecgFiltred;
    }

    public static double[] Butter05_20(double[] ecg, double frequency) {

        int l = ecg.length;

        double[] ecgFiltred = new double[l];
        int nfact = 3 * 100;
        double[] ecgFiltredReflection = new double[l + 2 * nfact];

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[nfact - i] = 2 * ecg[0] - ecg[0 + i];
        }

        for (int i = 0; i < l; i++) {
            ecgFiltredReflection[i + nfact] = ecg[i];
        }

        for (int i = 1; i < nfact + 1; i++) {
            ecgFiltredReflection[l + nfact - 1 + i] = 2 * ecg[l - 1] - ecg[l - 1 - i];
        }

        Butterworth butterworth = new Butterworth();
        //butterworth.lowPass(order,Samplingfreq,Cutoff frequ);
        //butterworth.highPass(order,Samplingfreq,Cutoff frequ);
        butterworth.bandPass(3,frequency,10.25,19.5);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[i] = butterworth.filter(ecgFiltredReflection[i]);
        }

        Butterworth butterworth2 = new Butterworth();
        //butterworth2.lowPass(order,Samplingfreq,Cutoff frequ);
        //butterworth2.highPass(order,Samplingfreq,Cutoff frequ);
        butterworth2.bandPass(3,frequency,10.25,19.5);

        for (int i = 0; i < l + 2 * nfact; i++) {
            ecgFiltredReflection[l + 2 * nfact - i - 1] = butterworth2.filter(ecgFiltredReflection[l + 2 * nfact - i - 1]);
        }

        for (int i = 0; i < l; i++) {
            ecgFiltred[i] = ecgFiltredReflection[i + nfact];
        }

        return ecgFiltred;
    }

    public static double[] abs(double[] x) {

        int l = x.length;

        double[] y = new double[l];

        for (int i = 0; i < l; i++) {
            y[i] = Math.abs(x[i]);
        }

        return y;
    }

    public static double[] absolute(double[] x) {
        double[] y;

        int l = x.length;

        List<Integer> ind;
        int numberOfInd = 0;

        ind = new ArrayList<Integer>();

        for(int i = 1; i < l; i++) {

            if ((x[i - 1] > 0) && (x[i] < 0)) {
                ind.add(i);
                numberOfInd++;
            }

            if ((x[i - 1] < 0) && (x[i] > 0)) {
                ind.add(i - 1);
                numberOfInd++;
            }
        }

        y = abs(x);

        for(int i = 0; i < numberOfInd; i++) {
            y[ind.get(i)] = x[ind.get(i)];
        }

        return y;
    }

    public static double[] PT_M(double[] x, double Rv) {
        int len = x.length;
        double[] y = new double[len];

        for (int i = 0; i < len; i++) {
            y[i] = Math.sqrt(Rv*Rv + x[i]*x[i]);
        }

        return y;
    }

    public static double[] PT_phi(double[] x, double Rv) {
        int len = x.length;
        double[] y = new double[len];

        for (int i = 0; i < len; i++) {
            y[i] = Math.atan2(x[i],Rv);
        }

        return y;
    }

    public static int maxIndex(double[] x, int start, int stop){
        int index = start;
        double m = x[start];

        for (int i = start + 1; i < stop + 1; i++){
            if (x[i] > m){
                m = x[i];
                index = i;
            }
        }

        return index;
    }

    public static int minIndex(double[] x, int start, int stop){
        int index = start;
        double m = x[start];

        for (int i = start + 1; i < stop + 1; i++){
            if (x[i] < m){
                m = x[i];
                index = i;
            }
        }

        return index;
    }

    public static double max(double[] x, int start, int stop){
        int index = start;
        double m = x[start];

        for (int i = start + 1; i < stop + 1; i++){
            if (x[i] > m){
                m = x[i];
                index = i;
            }
        }

        return m;
    }

    public static double min(double[] x, int start, int stop){
        int index = start;
        double m = x[start];

        for (int i = start + 1; i < stop + 1; i++){
            if (x[i] < m){
                m = x[i];
                index = i;
            }
        }

        return m;
    }

    public static double[] windowNorm(double[] x, double minimum, double maximum) {
        int len = x.length;
        double[] y = new double[len];

        for (int i = 0; i < len; i++) {
            y[i] = (x[i] - minimum)/(maximum - minimum);;
        }

        return y;
    }

    public static double[] getWindow(double[] x, int start, int stop){
        int len = stop - start + 1;
        double[] y = new double[len];

        for (int i = 0; i < len; i++) {
            y[i] = x[start + i];
        }

        return y;
    }

    public static double[] removeMedian(double[] x){
        int len = x.length;
        double median;

        double[] y = new double[len];
        double[] z = new double[len];

        for (int i = 0; i < len; i++) {
            z[i] = x[i];
        }

        Arrays.sort(z);

        median = z[len/2];

        for (int i = 0; i < len; i++) {
            y[i] = x[i] - median;
        }

        return y;
    }

    public static WavePoints waveDelineation(int wavePeak, double[] ecg_filt_diff, double frequency, double search_window) {
        WavePoints wave = new WavePoints();

        double s1;
        double s2;

        wave.peak = wavePeak;

        wave.onset = wavePeak - 1;
        s1 = ecg_filt_diff[wavePeak - 1];
        if ((wavePeak - Math.floor(search_window*frequency)) < 0) {
            while (wave.onset != 0) {
                wave.onset = wave.onset - 1;
                s2 = ecg_filt_diff[wave.onset];
                if ((s1 * s2) < 0) {
                    break;
                }
            }
        }

        else {
            while (wave.onset != wavePeak - floor(search_window * frequency)) {
                wave.onset = wave.onset - 1;
                s2 = ecg_filt_diff[wave.onset];
                if ((s1 * s2) < 0) {
                    break;
                }
            }
        }

        wave.offset = wavePeak+1;
        s1 = ecg_filt_diff[wavePeak + 1];
        if ((wavePeak + Math.floor(search_window*frequency)) >= ecg_filt_diff.length) {
            while (wave.offset != ecg_filt_diff.length - 1) {
                wave.offset = wave.offset + 1;
                s2 = ecg_filt_diff[wave.offset];
                if ((s1 * s2) < 0) {
                    break;
                }
            }
        }

        else {
            while (wave.offset != wavePeak + floor(search_window * frequency)) {
                wave.offset = wave.offset + 1;
                s2 = ecg_filt_diff[wave.offset];
                if ((s1 * s2) < 0) {
                    break;
                }
            }
        }

        return wave;
    }
}