package multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.qrsDetection;

import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;

import java.util.Arrays;

import static java.lang.Math.PI;
import static java.lang.Math.floor;

import static multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ptDetection.MartinezPT.*;
import static multisab.processing.ecgAnalysis.ecgPreprocessing.BaselineWanderRemoval.Butter_HF_05;

/**
 * This class implements Martinez PT algorithm for detection of Q and S wave.
 *
 * @author Davor Kukolja
 */

//TODO: Izbrisati, napraviti metodu u MartinezPT razredu

public class MartinezQS {

    public static ecgFiducialPoints DetectFiducialPoints(double[] ecg, double frequency, int[] R_peaks) {
        ecgFiducialPoints FiducialPoints;

        double[] M;
        double[] phi;
        double Rv;

        int l = ecg.length;
        int n = R_peaks.length;

        FiducialPoints = new ecgFiducialPoints();

        int[] qrsPeak = new int[n];
        for (int i = 0; i < n; i++) {
            qrsPeak[i] = R_peaks[i];
        }

        FiducialPoints.setQrsPeak(qrsPeak);

        double[] ecg_filt;
        ecg_filt = Butter_HF_05(ecg, frequency);
        //ecg_filt = Chebyshev_LF_70(ecg_filt, frequency);
        ecg_filt = Butter_LF_70(ecg_filt, frequency);


        int orientation;

        if (calculateMeanRwaveAmplitude(ecg_filt, frequency, R_peaks) > 0) {
            orientation = 1; // R peak is positive
        }
        else {
            orientation = 0; // R peak is negative
        }

        double[] ecg_abs;
        ecg_abs = abs(ecg_filt);

        double[] ecg_filt_sort = Arrays.copyOf(ecg_abs, ecg_abs.length);
        Arrays.sort(ecg_filt_sort);

        int m = (int) floor(0.999 * l);
        double ecg_norm = ecg_filt_sort[m];

        for (int i = 0; i < l; i++) {
            ecg_filt[i] = ecg_filt[i] / ecg_norm;
        }

        ecg_abs = absolute(ecg_filt);

        Rv = 0.001;

        M = PT_M(ecg_abs, Rv);
        phi = PT_phi(ecg_abs, Rv);


        int[] R_peaks_reannot = new int[n];

        for (int i = 0; i < n; i++) {
            int temp = R_peaks[i];
            if (phi[temp - 1] < phi[temp] && phi[temp] < phi[temp + 1]) {
                int start = temp;
                int stop = temp + 1;
                while (true) {
                    if (phi[stop] < phi[temp]) {
                        break;
                    }
                    if (stop == l - 1) {
                        break;
                    }
                    stop = stop + 1;
                }
                int R_peak = maxIndex(M, start, stop);
                R_peaks_reannot[i] = R_peak;
            } else {
                if (phi[temp - 1] > phi[temp] && phi[temp] > phi[temp + 1]) {
                    int stop = temp;
                    int start = temp - 1;
                    while (true) {
                        if (phi[start] < phi[temp]) {
                            break;
                        }
                        if (start == 0) {
                            break;
                        }
                        start = start - 1;
                    }
                    int R_peak = maxIndex(M, start, stop);
                    R_peaks_reannot[i] = R_peak;
                } else {
                    R_peaks_reannot[i] = R_peaks[i];
                }
            }
        }


        int[] gamma_QRS_minus = new int[n];
        int[] gamma_QRS_plus = new int[n];

        double thr = 0.25 * PI / 2;
        double max_gamma_QRS_minus = 0.1 * frequency;
        double max_gamma_QRS_plus = 0.1 * frequency;

        int temp;
        int i;

        for (i = 0; i < n; i++) {
            temp = R_peaks_reannot[i] - 1;
            while (true) {
                if (phi[temp] < thr) {
                    break;
                }
                if (temp == 0) {
                    break;
                }
                temp = temp - 1;
            }
            gamma_QRS_minus[i] = temp;

            if ((R_peaks_reannot[i] - temp) > max_gamma_QRS_minus) {
                while ((R_peaks_reannot[i] - temp) > max_gamma_QRS_minus) {
                    thr = thr + 0.05 * PI / 2;
                    temp = R_peaks_reannot[i] - 1;
                    while (true) {
                        if (phi[temp] < thr) {
                            break;
                        }
                        if (temp == 0) {
                            break;
                        }
                        temp = temp - 1;
                    }
                    gamma_QRS_minus[i] = temp;
                }
                thr = 0.25 * PI / 2;
            }

            temp = R_peaks_reannot[i] + 1;
            while (true) {
                if (phi[temp] < thr) {
                    break;
                }
                if (temp == l - 1) {
                    break;
                }
                temp = temp + 1;
            }
            gamma_QRS_plus[i] = temp;

            if ((temp - R_peaks_reannot[i]) > max_gamma_QRS_plus) {
                while ((temp - R_peaks_reannot[i]) > max_gamma_QRS_plus) {
                    thr = thr + 0.05 * PI / 2;
                    temp = R_peaks_reannot[i] + 1;
                    while (true) {
                        if (phi[temp] < thr) {
                            break;
                        }
                        if (temp == l) {
                            break;
                        }
                        temp = temp + 1;
                    }
                    gamma_QRS_plus[i] = temp;
                }
                thr = 0.25 * PI / 2;
            }
        }


        int[] QRS_onset_v1 = new int[n];
        int[] QRS_offset_v1 = new int[n];

        int[] SwavePeak = new int[n];
        int[] QwavePeak = new int[n];

        boolean[] SwaveAbsence = new boolean[n];
        boolean[] QwaveAbsence = new boolean[n];

        Rv = 0.005;

        double[] window;
        double[] window_M;

        ecg_abs = abs(ecg_filt);

        double temp2;
        int maximum_ind = 0; //TODO
        int local_maximum;

        // Prvi R peak

        i = 0;
        int start = gamma_QRS_minus[i] - (int) floor(0.035 * frequency);
        if (start < 1) {
            QRS_onset_v1[i] = Integer.MIN_VALUE;
            QwaveAbsence[i] = true;
            QwavePeak[i] = Integer.MIN_VALUE;
        } else {
            window = getWindow(ecg_abs, start, gamma_QRS_minus[i]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                QwaveAbsence[i] = true;
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[i]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v1[i] = ind;
                QwavePeak[i] = ind;
            } else {
                QwaveAbsence[i] = false;
                QwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v1[i] = maximum_ind + start;
                } else {
                    QRS_onset_v1[i] = local_maximum + start;
                }
            }
        }

        for (i = 1; i < n; i++) {

            start = gamma_QRS_minus[i] - (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, gamma_QRS_minus[i]);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = window.length - 1;
            while (true) {
                if (local_maximum == 0) {
                    break;
                }
                if (window[local_maximum - 1] < window[local_maximum]) {
                    break;
                }
                local_maximum = local_maximum - 1;
            }

            if (local_maximum == 0) {
                QwaveAbsence[i] = true;
                int ind = start;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind - 2] - ecg_filt[ind - 4]) - Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]));
                for (int j = start + 1; j < gamma_QRS_minus[i]; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j - 2] - ecg_filt[j - 4]) - Math.atan(ecg_filt[j] - ecg_filt[j - 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_onset_v1[i] = ind;
                QwavePeak[i] = ind;
            } else {
                QwaveAbsence[i] = false;
                QwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[QwavePeak[i]];
                    for (int j = local_maximum + start; j <= R_peaks_reannot[i]; j++){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            QwavePeak[i] = j;
                        }
                    }
                }
                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, 0, local_maximum) < 0.5) {
                    int flag = 0;
                    for (int j = 0; j < local_maximum; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_onset_v1[i] = maximum_ind + start;
                } else {
                    QRS_onset_v1[i] = local_maximum + start;
                }
            }
        }

        FiducialPoints.setQrsOnset(QRS_onset_v1);
        FiducialPoints.setQwavePeak(QwavePeak);
        FiducialPoints.setQwaveAbsence(QwaveAbsence);

        // Zadnji R peak

        i = n - 1;
        start = gamma_QRS_plus[i];
        if ((start + floor(0.055 * frequency)) > ecg_abs.length - 1){
            QRS_offset_v1[i] = -1;
            SwaveAbsence[i] = true;
            SwavePeak[i] = Integer.MIN_VALUE;
        }
        else {
            int window_end = start + (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                SwaveAbsence[i] = true;
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v1[i] = ind;
                SwavePeak[i] = ind;
            }
            else {
                SwaveAbsence[i] = false;
                SwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window, local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v1[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v1[i] = local_maximum + start;
                }
            }
        }

        for (i = 0; i < n - 1; i++) {
            start = gamma_QRS_plus[i];
            int window_end = start + (int) floor(0.035 * frequency);
            window = getWindow(ecg_abs, start, window_end);
            window = removeMedian(window);
            window_M = PT_M(window, Rv);
            window = PT_phi(window, Rv);

            local_maximum = 0;
            while (true) {
                if (local_maximum == window.length - 1) {
                    break;
                }
                if (window[local_maximum] > window[local_maximum + 1]) {
                    break;
                }
                local_maximum = local_maximum + 1;
            }

            if (local_maximum == window.length - 1) {
                SwaveAbsence[i] = true;
                int ind = start + 1;
                double max_diff = Math.abs(Math.atan(ecg_filt[ind] - ecg_filt[ind - 2]) - Math.atan(ecg_filt[ind + 2] - ecg_filt[ind])) - Math.abs(Math.atan(ecg_filt[ind + 2] - ecg_filt[ind]) - Math.atan(ecg_filt[ind + 4] - ecg_filt[ind + 2]));
                for (int j = start + 2; j < window_end + 1; j++) {
                    double diff = Math.abs(Math.atan(ecg_filt[j] - ecg_filt[j - 2]) - Math.atan(ecg_filt[j + 2] - ecg_filt[j])) - Math.abs(Math.atan(ecg_filt[j + 2] - ecg_filt[j]) - Math.atan(ecg_filt[j + 4] - ecg_filt[j + 2]));
                    if (diff > max_diff) {
                        max_diff = diff;
                        ind = j;
                    }
                }
                QRS_offset_v1[i] = ind;
                SwavePeak[i] = ind;
            }
            else {
                SwaveAbsence[i] = false;
                SwavePeak[i] = local_maximum + start;
                if (orientation == 1) {
                    double minimum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value <= minimum) {
                            minimum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }
                else {
                    double maximum = ecg_filt[SwavePeak[i]];
                    for (int j = local_maximum + start; j >= R_peaks_reannot[i]; j--){
                        double value = ecg_filt[j];
                        if (value >= maximum) {
                            maximum = value;
                            SwavePeak[i] = j;
                        }
                    }
                }

                double maximum = max(window, 0, window.length - 1);
                double minimum = min(window, 0, window.length - 1);
                window = windowNorm(window, minimum, maximum);

                if (min(window,local_maximum, window.length - 1) < 0.5) {
                    int flag = 0;
                    for (int j = local_maximum + 1; j < window.length; j++) {
                        if (window[j] < 0.5) {
                            if (flag == 0) {
                                flag = 1;
                                maximum = window_M[j];
                                maximum_ind = j;
                            } else {
                                temp2 = window_M[j];
                                if (temp2 > maximum) {
                                    maximum = temp2;
                                    maximum_ind = j;
                                }
                            }
                        }
                    }
                    QRS_offset_v1[i] = maximum_ind + start;
                }
                else {
                    QRS_offset_v1[i] = local_maximum + start;
                }
            }
        }

        FiducialPoints.setQrsOffset(QRS_offset_v1);
        FiducialPoints.setSwavePeak(SwavePeak);
        FiducialPoints.setSwaveAbsence(SwaveAbsence);

        return FiducialPoints;
    }

}