package multisab.processing.machineLearning;

import multisab.processing.machineLearning.discretization.CACC;
import multisab.processing.machineLearning.discretization.Discretization;
import org.encog.Encog;
import org.encog.util.csv.ReadCSV;

import java.io.File;
import java.util.Arrays;

import static org.encog.util.csv.CSVFormat.DECIMAL_POINT;

public class IrisDiscretizationMain {

    public void run(String[] args) {

        try {
/*
            double in[][] = new double[150][4];
            String out[] = new String[150];
            int classes[] = new int[150];

            File sourceFile = new File("E:/iris.csv");
            ReadCSV csv = new ReadCSV(sourceFile, false, DECIMAL_POINT);

            String[] line = new String[4];
            int i = 0;

            while(csv.next()) {
                in[i][0] = Double.parseDouble(csv.get(0));
                in[i][1] = Double.parseDouble(csv.get(1));
                in[i][2] = Double.parseDouble(csv.get(2));
                in[i][3] = Double.parseDouble(csv.get(3));
                out[i] = csv.get(4);
                if (out[i].equals("Iris-setosa")) {
                    classes[i] = 0;
                }
                if (out[i].equals("Iris-versicolor")) {
                    classes[i] = 1;
                }
                if (out[i].equals("Iris-virginica")) {
                    classes[i] = 2;
                }
                i++;
            }



            csv.close();
            csv = new ReadCSV(sourceFile, false, DECIMAL_POINT);
*/
/*
            double in[] = {3, 5, 6, 15, 17, 21, 35, 45, 46, 51, 56, 57, 66, 70, 71};
            int classes[] = {0, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 0, 0, 0};
*/

            double in[][] = {
                    {0, 34},
                    {0.1, 23},
                    {0.2, 12},
                    {0.3, 32},
                    {0.4, 21},
                    {0.4, 2},
                    {0.5, 35},
                    {0.5, 67},
                    {0.6, 64},
                    {0.6, 21},
                    {0.7, 74},
                    {0.8, 14},
                    {0.9, 26},
                    {1.0, 73},
                    {1.0, 84},
                    {1.1, 35},
                    {1.1, 25},
                    {1.1, 68},
                    {1.2, 87},
                    {1.3, 65},
                    {1.3, 36},
                    {1.3, 24},
                    {1.4, 87},
                    {1.5, 65},
                    {1.5, 43},
                    {1.6, 34},
                    {1.7, 234},
                    {1.7, 23},
                    {1.7, 23},
                    {1.8, 78},
                    {1.9, 34},
                    {2.0, 27},
                    {2.1, 87}
                    };
            int classes[] = {0, 2, 0, 0, 0, 1, 0, 2, 0, 2, 2, 1, 2, 0, 1, 2, 1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1};

            CACC cacc = new CACC();
            Discretization discretization = cacc.caccDiscretization(in, classes);

            int[][] discretizeData = discretization.discretizeData(in);

            for(int ii = 0; ii<in.length; ii++) {
                StringBuilder result = new StringBuilder();

                for(int j = 0; j<in[0].length; j++) {
                    result.append(Integer.toString(discretizeData[ii][j]));
                    result.append(" ");
                }

                //result.append(Integer.toString(discretizeData[ii]));
                System.out.println(result.toString());
            }


            Encog.getInstance().shutdown();

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        IrisDiscretizationMain prg = new IrisDiscretizationMain();
        prg.run(args);
    }
}