package multisab.processing.machineLearning.RFcore;

import java.util.List;

public class ParallelTreeBuildThread extends Thread{
	
	private Dataset sample;
	private int maxDepth;
	private int minSize; 
	private int nFeatures; 
	private List <Node> trees;
	private RandomForest alg;
	
	public ParallelTreeBuildThread(Dataset sample, int maxDepth, int minSize, int nFeatures, List <Node> trees, RandomForest alg){
		this.sample = sample;
		this.maxDepth = maxDepth;
		this.minSize = minSize;
		this.nFeatures = nFeatures;
		this.trees = trees;
		this.alg = alg;
		
	}
	
	public void run(){
		
		//System.out.println("dretva: "+this.getId());
		
		Node tree = alg.buildTree(sample, this.maxDepth, this.minSize, this.nFeatures);
		trees.add(tree);
		
	}

}
