package multisab.processing.machineLearning.discretization;

//import

/**
 * @author Davor Kukolja
 */
public class Discretization {
    private double[][] discretizationScheme;

    public Discretization(int N){
        discretizationScheme = new double[N][];
    }

    public void setDiscretizationScheme(int ind, double[] sheme) {
        discretizationScheme[ind] = sheme;
    }

    public double[] getDiscretizationScheme(int ind) {
        return discretizationScheme[ind];
    }

    public int[] discretizeData(double[] data) {
        int M = data.length;

        double[] sheme = discretizationScheme[0];

        int numberDiscreteValues = sheme.length + 1;

        // Discretize the continuous data
        int[] discreteData = new int[M];

        for (int i = 0; i < M; i++) {
            discreteData[i] = numberDiscreteValues - 1;
            for (int t = 0; t < sheme.length; t++) {
                if (data[i] <= sheme[t]) {
                    discreteData[i] = t;
                    break;
                }
            }
        }

        return discreteData;
    }

    public int[][] discretizeData(double[][] data) {
        int[][] discreteData = new int[data.length][data[0].length];

        for (int j = 0; j < data[0].length; j++) {
            double[] sheme = discretizationScheme[j];
            int numberDiscreteValues = sheme.length + 1;
            for (int i = 0; i < data.length; i++) {
                discreteData[i][j] = numberDiscreteValues - 1;
                for (int t = 0; t < sheme.length; t++) {
                    if (data[i][j] <= sheme[t]) {
                        discreteData[i][j] = t;
                        break;
                    }
                }
            }
        }
        return discreteData;
    }
}
