package multisab.processing.machineLearning.featureSelection;

public class ContingencyTable {
	
	/**
	 * Metoda generira kontigencijsku tablicu za dane atribute.
	 * Retke i stupce redom zauzimaju vrijednosti labela onim redosljedom kojim
	 * su dodavane u lisu labela atributa.
	 * 
	 * @param a1 - prvi atribut (vrijednosti po redovima)
	 * @param a2 - drugi atribut (vrijednosti po stupcima)
	 * @return kontingencijska tablica
	 */

	public static int[] generateTable(int[] a1, int number1, int[] a2, int number2) {
		int[] table = new int[number1*number2];

		for(int i = 0, columns = number2, n = a1.length; i < n; i++) {
			table[a1[i] * columns + a2[i]]++;
		}

		return table;
	}

	/**
	 * Metoda generira marginalnu tablicu za dani atribut.
	 * Frekvencije pojavljivanja za svaku vrijednost atributa.
	 * Ignoriraju se nepoznate vrijednosti!!
	 * 
	 * @param atr - atribut za koji gradimo tablicu
	 * @return marginalna tablica za dani atribut
	 */

	public static int[] boundaryTable(int[] atr, int number) {
		int[] column = new int[number];

		for(int i = 0; i<atr.length; i++) {
			column[atr[i]] += 1;
		}

		return column;
	}


	public static double entropy(int[] attr, int number) {
		double entropy = 0;
		double sum = 0;

		double n = attr.length;

		int[] counter = new int[number];

		for(int i = 0; i < n; i++) {
			counter[attr[i]] += 1;
		}

		for(int i = 0; i < number; i++) {
			int row = counter[i];
			double p = row/n;
			if(p > 0) {
				entropy -= p*Math.log(p);
				sum +=p;
			}
		}

		//nemamo logaritam po bazi 2 u Math
		return (entropy + Math.log(sum)) / (sum*Math.log(2));
	}

	/**
	 * Metoda izračunava uvjetnu entropiju H(x|y).
	 * 
	 * @param conditional - tablica uvijetnih vjerovatnosti p(x|y)
	 * @param boundaryColumns - tablica marginalnih vjerovatnosti po stupcima
	 * @param size - ukupni broj zapisa
	 * @return uvijetna entropija H(x|y)
	 */

	public static double conditionalEntropyColumns(double[] conditional, int[] boundaryColumns, double size) {
		double entropy = 0;
		double sum = 0;
		double e = 0;
		
		for(int i = 0, n = conditional.length/boundaryColumns.length; i < boundaryColumns.length; i++) {
			sum = 0;
			e = 0;
			
			for(int j = 0; j < n; j++) {
				double x = conditional[j*boundaryColumns.length +i];
				if(x > 0) {
					sum -= x*Math.log(x);
					e += x;
				}
			}
			
			if(e > 0) {
				entropy += (boundaryColumns[i]/size) * (sum + Math.log(e)) / (e*Math.log(2));
			}
		}
		
		return entropy;
	}

	/**
	 * Metoda generira tablicu uvijetnih vijerovatnosti p(x|y) 
	 * x = vrijednosti po retcima, y = vrijednosti po stupcima.
	 * 
	 * @param contingencyTable - kontingencijska tablica
	 * @param boundaryColumns - tablica marginalnih vjerovatnosti po stupcima
	 * @param rows - broj redaka
	 * @param columns - broj stupaca
	 * @return tablica uvijetnih vjerovatnosti
	 */

	public static double[] generateConditionalTableOverColumns(int[] contingencyTable, int[] boundaryColumns, int rows, int columns) {
		double[] table = new double[contingencyTable.length];
		
		for(int i = 0; i < rows; i++) {
			for(int j = 0; j < columns; j++) {
				int n = i*columns + j;
				table[n] = contingencyTable[n] / (double)boundaryColumns[j];
			}
		}
		
		return table;
	}
	
	//TODO dodati metodu koja direktno izracunava conditionalEntropy
}
