package multisab.processing.machineLearning.featureSelection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Ranker {

	private List<RankingInput> inputs;
	
	public Ranker() {
		inputs = new ArrayList<>();
	}

	public void addInput(Integer index, Double value) {
		inputs.add(new RankingInput(index, value));
	}
	
	public List<RankingInput> getInputs() {
		Collections.sort(inputs);
		return inputs;
	}
	
	public static class RankingInput implements Comparable<RankingInput>{
		private Integer index;
		private Double value;
		
		public RankingInput(Integer index, Double value) {
			this.index = index;
			this.value = value;
		}
		
		public Double getValue() {
			return value;
		}
		
		public Integer getIndex() {
			return index;
		}

		@Override
		public int compareTo(RankingInput o) {
			 return o.value.compareTo(value);
		}
		
		@Override
		public String toString() {
			return String.format("Feature %d: %5f",index, value);
		}
	}
}
