package multisab.processing.machineLearning.normalization;

/**
 * Created by Davor on 6.10.2016..
 */
public class Normalization {

    private double normalizationMin;
    private double normalizationMax;
    double min[];
    double max[];

    public Normalization(double normalizationMin, double normalizationMax) {
        this.normalizationMin = normalizationMin;
        this.normalizationMax = normalizationMax;
    }

    // Analyze the data, determine the min/max of every column.
    public void analyze(double[][] features) {

        int numberOfSamples = features.length;
        int numberOfFeatures = features[0].length;

        min = new double[numberOfFeatures];
        max = new double[numberOfFeatures];

        for (int i = 0; i < numberOfFeatures; i++) {
            min[i] = features[0][i];
            max[i] = features[0][i];
            for (int j = 1; j < numberOfSamples; j++) {
                if (features[j][i] < min[i]) {
                    min[i] = features[j][i];
                }
                if (features[j][i] > max[i]) {
                    max[i] = features[j][i];
                }
            }
        }
    }

    // Data normalization.
    public double[][] normalization(double[][] features) {

        int numberOfSamples = features.length;
        int numberOfFeatures = features[0].length;

        double normFeatures[][] = new double[numberOfSamples][numberOfFeatures];

        for(int i = 0; i < numberOfFeatures; i++)
        {
            for (int j = 0; j < numberOfSamples; j++) {
                normFeatures[j][i] = (features[j][i] - min[i]) * (normalizationMax - normalizationMin) / (max[i] - min[i]) + normalizationMin;
                /*
                Added here because weird results may occur
                 */
                if (Double.isNaN(normFeatures[j][i])){
                    normFeatures[j][i] = 0.0;
                }
            }
        }
        return normFeatures;
    }

}
