package multisab.processing.preprocessing.filtering;

/**
 * Implements method filterSginal
 * filterSignal returns filtered signal x with digital filter with given
 * numerator and denominator b and a.
 * Formula: y[n] = - sum(ak*y(n-k)) + sum(bk*x(n-k);
 * y[n] length is L + M -1 due to convolution
 *
 *
 * @input signal signal
 * @input a filter denominator
 * @input b filter numerator
 *
 * @author Krešimir Friganović
 * @date: 9.11.2016.
 *
 *
 */

public class Filter {
    public static double[] filterSignal(double[] signal, double[] b, double[] a) {

        int N = b.length;
        int M = a.length;
        int L = signal.length;
        double sumB = 0;
        double sumA = 0;
        double y[] = new double[2 * L + N - 1];
        double x[] = new double[L];
        double[] signal2 = new double[2 * L];


        for (int s = 0; s < L; s++) {
            signal2[s] = signal[s];
        }

        int es = 0;
        for (int s = L; s < 2 * L; s++) {
            signal2[s] = signal[es];
            es++;
        }


        for (int k = 0; k < signal2.length; k++) {

            sumB = 0;
            sumA = 0;

            //Računanje sume b(n)*x(k-n)
            for (int n = 0; n < N; n++) {
                if (n > k) {
                    break;

                } else {
                    sumB += b[n] * signal2[k - n];
                }
            }
            //Računanje sume a(m)*y(k-m)
            for (int m = 1; m < M; m++) {
                if (m > k) {
                    break;
                } else {
                    sumA += a[m] * y[k - m];
                }

            }

            //Računanje y[n]
            y[k] = (sumB - sumA);
            y[k] = y[k] / a[0];


        }
        es = 0;
        for (int j = L; j < 2 * L; j++) {
            x[es] = y[j];
            es++;
        }

        return x;

    }
}


