package multisab.processing.analysis;
import multisab.processing.machineLearning.EvaluationMeasures;
import multisab.processing.machineLearning.ModelEvaluation;
import multisab.processing.machineLearning.RFcore.*;
import multisab.processing.machineLearning.TrainTestSet;
import multisab.processing.multisabException.FeatureReadingException;
import multisab.processing.multisabException.ModelingException;
import multisab.processing.machineLearning.Classifier;


import java.io.File;
import java.util.*;

public class PerformModeling {

    //TODO: implement this general case method
    public static boolean executeModeling(String featureVectorsFilePath, String featureSelectionFilePath, String modelFilePath, String classificationResultsFilePath, String evaluationMethod, String holdoutPercentage, int kFolds, boolean first, boolean last, int goalIndex, String[] selectedModelingMethods, String[] parametersAndValues, boolean useSelectedFeatures, boolean parallelizeModeling, boolean saveModelToFile) throws ModelingException{

        boolean modelingResultsSaved = false;
        double percentageForTraining = 0.0;
        double temp;
        if (!holdoutPercentage.equals("")){
            percentageForTraining = 0.01 * Double.parseDouble(holdoutPercentage);
        }
        Classifier classifier;
        EvaluationMeasures evaluation;

        for (int i = 0; i<selectedModelingMethods.length; i++){
            switch (selectedModelingMethods[i]){
                case ModelingMethod.MLP:
                    try {
                        classifier = new Classifier(Classifier.FEEDFORWARD,ExtractedFeatures.readNumberOfClassesFromFeatureVectorsFile(featureVectorsFilePath,last,goalIndex));
                        if (evaluationMethod.equals("Holdout")){
                            String [] resultClassifications;
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            classifier.train(trainTestSet.getTrainSet(),trainTestSet.getTrainSetClassesLabels());
                            resultClassifications = classifier.classifyToString(trainTestSet.getTestSet());
                            //if (saveModelToFile){  // remove the comments when you manage to resolve saveTrainedModelToFile error: "Do not know how to persist object: Normalization"
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            evaluation = new EvaluationMeasures(Classifier.FEEDFORWARD, trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            String [][] foldsResultClassifications = new String[kFolds][];
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }
                            TrainTestSet [] jFoldTrainTest = new TrainTestSet[kFolds];
                            for (int j = 0; j < kFolds; j++){
                                jFoldTrainTest[j] = trainTestSet.formTrainTestSetForFoldNumber(j);
                                classifier.train(jFoldTrainTest[j].getTrainSet(),jFoldTrainTest[j].getTrainSetClassesLabels()/*ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,last,goalIndex)*/);
                                foldsResultClassifications[j] = classifier.classifyToString(jFoldTrainTest[j].getTestSet());
                            }
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            String [][] foldsTestSetLabels = new String[kFolds][];
                            for (int j = 0; j < kFolds; j++){
                                foldsTestSetLabels[j] = jFoldTrainTest[j].getTestSetClassesLabels();
                            }
                            evaluation = new EvaluationMeasures(Classifier.FEEDFORWARD, foldsTestSetLabels, foldsResultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("Train only")){
                            classifier.train(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,false),ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,true, -1));
                            classifier.saveTrainedModelToFile(modelFilePath);
                        }
                    }
                    catch (FeatureReadingException exc){
                        throw new ModelingException(exc.getMessage());
                    }
                    break;
                case ModelingMethod.RBF_NETWORK:
                    try {
                        classifier = new Classifier(Classifier.RBFNETWORK,ExtractedFeatures.readNumberOfClassesFromFeatureVectorsFile(featureVectorsFilePath,last,goalIndex));
                        if (evaluationMethod.equals("Holdout")){
                            String [] resultClassifications;
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            classifier.train(trainTestSet.getTrainSet(),trainTestSet.getTrainSetClassesLabels());
                            resultClassifications = classifier.classifyToString(trainTestSet.getTestSet());
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            evaluation = new EvaluationMeasures(Classifier.RBFNETWORK, trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            String [][] foldsResultClassifications = new String[kFolds][];
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }
                            TrainTestSet [] jFoldTrainTest = new TrainTestSet[kFolds];
                            for (int j = 0; j < kFolds; j++){
                                jFoldTrainTest[j] = trainTestSet.formTrainTestSetForFoldNumber(j);
                                classifier.train(jFoldTrainTest[j].getTrainSet(),jFoldTrainTest[j].getTrainSetClassesLabels()/*ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,last,goalIndex)*/);
                                foldsResultClassifications[j] = classifier.classifyToString(jFoldTrainTest[j].getTestSet());
                            }
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            String [][] foldsTestSetLabels = new String[kFolds][];
                            for (int j = 0; j < kFolds; j++){
                                foldsTestSetLabels[j] = jFoldTrainTest[j].getTestSetClassesLabels();
                            }
                            evaluation = new EvaluationMeasures(Classifier.RBFNETWORK, foldsTestSetLabels, foldsResultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("Train only")){
                            classifier.train(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,false),ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,true, -1));
                            classifier.saveTrainedModelToFile(modelFilePath);
                        }
                    }
                    catch (FeatureReadingException exc){
                        throw new ModelingException(exc.getMessage());
                    }
                    break;
                case ModelingMethod.SVM:
                    try {
                        classifier = new Classifier(Classifier.SVM,ExtractedFeatures.readNumberOfClassesFromFeatureVectorsFile(featureVectorsFilePath,last,goalIndex));
                        if (evaluationMethod.equals("Holdout")){
                            String [] resultClassifications;
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            classifier.train(trainTestSet.getTrainSet(),trainTestSet.getTrainSetClassesLabels());
                            resultClassifications = classifier.classifyToString(trainTestSet.getTestSet());
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            evaluation = new EvaluationMeasures(Classifier.SVM, trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            String [][] foldsResultClassifications = new String[kFolds][];
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }
                            TrainTestSet [] jFoldTrainTest = new TrainTestSet[kFolds];
                            for (int j = 0; j < kFolds; j++){
                                jFoldTrainTest[j] = trainTestSet.formTrainTestSetForFoldNumber(j);
                                classifier.train(jFoldTrainTest[j].getTrainSet(),jFoldTrainTest[j].getTrainSetClassesLabels()/*ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,last,goalIndex)*/);
                                foldsResultClassifications[j] = classifier.classifyToString(jFoldTrainTest[j].getTestSet());
                            }
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            String [][] foldsTestSetLabels = new String[kFolds][];
                            for (int j = 0; j < kFolds; j++){
                                foldsTestSetLabels[j] = jFoldTrainTest[j].getTestSetClassesLabels();
                            }
                            evaluation = new EvaluationMeasures(Classifier.SVM, foldsTestSetLabels, foldsResultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("Train only")){
                            classifier.train(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,false),ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,true, -1));
                            classifier.saveTrainedModelToFile(modelFilePath);
                        }
                    }
                    catch (FeatureReadingException exc){
                        throw new ModelingException(exc.getMessage());
                    }
                    break;
                case ModelingMethod.NEAT:
                    try {
                        classifier = new Classifier(Classifier.NEAT,ExtractedFeatures.readNumberOfClassesFromFeatureVectorsFile(featureVectorsFilePath,last,goalIndex));
                        if (evaluationMethod.equals("Holdout")){
                            String [] resultClassifications;
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            classifier.train(trainTestSet.getTrainSet(),trainTestSet.getTrainSetClassesLabels());
                            resultClassifications = classifier.classifyToString(trainTestSet.getTestSet());
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            evaluation = new EvaluationMeasures(Classifier.NEAT, trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            String [][] foldsResultClassifications = new String[kFolds][];
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }
                            TrainTestSet [] jFoldTrainTest = new TrainTestSet[kFolds];
                            for (int j = 0; j < kFolds; j++){
                                jFoldTrainTest[j] = trainTestSet.formTrainTestSetForFoldNumber(j);
                                classifier.train(jFoldTrainTest[j].getTrainSet(),jFoldTrainTest[j].getTrainSetClassesLabels()/*ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,last,goalIndex)*/);
                                foldsResultClassifications[j] = classifier.classifyToString(jFoldTrainTest[j].getTestSet());
                            }
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            String [][] foldsTestSetLabels = new String[kFolds][];
                            for (int j = 0; j < kFolds; j++){
                                foldsTestSetLabels[j] = jFoldTrainTest[j].getTestSetClassesLabels();
                            }
                            evaluation = new EvaluationMeasures(Classifier.NEAT, foldsTestSetLabels, foldsResultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("Train only")){
                            classifier.train(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,false),ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,true, -1));
                            classifier.saveTrainedModelToFile(modelFilePath);
                        }
                    }
                    catch (FeatureReadingException exc){
                        throw new ModelingException(exc.getMessage());
                    }
                    break;
                case ModelingMethod.PNN:
                    try {
                        classifier = new Classifier(Classifier.PNN,ExtractedFeatures.readNumberOfClassesFromFeatureVectorsFile(featureVectorsFilePath,last,goalIndex));
                        if (evaluationMethod.equals("Holdout")){
                            String [] resultClassifications;
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            classifier.train(trainTestSet.getTrainSet(),trainTestSet.getTrainSetClassesLabels());
                            resultClassifications = classifier.classifyToString(trainTestSet.getTestSet());
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            evaluation = new EvaluationMeasures(Classifier.PNN, trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            String [][] foldsResultClassifications = new String[kFolds][];
                            TrainTestSet trainTestSet;
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }
                            TrainTestSet [] jFoldTrainTest = new TrainTestSet[kFolds];
                            for (int j = 0; j < kFolds; j++){
                                jFoldTrainTest[j] = trainTestSet.formTrainTestSetForFoldNumber(j);
                                classifier.train(jFoldTrainTest[j].getTrainSet(),jFoldTrainTest[j].getTrainSetClassesLabels()/*ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,last,goalIndex)*/);
                                foldsResultClassifications[j] = classifier.classifyToString(jFoldTrainTest[j].getTestSet());
                            }
                            //if (saveModelToFile){
                            //    classifier.saveTrainedModelToFile(modelFilePath);
                            //}
                            String [][] foldsTestSetLabels = new String[kFolds][];
                            for (int j = 0; j < kFolds; j++){
                                foldsTestSetLabels[j] = jFoldTrainTest[j].getTestSetClassesLabels();
                            }
                            evaluation = new EvaluationMeasures(Classifier.PNN, foldsTestSetLabels, foldsResultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;
                        }
                        else if (evaluationMethod.equals("Train only")){
                            classifier.train(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,false),ExtractedFeatures.readClassesFromFeatureVectorsFileAsStrings(featureVectorsFilePath,true, -1));
                            classifier.saveTrainedModelToFile(modelFilePath);
                        }
                    }
                    catch (FeatureReadingException exc){
                        throw new ModelingException(exc.getMessage());
                    }
                    break;
                case ModelingMethod.RF:
                    try {

                        double[][] features = ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true);
                        TrainTestSet trainTestSet;
                        String [] resultClassifications;

                        if (evaluationMethod.equals("Holdout")){
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(features, percentageForTraining,first,System.currentTimeMillis(),last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);

                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(features, percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }

                            //create train dataset
                            Dataset trainDS = new Dataset();
                            for(int n=0; n<trainTestSet.getTrainSet().length; n++){
                                ArrayList<Field> fields = new ArrayList<>();
                                for (int j=0; j<trainTestSet.getTrainSet()[0].length; j++){
                                    RealValField rvf = new RealValField(j);
                                    rvf.setValue(trainTestSet.getTrainSet()[n][j]);
                                    fields.add(rvf);
                                }
                                CategoryField cf = new CategoryField(n);
                                //check if dictionary list is empty
                                if(trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length)==null){
                                    trainDS.dictionaries.put(trainTestSet.getTrainSet()[0].length, new HashMap<Integer, String>());
                                }
                                Map dict = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length);
                                if(	dict.containsValue(trainTestSet.getTrainSetClassesLabels()[n])){
                                    int key = Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]));
                                }
                                else{
                                    dict.put(dict.keySet().size(), trainTestSet.getTrainSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]));
                                }
                                fields.add(cf);
                                Entry e = new Entry();
                                e.setFields(fields);
                                trainDS.addNewEntry(e);
                            }

                            //create test dataset
                            Dataset testDS = new Dataset();
                            for(int n=0; n<trainTestSet.getTestSet().length; n++){
                                ArrayList<Field> fields = new ArrayList<>();
                                for (int j=0; j<trainTestSet.getTestSet()[0].length; j++){
                                    RealValField rvf = new RealValField(j);
                                    rvf.setValue(trainTestSet.getTestSet()[n][j]);
                                    fields.add(rvf);
                                }
                                CategoryField cf = new CategoryField(n);
                                Map dict = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length); //dohvati dictionairy od train seta (mora biti isti dictionary)
                                if(	dict.containsValue(trainTestSet.getTestSetClassesLabels()[n])){
                                    int key = Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]));
                                }
                                else{
                                    dict.put(dict.keySet().size(), trainTestSet.getTestSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]));
                                }
                                fields.add(cf);
                                Entry e = new Entry();
                                e.setFields(fields);
                                testDS.addNewEntry(e);
                                testDS.dictionaries = trainDS.dictionaries; // must have same dictionairies


                            }

                            Integer maxDepth = 10000;
                            Integer minSize = 1;
                            Double sampleSize = 1.0;
                            Integer nTrees = 100;

                            //Do random forest evaluation
                            List<String> params = new ArrayList<>();
                            /*params.add(parametersAndValues[0]);
                            params.add(parametersAndValues[1]);
                            params.add(parametersAndValues[2]);
                            params.add(parametersAndValues[3]);*/
                            params.add(maxDepth.toString());
                            params.add(minSize.toString());
                            params.add(sampleSize.toString());
                            params.add(nTrees.toString());

                            Integer nrFeatures=(int)Math.sqrt((trainDS.getEntries().get(0).getFields().size()-1));
                            params.add(nrFeatures.toString());

                            List<Object> scores = new ArrayList<>();
                            List<Object> predictedRes = new ArrayList<>();

                            Algorithm rf = new RandomForest(params);
                            predictedRes.addAll( rf.execute(trainDS, testDS));


                            resultClassifications = new String[predictedRes.size()];
                            for(int k= 0; k< predictedRes.size(); k++){
                                resultClassifications[k] = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length).get(predictedRes.get(k));

                            }
                            evaluation = new EvaluationMeasures("RANDOM FOREST", trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;

                            //TODO: save model to file
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            //TODO
                            if (!useSelectedFeatures) {
                                //
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }

                            //TODO: save model to file

                        }
                        else if (evaluationMethod.equals("Train only")){
                            //TODO
                        }


                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }

                    break;


                case ModelingMethod.EXT:
                    try {

                        double[][] features = ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, true);
                        TrainTestSet trainTestSet;
                        String [] resultClassifications;

                        if (evaluationMethod.equals("Holdout")){
                            if (!useSelectedFeatures) {
                                trainTestSet = ModelEvaluation.holdout(features, percentageForTraining,first,System.currentTimeMillis(),last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);

                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.holdout(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.holdout(features, percentageForTraining, first, System.currentTimeMillis(), last, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath), true);
                                }
                            }

                            //create train dataset
                            Dataset trainDS = new Dataset();
                            for(int n=0; n<trainTestSet.getTrainSet().length; n++){
                                ArrayList<Field> fields = new ArrayList<>();
                                for (int j=0; j<trainTestSet.getTrainSet()[0].length; j++){
                                    RealValField rvf = new RealValField(j);
                                    rvf.setValue(trainTestSet.getTrainSet()[n][j]);
                                    fields.add(rvf);
                                }
                                CategoryField cf = new CategoryField(n);
                                //check if dictionary list is empty
                                if(trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length)==null){
                                    trainDS.dictionaries.put(trainTestSet.getTrainSet()[0].length, new HashMap<Integer, String>());
                                }
                                Map dict = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length);
                                if(	dict.containsValue(trainTestSet.getTrainSetClassesLabels()[n])){
                                    int key = Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]));
                                }
                                else{
                                    dict.put(dict.keySet().size(), trainTestSet.getTrainSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTrainSetClassesLabels()[n]));
                                }
                                fields.add(cf);
                                Entry e = new Entry();
                                e.setFields(fields);
                                trainDS.addNewEntry(e);
                            }

                            //create test dataset
                            Dataset testDS = new Dataset();
                            for(int n=0; n<trainTestSet.getTestSet().length; n++){
                                ArrayList<Field> fields = new ArrayList<>();
                                for (int j=0; j<trainTestSet.getTestSet()[0].length; j++){
                                    RealValField rvf = new RealValField(j);
                                    rvf.setValue(trainTestSet.getTestSet()[n][j]);
                                    fields.add(rvf);
                                }
                                CategoryField cf = new CategoryField(n);
                                Map dict = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length); //dohvati dictionairy od train seta (mora biti isti dictionary)
                                if(	dict.containsValue(trainTestSet.getTestSetClassesLabels()[n])){
                                    int key = Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]));
                                }
                                else{
                                    dict.put(dict.keySet().size(), trainTestSet.getTestSetClassesLabels()[n]);
                                    cf.setValue(Entry.getKey(dict, trainTestSet.getTestSetClassesLabels()[n]));
                                }
                                fields.add(cf);
                                Entry e = new Entry();
                                e.setFields(fields);
                                testDS.addNewEntry(e);
                                testDS.dictionaries = trainDS.dictionaries; // must have same dictionairies


                            }

                            Integer maxDepth = 10000;
                            Integer minSize = 1;
                            Double sampleSize = 1.0;
                            Integer nTrees = 100;

                            //Do extratrees evaluation
                            List<String> params = new ArrayList<>();
                            /*params.add(parametersAndValues[0]);
                            params.add(parametersAndValues[1]);
                            params.add(parametersAndValues[2]);
                            params.add(parametersAndValues[3]);*/
                            params.add(maxDepth.toString());
                            params.add(minSize.toString());
                            params.add(sampleSize.toString());
                            params.add(nTrees.toString());

                            Integer nrFeatures=(int)Math.sqrt((trainDS.getEntries().get(0).getFields().size()-1));
                            params.add(nrFeatures.toString());

                            List<Object> scores = new ArrayList<>();
                            List<Object> predictedRes = new ArrayList<>();

                            Algorithm ext = new ExtraTrees(params);
                            predictedRes.addAll( ext.execute(trainDS, testDS));


                            resultClassifications = new String[predictedRes.size()];
                            for(int k= 0; k< predictedRes.size(); k++){
                                resultClassifications[k] = trainDS.dictionaries.get(trainTestSet.getTrainSet()[0].length).get(predictedRes.get(k));

                            }

                            evaluation = new EvaluationMeasures("EXTRA TREES", trainTestSet.getTestSetClassesLabels(), resultClassifications, PerformModeling.getUniqueClasses(ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath)));
                            evaluation.constructConfusionMatrixAndDetermineMetrics();
                            evaluation.saveClassificationResultsToFile(classificationResultsFilePath,true,evaluationMethod,holdoutPercentage, kFolds, first);
                            modelingResultsSaved = true;

                            //TODO: save model to file
                        }
                        else if (evaluationMethod.equals("kFoldCrossValidation")){
                            //TODO
                            if (!useSelectedFeatures) {
                                //
                            }
                            else {
                                int [] selectedFeatures = FeatureSelectionResults.loadSelectedFeatureIndicesFromFile(featureSelectionFilePath);
                                if (selectedFeatures[0] != -1) {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath, selectedFeatures, true), kFolds, first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                                else {
                                    trainTestSet = ModelEvaluation.kFoldCrossValidation(ExtractedFeatures.readNumericExtractedFeatures(featureVectorsFilePath,true),kFolds,first, System.currentTimeMillis(), last, goalIndex, ExtractedFeatures.readExtractedDisorders(featureVectorsFilePath),true);
                                }
                            }

                            //TODO: save model to file

                        }
                        else if (evaluationMethod.equals("Train only")){
                            //TODO
                        }


                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                default:
                    throw new ModelingException("Unknown or unsupported modeling method");
            }

        }
        return modelingResultsSaved;
    }

    private static String [] getUniqueClasses (String [] allClasses){
        Set<String> uniqueClasses = new HashSet<>();

        for (int i = 0; i < allClasses.length; i++) {
            if (!uniqueClasses.contains(allClasses[i])) {
                uniqueClasses.add(allClasses[i]);
            }
        }
        String [] uniqueClassesField = new String[uniqueClasses.size()];
        Iterator<String> it = uniqueClasses.iterator();
        int i = 0;
        while (it.hasNext()){
            uniqueClassesField[i] = it.next();
            i++;
        }
        return uniqueClassesField;
    }

    private static double accuracyMetric(Dataset actual, List<Object> predicted){
        int correct = 0;
        int resIndex = actual.getEntries().get(0).getFields().size() -1;

        for(int i=0; i< actual.getEntries().size(); i++){
            Integer actValue = (Integer) actual.getEntries().get(i).getFields().get(resIndex).getValue();
            Integer predValue = (Integer) predicted.get(i);
            if (actValue.intValue() == ((Integer) predicted.get(i)).intValue()){
                correct +=1;
            }
        }

        return (double)correct/((double)actual.getEntries().size());
    }

}
