package multisab.processing.analysis.expertSystem;

import multisab.processing.analysis.Features;

import java.util.ArrayList;
import java.util.List;

import multisab.processing.analysis.ModelingMethod;
import multisab.processing.analysis.PreprocessingMethod;
import multisab.processing.scenarios.Scenarios;

public class ExpertSystem {
    public boolean [] analysisGoals;
    public boolean [] dataAvailable;
    public boolean [] scenario;
    public boolean [] segmentLength;

    public ExpertSystem(){
        analysisGoals = new boolean[ExpertSystem.ANALYSIS_GOAL_NUMBER_OF_OPTIONS];
        dataAvailable = new boolean[ExpertSystem.DATA_AVAILABLE_NUMBER_OF_OPTIONS];
        segmentLength = new boolean[ExpertSystem.SEGMENT_LENGTH_NUMBER_OF_OPTIONS];
        scenario = new boolean[ExpertSystem.SCENARIO_NUMBER_OF_OPTIONS];
        for(int i = 0; i<analysisGoals.length; i++){
            analysisGoals[i] = false;
        }
        for(int i = 0; i<dataAvailable.length; i++){
            dataAvailable[i] = false;
        }
        for(int i = 0; i<segmentLength.length; i++){
            segmentLength[i] = false;
        }
        for(int i = 0; i<scenario.length; i++) {
            scenario[i] = false;
        }
    }

    public void addAnalysisGoal(int analysisGoal){
        this.analysisGoals[analysisGoal] = true;
    }
    public void setAnalysisGoals(boolean [] analysisGoals){
        for(int i = 0; i<4; i++){
            this.analysisGoals[i] = analysisGoals[i];
        }
    }
    public void addDataAvailable(int dataAvailable){
        this.dataAvailable[dataAvailable] = true;
    }
    public void setDataAvailable(boolean [] dataAvailable){
        for(int i = 0; i<4; i++){
            this.dataAvailable[i] = dataAvailable[i];
        }
    }
    public void setSegmentLength(int segmentLength){
        this.segmentLength[segmentLength] = true;
    }

    public Features getRecommendedFeatures(){
        Features features = new Features();
        if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_ECG] && this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_DETECTION]){
            if (this.scenario[ExpertSystem.SCENARIO_ACUTE_MYOCARDIAL_ISCHEMIA]){
                features.addFeature(Features.ECG_J_POINT_AMPLITUDE);
                features.addFeature(Features.ECG_R_S_RATIO);
                features.addFeature(Features.ECG_T_WAVE_AMPLITUDE);
                features.addFeature(Features.ECG_ST_SEGMENT_SLOPE);
            }
            else if (this.scenario[ExpertSystem.SCENARIO_ATRIAL_FIBRILLATION]){
                features.addFeature(Features.ECG_P_WAVE_ABSENCE);
                features.addFeature(Features.ECG_QRS_COMPLEX_DURATION);
                if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_HRV]){
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_24_H]){
                        features.addFeature(Features.HRV_TOTAL_PWR);
                        features.addFeature(Features.HRV_VLF);
                        features.addFeature(Features.POWER_LAW_EXPONENT_ALPHA);
                    }
                    else if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_5_MIN]){
                        features.addFeature(Features.HRV_1_AVNN);
                        features.addFeature(Features.HRV_SDNN);
                        features.addFeature(Features.HRV_RMSSD);
                        features.addFeature(Features.HRV_PNN50);
                        features.addFeature(Features.HRV_LF);
                        features.addFeature(Features.HRV_HF);
                        features.addFeature(Features.HRV_LF_HF_RATIO);
                        features.addFeature(Features.AP_EN);
                        features.addFeature(Features.SAMP_EN);
                    }
                }
            }
            else if (this.scenario[ExpertSystem.SCENARIO_CONGESTIVE_HEART_FAILURE]){
                features.addFeature(Features.ECG_Q_WAVE_AMPLITUDE);
                features.addFeature(Features.ECG_PR_INTERVAL_DURATION);
                features.addFeature(Features.ECG_P_WAVE_AMPLITUDE);
                features.addFeature(Features.ECG_R_WAVE_AMPLITUDE);
                features.addFeature(Features.ECG_QRS_COMPLEX_DURATION);
                features.addFeature(Features.ECG_QT_QTc_RATIO);
                features.addFeature(Features.ECG_ST_SEGMENT_SLOPE);
                features.addFeature(Features.ECG_S_WAVE_DURATION);  // in leads I,V5,V6,V1,V2
                features.addFeature(Features.ECG_R_WAVE_DURATION);  // in leads V5,V6
                if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_HRV]){
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_24_H]){
                        features.addFeature(Features.HRV_VLF);
                        features.addFeature(Features.POWER_LAW_EXPONENT_ALPHA);
                    }
                    else if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_5_MIN]){
                        features.addFeature(Features.HRV_1_AVNN);
                        features.addFeature(Features.HRV_SDNN);
                        features.addFeature(Features.DFA_ALPHA1);
                        features.addFeature(Features.HRV_LF);
                    }
                }
            }

        }
        if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_HRV] && !this.dataAvailable[ExpertSystem.DATA_AVAILABLE_ECG]){
            if (this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_CLASSIFICATION]){
                if (this.scenario[ExpertSystem.SCENARIO_CARDIAC_ARRHYTHMIA]){
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_20_s]) {
                        features.addFeature(Features.HRV_AVNN);
                        features.addFeature(Features.HRV_SDNN);
                        features.addFeature(Features.HRV_RMSSD);
                        features.addFeature(Features.HRV_SDSD);
                        features.addFeature(Features.HRV_PNN50);
                        features.addFeature(Features.HRV_HRV_TRIANGULAR_INDEX);
                        features.addFeature(Features.HRV_TINN);
                        features.addFeature(Features.HRV_LF);
                        features.addFeature(Features.HRV_HF);
                        features.addFeature(Features.HRV_LF_HF_RATIO);
                        features.addFeature(Features.ALPHABET_ENTROPY);
                    }
                }
            }
            else if (this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_DETECTION]){
                if (this.scenario[ExpertSystem.SCENARIO_CONGESTIVE_HEART_FAILURE]){
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_24_H]) {
                        features.addFeature(Features.HRV_VLF);
                        features.addFeature(Features.HRV_LF_HF_RATIO);
                        features.addFeature(Features.HRV_STANDARD_DEVIATION_RATIO);
                        features.addFeature(Features.HRV_SDANN);
                        features.addFeature(Features.POWER_LAW_EXPONENT_ALPHA);
                        features.addFeature(Features.CORRELATION_DIMENSION);
                        features.addFeature(Features.HURST_EXPONENT);
                        features.addFeature(Features.LARGEST_LYAPUNOV_EXPONENT);
                        features.addFeature(Features.HEART_RATE_TURBULENCE_ONSET);
                        features.addFeature(Features.HEART_RATE_TURBULENCE_SLOPE);
                        features.addFeature(Features.DFA_ALPHA2);
                        features.addFeature(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                        features.addFeature(Features.SAMP_EN); // multiscale
                    }
                    else if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_5_MIN]) {
                        features.addFeature(Features.HRV_RMSSD);
                        features.addFeature(Features.HRV_TINN);
                        features.addFeature(Features.HRV_LF);
                        features.addFeature(Features.HRV_HF);
                        features.addFeature(Features.HRV_LF_HF_RATIO);
                        features.addFeature(Features.HRV_TOTAL_PWR);
                        features.addFeature(Features.DFA_ALPHA1);
                        features.addFeature(Features.DFA_ALPHA2);
                        features.addFeature(Features.AUTOCORRELATION_COEFFICIENT);
                        features.addFeature(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                        features.addFeature(Features.ALPHABET_ENTROPY);
                    }
                }
            }
        }
        return features;
    }

    public static List<String> getDefinedPreprocessingMethodsForScenario(String scenario, String dataType){
        List<String> definedPreprocessingMethods = new ArrayList<>();

        switch (scenario){
            case (Scenarios.AMI_DETECTION_HR):
                definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                break;
            case (Scenarios.AMI_DETECTION_EN):
                definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
            case (Scenarios.CHF_DETECTION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.CHF_DETECTION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.AF_DETECTION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.AF_DETECTION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.AMI_CLASSIFICATION_HR):
                definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                break;
            case (Scenarios.AMI_CLASSIFICATION_EN):
                definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                break;
            case (Scenarios.CHF_CLASSIFICATION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.CHF_CLASSIFICATION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.AF_CLASSIFICATION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.AF_CLASSIFICATION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.ALL_AVAILABLE_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_HR):
                definedPreprocessingMethods.add(PreprocessingMethod.BURG);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_EN):
                definedPreprocessingMethods.add(PreprocessingMethod.BURG);
                break;
            case (Scenarios.EPILEPSY_DETECTION_HR):
                definedPreprocessingMethods.add(PreprocessingMethod.BURG);
                break;
            case (Scenarios.EPILEPSY_DETECTION_EN):
                definedPreprocessingMethods.add(PreprocessingMethod.BURG);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.R_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.R_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_HR):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.R_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_EN):
                if (dataType.contains("ECG")) {
                    definedPreprocessingMethods.add(PreprocessingMethod.R_PEAKS_DETECTION_ECG);
                }
                definedPreprocessingMethods.add(PreprocessingMethod.LOMB_SCARGLE);
                break;
            default:
                break;
        }
        return definedPreprocessingMethods;
    }

    public static List<String> getDefinedModelingMethodsForScenario(String scenario, String dataType){
        List<String> definedModelingMethods = new ArrayList<>();

        // razmisliti da se na neke (sve?) detection scenarije predloži droolsov detection expert system, dotad klasifikatori
        switch (scenario){
            case (Scenarios.AMI_DETECTION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AMI_DETECTION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
            case (Scenarios.CHF_DETECTION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.CHF_DETECTION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AF_DETECTION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AF_DETECTION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AMI_CLASSIFICATION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AMI_CLASSIFICATION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.CHF_CLASSIFICATION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.CHF_CLASSIFICATION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AF_CLASSIFICATION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.AF_CLASSIFICATION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.EPILEPSY_DETECTION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.EPILEPSY_DETECTION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_HR):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_EN):
                definedModelingMethods.add(ModelingMethod.SVM);
                break;
            default:
                break;
        }
        return definedModelingMethods;
    }


    public static List<String> getDefinedFeaturesForScenario(String scenario, String dataType){
        List<String> definedFeatures = new ArrayList<>();

        switch (scenario){
            case (Scenarios.AMI_DETECTION_HR):
                definedFeatures.add(Features.ECG_J_POINT_AMPLITUDE);
                definedFeatures.add(Features.ECG_R_S_RATIO);
                definedFeatures.add(Features.ECG_T_WAVE_AMPLITUDE);
                definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                break;
            case (Scenarios.AMI_DETECTION_EN):
                definedFeatures.add(Features.ECG_J_POINT_AMPLITUDE);
                definedFeatures.add(Features.ECG_R_S_RATIO);
                definedFeatures.add(Features.ECG_T_WAVE_AMPLITUDE);
                definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                break;
            case (Scenarios.CHF_DETECTION_HR):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_Q_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_PR_INTERVAL_DURATION);
                    definedFeatures.add(Features.ECG_P_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_R_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                    definedFeatures.add(Features.ECG_QT_QTc_RATIO);
                    definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                    definedFeatures.add(Features.ECG_S_WAVE_DURATION);
                    definedFeatures.add(Features.ECG_R_WAVE_DURATION);
                }
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.DFA_ALPHA1); // implementirati specificno ekstrakciju za ALPHA_1 i ALPHA_2
                definedFeatures.add(Features.HRV_LF);
                break;
            case (Scenarios.CHF_DETECTION_EN):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_Q_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_PR_INTERVAL_DURATION);
                    definedFeatures.add(Features.ECG_P_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_R_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                    definedFeatures.add(Features.ECG_QT_QTc_RATIO);
                    definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                    definedFeatures.add(Features.ECG_S_WAVE_DURATION);
                    definedFeatures.add(Features.ECG_R_WAVE_DURATION);
                }
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.HRV_LF);
                break;
            case (Scenarios.AF_DETECTION_HR):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_P_WAVE_ABSENCE);
                    definedFeatures.add(Features.ECG_FIBRILATORY_RATE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                }
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.AP_EN);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.AF_DETECTION_EN):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_P_WAVE_ABSENCE);
                    definedFeatures.add(Features.ECG_FIBRILATORY_RATE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                }
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.AP_EN);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.AMI_CLASSIFICATION_HR):
                definedFeatures.add(Features.ECG_J_POINT_AMPLITUDE);
                definedFeatures.add(Features.ECG_R_S_RATIO);
                definedFeatures.add(Features.ECG_T_WAVE_AMPLITUDE);
                definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                break;
            case (Scenarios.AMI_CLASSIFICATION_EN):
                definedFeatures.add(Features.ECG_J_POINT_AMPLITUDE);
                definedFeatures.add(Features.ECG_R_S_RATIO);
                definedFeatures.add(Features.ECG_T_WAVE_AMPLITUDE);
                definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                break;
            case (Scenarios.CHF_CLASSIFICATION_HR):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_Q_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_PR_INTERVAL_DURATION);
                    definedFeatures.add(Features.ECG_P_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_R_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                    definedFeatures.add(Features.ECG_QT_QTc_RATIO);
                    definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                    definedFeatures.add(Features.ECG_S_WAVE_DURATION);
                    definedFeatures.add(Features.ECG_R_WAVE_DURATION);
                }
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.HRV_LF);
                break;
            case (Scenarios.CHF_CLASSIFICATION_EN):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_Q_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_PR_INTERVAL_DURATION);
                    definedFeatures.add(Features.ECG_P_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_R_WAVE_AMPLITUDE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                    definedFeatures.add(Features.ECG_QT_QTc_RATIO);
                    definedFeatures.add(Features.ECG_ST_SEGMENT_SLOPE);
                    definedFeatures.add(Features.ECG_S_WAVE_DURATION);
                    definedFeatures.add(Features.ECG_R_WAVE_DURATION);
                }
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.HRV_LF);
                break;
            case (Scenarios.AF_CLASSIFICATION_HR):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_P_WAVE_ABSENCE);
                    definedFeatures.add(Features.ECG_FIBRILATORY_RATE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                }
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.AP_EN);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.AF_CLASSIFICATION_EN):
                if (dataType.contains("ECG")) {
                    definedFeatures.add(Features.ECG_P_WAVE_ABSENCE);
                    definedFeatures.add(Features.ECG_FIBRILATORY_RATE);
                    definedFeatures.add(Features.ECG_QRS_COMPLEX_DURATION);
                }
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.HRV_1_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.AP_EN);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_HR):
                definedFeatures.add(Features.EEG_ALPHA_BAND);
                definedFeatures.add(Features.EEG_BETA_BAND);
                definedFeatures.add(Features.EEG_DELTA_BAND);
                definedFeatures.add(Features.EEG_GAMMA_BAND);
                definedFeatures.add(Features.EEG_THETA_BAND);
                definedFeatures.add(Features.EEG_TOTAL_PWR);
                definedFeatures.add(Features.EEG_SPECT_EN);
                definedFeatures.add(Features.EEG_MEAN);
                definedFeatures.add(Features.EEG_STANDARD_DEVIATION);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF_NORM);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF_NORM);
                break;
            case (Scenarios.EPILEPSY_CLASSIFICATION_EN):
                definedFeatures.add(Features.EEG_ALPHA_BAND);
                definedFeatures.add(Features.EEG_BETA_BAND);
                definedFeatures.add(Features.EEG_DELTA_BAND);
                definedFeatures.add(Features.EEG_GAMMA_BAND);
                definedFeatures.add(Features.EEG_THETA_BAND);
                definedFeatures.add(Features.EEG_TOTAL_PWR);
                definedFeatures.add(Features.EEG_SPECT_EN);
                definedFeatures.add(Features.EEG_MEAN);
                definedFeatures.add(Features.EEG_STANDARD_DEVIATION);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF_NORM);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF_NORM);
                break;
            case (Scenarios.EPILEPSY_DETECTION_HR):
                definedFeatures.add(Features.EEG_ALPHA_BAND);
                definedFeatures.add(Features.EEG_BETA_BAND);
                definedFeatures.add(Features.EEG_DELTA_BAND);
                definedFeatures.add(Features.EEG_GAMMA_BAND);
                definedFeatures.add(Features.EEG_THETA_BAND);
                definedFeatures.add(Features.EEG_TOTAL_PWR);
                definedFeatures.add(Features.EEG_SPECT_EN);
                definedFeatures.add(Features.EEG_MEAN);
                definedFeatures.add(Features.EEG_STANDARD_DEVIATION);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF_NORM);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF_NORM);
                break;
            case (Scenarios.EPILEPSY_DETECTION_EN):
                definedFeatures.add(Features.EEG_ALPHA_BAND);
                definedFeatures.add(Features.EEG_BETA_BAND);
                definedFeatures.add(Features.EEG_DELTA_BAND);
                definedFeatures.add(Features.EEG_GAMMA_BAND);
                definedFeatures.add(Features.EEG_THETA_BAND);
                definedFeatures.add(Features.EEG_TOTAL_PWR);
                definedFeatures.add(Features.EEG_SPECT_EN);
                definedFeatures.add(Features.EEG_MEAN);
                definedFeatures.add(Features.EEG_STANDARD_DEVIATION);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_FIRST_DIFF_NORM);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF);
                definedFeatures.add(Features.EEG_MEAN_OF_SECOND_DIFF_NORM);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_HR):
                definedFeatures.add(Features.HRV_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_SDSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_HRV_TRIANGULAR_INDEX);
                definedFeatures.add(Features.HRV_TINN);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.ALPHABET_ENTROPY);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.DFA_ALPHA2);
                definedFeatures.add(Features.AUTOCORRELATION_COEFFICIENT);
                definedFeatures.add(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                definedFeatures.add(Features.HRV_STANDARD_DEVIATION_RATIO);
                definedFeatures.add(Features.LARGEST_LYAPUNOV_EXPONENT);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.ARRHYTHMIA_CLASSIFICATION_EN):
                definedFeatures.add(Features.HRV_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_SDSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_HRV_TRIANGULAR_INDEX);
                definedFeatures.add(Features.HRV_TINN);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.ALPHABET_ENTROPY);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.DFA_ALPHA2);
                definedFeatures.add(Features.AUTOCORRELATION_COEFFICIENT);
                definedFeatures.add(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                definedFeatures.add(Features.HRV_STANDARD_DEVIATION_RATIO);
                definedFeatures.add(Features.LARGEST_LYAPUNOV_EXPONENT);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_HR):
                definedFeatures.add(Features.HRV_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_SDSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_HRV_TRIANGULAR_INDEX);
                definedFeatures.add(Features.HRV_TINN);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.ALPHABET_ENTROPY);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.DFA_ALPHA2);
                definedFeatures.add(Features.AUTOCORRELATION_COEFFICIENT);
                definedFeatures.add(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                definedFeatures.add(Features.HRV_STANDARD_DEVIATION_RATIO);
                definedFeatures.add(Features.LARGEST_LYAPUNOV_EXPONENT);
                definedFeatures.add(Features.SAMP_EN);
                break;
            case (Scenarios.ARRHYTHMIA_DETECTION_EN):
                definedFeatures.add(Features.HRV_AVNN);
                definedFeatures.add(Features.HRV_SDNN);
                definedFeatures.add(Features.HRV_RMSSD);
                definedFeatures.add(Features.HRV_SDSD);
                definedFeatures.add(Features.HRV_PNN50);
                definedFeatures.add(Features.HRV_HRV_TRIANGULAR_INDEX);
                definedFeatures.add(Features.HRV_TINN);
                definedFeatures.add(Features.HRV_LF);
                definedFeatures.add(Features.HRV_HF);
                definedFeatures.add(Features.HRV_LF_HF_RATIO);
                definedFeatures.add(Features.HRV_TOTAL_PWR);
                definedFeatures.add(Features.ALPHABET_ENTROPY);
                definedFeatures.add(Features.DFA_ALPHA1);
                definedFeatures.add(Features.DFA_ALPHA2);
                definedFeatures.add(Features.AUTOCORRELATION_COEFFICIENT);
                definedFeatures.add(Features.HAAR_WAVELET_STANDARD_DEVIATION);
                definedFeatures.add(Features.HRV_STANDARD_DEVIATION_RATIO);
                definedFeatures.add(Features.LARGEST_LYAPUNOV_EXPONENT);
                definedFeatures.add(Features.SAMP_EN);
                break;
            default:
                break;
        }
        return definedFeatures;
    }




    public Features getAdditionalFeatures() {
        Features features = new Features();
        if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_ECG] && this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_DETECTION]){
            if (this.scenario[ExpertSystem.SCENARIO_ACUTE_MYOCARDIAL_ISCHEMIA]){
                features.addFeature(Features.ECG_J_POINT_AMPLITUDE_STDEV);
                features.addFeature(Features.ECG_QTV_NORM);
                features.addFeature(Features.ECG_QTVI);
                if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_HRV]) {
                    features.addFeature(Features.HRV_LF);
                    features.addFeature(Features.HRV_HF);
                }
            }
            else if (this.scenario[ExpertSystem.SCENARIO_ATRIAL_FIBRILLATION]) {
                features.addFeature(Features.ECG_TQ_INTERVAL_WE);
                features.addFeature(Features.ECG_TQ_INTERVAL_RWE);
            }
        }
        if (this.dataAvailable[ExpertSystem.DATA_AVAILABLE_HRV] && !this.dataAvailable[ExpertSystem.DATA_AVAILABLE_ECG]){
            if (this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_CLASSIFICATION]) {
                if (this.scenario[ExpertSystem.SCENARIO_CARDIAC_ARRHYTHMIA]) {
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_20_s]) {
                        features.addFeature(Features.AP_EN);
                        features.addFeature(Features.HRV_STANDARD_DEVIATION_RATIO);
                        features.addFeature(Features.LARGEST_LYAPUNOV_EXPONENT);
                        features.addFeature(Features.SAMP_EN);
                        features.addFeature(Features.DFA_ALPHA1);
                        features.addFeature(Features.RECURRENCE_PLOT);
                        features.addFeature(Features.HRV_PNN20);
                        features.addFeature(Features.FANO_FACTOR);
                        features.addFeature(Features.ALLAN_FACTOR);
                    }
                }
            }
            else if (this.analysisGoals[ExpertSystem.ANALYSIS_GOAL_DETECTION]) {
                if (this.scenario[ExpertSystem.SCENARIO_CONGESTIVE_HEART_FAILURE]) {
                    if (this.segmentLength[ExpertSystem.SEGMENT_LENGTH_5_MIN]) {
                        features.addFeature(Features.HRV_AVNN);
                        features.addFeature(Features.HRV_SDNN);
                        features.addFeature(Features.HRV_HRV_TRIANGULAR_INDEX);
                        features.addFeature(Features.AP_EN);
                    }
                }
            }
        }
        return features;
    }
    // modify this part if necessary
    private static final int ANALYSIS_GOAL_NUMBER_OF_OPTIONS = 4;
    private static final int DATA_AVAILABLE_NUMBER_OF_OPTIONS = 4;
    private static final int SEGMENT_LENGTH_NUMBER_OF_OPTIONS = 3;
    private static final int SCENARIO_NUMBER_OF_OPTIONS = 4;

    // modify this part if necessary
    public static final int ANALYSIS_GOAL_CLASSIFICATION = 0;
    public static final int ANALYSIS_GOAL_DETECTION = 1;
    public static final int ANALYSIS_GOAL_PREDICTION = 2;
    public static final int ANALYSIS_GOAL_INSPECTION_AND_VISUALIZATION = 3;

    // modify this part if necessary
    public static final int DATA_AVAILABLE_ECG = 0;
    public static final int DATA_AVAILABLE_EEG = 1;
    public static final int DATA_AVAILABLE_EMG = 2;
    public static final int DATA_AVAILABLE_HRV = 3;

    // modify this part if necessary
    public static final int SEGMENT_LENGTH_5_MIN = 0;
    public static final int SEGMENT_LENGTH_24_H = 1;
    public static final int SEGMENT_LENGTH_20_s = 2;

    // modify this part if necessary
    public static final int SCENARIO_ACUTE_MYOCARDIAL_ISCHEMIA = 0;
    public static final int SCENARIO_ATRIAL_FIBRILLATION = 1;
    public static final int SCENARIO_CONGESTIVE_HEART_FAILURE = 2;
    public static final int SCENARIO_CARDIAC_ARRHYTHMIA = 3;
}
