/*
 * Created on 2006.04.28
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package multisab.processing.commonSignalFeatures.nonlinear.phaseSpace;
import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;
/**
 * @author Jovic
 * @version Ovaj razred ima funkciju računanja indeksa prostorne popunjenosti za danu
 *          matricu podataka, prema autorima Oliver Faust, Rajendra Acharya U, SM Krishnan and Lim Choo Min,
 * objavljeno u: BioMedical Engineering OnLine 2004, dostupno na:  http://www.biomedical-engineering-online.com/content/3/1/30 .
 */
public class SpatialFillingIndex {
    public static final int MINIMAL_LENGTH_FOR_EXTRACTION = 5;
    public static final int DEFAULT_PHASE_SPACE_DIMENSION = 2;

    public static double calculateSpatialFillingIndex(double [] segment, int dimension, int lag, int finesse){
        double[][] aMatrix = new double[segment.length-lag][dimension];
        for (int g=0; g<segment.length-dimension*lag+1; g++){
            for (int n=0; n<dimension; n++){
                aMatrix[g][n] = segment[g+n*lag];
            }
        }
        double max2 = Statistics.maximum(segment);
        double[][] bMatrix;    // matrica B algoritma SFI
        double[][] cMatrix; // matrica C (ujedno i P i Q) algoritma SFI
        bMatrix = new double[aMatrix.length][aMatrix[0].length];
        //this.finesse = finesse;

        // Računanje matrice B
        for (int i = 0; i < aMatrix.length; i++) {
            for (int j = 0; j < aMatrix[i].length; j++) {
                bMatrix[i][j] = aMatrix[i][j] / max2;
            }
        }
        cMatrix = new double[finesse][finesse];
        for (int i = 0; i < finesse; i++) {
            for (int j = 0; j < finesse; j++) {
                cMatrix[i][j] = 0;
            }
        }
        // Računanje matrice C - broja točaka koje padaju u (i,j). kvadrat.
        double xStart, yStart, xEnd, yEnd;
        boolean found = false;
        for (int i = 0; i < finesse; i++) {
            for (int j = 0; j < finesse; j++) {
                xStart = -1 + (double) (2 * i) / finesse;
                xEnd = -1 + (double) (2 * (i + 1)) / finesse;
                yStart = -1 + (double) (2 * j) / finesse;
                yEnd = -1 + (double) (2 * (j + 1)) / finesse;
                for (int k = 0; k < bMatrix.length; k++) {
                    found = false;
                    for (int l = 0; l < bMatrix[k].length; l++) {
                        if (l == 0) {
                            if (bMatrix[k][l] >= xStart && bMatrix[k][l] < xEnd) {
                                found = true;
                            }
                        } else {
                            if (found) {
                                if (bMatrix[k][l] >= yStart && bMatrix[k][l] < yEnd) {
                                    cMatrix[i][j]++;
                                }
                            }
                        }
                    }
                }
            }
        }
        double sum = 0;

        for (int i = 0; i < finesse; i++) {
            for (int j = 0; j < finesse; j++) {
                sum += cMatrix[i][j];
            }
        }
        // Određivanje elemenata matrice P i Q odjednom.
        for (int i = 0; i < finesse; i++) {
            for (int j = 0; j < finesse; j++) {
                cMatrix[i][j] /= sum;    //pMatrix
                cMatrix[i][j] = Math.pow(cMatrix[i][j], 2.0); //qMatrix
            }
        }
        sum = 0;
        // Računanje sume "s" iz matrice Q
        for (int i = 0; i < finesse; i++) {
            for (int j = 0; j < finesse; j++) {
                sum += cMatrix[i][j];
            }
        }
        //this.sumS = sum;
        // Određivanje SFI-a
        return 1000*sum / Math.pow(finesse, 2);  // Da bi indeks bio > 1, inače je reda 10e-3.
    }
}
