package multisab.processing.ecgAnalysis;

import multisab.processing.commonSignalFeatures.timeDomain.statisticMeasure.Statistics;
import multisab.processing.ecgAnalysis.ecgFiducialPointsDetection.ecgFiducialPoints;

/**
 * Main class for ECG morphological multisab.processing.analysis
 *
 * @author Davor Kukolja
 */

//TODO: Vidjeti da li je potrebna normalizacija EKG signala ili će uvijek svi signali biti iz iste baze podataka ili imati jednake physicalMin, physicalMax, digitalMin i digitalMax

public class MorphologicalAnalysisECG {

    public static double MorphologicalAnalysisECG(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcgRwaveAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsPeak[] = FiducialPoints.getQrsPeak();
        int n = qrsPeak.length;

        double ecgRwaveAmplitude = 0;

        for (int i = 0; i < n; i++) {
            ecgRwaveAmplitude = ecgRwaveAmplitude + ecg[qrsPeak[i]];
        }

        ecgRwaveAmplitude = Math.abs(ecgRwaveAmplitude / n);

        return ecgRwaveAmplitude;
    };

    public static double calculateEcgQRScomplexDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsOnset[] = FiducialPoints.getQrsOnset();
        int qrsOffset[] = FiducialPoints.getQrsOffset();
        int n = qrsOnset.length;

        double ecgQRScomplexDuration = 0;

        for (int i = 0; i < n; i++) {
            ecgQRScomplexDuration = ecgQRScomplexDuration + qrsOffset[i] - qrsOnset[i];
        }

        ecgQRScomplexDuration = ecgQRScomplexDuration / frequency / n;

        return ecgQRScomplexDuration;
    };

    public static double calculateEcgPwaveAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int PwavePeak[] = FiducialPoints.getPwavePeak();
        int n = 0;

        double ecgPwaveAmplitude = 0;

        if (PwavePeak[0] == Integer.MIN_VALUE) {
            n++;
        }
        else {
            if (PwavePeak[0] >= 0) {
                ecgPwaveAmplitude = ecgPwaveAmplitude + ecg[PwavePeak[0]];
                n++;
            }
        }

        for (int i = 1; i < PwavePeak.length; i++) {
            if (PwavePeak[i] != Integer.MIN_VALUE) {
                ecgPwaveAmplitude = ecgPwaveAmplitude + ecg[PwavePeak[i]];
            }
            n++;
        }

        ecgPwaveAmplitude = ecgPwaveAmplitude / n;

        return ecgPwaveAmplitude;
    };

    public static double calculateEcgPwaveAbsence(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcgPwaveDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int PwaveOnset[] = FiducialPoints.getPwaveOnset();
        int PwaveOffset[] = FiducialPoints.getPwaveOffset();
        int n = 0;

        double ecgPwaveDuration = 0;

        for (int i = 0; i < PwaveOnset.length; i++) {
            if (PwaveOnset[i] != Integer.MIN_VALUE) {
                ecgPwaveDuration = ecgPwaveDuration + PwaveOffset[i] - PwaveOnset[i];
                n++;
            }
        }

        ecgPwaveDuration = ecgPwaveDuration / frequency / n;

        return ecgPwaveDuration;
    };

    public static double calculateEcgTwaveAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int TwavePeak[] = FiducialPoints.getTwavePeak();
        int l = ecg.length;
        int n = 0;
        int i;

        double ecgTwaveAmplitude = 0;

        for (i = 0; i < TwavePeak.length - 1; i++) {
            if (TwavePeak[i] != Integer.MIN_VALUE) {
                ecgTwaveAmplitude = ecgTwaveAmplitude + ecg[TwavePeak[i]];
            }
            n++;
        }

        if (TwavePeak[i] == Integer.MIN_VALUE) {
            n++;
        }
        else {
            if (TwavePeak[i] < l) {
                ecgTwaveAmplitude = ecgTwaveAmplitude + ecg[TwavePeak[i]];
                n++;
            }
        }

        ecgTwaveAmplitude = ecgTwaveAmplitude / n;

        return ecgTwaveAmplitude;
    };

    public static double calculateEcgTwaveDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int TwaveOnset[] = FiducialPoints.getTwaveOnset();
        int TwaveOffset[] = FiducialPoints.getTwaveOffset();
        int n = 0;

        double ecgTwaveDuration = 0;

        for (int i = 0; i < TwaveOnset.length; i++) {
            if (TwaveOnset[i] != Integer.MIN_VALUE) {
                ecgTwaveDuration = ecgTwaveDuration + TwaveOffset[i] - TwaveOnset[i];
                n++;
            }
        }

        ecgTwaveDuration = ecgTwaveDuration / frequency / n;

        return ecgTwaveDuration;
    };

    // TODO: Implementirati detekciju J točke
    public static double calculateEcgSTsegmentDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int QrsOffset[] = FiducialPoints.getQrsOffset();
        int TwaveOnset[] = FiducialPoints.getTwaveOnset();
        int n = 0;

        double ecgSTsegmentDuration = 0;

        for (int i = 0; i < TwaveOnset.length; i++) {
            if (TwaveOnset[i] != Integer.MIN_VALUE) {
                ecgSTsegmentDuration = ecgSTsegmentDuration + TwaveOnset[i] - QrsOffset[i];
                n++;
            }
        }

        ecgSTsegmentDuration = ecgSTsegmentDuration / frequency / n;

        return ecgSTsegmentDuration;
    };

    // TODO: Implementirati detekciju J točke
    public static double calculateEcgSTsegmentSlope(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int QrsOffset[] = FiducialPoints.getQrsOffset();
        int TwaveOnset[] = FiducialPoints.getTwaveOnset();
        int l = ecg.length;
        int n = 0;

        double ecgSTsegmentSlope = 0;

        for (int i = 0; i < TwaveOnset.length; i++) {
            if ((TwaveOnset[i] != Integer.MIN_VALUE) && (TwaveOnset[i] < l)) {
                ecgSTsegmentSlope = ecgSTsegmentSlope + ((ecg[TwaveOnset[i]] - ecg[QrsOffset[i]]) / (TwaveOnset[i] - QrsOffset[i]));
                n++;
            }
        }

        ecgSTsegmentSlope = ecgSTsegmentSlope * frequency / n;

        return ecgSTsegmentSlope;
    };

    //TODO: Kraj QT intervala bi se trebao odrediti pomoću tangente
    public static double calculateEcgQTintervalDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int QrsOnset[] = FiducialPoints.getQrsOnset();
        int TwaveOffset[] = FiducialPoints.getTwaveOffset();
        int n = 0;

        double ecgQTintervalDuration = 0;

        for (int i = 0; i < TwaveOffset.length; i++) {
            if (TwaveOffset[i] != Integer.MIN_VALUE) {
                ecgQTintervalDuration = ecgQTintervalDuration + TwaveOffset[i] - QrsOnset[i];
                n++;
            }
        }

        ecgQTintervalDuration = ecgQTintervalDuration / frequency / n;

        return ecgQTintervalDuration;
    };

    public static double calculateEcgPRintervalDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int PwaveOnset[] = FiducialPoints.getPwaveOnset();
        int QrsOnset[] = FiducialPoints.getQrsOnset();
        int n = 0;

        double ecgPRintervalDuration = 0;

        for (int i = 0; i < QrsOnset.length; i++) {
            if (PwaveOnset[i] != Integer.MIN_VALUE) {
                ecgPRintervalDuration = ecgPRintervalDuration + QrsOnset[i] - PwaveOnset[i];
                n++;
            }
        }

        ecgPRintervalDuration = ecgPRintervalDuration / frequency / n;

        return ecgPRintervalDuration;
    };

    // TODO: Implementirati detekciju J točke
    public static double calculateEcgJpointAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsOffset[] = FiducialPoints.getQrsOffset();
        int l = ecg.length;
        int n = qrsOffset.length;

        double ecgJpointAmplitude = 0;

        for (int i = 0; i < n - 1; i++) {
            ecgJpointAmplitude = ecgJpointAmplitude + ecg[qrsOffset[i]];
        }

        if (qrsOffset[n - 1] < l) {
            ecgJpointAmplitude = ecgJpointAmplitude + ecg[qrsOffset[n - 1]];
        }
        else {
            n--;
        }

        ecgJpointAmplitude = ecgJpointAmplitude / n;

        return ecgJpointAmplitude;
    };

    public static double calculateEcg_R_S_Ratio(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        double ecgRwaveAmplitude = calculateEcgRwaveAmplitude(ecg, frequency, FiducialPoints);
        double ecgSwaveAmplitude = calculateEcgSwaveAmplitude(ecg, frequency, FiducialPoints);

        if (ecgRwaveAmplitude > 100*ecgSwaveAmplitude) {
            return 100.;
        }
        else {
            return ecgRwaveAmplitude/ecgSwaveAmplitude;
        }
    };

    public static double calculateEcgQwaveAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int QwavePeak[] = FiducialPoints.getQwavePeak();
        boolean QwaveAbsence[] = FiducialPoints.getQwaveAbsence();
        int n = 0;

        double ecgQwaveAmplitude = 0;

        if (QwaveAbsence[0] == true) {
            n++;
        }
        else {
            if (QwavePeak[0] >= 0) {
                ecgQwaveAmplitude = ecgQwaveAmplitude + Math.abs(ecg[QwavePeak[0]]);
                n++;
            }
        }

        for (int i = 1; i < QwavePeak.length; i++) {
            if (QwaveAbsence[i] == false) {
                ecgQwaveAmplitude = ecgQwaveAmplitude + Math.abs(ecg[QwavePeak[i]]);
            }
            n++;
        }

        ecgQwaveAmplitude = ecgQwaveAmplitude / n;

        return ecgQwaveAmplitude;
    };

    public static double calculateEcgSwaveAmplitude(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int SwavePeak[] = FiducialPoints.getSwavePeak();
        boolean SwaveAbsence[] = FiducialPoints.getSwaveAbsence();
        int l = ecg.length;
        int n = 0;
        int i;

        double ecgSwaveAmplitude = 0;

        for (i = 0; i < SwavePeak.length - 1; i++) {
            if (SwaveAbsence[i] == false) {
                ecgSwaveAmplitude = ecgSwaveAmplitude + Math.abs(ecg[SwavePeak[i]]);
            }
            n++;
        }

        if (SwaveAbsence[i] == true) {
            n++;
        }
        else {
            if (SwavePeak[i] < l) {
                ecgSwaveAmplitude = ecgSwaveAmplitude + Math.abs(ecg[SwavePeak[i]]);
                n++;
            }
        }

        ecgSwaveAmplitude = ecgSwaveAmplitude / n;

        return ecgSwaveAmplitude;
    };

    public static double calculateEcgRwaveDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int QwavePeak[] = FiducialPoints.getQwavePeak();
        int SwavePeak[] = FiducialPoints.getSwavePeak();
        int n = QwavePeak.length;

        double ecgRwaveDuration = 0;

        for (int i = 0; i < n; i++) {
            ecgRwaveDuration = ecgRwaveDuration + SwavePeak[i] - QwavePeak[i];
        }

        ecgRwaveDuration = ecgRwaveDuration / frequency / n;

        return ecgRwaveDuration;
    };

    public static double calculateEcgSwaveDuration(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsPeak[] = FiducialPoints.getQrsPeak();
        int QrsOffset[] = FiducialPoints.getQrsOffset();
        int n = qrsPeak.length;

        double ecgSwaveDuration = 0;

        for (int i = 0; i < n; i++) {
            ecgSwaveDuration = ecgSwaveDuration + QrsOffset[i] - qrsPeak[i];
        }

        ecgSwaveDuration = ecgSwaveDuration / frequency / n;

        return ecgSwaveDuration;
    };

    public static double calculateEcgFibrilatoryRate(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcg_QT_QTc_Ratio(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsPeak[] = FiducialPoints.getQrsPeak();
        int n = qrsPeak.length;

        double RR = (qrsPeak[n-1] - qrsPeak[0]) / (double) n;
        double QT = calculateEcgQTintervalDuration(ecg, frequency, FiducialPoints);
        double QTc = QT / Math.pow(RR, 0.33333);

        return QT / QTc;
    };

    public static double calculateEcgQTVnorm(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcgQTVI(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcgTQintervalWE(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    public static double calculateEcgTQintervalRWE(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){

        return 0;
    };

    // TODO: Implementirati detekciju J točke
    public static double calculateEcgJpointAmplitudeSD(double[] ecg, double frequency, ecgFiducialPoints FiducialPoints){
        int qrsOffset[] = FiducialPoints.getQrsOffset();
        int l = ecg.length;
        int n = qrsOffset.length;

        double ecgJpointAmplitudeSD;

        if (qrsOffset[n - 1] >= l) {
            n--;
        }

        double ecgJpointAmplitude[] = new double[n];

        for (int i = 0; i < n; i++) {
            ecgJpointAmplitude[i] = ecg[qrsOffset[i]];
        }

        ecgJpointAmplitudeSD = Statistics.standardDeviation(ecgJpointAmplitude);

        return ecgJpointAmplitudeSD;
    };

}
